/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.ecmessage.msg.xfs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.mal.MalNewOrderUtils;
import kd.scm.mal.common.aftersale.XFSAfterSaleUpdater;
import kd.scm.mal.common.aftersale.bean.AfterSaleServiceDetailInfo;
import kd.scm.mal.common.ecmessage.enums.XfsMsgTypeEnum;
import kd.scm.mal.common.ecmessage.msg.AbstractMessageHandler;
import net.sf.json.JSONObject;

public class XfsAfterOrderStateMessageHandler
extends AbstractMessageHandler {
    private static final Log logger = LogFactory.getLog(XfsAfterOrderStateMessageHandler.class);

    @Override
    public boolean doExcute(DynamicObject[] messageDyos) {
        Map<String, String> orderIdStatusMap = this.getKeyMap(messageDyos, XfsMsgTypeEnum.RETURN_STATE.getVal(), "refundOrderNo", "state");
        ArrayList<String> afterOrderList = new ArrayList<String>(orderIdStatusMap.keySet());
        logger.info("@@@XfsAfterOrderStateMessageHandler\u5904\u7406\u552e\u540e\u72b6\u6001\uff1a" + afterOrderList);
        if (afterOrderList.isEmpty()) {
            this.addRetryTimes(messageDyos, this.getClass().getName());
            return false;
        }
        for (DynamicObject dyo : messageDyos) {
            this.updateXfsAfterOrderState(dyo);
        }
        return true;
    }

    private void updateXfsAfterOrderState(DynamicObject dyo) {
        DynamicObject[] dyos;
        String result = dyo.getString("result");
        JSONObject json = JSONObject.fromObject((Object)result);
        String key = json.getString("refundOrderNo");
        String val = json.getString("state");
        for (DynamicObject malreturnreqDyn : dyos = this.getXfsReturnReq(key)) {
            HashMap<String, Object> afterSrvStatusMap = new HashMap<String, Object>();
            afterSrvStatusMap.put("sheetId", key);
            afterSrvStatusMap.put("afterSrvStatus", val);
            AfterSaleServiceDetailInfo xfsServiceResult = new AfterSaleServiceDetailInfo(afterSrvStatusMap);
            DynamicObjectCollection entryentityCol = malreturnreqDyn.getDynamicObjectCollection("entryentity");
            DynamicObject firstEntry = (DynamicObject)entryentityCol.get(0);
            xfsServiceResult.setNum(firstEntry.getInt("qty"));
            xfsServiceResult.setSkuId(firstEntry.getString("goods.number"));
            DynamicObject xfsEcOrder = MalNewOrderUtils.getOrderDyn((String)firstEntry.getString("ecorder_id"), (String)EcPlatformEnum.ECPLATFORM_XFS.getVal());
            xfsServiceResult.setOrderId((String)xfsEcOrder.get("orderid"));
            xfsServiceResult.setPorderid((String)xfsEcOrder.get("porderid"));
            XFSAfterSaleUpdater xfsAfterSaleUpdater = new XFSAfterSaleUpdater(malreturnreqDyn, xfsServiceResult);
            xfsAfterSaleUpdater.updateAndCommit();
        }
    }

    private DynamicObject[] getXfsReturnReq(String refundOrderNo) {
        QFilter filter = new QFilter("aftersaleentry.afservicebill.number", "=", (Object)refundOrderNo);
        String selectFields = DynamicObjectUtil.getSelectfields((String)"mal_returnreq", (boolean)false);
        selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"mal_returnreq", (String)"entryentity", (boolean)false);
        selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"mal_returnreq", (String)"aftersaleentry", (boolean)false);
        return BusinessDataServiceHelper.load((String)"mal_returnreq", (String)selectFields, (QFilter[])new QFilter[]{filter});
    }
}

