/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.ecmessage.msg.xfs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.util.mal.MalNewOrderUtils;
import kd.scm.mal.common.ecmessage.enums.XfsMsgTypeEnum;
import kd.scm.mal.common.ecmessage.msg.AbstractMessageHandler;
import kd.scm.mal.common.ecmessage.msg.util.EcMessageUtil;
import kd.scm.mal.common.service.impl.EcOrderAutoReceiceProxy;

public class XfsDeliverdOrderMessageHandler
extends AbstractMessageHandler {
    private static final Log logger = LogFactory.getLog(XfsDeliverdOrderMessageHandler.class);

    @Override
    public boolean doExcute(DynamicObject[] messageDyos) {
        Map<String, String> orderIdStatusMap = this.getKeyMap(messageDyos, XfsMsgTypeEnum.ORDER_DELIVERED.getVal(), "orderNo", "state");
        ArrayList<String> deliveredOrderList = new ArrayList<String>(orderIdStatusMap.keySet());
        logger.info("@@@XfDeliverdOrderMessageHandler\u5904\u7406\u59a5\u6295\u8ba2\u5355\uff1a" + deliveredOrderList);
        if (deliveredOrderList.isEmpty()) {
            this.addRetryTimes(messageDyos, this.getClass().getName());
            return false;
        }
        this.updateXfsOrderState(orderIdStatusMap);
        boolean ecAutoReceive = (Boolean)SystemParamServiceHelper.getBillParameter((String)"mal_order", (String)"ecautoreceive");
        if (ecAutoReceive) {
            Set<String> completeIds = EcMessageUtil.getPurEntryIdsByEcOrderNo(new HashSet<String>(deliveredOrderList), "pbd_order_xfs", "id,orderid", "orderid");
            DynamicObject[] purOrders = this.getPurOrderByEcOrder(EcPlatformEnum.ECPLATFORM_XFS.getVal(), new HashSet<String>(deliveredOrderList));
            new EcOrderAutoReceiceProxy(this.getEcOrderAutoReceiveService(purOrders)).autoReceive(purOrders, completeIds);
        }
        return true;
    }

    private DynamicObject[] getPurOrderByEcOrder(String ecType, Set<String> orderNumbers) {
        QFilter typeFilter;
        QFilter ecOrderFilter = new QFilter("entryentity.order", "in", (Object)MalNewOrderUtils.getEcOrderPks((String)ecType, new HashSet<String>(orderNumbers)));
        DynamicObjectCollection malOrderCol = QueryServiceHelper.query((String)"mal_order", (String)"id", (QFilter[])new QFilter[]{ecOrderFilter, typeFilter = new QFilter("platform", "=", (Object)ecType)});
        if (null != malOrderCol && malOrderCol.size() > 0) {
            ArrayList malOrderIds = new ArrayList(malOrderCol.size());
            malOrderCol.forEach(dyo -> malOrderIds.add(dyo.getString("id")));
            String selectProperties = "id,billno,businesstype,materialentry.srcbillid,materialentry.srcentryid,materialentry.qty,materialentry.jdorder,materialentry.poentryid,materialentry.pobillid,materialentry.unit,materialentry.basicunit,materialentry.purtype,materialentry.entryrcvorg,materialentry.entryrcvorg.id,materialentry.entryrcvorg.number";
            return BusinessDataServiceHelper.load((String)"pur_order", (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("materialentry.srcbillid", "in", malOrderIds)}, (String)"billdate desc");
        }
        return null;
    }

    private void updateXfsOrderState(Map<String, String> orderIdStatusMap) {
        DynamicObject[] dyos;
        for (DynamicObject dyo : dyos = this.getXfsOrder(orderIdStatusMap.keySet())) {
            String orderId = dyo.getString("orderId");
            String state = orderIdStatusMap.get(orderId);
            dyo.set("state", (Object)state);
        }
        SaveServiceHelper.save((DynamicObject[])dyos);
    }

    private DynamicObject[] getXfsOrder(Collection<String> cgOrderIdList) {
        QFilter filter = new QFilter("orderid", "in", cgOrderIdList);
        return BusinessDataServiceHelper.load((String)"pbd_order_xfs", (String)"id,orderid,state,submitstate,orderstate", (QFilter[])new QFilter[]{filter});
    }
}

