/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.ecmessage.msg.xfs;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.enums.PurEcInvoiceEnum;
import kd.scm.common.helper.apiconnector.api.util.EcGroupApiUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.mal.MalNewOrderUtils;
import kd.scm.mal.common.ecmessage.msg.AbstractMessageHandler;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class XfsSplitOrderMessageHandler
extends AbstractMessageHandler {
    private static final Log logger = LogFactory.getLog(XfsSplitOrderMessageHandler.class);

    @Override
    public boolean doExcute(DynamicObject[] messageDyos) {
        Map<String, JSONArray> subOrderMap = this.getSubOrderMap(messageDyos);
        logger.info("@@@XfsDeliverdOrderMessageHandler\u5904\u7406\u8ba2\u5355\uff1a" + subOrderMap);
        if (subOrderMap.isEmpty()) {
            this.addRetryTimes(messageDyos, this.getClass().getName());
            return false;
        }
        logger.info("@@@XfsDeliverdOrderMessageHandler\u5f00\u59cb\u5904\u7406\u8ba2\u5355\u62c6\u5355");
        this.handleOrderSplit(subOrderMap);
        return true;
    }

    private void handleOrderSplit(Map<String, JSONArray> subOrderMap) {
        logger.info("handleOrderSplit\u53c2\u6570\uff1a" + subOrderMap);
        Map<String, DynamicObject> pOrderIdMalOrderDynMap = this.getOrderDyoMap(new HashSet<String>(subOrderMap.keySet()));
        for (Map.Entry<String, DynamicObject> entry : pOrderIdMalOrderDynMap.entrySet()) {
            Map<String, Long> skuEcOrderPkMap = this.getSkuEcOrderPkMap(entry.getKey(), subOrderMap.get(entry.getKey()));
            this.updateMalOrderByChildOrder(skuEcOrderPkMap, entry.getValue());
        }
    }

    private Map<String, Long> getSkuEcOrderPkMap(String pOrderNo, JSONArray subOrderNos) {
        HashMap<String, Long> res = new HashMap<String, Long>();
        this.createChildOrder(pOrderNo, subOrderNos);
        HashSet ecOrderIds = new HashSet(subOrderNos.size());
        ecOrderIds.addAll(subOrderNos);
        DynamicObjectCollection ecOrders = MalNewOrderUtils.queryEcOrderDetailByEcOrderIds((String)EcPlatformEnum.ECPLATFORM_XFS.getVal(), ecOrderIds);
        for (DynamicObject ecOrderDyn : ecOrders) {
            res.put(ecOrderDyn.getString("entryentity.goods.number"), ecOrderDyn.getLong("id"));
        }
        return res;
    }

    private void createChildOrder(String pOrderNo, JSONArray subOrderNos) {
        DynamicObject[] ecOrderDyns = new DynamicObject[subOrderNos.size()];
        DynamicObjectCollection pEcOrderCols = MalNewOrderUtils.queryEcOrderDetailByEcOrderIds((String)EcPlatformEnum.ECPLATFORM_XFS.getVal(), Stream.of(pOrderNo).collect(Collectors.toSet()));
        for (int i = 0; i < subOrderNos.size(); ++i) {
            Map subEcOrderDetail = EcGroupApiUtil.getEcOrderDetail((String)subOrderNos.getString(i), (String)EcPlatformEnum.ECPLATFORM_XFS.getVal());
            ecOrderDyns[i] = this.createEcOrderDyn(pOrderNo, (Map)subEcOrderDetail.get(EcPlatformEnum.ECPLATFORM_XFS.getVal()), pEcOrderCols);
        }
        SaveServiceHelper.save((DynamicObject[])ecOrderDyns);
    }

    private DynamicObject createEcOrderDyn(String pOrderNo, Map<String, Object> subEcOrderDetail, DynamicObjectCollection pEcOrderCols) {
        DynamicObject res = BusinessDataServiceHelper.newDynamicObject((String)"pbd_order_xfs");
        res.set("porderid", (Object)pOrderNo);
        res.set("orderid", subEcOrderDetail.get("orderNo"));
        res.set("submitstate", (Object)"1");
        res.set("orderstate", (Object)"1");
        res.set("state", subEcOrderDetail.get("state"));
        res.set("freight", subEcOrderDetail.get("freight"));
        res.set("orderamount", subEcOrderDetail.get("orderAmount"));
        String currency = MalOrderUtil.getDefaultCurrency();
        if (StringUtils.isNotBlank((CharSequence)currency)) {
            res.set("currency_id", (Object)currency);
        } else {
            res.set("currency_id", (Object)"1");
        }
        res.set("invoicestate", (Object)PurEcInvoiceEnum.PREREQUEST.getVal());
        res.set("createtime", (Object)new Date());
        BigDecimal amount = BigDecimal.ZERO;
        DynamicObjectCollection entryDyoCol = (DynamicObjectCollection)res.get("entryentity");
        List skuInfos = (List)subEcOrderDetail.get("skuInfos");
        for (Map skuInfo : skuInfos) {
            DynamicObject entryDyo = entryDyoCol.addNew();
            for (DynamicObject pEntryDyo : pEcOrderCols) {
                if (!skuInfo.get("skuNo").equals(pEntryDyo.getString("entryentity.goods.number"))) continue;
                entryDyo.set("goods", pEntryDyo.get("entryentity.goods.id"));
                entryDyo.set("qty", skuInfo.get("buyNum"));
                entryDyo.set("price", (Object)pEntryDyo.getBigDecimal("entryentity.price"));
                entryDyo.set("nakedamount", (Object)pEntryDyo.getBigDecimal("entryentity.nakedamount"));
                entryDyo.set("taxamount", (Object)pEntryDyo.getBigDecimal("entryentity.taxamount"));
                entryDyo.set("taxrate", (Object)pEntryDyo.getBigDecimal("entryentity.taxrate"));
                amount = amount.add(entryDyo.getBigDecimal("qty").multiply(entryDyo.getBigDecimal("nakedamount")));
            }
        }
        BigDecimal tax = res.getBigDecimal("orderamount").subtract(amount);
        res.set("ordernakedamount", (Object)amount);
        res.set("ordertaxamount", (Object)tax);
        return res;
    }

    private void updateMalOrderByChildOrder(Map<String, Long> skuEcOrderPkMap, DynamicObject malOrderDyn) {
        DynamicObjectCollection maColl = malOrderDyn.getDynamicObjectCollection("entryentity");
        for (DynamicObject coll : maColl) {
            Long ecOrderId = skuEcOrderPkMap.get(coll.getDynamicObject("goods").getString("number"));
            if (ecOrderId == null) continue;
            coll.set("order", (Object)ecOrderId);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{malOrderDyn});
    }

    private Map<String, DynamicObject> getOrderDyoMap(Set<String> pOrderSet) {
        DynamicObject[] dyos;
        Map ecOrderMap = MalNewOrderUtils.queryEcOrderByEcOrderIds((String)EcPlatformEnum.ECPLATFORM_XFS.getVal(), new HashSet<String>(pOrderSet));
        HashMap<String, DynamicObject> result = new HashMap<String, DynamicObject>(ecOrderMap.size());
        String selectFields = "sumtaxamount,entryentity.order,entryentity.order.orderid,entryentity.order.porderid,entryentity.goods,orderstatus,id,entryentity.id,platform";
        QFilter platFilter = new QFilter("platform", "=", (Object)EcPlatformEnum.ECPLATFORM_XFS.getVal());
        QFilter ecOrderIdFilter = new QFilter("entryentity.order", "in", ecOrderMap.keySet());
        for (DynamicObject dyo : dyos = BusinessDataServiceHelper.load((String)"mal_order", (String)selectFields, (QFilter[])new QFilter[]{platFilter, ecOrderIdFilter})) {
            DynamicObjectCollection entryEntityCol = dyo.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryEntityCol) {
                if (!pOrderSet.contains(entry.getString("order.orderid"))) continue;
                result.put(entry.getString("order.orderid"), dyo);
            }
        }
        return result;
    }

    private Map<String, JSONArray> getSubOrderMap(DynamicObject[] messageDyos) {
        HashMap<String, JSONArray> resultMap = new HashMap<String, JSONArray>(messageDyos.length);
        for (DynamicObject dyo : messageDyos) {
            String result = dyo.getString("result");
            JSONObject json = JSONObject.fromObject((Object)result);
            String orderNo = json.getString("orderNo");
            JSONArray subOrderNosJa = json.getJSONArray("subOrderNos");
            if (StringUtils.isBlank((CharSequence)orderNo) || ObjectUtils.isEmpty((Object)subOrderNosJa)) continue;
            JSONArray ja = resultMap.getOrDefault(orderNo, new JSONArray());
            ja.addAll((Collection)subOrderNosJa);
            resultMap.put(orderNo, ja);
        }
        return resultMap;
    }
}

