/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.ecmessage.msg.xy;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.mal.common.ecmessage.enums.XyMsgTypeEnum;
import kd.scm.mal.common.ecmessage.msg.AbstractMessageHandler;
import kd.scm.mal.common.util.MalPlaceOrderUtils;
import net.sf.json.JSONObject;

public class XyCancelOrderMessageHandler
extends AbstractMessageHandler {
    private static final Log logger = LogFactory.getLog(XyCancelOrderMessageHandler.class);

    public Set<String> startCancel(Set<String> cancelOrderList) {
        return MalPlaceOrderUtils.malOrderInvalidProcessor(cancelOrderList, EcPlatformEnum.ECPLATFORM_XY.getVal());
    }

    @Override
    public boolean doExcute(DynamicObject[] messageDyos) {
        HashSet<String> cancelOrderList = new HashSet<String>(messageDyos.length);
        HashMap<String, DynamicObject> msgMap = new HashMap<String, DynamicObject>(messageDyos.length);
        for (DynamicObject dyo : messageDyos) {
            String msgType = dyo.getString("msgtype");
            if (!msgType.equals(XyMsgTypeEnum.ORDER_CANCELED.getVal())) continue;
            String result = dyo.getString("result");
            JSONObject json = JSONObject.fromObject((Object)result);
            String orderId = json.getString("orderId");
            cancelOrderList.add(orderId);
            msgMap.put(orderId, dyo);
        }
        logger.info("@@@XyCancelOrderMessageHandler\u5904\u7406\u8ba2\u5355\uff1a" + cancelOrderList);
        if (cancelOrderList.size() < 1) {
            this.addRetryTimes(messageDyos, this.getClass().getName());
            return false;
        }
        Set<String> sucessOrders = this.startCancel(cancelOrderList);
        if (sucessOrders.size() <= 0) {
            this.addRetryTimes(messageDyos, this.getClass().getName());
            return false;
        }
        DynamicObject[] failedMsgDyos = this.getFailedMessageDyo(sucessOrders, msgMap);
        if (failedMsgDyos.length > 0) {
            this.addRetryTimes(failedMsgDyos, this.getClass().getName());
            DynamicObject[] sucessMsgDyos = this.getSuccessMessageDyo(sucessOrders, msgMap);
            this.changeConsumeStatus(sucessMsgDyos);
            return false;
        }
        return true;
    }
}

