/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.ecmessage.msg.xy;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.mal.common.ecmessage.enums.XyMsgTypeEnum;
import kd.scm.mal.common.ecmessage.msg.AbstractMessageHandler;
import kd.scm.mal.common.ecmessage.msg.util.EcMessageUtil;
import kd.scm.mal.common.service.impl.EcOrderAutoReceiceProxy;
import net.sf.json.JSONObject;

public class XyDeliverdOrderMessageHandler
extends AbstractMessageHandler {
    private static final Log logger = LogFactory.getLog(XyDeliverdOrderMessageHandler.class);

    public static void updateXyOrderStatus(String statusKey, Set<String> orderSet, String status) {
        QFilter filter = new QFilter("orderid", "in", orderSet);
        DynamicObject[] dyos = BusinessDataServiceHelper.load((String)"pbd_order_xy", (String)("orderid," + statusKey), (QFilter[])new QFilter[]{filter});
        if (null == dyos || dyos.length <= 0) {
            return;
        }
        for (DynamicObject bill : dyos) {
            bill.set(statusKey, (Object)status);
        }
        SaveServiceHelper.save((DynamicObject[])dyos);
    }

    @Override
    public boolean doExcute(DynamicObject[] messageDyos) {
        HashSet<String> orders = new HashSet<String>(messageDyos.length);
        for (DynamicObject dyo : messageDyos) {
            String msgType = dyo.getString("msgtype");
            if (!msgType.equals(XyMsgTypeEnum.ORDER_DELIVERED.getVal())) continue;
            String result = dyo.getString("result");
            JSONObject json = JSONObject.fromObject((Object)result);
            String orderId = json.getString("orderId");
            String orderType = json.getString("orderType");
            String state = json.getString("state");
            if (!"1".equals(state) || null != orderType && !orderType.equals("1")) continue;
            orders.add(orderId);
        }
        logger.info("@@@XyDeliverdOrderMessageHandler\u5904\u7406\u59a5\u6295\u8ba2\u5355\uff1a" + orders);
        if (orders.isEmpty()) {
            this.addRetryTimes(messageDyos, this.getClass().getName());
            return false;
        }
        XyDeliverdOrderMessageHandler.updateXyOrderStatus("state", orders, "1");
        boolean ecAutoReceive = (Boolean)SystemParamServiceHelper.getBillParameter((String)"mal_order", (String)"ecautoreceive");
        if (ecAutoReceive) {
            Set<String> completeIds = EcMessageUtil.getPurEntryIdsByEcOrderNo(orders, "pbd_order_xy", "id,orderid", "orderid");
            DynamicObject[] purOrders = EcMessageUtil.getPurOrderByEcOrder(EcPlatformEnum.ECPLATFORM_XY.getVal(), orders);
            new EcOrderAutoReceiceProxy(this.getEcOrderAutoReceiveService(purOrders)).autoReceive(purOrders, completeIds);
        }
        return true;
    }
}

