/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.ecmessage.msg.zkh;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.enums.PurEcInvoiceEnum;
import kd.scm.common.helper.apiconnector.api.ApiAccessor;
import kd.scm.common.helper.apiconnector.api.util.EcApiUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.mal.MalNewOrderUtils;
import kd.scm.mal.common.ecmessage.msg.AbstractMessageHandler;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class ZkhSplitOrderMessageHandler
extends AbstractMessageHandler {
    private static final Log logger = LogFactory.getLog(ZkhSplitOrderMessageHandler.class);

    @Override
    public boolean doExcute(DynamicObject[] messageDyos) {
        Map<String, JSONArray> subOrderMap = this.getSubOrderMap(messageDyos);
        logger.info("@@@ZkhSplitOrderMessageHandler\u5904\u7406\u8ba2\u5355\uff1a" + subOrderMap);
        if (subOrderMap.isEmpty()) {
            this.addRetryTimes(messageDyos, this.getClass().getName());
            return false;
        }
        logger.info("@@@ZkhSplitOrderMessageHandler\u5f00\u59cb\u5904\u7406\u8ba2\u5355\u62c6\u5355");
        this.handleOrderSplit(subOrderMap);
        return true;
    }

    private void handleOrderSplit(Map<String, JSONArray> subOrderMap) {
        ArrayList<DynamicObject> ecOrderDyns = new ArrayList<DynamicObject>(1024);
        for (Map.Entry<String, JSONArray> entry : subOrderMap.entrySet()) {
            this.createChildOrder(entry.getKey(), entry.getValue(), ecOrderDyns);
        }
        if (ecOrderDyns.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])ecOrderDyns.toArray(new DynamicObject[0]));
        }
    }

    private void createChildOrder(String pOrderNo, JSONArray subOrderNos, List<DynamicObject> ecOrderDyns) {
        DynamicObjectCollection pEcOrderCols = MalNewOrderUtils.queryEcOrderDetailByEcOrderIds((String)EcPlatformEnum.ECPLATFORM_ZKH.getVal(), Stream.of(pOrderNo).collect(Collectors.toSet()));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("orderId", pOrderNo);
        List datas = (List)EcApiUtil.parseResful((Object)ApiAccessor.invoke((String)"SRM_ZKH_ORDER_get_packagelist", params));
        for (int i = 0; i < subOrderNos.size(); ++i) {
            Object packageId = subOrderNos.get(i);
            for (Map data : datas) {
                if (!data.get("packageId").equals(packageId)) continue;
                ecOrderDyns.add(this.createEcOrderDyn(pOrderNo, data, pEcOrderCols));
            }
        }
    }

    private DynamicObject createEcOrderDyn(String pOrderNo, Map<String, Object> subEcOrderDetail, DynamicObjectCollection pEcOrderCols) {
        DynamicObject res = BusinessDataServiceHelper.newDynamicObject((String)"pbd_order_zkh");
        res.set("porderid", (Object)pOrderNo);
        res.set("orderid", subEcOrderDetail.get("packageId"));
        res.set("submitstate", (Object)"1");
        res.set("orderstate", (Object)"1");
        res.set("state", subEcOrderDetail.get("deliveryStatus"));
        res.set("freight", (Object)BigDecimal.ZERO);
        String currency = MalOrderUtil.getDefaultCurrency();
        if (StringUtils.isNotBlank((CharSequence)currency)) {
            res.set("currency_id", (Object)currency);
        } else {
            res.set("currency_id", (Object)"1");
        }
        res.set("invoicestate", (Object)PurEcInvoiceEnum.PREREQUEST.getVal());
        res.set("createtime", (Object)new Date());
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal orderamount = BigDecimal.ZERO;
        DynamicObjectCollection entryDyoCol = (DynamicObjectCollection)res.get("entryentity");
        List skuInfos = (List)subEcOrderDetail.get("deliveryItems");
        for (Map skuInfo : skuInfos) {
            DynamicObject entryDyo = entryDyoCol.addNew();
            for (DynamicObject pEntryDyo : pEcOrderCols) {
                if (!skuInfo.get("skuId").equals(pEntryDyo.getString("entryentity.goods.number"))) continue;
                entryDyo.set("goods", pEntryDyo.get("entryentity.goods.id"));
                entryDyo.set("qty", skuInfo.get("num"));
                entryDyo.set("price", (Object)pEntryDyo.getBigDecimal("entryentity.price"));
                entryDyo.set("nakedamount", (Object)pEntryDyo.getBigDecimal("entryentity.nakedamount"));
                entryDyo.set("taxamount", (Object)pEntryDyo.getBigDecimal("entryentity.taxamount"));
                entryDyo.set("taxrate", (Object)pEntryDyo.getBigDecimal("entryentity.taxrate"));
                amount = amount.add(entryDyo.getBigDecimal("qty").multiply(entryDyo.getBigDecimal("nakedamount")));
                orderamount = orderamount.add(entryDyo.getBigDecimal("qty").multiply(entryDyo.getBigDecimal("price")));
            }
        }
        BigDecimal tax = res.getBigDecimal("orderamount").subtract(amount);
        res.set("ordernakedamount", (Object)amount);
        res.set("ordertaxamount", (Object)tax);
        res.set("orderamount", (Object)orderamount);
        return res;
    }

    private Map<String, JSONArray> getSubOrderMap(DynamicObject[] messageDyos) {
        HashMap<String, JSONArray> resultMap = new HashMap<String, JSONArray>(messageDyos.length);
        for (DynamicObject dyo : messageDyos) {
            String result = dyo.getString("result");
            JSONObject json = JSONObject.fromObject((Object)result);
            String orderType = json.getString("orderType");
            if (!"2".equals(orderType)) continue;
            String orderNo = json.getString("orderId");
            String packageId = json.getString("packageId");
            JSONArray packageIds = new JSONArray();
            if (null != resultMap.get(orderNo)) {
                packageIds = (JSONArray)resultMap.get(orderNo);
            }
            packageIds.add((Object)packageId);
            resultMap.put(orderNo, packageIds);
        }
        return resultMap;
    }
}

