/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.org;

import java.util.Map;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.enums.OrgTypeEnum;
import kd.scm.mal.common.org.IMalOrgService;
import kd.scm.mal.common.org.impl.MalEasOrgService;
import kd.scm.mal.common.org.impl.MalOrgService;

public class MalOrgServiceFactory {
    public static final String TOTYPE = "totype";
    public static final String FROMTYPE = "fromtype";
    public static final String BOS_ORG_TYPERELATION = "bos_org_typerelation";

    private MalOrgServiceFactory() {
    }

    public static IMalOrgService getMalOrgService() {
        if (MalOrgServiceFactory.hasDelegantRalation()) {
            return new MalEasOrgService();
        }
        return new MalOrgService();
    }

    public static boolean hasDelegantRalation() {
        return MalOrgServiceFactory.existOrgRelation(OrgTypeEnum.ADMINISTRATIVE.getVal(), OrgTypeEnum.PURCHASE.getVal()) && MalOrgServiceFactory.existOrgRelation(OrgTypeEnum.INVENTORY.getVal(), OrgTypeEnum.ACCOUNTING.getVal()) && MalOrgServiceFactory.existOrgRelation(OrgTypeEnum.PURCHASE.getVal(), OrgTypeEnum.ACCOUNTING.getVal()) && MalOrgServiceFactory.existOrgRelation(OrgTypeEnum.INVENTORY.getVal(), OrgTypeEnum.PURCHASE.getVal());
    }

    private static boolean existOrgRelation(String fromOrgType, String toOrgType) {
        QFilter toTypeFilter = new QFilter(TOTYPE, "=", (Object)toOrgType);
        QFilter fromTypeFilter = new QFilter(FROMTYPE, "=", (Object)fromOrgType);
        Map typeMap = BusinessDataServiceHelper.loadFromCache((String)BOS_ORG_TYPERELATION, (String)"id", (QFilter[])new QFilter[]{toTypeFilter, fromTypeFilter});
        return !CollectionUtils.isEmpty((Map)typeMap);
    }
}

