/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.org.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scm.common.enums.OrgTypeEnum;
import kd.scm.mal.common.org.AbstractMalDelegantOrgService;

public class MalEasOrgService
extends AbstractMalDelegantOrgService {
    @Override
    public List<Long> getDemandOrgList(Long userId) {
        return UserServiceHelper.getAllDepartmentByUserId((long)userId);
    }

    @Override
    public List<Long> getPurchaseOrgList(Long orgId) {
        return this.getBizToOrgList(OrgTypeEnum.ADMINISTRATIVE.getVal(), OrgTypeEnum.PURCHASE.getVal(), orgId);
    }

    @Override
    public List<Long> getInvOrgList(Long purOrgId) {
        List invOrgIds = OrgUnitServiceHelper.getFromOrgs((String)OrgTypeEnum.PURCHASE.getVal(), (Long)purOrgId, (String)OrgTypeEnum.INVENTORY.getVal());
        return invOrgIds.stream().distinct().collect(Collectors.toList());
    }

    @Override
    public List<Long> getSettleOrgList(Long purOrgId, Long invOrgId) {
        ArrayList<Long> settleOrgIds = new ArrayList<Long>();
        if (purOrgId != 0L) {
            settleOrgIds.addAll(this.getBizToOrgList(OrgTypeEnum.PURCHASE.getVal(), OrgTypeEnum.ACCOUNTING.getVal(), purOrgId));
        }
        if (invOrgId != 0L) {
            settleOrgIds.addAll(this.getBizToOrgList(OrgTypeEnum.INVENTORY.getVal(), OrgTypeEnum.ACCOUNTING.getVal(), invOrgId));
        }
        return settleOrgIds.stream().distinct().collect(Collectors.toList());
    }

    @Override
    public List<Long> getOwnerOrgList(Long purOrgId, Long invOrgId) {
        return this.getSettleOrgList(purOrgId, invOrgId);
    }

    @Override
    public Long getDefaultDemandOrgByUser(Long userId) {
        return UserServiceHelper.getUserMainOrgId((long)userId);
    }

    @Override
    public Long getDefaultPurchaseOrg(Long orgId) {
        List<Long> purOrgList = this.getPurchaseOrgList(orgId);
        return this.getSelectDefault(purOrgList, orgId);
    }

    @Override
    public Long getDefaultInvOrg(Long purOrgId) {
        List<Long> invOrgList = this.getInvOrgList(purOrgId);
        return this.getSelectDefault(invOrgList, purOrgId);
    }

    @Override
    public Long getDefaultSettleOrg(Long purOrgId, Long invOrgId) {
        List<Long> settleOrgList = this.getSettleOrgList(purOrgId, invOrgId);
        return this.getSelectDefault(settleOrgList, purOrgId);
    }

    @Override
    public Long getDefaultOwnerOrg(Long orgId, Long purOrgId) {
        Map mpCompany = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId);
        if (!mpCompany.isEmpty()) {
            return Long.valueOf(mpCompany.get("id").toString());
        }
        return this.getSelectDefault(this.getOwnerOrgList(orgId, purOrgId), orgId);
    }

    @Override
    public Long getSelectDefault(List<Long> orgIdList, Long targetOrgId) {
        if (orgIdList.contains(targetOrgId)) {
            return targetOrgId;
        }
        Long curOrgId = RequestContext.get().getOrgId();
        if (orgIdList.contains(curOrgId)) {
            return curOrgId;
        }
        return orgIdList.size() > 0 ? orgIdList.get(0) : Long.valueOf(0L);
    }
}

