/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.org.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scm.common.enums.OrgTypeEnum;
import kd.scm.mal.common.org.AbstractMalDelegantOrgService;

public class MalOrgService
extends AbstractMalDelegantOrgService {
    @Override
    public List<Long> getDemandOrgList(Long userId) {
        return new ArrayList<Long>();
    }

    @Override
    public List<Long> getPurchaseOrgList(Long orgId) {
        return this.getBizToOrgList(null, OrgTypeEnum.PURCHASE.getVal(), orgId);
    }

    @Override
    public List<Long> getInvOrgList(Long purOrgId) {
        return this.getBizToOrgList(OrgTypeEnum.PURCHASE.getVal(), OrgTypeEnum.INVENTORY.getVal(), purOrgId);
    }

    @Override
    public List<Long> getSettleOrgList(Long purOrgId, Long orgId) {
        ArrayList<Long> resultList = new ArrayList<Long>(2);
        Map mpCompany = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
        Map poCompany = OrgUnitServiceHelper.getCompanyByOrg((Long)purOrgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
        if (!mpCompany.isEmpty()) {
            resultList.add(Long.valueOf(mpCompany.get("id").toString()));
        }
        if (!poCompany.isEmpty()) {
            resultList.add(Long.valueOf(poCompany.get("id").toString()));
        }
        return resultList.stream().distinct().collect(Collectors.toList());
    }

    @Override
    public List<Long> getOwnerOrgList(Long orgId, Long purOrgId) {
        return this.getSettleOrgList(orgId, purOrgId);
    }

    @Override
    public Long getDefaultDemandOrgByUser(Long userId) {
        Long defaultOrg = UserServiceHelper.getUserMainOrgId((long)userId);
        ArrayList<Long> orgIdList = new ArrayList<Long>(1);
        orgIdList.add(defaultOrg);
        if (OrgUnitServiceHelper.checkOrgFunction((Long)defaultOrg, (String)"15")) {
            return defaultOrg;
        }
        List resultList = OrgUnitServiceHelper.getAdminOrgRelation(orgIdList, (boolean)false);
        if (resultList.size() <= 0) {
            return 0L;
        }
        return resultList.contains(defaultOrg) ? defaultOrg : this.getSelectDefault(resultList, RequestContext.get().getOrgId());
    }

    @Override
    public Long getDefaultPurchaseOrg(Long orgId) {
        return this.getBizToOrg(null, OrgTypeEnum.PURCHASE.getVal(), orgId);
    }

    @Override
    public Long getDefaultInvOrg(Long purOrgId) {
        return this.getBizToOrg(OrgTypeEnum.PURCHASE.getVal(), OrgTypeEnum.INVENTORY.getVal(), purOrgId);
    }

    @Override
    public Long getDefaultSettleOrg(Long orgId, Long purOrgId) {
        Map mpCompany = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId);
        if (!mpCompany.isEmpty()) {
            return Long.valueOf(mpCompany.get("id").toString());
        }
        return this.getSelectDefault(this.getSettleOrgList(orgId, purOrgId), purOrgId);
    }

    @Override
    public Long getDefaultOwnerOrg(Long orgId, Long purOrgId) {
        Map mpCompany = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId);
        if (!mpCompany.isEmpty()) {
            return Long.valueOf(mpCompany.get("id").toString());
        }
        return this.getSelectDefault(this.getOwnerOrgList(orgId, purOrgId), orgId);
    }

    @Override
    public Long getSelectDefault(List<Long> orgIdList, Long targetOrgId) {
        if (orgIdList.contains(targetOrgId)) {
            return targetOrgId;
        }
        return orgIdList.size() > 0 ? orgIdList.get(0) : Long.valueOf(0L);
    }

    public Long getDefaultOrg(List<Long> orgIdList, Long targetOrgId) {
        if (orgIdList.size() > 0 && orgIdList.get(0).longValue() != targetOrgId.longValue() && targetOrgId != 0L) {
            return orgIdList.get(0);
        }
        if (orgIdList.contains(targetOrgId)) {
            return targetOrgId;
        }
        return orgIdList.size() > 0 ? orgIdList.get(0) : Long.valueOf(0L);
    }
}

