/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.placeorder.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ecapi.entity.PriceInfo;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.ecapi.util.AddressUtil;
import kd.scm.common.ecapi.util.EmalStatusUtil;
import kd.scm.common.enums.PurEcInvoiceEnum;
import kd.scm.common.helper.apiconnector.api.ApiAccessor;
import kd.scm.common.helper.apiconnector.api.util.EcApiUtil;
import kd.scm.common.helper.apiconnector.api.util.Parser;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.cal.Cal4DynamicObj;
import kd.scm.mal.common.constant.MalPlaceOrderConstant;
import kd.scm.mal.common.enums.MalBizflowParamEnum;
import kd.scm.mal.common.placeorder.service.PlaceOrderService;
import kd.scm.mal.common.util.MalJdProductUtil;
import kd.scm.mal.common.util.MalPlaceOrderUtils;
import kd.scm.mal.common.util.MalProductUtil;

@Deprecated
public class CgPlaceOrderService
extends PlaceOrderService {
    private static Log log = LogFactory.getLog(CgPlaceOrderService.class);

    @Override
    public String getSource() {
        return EcPlatformEnum.ECPLATFORM_CG.getVal();
    }

    @Override
    public Map<String, Object> checkStatus(List<String> productIdList) {
        List<String> offList = MalPlaceOrderUtils.checkSkuStates(this.getSource(), productIdList);
        if (null != offList && offList.size() > 0) {
            HashMap<String, Object> result = new HashMap<String, Object>(2);
            result.put("status", Boolean.FALSE);
            result.put("goodsList", offList);
            return result;
        }
        return null;
    }

    @Override
    public Map<String, Object> placeOrder(int supplierSize, DynamicObject sourceDyo) {
        HashMap<String, Object> resultMsg = new HashMap<String, Object>(4);
        resultMsg.put("source", this.getSource());
        LinkedHashMap<String, Object> materialMappingMap = new LinkedHashMap<String, Object>();
        DynamicObject orderDyo = BusinessDataServiceHelper.newDynamicObject((String)"mal_order");
        ArrayList<String> skusList = new ArrayList<String>();
        HashMap<String, String> nameMap = new HashMap<String, String>();
        HashMap<String, String> imgMap = new HashMap<String, String>();
        HashMap<String, Integer> qtyMap = new HashMap<String, Integer>();
        HashMap<String, BigDecimal> goodPriceMap = new HashMap<String, BigDecimal>();
        int cgSupplierIndex = 0;
        for (int supplierIndex = 1; supplierIndex <= supplierSize; ++supplierIndex) {
            if (!sourceDyo.get("source" + supplierIndex).toString().equalsIgnoreCase(this.getSource())) continue;
            cgSupplierIndex = supplierIndex;
            DynamicObjectCollection entryDyoCol = (DynamicObjectCollection)sourceDyo.get("entryentity" + supplierIndex);
            for (DynamicObject dyo : entryDyoCol) {
                String sku = dyo.getString("goods" + supplierIndex);
                Object materialId = dyo.get("material" + supplierIndex);
                skusList.add(sku);
                nameMap.put(sku, dyo.getString("goodsname" + supplierIndex));
                imgMap.put(sku, dyo.getString("goodsimg" + supplierIndex));
                qtyMap.put(sku, dyo.getInt("qty" + supplierIndex));
                goodPriceMap.put(sku, dyo.getBigDecimal("goodprice" + supplierIndex));
                materialMappingMap.put(sku, materialId);
            }
        }
        OperationResult saveResult = null;
        OperationResult submitResult = null;
        try {
            OperationResult auditResult;
            log.info("@@@@@@@@\u5f00\u59cb\u83b7\u53d6\u6668\u5149\u5546\u54c1@@@@@@@@");
            Map<String, String> skuIdMap = MalPlaceOrderUtils.getMalGoods(skusList, nameMap, imgMap, this.getSource());
            log.info("@@@@@@@@\u83b7\u53d6\u6668\u5149\u5546\u54c1\u6210\u529f@@@@@@@@");
            log.info("@@@@@@@@\u53d6\u6668\u5149\u4ef7\u683c@@@@@@@@");
            Map<String, PriceInfo> priceMap = MalPlaceOrderUtils.getMalGoodsPrice(this.getSource(), skusList, null).get(this.getSource());
            log.info("@@@@@@@@\u53d6\u6668\u5149\u4ef7\u683c\u6210\u529f@@@@@@@@");
            this.preHandleDynamicObj(sourceDyo, null, skusList);
            log.info("@@@@@@@@\u5904\u7406\u5546\u57ce\u5355\u5934\u4fe1\u606f@@@@@@@@");
            this.handleOrderHeadInfo(sourceDyo, orderDyo, this.getSource(), cgSupplierIndex);
            log.info("@@@@@@@@\u5904\u7406\u5546\u57ce\u5355\u5934\u4fe1\u606f\u6210\u529f@@@@@@@@");
            log.info("@@@@@@@@\u5904\u7406\u5546\u57ce\u5206\u5f55\u4fe1\u606f@@@@@@@@");
            this.handleOrderEntryInfo(this.getSource(), sourceDyo, orderDyo, priceMap, skuIdMap, supplierSize);
            log.info("@@@@@@@@\u5904\u7406\u5546\u57ce\u5206\u5f55\u4fe1\u606f\u6210\u529f@@@@@@@@");
            log.info("@@@@@@@@\u6839\u636e\u5546\u57ce\u8ba2\u5355\u7f16\u7801\u89c4\u5219\u81ea\u52a8\u751f\u6210\u5355\u636e\u7f16\u7801@@@@@@@@");
            OperateOption option = OperateOption.create();
            option.setVariableValue("isStrict", "false");
            saveResult = SaveServiceHelper.saveOperate((String)"save", (String)"mal_order", (DynamicObject[])new DynamicObject[]{orderDyo}, (OperateOption)option);
            resultMsg.put("saveResult", saveResult);
            log.info("@@@@@@@@\u5f00\u59cb\u6839\u636e\u53c2\u6570\u66f4\u65b0\u5546\u54c1\u7269\u6599\u5bf9\u5e94\u5173\u7cfb\u8868\u4fe1\u606f@@@@@@@@");
            this.updateMappingRelation(materialMappingMap, skuIdMap);
            log.info("@@@@@@@@\u6839\u636e\u53c2\u6570\u66f4\u65b0\u5546\u54c1\u7269\u6599\u5bf9\u5e94\u5173\u7cfb\u8868\u4fe1\u606f\u5b8c\u6210@@@@@@@@");
            log.info("@@@@@@@@\u5f00\u59cb\u751f\u6210\u6668\u5149\u9884\u5360\u5e93\u5b58\u5355@@@@@@@@");
            Map<String, Object> cgResultMap = this.createCgOrder(sourceDyo, orderDyo.getString("billno"), qtyMap, goodPriceMap, cgSupplierIndex);
            String cgOrderId = (String)cgResultMap.get("orderId");
            log.info("@@@@@@@@\u751f\u6210\u6668\u5149\u9884\u5360\u5e93\u5b58\u5355\u5b8c\u6210@@@@@@@@");
            log.info("\u6668\u5149\u9884\u5360\u5e93\u5b58\u5355ID:" + cgOrderId);
            log.info("@@@@@@@@\u5f00\u59cb\u4fdd\u5b58\u6668\u5149\u8ba2\u5355\u76f8\u5173\u4fe1\u606f@@@@@@@@");
            this.saveCgParentOrder(cgSupplierIndex, sourceDyo, skuIdMap, priceMap, qtyMap, cgResultMap);
            log.info("@@@@@@@@\u4fdd\u5b58\u6668\u5149\u8ba2\u5355\u76f8\u5173\u4fe1\u606f\u5b8c\u6210@@@@@@@@");
            log.info("@@@@@@@@\u5f00\u59cb\u66f4\u65b0\u5546\u57ce\u8ba2\u5355\u4fe1\u606f@@@@@@@@");
            this.writeBack2OrderInfo(sourceDyo, cgOrderId, orderDyo.getString("billno"), cgResultMap, skuIdMap);
            log.info("@@@@@@@@\u66f4\u65b0\u5546\u57ce\u8ba2\u5355\u4fe1\u606f\u5b8c\u6210@@@@@@@@");
            log.info("@@@\u6668\u5149\u4e0b\u5355\u52a8\u6001\u5bf9\u8c61" + orderDyo);
            submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"mal_order", (Object[])saveResult.getSuccessPkIds().toArray(new Object[0]), (OperateOption)option);
            if (!submitResult.isSuccess()) {
                log.error("@@@kd.scm.mal.common.placeorder.service.XyPlaceOrderService.placeOrder,\u63d0\u4ea4\u5546\u57ce\u8ba2\u5355\u5f02\u5e38-->" + ExceptionUtil.getErrorInfoDetails((List)submitResult.getAllErrorOrValidateInfo()));
                String msg = ResManager.loadKDString((String)"\u5355\u636e\u63d0\u4ea4\u5931\u8d25,\u539f\u56e0\uff1a", (String)"CgPlaceOrderService_0", (String)"scm-mal-common", (Object[])new Object[0]);
                throw new KDBizException(new ErrorCode("Submit Bill fail", msg + submitResult.getMessage() + " " + ExceptionUtil.getErrorInfoDetails((List)submitResult.getAllErrorOrValidateInfo())), new Object[0]);
            }
            resultMsg.put("billid", submitResult.getSuccessPkIds().toArray(new Long[0])[0]);
            resultMsg.put("billno", orderDyo.getString("billno"));
            log.info("@@@@@@@@\u5f00\u59cb\u6839\u636e\u53c2\u6570\u6267\u884c\u5546\u57ce\u8ba2\u5355\u5ba1\u6838@@@@@@@@");
            String bizflow = MalOrderUtil.getBizFlowParam();
            if ((StringUtils.equalsIgnoreCase((CharSequence)bizflow, (CharSequence)MalBizflowParamEnum.ERP_PURORDER.getVal()) || StringUtils.equalsIgnoreCase((CharSequence)bizflow, (CharSequence)MalBizflowParamEnum.ERP_PURREQUEST.getVal())) && !(auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"mal_order", (Object[])submitResult.getSuccessPkIds().toArray(new Object[0]), (OperateOption)option)).isSuccess()) {
                log.error("@@@kd.scm.mal.common.placeorder.service.XyPlaceOrderService.placeOrder,\u5ba1\u6838\u5546\u57ce\u8ba2\u5355\u5931\u8d25,-->" + ExceptionUtil.getErrorInfoDetails((List)auditResult.getAllErrorOrValidateInfo()));
                String msg = ResManager.loadKDString((String)"\u5546\u57ce\u8ba2\u5355\u5ba1\u6838\u5931\u8d25,\u539f\u56e0\uff1a", (String)"CgPlaceOrderService_2", (String)"scm-mal-common", (Object[])new Object[0]);
                throw new KDBizException(new ErrorCode("Audit Bill fail", msg + auditResult.getMessage() + " " + ExceptionUtil.getErrorInfoDetails((List)auditResult.getAllErrorOrValidateInfo())), new Object[0]);
            }
            log.info("@@@@@@@@\u6839\u636e\u53c2\u6570\u6267\u884c\u5546\u57ce\u8ba2\u5355\u5ba1\u6838\u6210\u529f@@@@@@@@");
            if (((Boolean)sourceDyo.get("fromcart")).booleanValue()) {
                log.info("@@@@@@@@\u5f00\u59cb\u5220\u9664\u8d2d\u7269\u8f66\u91cc\u9762\u7684\u8bb0\u5f55@@@@@@@@");
                MalProductUtil.deleteCartProds4Jd(skusList);
                log.info("@@@@@@@@\u5220\u9664\u8d2d\u7269\u8f66\u91cc\u9762\u7684\u8bb0\u5f55\u5b8c\u6210@@@@@@@@");
            }
        }
        catch (Exception e) {
            resultMsg.put("errMsg", e.getMessage());
            log.error("@@@XyPlaceOrderService.placeOrder\u5546\u57ce\u4e0b\u5355\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + ExceptionUtil.getStackTrace((Throwable)e));
            if (e instanceof KDBizException) {
                KDBizException kdBizException = (KDBizException)e;
                this.rollBackMalOrder(saveResult, kdBizException);
            }
            this.rollBackMalOrder(saveResult);
        }
        return resultMsg;
    }

    protected Map<String, Object> createCgOrder(DynamicObject sourceDyo, String orderBillNo, Map<String, Integer> qtyMap, Map<String, BigDecimal> goodPriceMap, int cgSupplierIndex) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        StringBuilder logString = new StringBuilder();
        logString.append(ResManager.loadKDString((String)"\u751f\u6210\u6668\u5149\u9884\u5360\u5e93\u5b58\u5355\u63a5\u53e3\u53c2\u6570:", (String)"CgPlaceOrderService_4", (String)"scm-mal-common", (Object[])new Object[0]));
        HashMap<String, Object> params = new HashMap<String, Object>(32);
        params.put("thirdOrder", orderBillNo);
        logString.append("thirdOrder:").append(orderBillNo);
        ArrayList skuList = new ArrayList(qtyMap.size());
        for (Map.Entry<String, Integer> skuEntry : qtyMap.entrySet()) {
            HashMap<String, String> map = new HashMap<String, String>(4);
            map.put("sku", skuEntry.getKey());
            map.put("num", skuEntry.getValue().toString());
            map.put("price", goodPriceMap.get(skuEntry.getKey()).toString());
            skuList.add(map);
        }
        params.put("sku", skuList);
        logString.append("sku:").append(SerializationUtils.toJsonString(skuList));
        Map<String, String> recieptMap = MalJdProductUtil.getRecieptInfo(sourceDyo.getString("receipt"));
        params.put("receiverName", recieptMap.get("receiptname"));
        String addressId = sourceDyo.getString("addressid");
        String[] addr = AddressUtil.getNumberArr((Long)Long.valueOf(addressId), (String)this.getSource());
        if (null == addr || addr.length < 3) {
            log.error("\u65b0\u7248\u5546\u57ce\u83b7\u53d6\u6668\u5149\u4e0b\u5355\u5730\u5740\u5931\u8d25, \u5546\u57ce\u5730\u5740 = " + addressId + "\u6668\u5149\u5730\u5740 = " + addr);
            throw new KDException(new ErrorCode("get cg address error", ResManager.loadKDString((String)"\u83b7\u53d6\u6668\u5149\u4e0b\u5355\u5730\u5740\u5931\u8d25\u3002", (String)"CgPlaceOrderService_3", (String)"scm-mal-common", (Object[])new Object[0])), new Object[0]);
        }
        params.put("provinceId", addr[MalPlaceOrderConstant.PROVINCE_INDEX]);
        params.put("cityId", addr[MalPlaceOrderConstant.CITY_INDEX]);
        params.put("countyId", addr[MalPlaceOrderConstant.COUNTY_INDEX]);
        params.put("address", recieptMap.get("receiptAddr"));
        params.put("mobile", recieptMap.get("receiptphone"));
        params.put("email", recieptMap.get("receiptemail"));
        params.put("zip", recieptMap.get("receiptzip"));
        params.put("remark", sourceDyo.getString("remark" + cgSupplierIndex));
        params.put("invoiceType", sourceDyo.get("invoicetype" + cgSupplierIndex).toString());
        logString.append("invoiceType:").append(sourceDyo.get("invoicetype" + cgSupplierIndex).toString());
        params.put("invoiceTitle", sourceDyo.getString("invoiceorg.ffirmname.zh_CN").trim());
        logString.append("invoiceTitle:").append(sourceDyo.getString("invoiceorg.ffirmname.zh_CN").trim());
        params.put("paymentType", sourceDyo.get("paytype" + cgSupplierIndex).toString());
        logString.append("paymentType:").append(sourceDyo.get("paytype" + cgSupplierIndex).toString());
        params.put("amount", sourceDyo.getBigDecimal("totalgoodsamt" + cgSupplierIndex).toString());
        params.put("servFee", sourceDyo.getBigDecimal("freight" + cgSupplierIndex).toString());
        params.put("regCode", sourceDyo.getString("invoiceorg.ftaxregnum").trim());
        params.put("regBank", sourceDyo.getString("invoiceorg.depositbank").trim());
        params.put("regBankAccount", sourceDyo.getString("invoiceorg.bankaccount").trim());
        params.put("invoicePhone", sourceDyo.getString("invoiceorg.phone").trim());
        params.put("invoiceAddress", sourceDyo.getString("invoiceorg.faddress").trim());
        log.info(logString.toString());
        Map data = (Map)EcApiUtil.parseResful((Object)ApiAccessor.invoke((String)"SRM_CG_ORDER_order", params));
        log.info("\u8c03\u7528\u751f\u6210\u6668\u5149\u9884\u5360\u5e93\u5b58\u5355\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\uff1a" + data);
        String orderId = data.get("yggc_order").toString();
        result.put("orderId", orderId);
        result.put("resultMap", data);
        result.put("sku", data.get("skus"));
        return result;
    }

    private void writeBack2OrderInfo(DynamicObject sourceDyo, String orderId, String billNo, Map<String, Object> result, Map<String, String> skuIdMap) {
        HashMap<String, String> idSkuMap = new HashMap<String, String>((int)((double)skuIdMap.size() / 0.75));
        for (Map.Entry<String, String> entry : skuIdMap.entrySet()) {
            idSkuMap.put(entry.getValue(), entry.getKey());
        }
        QFilter filter = new QFilter("billno", "=", (Object)billNo);
        String head = DynamicObjectUtil.getSelectfields((String)"mal_order", (boolean)false);
        String entry = DynamicObjectUtil.getEntrySelectfields((String)"", (String)"mal_order", (String)"entryentity", (boolean)false);
        String selectFields = head + "," + entry;
        DynamicObject[] dyo = BusinessDataServiceHelper.load((String)"mal_order", (String)selectFields, (QFilter[])new QFilter[]{filter});
        dyo[0].set("jdorderid", (Object)orderId);
        String cgParentOrderPkId = MalPlaceOrderUtils.getParentOrderPkId(orderId, this.getSource()).toString();
        DynamicObject cgOrderDyn = MalPlaceOrderUtils.getOrderDyn(cgParentOrderPkId, this.getSource());
        dyo[0].set("ecorderid_id", (Object)cgParentOrderPkId);
        dyo[0].set("ecorderid", (Object)cgOrderDyn);
        dyo[0].set("orderstatus", (Object)EmalStatusUtil.getNumber((String)cgOrderDyn.get("state").toString(), (String)"1", (String)this.getSource()));
        for (DynamicObject temp : (DynamicObjectCollection)dyo[0].get("entryentity")) {
            String goodsId = temp.getString("goods.id");
            String goodsIdSku = (String)idSkuMap.get(goodsId);
            if (goodsIdSku == null) continue;
            List list = (List)result.get("sku");
            for (Map map : list) {
                if (!goodsIdSku.equalsIgnoreCase(map.get("sku").toString())) continue;
                temp.set("taxprice", (Object)new BigDecimal(map.get("price").toString()));
                temp.set("taxrate", (Object)new BigDecimal(null == map.get("tax_rate") ? "0" : map.get("tax_rate").toString()).multiply(new BigDecimal("100.00")));
                temp.set("order_id", (Object)cgParentOrderPkId);
                temp.set("order", (Object)cgOrderDyn);
            }
        }
        Cal4DynamicObj.reCalBill((DynamicObject)dyo[0], (String)"entryentity");
        SaveServiceHelper.save((DynamicObject[])dyo);
    }

    public void saveCgParentOrder(int cgSupplierIndex, DynamicObject sourceDyo, Map<String, String> skuIdMap, Map<String, PriceInfo> priceMap, Map<String, Integer> qtyMap, Map<String, Object> result) {
        DynamicObject cgOrder = BusinessDataServiceHelper.newDynamicObject((String)"pbd_order_cg");
        this.setCgOrderHeadInfo(sourceDyo, cgSupplierIndex, cgOrder, result);
        this.setCgOrderEntryInfo(cgOrder, skuIdMap, priceMap, qtyMap, result);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{cgOrder});
    }

    public void setCgOrderHeadInfo(DynamicObject sourceDyo, int cgSupplierIndex, DynamicObject cgOrder, Map<String, Object> result) {
        String currency = MalOrderUtil.getDefaultCurrency();
        Date currentDate = new Date();
        String orderId = (String)result.get("orderId");
        Map data = (Map)result.get("resultMap");
        cgOrder.set("porderid", (Object)orderId);
        cgOrder.set("orderid", (Object)orderId);
        cgOrder.set("submitstate", (Object)"0");
        cgOrder.set("orderstate", (Object)"1");
        cgOrder.set("state", (Object)"0");
        cgOrder.set("ordernakedamount", (Object)new BigDecimal(Parser.toString(data.get("order_naked_price"))));
        cgOrder.set("ordertaxamount", (Object)new BigDecimal(Parser.toString(data.get("order_taxprice_total"))));
        cgOrder.set("freight", (Object)(null == data.get("freight") ? BigDecimal.ZERO : new BigDecimal(Parser.toString(data.get("freight")))));
        cgOrder.set("orderamount", (Object)new BigDecimal(Parser.toString(data.get("order_price"))));
        if (StringUtils.isNotBlank((CharSequence)currency)) {
            cgOrder.set("currency_id", (Object)currency);
        } else {
            cgOrder.set("currency_id", (Object)"1");
        }
        cgOrder.set("invoicestate", (Object)PurEcInvoiceEnum.PREREQUEST.getVal());
        cgOrder.set("invoicetype", (Object)sourceDyo.get("invoicetype" + cgSupplierIndex).toString());
        cgOrder.set("createtime", (Object)currentDate);
    }

    public void setCgOrderEntryInfo(DynamicObject cgOrder, Map<String, String> skuIdMap, Map<String, PriceInfo> priceMap, Map<String, Integer> qtyMap, Map<String, Object> result) {
        DynamicObjectCollection entryDyoCol = (DynamicObjectCollection)cgOrder.get("entryentity");
        List skuList = (List)result.get("sku");
        for (Map.Entry<String, Integer> skuMap : qtyMap.entrySet()) {
            DynamicObject entryDyo = entryDyoCol.addNew();
            entryDyo.set("goods", (Object)skuIdMap.get(skuMap.getKey()));
            entryDyo.set("qty", (Object)skuMap.getValue());
            for (Map map : skuList) {
                if (null == map.get("skuId") || !map.get("sku").toString().equalsIgnoreCase(skuMap.getKey())) continue;
                entryDyo.set("price", (Object)new BigDecimal(null == map.get("price") ? "0" : map.get("price").toString()));
                entryDyo.set("nakedamount", (Object)new BigDecimal(null == map.get("naked_price") ? "0" : map.get("naked_price").toString()));
                entryDyo.set("taxamount", (Object)new BigDecimal(null == map.get("tax_price") ? "0" : map.get("tax_price").toString()));
                entryDyo.set("taxrate", (Object)new BigDecimal(null == map.get("tax_rate") ? "0" : map.get("tax_rate").toString()).multiply(new BigDecimal("100.00")));
            }
        }
    }
}

