/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.placeorder.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ecapi.entity.PriceInfo;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.ecapi.util.AddressUtil;
import kd.scm.common.ecapi.util.EmalStatusUtil;
import kd.scm.common.enums.PurEcInvoiceEnum;
import kd.scm.common.helper.apiconnector.api.ApiAccessor;
import kd.scm.common.helper.apiconnector.api.util.EcApiUtil;
import kd.scm.common.helper.apiconnector.api.util.Parser;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.cal.Cal4DynamicObj;
import kd.scm.mal.common.constant.MalPlaceOrderConstant;
import kd.scm.mal.common.enums.MalBizflowParamEnum;
import kd.scm.mal.common.placeorder.service.PlaceOrderService;
import kd.scm.mal.common.util.MalJdProductUtil;
import kd.scm.mal.common.util.MalPlaceOrderUtils;
import kd.scm.mal.common.util.MalProductUtil;

@Deprecated
public class DlPlaceOrderService
extends PlaceOrderService {
    private static Log log = LogFactory.getLog(DlPlaceOrderService.class);

    @Override
    public String getSource() {
        return EcPlatformEnum.ECPLATFORM_DL.getVal();
    }

    @Override
    public Map<String, Object> checkStatus(List<String> productIdList) {
        List<String> offList = MalPlaceOrderUtils.checkSkuStates(this.getSource(), productIdList);
        if (null != offList && offList.size() > 0) {
            HashMap<String, Object> result = new HashMap<String, Object>(2);
            result.put("status", Boolean.FALSE);
            result.put("goodsList", offList);
            return result;
        }
        return null;
    }

    private Map<String, BigDecimal> getAmountParam(Map<String, PriceInfo> priceInfoMap, Map<String, Integer> qtyMap) {
        HashMap<String, BigDecimal> resMap = new HashMap<String, BigDecimal>(8);
        BigDecimal totalTaxAmount = BigDecimal.ZERO;
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalTax = BigDecimal.ZERO;
        for (Map.Entry<String, Integer> entry : qtyMap.entrySet()) {
            String sku = entry.getKey();
            if (null == priceInfoMap.get(sku) || null == priceInfoMap.get(sku).getTaxPrice() || null == priceInfoMap.get(sku).getPrice()) continue;
            totalTaxAmount = totalTaxAmount.add(Parser.toBigDecimal((Object)entry.getValue()).multiply(priceInfoMap.get(sku).getTaxPrice()));
            totalAmount = totalAmount.add(Parser.toBigDecimal((Object)entry.getValue()).multiply(priceInfoMap.get(sku).getPrice()));
        }
        totalTax = totalTaxAmount.subtract(totalAmount);
        resMap.put("orderPrice", totalTaxAmount);
        resMap.put("orderNakedPrice", totalAmount);
        resMap.put("orderTaxPrice", totalTax);
        return resMap;
    }

    @Override
    public Map<String, Object> placeOrder(int supplierSize, DynamicObject sourceDyo) {
        HashMap<String, Object> resultMsg = new HashMap<String, Object>(4);
        resultMsg.put("source", this.getSource());
        LinkedHashMap<String, Object> materialMappingMap = new LinkedHashMap<String, Object>(10);
        DynamicObject orderDyo = BusinessDataServiceHelper.newDynamicObject((String)"mal_order");
        ArrayList<String> skusList = new ArrayList<String>(10);
        HashMap<String, String> nameMap = new HashMap<String, String>(10);
        HashMap<String, String> imgMap = new HashMap<String, String>(10);
        HashMap<String, Integer> qtyMap = new HashMap<String, Integer>(10);
        int dlSupplierIndex = 0;
        for (int supplierIndex = 1; supplierIndex <= supplierSize; ++supplierIndex) {
            if (!sourceDyo.get("source" + supplierIndex).toString().equalsIgnoreCase(this.getSource())) continue;
            dlSupplierIndex = supplierIndex;
            DynamicObjectCollection entryDyoCol = (DynamicObjectCollection)sourceDyo.get("entryentity" + supplierIndex);
            for (DynamicObject dyo : entryDyoCol) {
                String sku = dyo.getString("goods" + supplierIndex);
                Object materialId = dyo.get("material" + supplierIndex);
                skusList.add(sku);
                nameMap.put(sku, dyo.getString("goodsname" + supplierIndex));
                imgMap.put(sku, dyo.getString("goodsimg" + supplierIndex));
                qtyMap.put(sku, dyo.getInt("qty" + supplierIndex));
                materialMappingMap.put(sku, materialId);
            }
        }
        OperationResult saveResult = null;
        OperationResult submitResult = null;
        try {
            OperationResult auditResult;
            log.info("@@@@@@@@\u5f00\u59cb\u83b7\u53d6\u5f97\u529b\u5546\u54c1@@@@@@@@");
            Map<String, String> skuIdMap = MalPlaceOrderUtils.getMalGoods(skusList, nameMap, imgMap, this.getSource());
            log.info("@@@@@@@@\u83b7\u53d6\u5f97\u529b\u5546\u54c1\u6210\u529f@@@@@@@@");
            log.info("@@@@@@@@\u53d6\u5f97\u529b\u4ef7\u683c@@@@@@@@");
            Map<String, PriceInfo> priceMap = MalPlaceOrderUtils.getMalGoodsPrice(this.getSource(), skusList, null).get(this.getSource());
            log.info("@@@@@@@@\u53d6\u5f97\u529b\u4ef7\u683c\u6210\u529f@@@@@@@@");
            this.preHandleDynamicObj(sourceDyo, null, skusList);
            log.info("@@@@@@@@\u5904\u7406\u5546\u57ce\u5355\u5934\u4fe1\u606f@@@@@@@@");
            this.handleOrderHeadInfo(sourceDyo, orderDyo, this.getSource(), dlSupplierIndex);
            log.info("@@@@@@@@\u5904\u7406\u5546\u57ce\u5355\u5934\u4fe1\u606f\u6210\u529f@@@@@@@@");
            log.info("@@@@@@@@\u5904\u7406\u5546\u57ce\u5206\u5f55\u4fe1\u606f@@@@@@@@");
            this.handleOrderEntryInfo(this.getSource(), sourceDyo, orderDyo, priceMap, skuIdMap, supplierSize);
            log.info("@@@@@@@@\u5904\u7406\u5546\u57ce\u5206\u5f55\u4fe1\u606f\u6210\u529f@@@@@@@@");
            log.info("@@@@@@@@\u6839\u636e\u5546\u57ce\u8ba2\u5355\u7f16\u7801\u89c4\u5219\u81ea\u52a8\u751f\u6210\u5355\u636e\u7f16\u7801@@@@@@@@");
            OperateOption option = OperateOption.create();
            option.setVariableValue("isStrict", "false");
            saveResult = SaveServiceHelper.saveOperate((String)"save", (String)"mal_order", (DynamicObject[])new DynamicObject[]{orderDyo}, (OperateOption)option);
            resultMsg.put("saveResult", saveResult);
            log.info("@@@@@@@@\u5f00\u59cb\u6839\u636e\u53c2\u6570\u66f4\u65b0\u5546\u54c1\u7269\u6599\u5bf9\u5e94\u5173\u7cfb\u8868\u4fe1\u606f@@@@@@@@");
            this.updateMappingRelation(materialMappingMap, skuIdMap);
            log.info("@@@@@@@@\u6839\u636e\u53c2\u6570\u66f4\u65b0\u5546\u54c1\u7269\u6599\u5bf9\u5e94\u5173\u7cfb\u8868\u4fe1\u606f\u5b8c\u6210@@@@@@@@");
            log.info("@@@@@@@@\u5f00\u59cb\u751f\u6210\u5f97\u529b\u9884\u5360\u5e93\u5b58\u5355@@@@@@@@");
            Map<String, Object> dlResultMap = this.createDlOrder(sourceDyo, String.valueOf(DBServiceHelper.genGlobalLongId()), qtyMap, priceMap, dlSupplierIndex);
            String dlOrderId = (String)dlResultMap.get("orderId");
            log.info("@@@@@@@@\u751f\u6210\u5f97\u529b\u9884\u5360\u5e93\u5b58\u5355\u5b8c\u6210@@@@@@@@");
            log.info("\u5f97\u529b\u9884\u5360\u5e93\u5b58\u5355ID:" + dlOrderId);
            log.info("@@@@@@@@\u5f00\u59cb\u4fdd\u5b58\u5f97\u529b\u8ba2\u5355\u76f8\u5173\u4fe1\u606f@@@@@@@@");
            this.savedlParentOrder(dlSupplierIndex, sourceDyo, skuIdMap, priceMap, qtyMap, dlResultMap);
            log.info("@@@@@@@@\u4fdd\u5b58\u5f97\u529b\u8ba2\u5355\u76f8\u5173\u4fe1\u606f\u5b8c\u6210@@@@@@@@");
            log.info("@@@@@@@@\u5f00\u59cb\u66f4\u65b0\u5546\u57ce\u8ba2\u5355\u4fe1\u606f@@@@@@@@");
            this.writeBack2OrderInfo(sourceDyo, dlOrderId, orderDyo.getString("billno"), priceMap, skuIdMap);
            log.info("@@@@@@@@\u66f4\u65b0\u5546\u57ce\u8ba2\u5355\u4fe1\u606f\u5b8c\u6210@@@@@@@@");
            log.info("@@@\u5f97\u529b\u4e0b\u5355\u52a8\u6001\u5bf9\u8c61" + orderDyo);
            submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"mal_order", (Object[])saveResult.getSuccessPkIds().toArray(new Object[0]), (OperateOption)option);
            if (!submitResult.isSuccess()) {
                log.error("@@@kd.scm.mal.common.placeorder.service.DlPlaceOrderService.placeOrder,\u63d0\u4ea4\u5546\u57ce\u8ba2\u5355\u5f02\u5e38-->" + ExceptionUtil.getErrorInfoDetails((List)submitResult.getAllErrorOrValidateInfo()));
                String msg = ResManager.loadKDString((String)"\u5355\u636e\u63d0\u4ea4\u5931\u8d25,\u539f\u56e0\uff1a", (String)"DlPlaceOrderService_0", (String)"scm-mal-common", (Object[])new Object[0]);
                throw new KDBizException(new ErrorCode("Submit Bill fail", msg + submitResult.getMessage() + " " + ExceptionUtil.getErrorInfoDetails((List)submitResult.getAllErrorOrValidateInfo())), new Object[0]);
            }
            resultMsg.put("billid", submitResult.getSuccessPkIds().toArray(new Long[0])[0]);
            resultMsg.put("billno", orderDyo.getString("billno"));
            log.info("@@@@@@@@\u5f00\u59cb\u6839\u636e\u53c2\u6570\u6267\u884c\u5546\u57ce\u8ba2\u5355\u5ba1\u6838@@@@@@@@");
            String bizflow = MalOrderUtil.getBizFlowParam();
            if ((StringUtils.equalsIgnoreCase((CharSequence)bizflow, (CharSequence)MalBizflowParamEnum.ERP_PURORDER.getVal()) || StringUtils.equalsIgnoreCase((CharSequence)bizflow, (CharSequence)MalBizflowParamEnum.ERP_PURREQUEST.getVal())) && !(auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"mal_order", (Object[])submitResult.getSuccessPkIds().toArray(new Object[0]), (OperateOption)option)).isSuccess()) {
                log.error("@@@kd.scm.mal.common.placeorder.service.DlPlaceOrderService.placeOrder,\u5ba1\u6838\u5546\u57ce\u8ba2\u5355\u5931\u8d25,-->" + ExceptionUtil.getErrorInfoDetails((List)auditResult.getAllErrorOrValidateInfo()));
                String msg = ResManager.loadKDString((String)"\u5546\u57ce\u8ba2\u5355\u5ba1\u6838\u5931\u8d25,\u539f\u56e0\uff1a", (String)"DlPlaceOrderService_1", (String)"scm-mal-common", (Object[])new Object[0]);
                throw new KDBizException(new ErrorCode("Audit Bill fail", msg + auditResult.getMessage() + " " + ExceptionUtil.getErrorInfoDetails((List)auditResult.getAllErrorOrValidateInfo())), new Object[0]);
            }
            log.info("@@@@@@@@\u6839\u636e\u53c2\u6570\u6267\u884c\u5546\u57ce\u8ba2\u5355\u5ba1\u6838\u6210\u529f@@@@@@@@");
            if (((Boolean)sourceDyo.get("fromcart")).booleanValue()) {
                log.info("@@@@@@@@\u5f00\u59cb\u5220\u9664\u8d2d\u7269\u8f66\u91cc\u9762\u7684\u8bb0\u5f55@@@@@@@@");
                MalProductUtil.deleteCartProds4Jd(skusList);
                log.info("@@@@@@@@\u5220\u9664\u8d2d\u7269\u8f66\u91cc\u9762\u7684\u8bb0\u5f55\u5b8c\u6210@@@@@@@@");
            }
        }
        catch (Exception e) {
            resultMsg.put("errMsg", e.getMessage());
            log.error("@@@DlPlaceOrderService.placeOrder\u5546\u57ce\u4e0b\u5355\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + ExceptionUtil.getStackTrace((Throwable)e));
            if (e instanceof KDBizException) {
                KDBizException kdBizException = (KDBizException)e;
                this.rollBackMalOrder(saveResult, kdBizException);
            }
            this.rollBackMalOrder(saveResult);
        }
        return resultMsg;
    }

    protected Map<String, Object> createDlOrder(DynamicObject sourceDyo, String orderBillNo, Map<String, Integer> qtyMap, Map<String, PriceInfo> priceInfoMap, int dlSupplierIndex) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<String, BigDecimal> amountParamMap = this.getAmountParam(priceInfoMap, qtyMap);
        StringBuilder logString = new StringBuilder();
        logString.append(ResManager.loadKDString((String)"\u751f\u6210\u5f97\u529b\u9884\u5360\u5e93\u5b58\u5355\u63a5\u53e3\u53c2\u6570:", (String)"DlPlaceOrderService_2", (String)"scm-mal-common", (Object[])new Object[0]));
        HashMap<String, Object> params = new HashMap<String, Object>(32);
        params.put("pxOrderId", orderBillNo);
        logString.append("pxOrderId:").append(orderBillNo);
        Map<String, String> recieptMap = MalJdProductUtil.getRecieptInfo(sourceDyo.getString("receipt"));
        params.put("name", recieptMap.get("receiptname"));
        String addressId = sourceDyo.getString("addressid");
        String[] addr = AddressUtil.getNumberArr((Long)Long.valueOf(addressId), (String)this.getSource());
        if (null == addr || addr.length < 3) {
            log.error("\u65b0\u7248\u5546\u57ce\u83b7\u53d6\u5f97\u529b\u4e0b\u5355\u5730\u5740\u5931\u8d25, \u5546\u57ce\u5730\u5740 = " + addressId + "\u5f97\u529b\u5730\u5740 = " + addr);
            throw new KDException(new ErrorCode("get DL address error", ResManager.loadKDString((String)"\u83b7\u53d6\u5f97\u529b\u4e0b\u5355\u5730\u5740\u5931\u8d25\u3002", (String)"DlPlaceOrderService_3", (String)"scm-mal-common", (Object[])new Object[0])), new Object[0]);
        }
        params.put("province", addr[MalPlaceOrderConstant.PROVINCE_INDEX]);
        params.put("city", addr[MalPlaceOrderConstant.CITY_INDEX]);
        params.put("county", addr[MalPlaceOrderConstant.COUNTY_INDEX]);
        params.put("address", recieptMap.get("receiptAddr"));
        params.put("mobile", recieptMap.get("receiptphone"));
        params.put("email", recieptMap.get("receiptemail"));
        params.put("zip", recieptMap.get("receiptzip"));
        params.put("remark", sourceDyo.getString("remark" + dlSupplierIndex));
        params.put("companyName", sourceDyo.getString("invoiceorg.ffirmname.zh_CN").trim());
        params.put("payType", sourceDyo.get("paytype" + dlSupplierIndex).toString());
        params.put("orderPrice", amountParamMap.get("orderPrice"));
        params.put("orderNakedPrice", amountParamMap.get("orderNakedPrice"));
        params.put("orderTaxPrice", amountParamMap.get("orderTaxPrice"));
        params.put("invoiceType", sourceDyo.get("invoicetype" + dlSupplierIndex).toString());
        params.put("invoiceState", "2");
        params.put("invoiceTitle", sourceDyo.getString("invoiceorg.ffirmname.zh_CN").trim());
        params.put("invoiceIdNo", sourceDyo.getString("invoiceorg.ftaxregnum").trim());
        params.put("invoiceBankName", sourceDyo.getString("invoiceorg.depositbank").trim());
        params.put("invoiceBankNo", sourceDyo.getString("invoiceorg.bankaccount").trim());
        params.put("invoiceAddress", sourceDyo.getString("invoiceorg.faddress").trim());
        params.put("invoiceTelephone", sourceDyo.getString("invoiceorg.phone").trim());
        StringBuilder skuStr = new StringBuilder();
        skuStr.append('[');
        for (Map.Entry<String, Integer> skuEntry : qtyMap.entrySet()) {
            skuStr.append('{');
            skuStr.append("\"sku\":\"").append(skuEntry.getKey()).append("\",\"pxSku\":\"").append(skuEntry.getKey()).append("\",\"num\":").append(skuEntry.getValue()).append(",\"price\":").append(priceInfoMap.get(skuEntry.getKey()) != null ? Parser.toString((Object)priceInfoMap.get(skuEntry.getKey()).getTaxPrice()) : "0.00").append(",\"nakedPrice\":").append(priceInfoMap.get(skuEntry.getKey()) != null ? Parser.toString((Object)priceInfoMap.get(skuEntry.getKey()).getPrice()) : "0.00").append(",\"taxPrice\":").append(priceInfoMap.get(skuEntry.getKey()) != null ? Parser.toString((Object)priceInfoMap.get(skuEntry.getKey()).getTax()) : "0.00").append(",\"taxRate\":").append(priceInfoMap.get(skuEntry.getKey()) != null ? Parser.toString((Object)priceInfoMap.get(skuEntry.getKey()).getTaxRate()) : "0.00");
            skuStr.append("},");
        }
        String tempSku = skuStr.substring(0, skuStr.lastIndexOf(","));
        tempSku = tempSku + "]";
        params.put("orderDetails", tempSku);
        logString.append("orderDetails:").append(tempSku);
        params.put("freight", sourceDyo.getBigDecimal("freight" + dlSupplierIndex).toString());
        log.info(logString.toString());
        Map data = (Map)EcApiUtil.parseResful((Object)ApiAccessor.invoke((String)"SRM_DL_ORDER_submitOrderV2", params));
        log.info("\u8c03\u7528\u751f\u6210\u5f97\u529b\u9884\u5360\u5e93\u5b58\u5355\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\uff1a" + data);
        String orderId = data.get("pxOrderId").toString();
        result.put("orderId", orderId);
        result.put("resultMap", data);
        return result;
    }

    private void writeBack2OrderInfo(DynamicObject sourceDyo, String orderId, String billNo, Map<String, PriceInfo> priceMap, Map<String, String> skuIdMap) {
        HashMap<String, String> idSkuMap = new HashMap<String, String>((int)((double)skuIdMap.size() / 0.75));
        for (Map.Entry<String, String> entry : skuIdMap.entrySet()) {
            idSkuMap.put(entry.getValue(), entry.getKey());
        }
        QFilter filter = new QFilter("billno", "=", (Object)billNo);
        String head = DynamicObjectUtil.getSelectfields((String)"mal_order", (boolean)false);
        String entry = DynamicObjectUtil.getEntrySelectfields((String)"", (String)"mal_order", (String)"entryentity", (boolean)false);
        String selectFields = head + "," + entry;
        DynamicObject[] dyo = BusinessDataServiceHelper.load((String)"mal_order", (String)selectFields, (QFilter[])new QFilter[]{filter});
        dyo[0].set("jdorderid", (Object)orderId);
        String dlParentOrderPkId = MalPlaceOrderUtils.getParentOrderPkId(orderId, this.getSource()).toString();
        DynamicObject dlOrderDyn = MalPlaceOrderUtils.getOrderDyn(dlParentOrderPkId, this.getSource());
        dyo[0].set("ecorderid_id", (Object)dlParentOrderPkId);
        dyo[0].set("ecorderid", (Object)dlOrderDyn);
        dyo[0].set("orderstatus", (Object)EmalStatusUtil.getNumber((String)dlOrderDyn.get("state").toString(), (String)"1", (String)this.getSource()));
        for (DynamicObject temp : (DynamicObjectCollection)dyo[0].get("entryentity")) {
            String goodsId = temp.getString("goods.id");
            String goodsIdSku = (String)idSkuMap.get(goodsId);
            if (goodsIdSku == null) continue;
            PriceInfo priceInfo = priceMap.get(goodsIdSku);
            temp.set("taxprice", (Object)priceInfo.getTaxPrice());
            temp.set("taxrate", (Object)priceInfo.getTaxRate());
            temp.set("order_id", (Object)dlParentOrderPkId);
            temp.set("order", (Object)dlOrderDyn);
        }
        Cal4DynamicObj.reCalBill((DynamicObject)dyo[0], (String)"entryentity");
        SaveServiceHelper.save((DynamicObject[])dyo);
    }

    public void savedlParentOrder(int dlSupplierIndex, DynamicObject sourceDyo, Map<String, String> skuIdMap, Map<String, PriceInfo> priceMap, Map<String, Integer> qtyMap, Map<String, Object> result) {
        DynamicObject dlOrder = BusinessDataServiceHelper.newDynamicObject((String)"pbd_order_dl");
        Map<String, BigDecimal> amountParamMap = this.getAmountParam(priceMap, qtyMap);
        this.setDlOrderHeadInfo(sourceDyo, dlSupplierIndex, dlOrder, result, amountParamMap);
        this.setdlOrderEntryInfo(dlOrder, skuIdMap, priceMap, qtyMap, result);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dlOrder});
    }

    public void setDlOrderHeadInfo(DynamicObject sourceDyo, int dlSupplierIndex, DynamicObject dlOrder, Map<String, Object> result, Map<String, BigDecimal> amountParamMap) {
        String currency = MalOrderUtil.getDefaultCurrency();
        Date currentDate = new Date();
        String orderId = (String)result.get("orderId");
        Map data = (Map)result.get("resultMap");
        dlOrder.set("porderid", (Object)orderId);
        dlOrder.set("orderid", (Object)orderId);
        dlOrder.set("submitstate", (Object)"0");
        dlOrder.set("orderstate", (Object)"1");
        dlOrder.set("state", (Object)"1");
        dlOrder.set("freight", (Object)(null == data.get("freight") ? BigDecimal.ZERO : new BigDecimal(Parser.toString(data.get("freight")))));
        dlOrder.set("ordernakedamount", (Object)amountParamMap.get("orderNakedPrice"));
        dlOrder.set("ordertaxamount", (Object)amountParamMap.get("orderTaxPrice"));
        dlOrder.set("orderamount", (Object)amountParamMap.get("orderPrice"));
        if (StringUtils.isNotBlank((CharSequence)currency)) {
            dlOrder.set("currency_id", (Object)currency);
        } else {
            dlOrder.set("currency_id", (Object)"1");
        }
        dlOrder.set("invoicestate", (Object)PurEcInvoiceEnum.PREREQUEST.getVal());
        dlOrder.set("invoicetype", (Object)sourceDyo.get("invoicetype" + dlSupplierIndex).toString());
        dlOrder.set("createtime", (Object)currentDate);
    }

    public void setdlOrderEntryInfo(DynamicObject dlOrder, Map<String, String> skuIdMap, Map<String, PriceInfo> priceMap, Map<String, Integer> qtyMap, Map<String, Object> result) {
        DynamicObjectCollection entryDyoCol = (DynamicObjectCollection)dlOrder.get("entryentity");
        for (Map.Entry<String, Integer> skuMap : qtyMap.entrySet()) {
            DynamicObject entryDyo = entryDyoCol.addNew();
            String sku = skuMap.getKey();
            entryDyo.set("goods", (Object)skuIdMap.get(sku));
            entryDyo.set("qty", (Object)skuMap.getValue());
            PriceInfo priceInfo = priceMap.get(sku);
            if (null == priceInfo) continue;
            entryDyo.set("price", (Object)(priceInfo.getTaxPrice() == null ? BigDecimal.ZERO : priceInfo.getTaxPrice()));
            entryDyo.set("nakedamount", (Object)(priceInfo.getPrice() == null ? BigDecimal.ZERO : priceInfo.getPrice()));
            entryDyo.set("taxamount", (Object)(priceInfo.getTax() == null ? BigDecimal.ZERO : priceInfo.getTax()));
            entryDyo.set("taxrate", (Object)(priceInfo.getTaxRate() == null ? BigDecimal.ZERO : priceInfo.getTaxRate()));
        }
    }
}

