/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.placeorder.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ecapi.entity.PriceInfo;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.ecapi.jd.JDAccessTokenUtil;
import kd.scm.common.ecapi.util.AddressUtil;
import kd.scm.common.ecapi.util.EmalStatusUtil;
import kd.scm.common.enums.JDOrderStatusEnum;
import kd.scm.common.enums.PurEcInvoiceEnum;
import kd.scm.common.helper.apiconnector.api.ApiAccessor;
import kd.scm.common.helper.apiconnector.api.parser.JdApiParser;
import kd.scm.common.helper.apiconnector.api.util.EcApiUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.cal.Cal4DynamicObj;
import kd.scm.mal.common.constant.MalPlaceOrderConstant;
import kd.scm.mal.common.enums.MalBizflowParamEnum;
import kd.scm.mal.common.placeorder.service.PlaceOrderService;
import kd.scm.mal.common.util.MalJdProductUtil;
import kd.scm.mal.common.util.MalPlaceOrderUtils;
import kd.scm.mal.common.util.MalProductUtil;

@Deprecated
public class JdPlaceOrderService
extends PlaceOrderService {
    private static Log log = LogFactory.getLog(JdPlaceOrderService.class);

    @Override
    public String getSource() {
        return EcPlatformEnum.ECPLATFORM_JD.getVal();
    }

    @Override
    public Map<String, Object> checkStatus(List<String> productIdList) {
        List<String> offList = MalPlaceOrderUtils.checkSkuStates(this.getSource(), productIdList);
        if (null != offList && offList.size() > 0) {
            HashMap<String, Object> result = new HashMap<String, Object>(2);
            result.put("status", Boolean.FALSE);
            result.put("goodsList", offList);
            return result;
        }
        return null;
    }

    @Override
    public Map<String, Object> placeOrder(int supplierSize, DynamicObject sourceDyo) {
        HashMap<String, Object> resultMsg = new HashMap<String, Object>(4);
        resultMsg.put("source", this.getSource());
        LinkedHashMap<String, Object> materialMappingMap = new LinkedHashMap<String, Object>();
        DynamicObject orderDyo = BusinessDataServiceHelper.newDynamicObject((String)"mal_order");
        ArrayList<String> skusList = new ArrayList<String>();
        HashMap<String, String> nameMap = new HashMap<String, String>();
        HashMap<String, String> imgMap = new HashMap<String, String>();
        HashMap<String, Integer> qtyMap = new HashMap<String, Integer>();
        int jdSupplierIndex = 0;
        for (int supplierIndex = 1; supplierIndex <= supplierSize; ++supplierIndex) {
            if (!sourceDyo.get("source" + supplierIndex).toString().equalsIgnoreCase(this.getSource())) continue;
            jdSupplierIndex = supplierIndex;
            DynamicObjectCollection entryDyoCol = (DynamicObjectCollection)sourceDyo.get("entryentity" + supplierIndex);
            for (DynamicObject dyo : entryDyoCol) {
                String sku = dyo.getString("goods" + supplierIndex);
                Object materialId = dyo.get("material" + supplierIndex);
                skusList.add(sku);
                nameMap.put(sku, dyo.getString("goodsname" + supplierIndex));
                imgMap.put(sku, dyo.getString("goodsimg" + supplierIndex));
                qtyMap.put(sku, dyo.getInt("qty" + supplierIndex));
                materialMappingMap.put(sku, materialId);
            }
        }
        OperationResult saveResult = null;
        OperationResult submitResult = null;
        try {
            OperationResult auditResult;
            log.info("@@@@@@@@\u5f00\u59cb\u4fdd\u5b58\u4eac\u4e1c\u5546\u54c1@@@@@@@@");
            Map<String, String> skuIdMap = MalPlaceOrderUtils.getMalGoods(skusList, nameMap, imgMap, this.getSource());
            log.info("@@@@@@@@\u4fdd\u5b58\u4eac\u4e1c\u5546\u54c1\u6210\u529f@@@@@@@@");
            log.info("@@@@@@@@\u53d6\u4eac\u4e1c\u4ef7\u683c@@@@@@@@");
            Map<String, PriceInfo> priceMap = MalPlaceOrderUtils.getMalGoodsPrice(this.getSource(), skusList, null).get(this.getSource());
            log.info("@@@@@@@@\u53d6\u4eac\u4e1c\u4ef7\u683c\u6210\u529f@@@@@@@@");
            this.preHandleDynamicObj(sourceDyo, null, skusList);
            log.info("@@@@@@@@\u5904\u7406\u5546\u57ce\u5355\u5934\u4fe1\u606f@@@@@@@@");
            this.handleOrderHeadInfo(sourceDyo, orderDyo, this.getSource(), jdSupplierIndex);
            log.info("@@@@@@@@\u5904\u7406\u5546\u57ce\u5355\u5934\u4fe1\u606f\u6210\u529f@@@@@@@@");
            log.info("@@@@@@@@\u5904\u7406\u5546\u57ce\u5206\u5f55\u4fe1\u606f@@@@@@@@");
            this.handleOrderEntryInfo(this.getSource(), sourceDyo, orderDyo, priceMap, skuIdMap, supplierSize);
            log.info("@@@@@@@@\u5904\u7406\u5546\u57ce\u5206\u5f55\u4fe1\u606f\u6210\u529f@@@@@@@@");
            log.info("@@@@@@@@\u5904\u7406\u76f8\u5173\u4ef7\u683c\u91d1\u989d\u5b57\u6bb5\u7684\u8ba1\u7b97@@@@@@@@");
            Cal4DynamicObj.calByTaxAmount((DynamicObject)orderDyo, (String)"entryentity");
            log.info("@@@@@@@@\u5904\u7406\u76f8\u5173\u4ef7\u683c\u91d1\u989d\u5b57\u6bb5\u7684\u8ba1\u7b97\u6210\u529f@@@@@@@@");
            log.info("@@@@@@@@\u6839\u636e\u5546\u57ce\u8ba2\u5355\u7f16\u7801\u89c4\u5219\u81ea\u52a8\u751f\u6210\u5355\u636e\u7f16\u7801@@@@@@@@");
            OperateOption option = OperateOption.create();
            option.setVariableValue("isStrict", "false");
            saveResult = SaveServiceHelper.saveOperate((String)"save", (String)"mal_order", (DynamicObject[])new DynamicObject[]{orderDyo}, (OperateOption)option);
            resultMsg.put("saveResult", saveResult);
            log.info("@@@@@@@@\u5f00\u59cb\u6839\u636e\u53c2\u6570\u66f4\u65b0\u5546\u54c1\u7269\u6599\u5bf9\u5e94\u5173\u7cfb\u8868\u4fe1\u606f@@@@@@@@");
            this.updateMappingRelation(materialMappingMap, skuIdMap);
            log.info("@@@@@@@@\u6839\u636e\u53c2\u6570\u66f4\u65b0\u5546\u54c1\u7269\u6599\u5bf9\u5e94\u5173\u7cfb\u8868\u4fe1\u606f\u5b8c\u6210@@@@@@@@");
            log.info("@@@@@@@@\u5f00\u59cb\u751f\u6210\u4eac\u4e1c\u9884\u5360\u5e93\u5b58\u5355@@@@@@@@");
            Map<String, Object> jdResultMap = this.createJDOrder(sourceDyo, orderDyo.getString("billno"), qtyMap, jdSupplierIndex);
            String jdOrderId = (String)jdResultMap.get("jdOrderId");
            log.info("@@@@@@@@\u751f\u6210\u4eac\u4e1c\u9884\u5360\u5e93\u5b58\u5355\u5b8c\u6210@@@@@@@@");
            log.info("\u4eac\u4e1c\u9884\u5360\u5e93\u5b58\u5355ID:" + jdOrderId);
            log.info("@@@@@@@@\u5f00\u59cb\u4fdd\u5b58\u4eac\u4e1c\u5355\u76f8\u5173\u4fe1\u606f@@@@@@@@");
            JdPlaceOrderService.saveJdParentOrder(skuIdMap, priceMap, qtyMap, jdResultMap);
            log.info("@@@@@@@@\u4fdd\u5b58\u4eac\u4e1c\u5355\u76f8\u5173\u4fe1\u606f\u5b8c\u6210@@@@@@@@");
            log.info("@@@@@@@@\u5f00\u59cb\u66f4\u65b0\u5546\u57ce\u8ba2\u5355\u4fe1\u606f@@@@@@@@");
            this.writeBack2OrderInfo(sourceDyo, jdOrderId, orderDyo.getString("billno"), jdResultMap, skuIdMap, jdSupplierIndex);
            log.info("@@@@@@@@\u66f4\u65b0\u5546\u57ce\u8ba2\u5355\u4fe1\u606f\u5b8c\u6210@@@@@@@@");
            log.info("@@@\u4eac\u4e1c\u4e0b\u5355\u52a8\u6001\u5bf9\u8c61" + orderDyo);
            submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"mal_order", (Object[])saveResult.getSuccessPkIds().toArray(new Object[0]), (OperateOption)option);
            if (!submitResult.isSuccess()) {
                log.error("@@@kd.scm.mal.formplugin.util.MalMakeOrderHelper.makeOrder4Jd,\u63d0\u4ea4\u5546\u57ce\u8ba2\u5355\u5f02\u5e38-->" + ExceptionUtil.getErrorInfoDetails((List)submitResult.getAllErrorOrValidateInfo()));
                String msg = ResManager.loadKDString((String)"\u5355\u636e\u63d0\u4ea4\u5931\u8d25,\u539f\u56e0\uff1a", (String)"JdPlaceOrderService_0", (String)"scm-mal-common", (Object[])new Object[0]);
                throw new KDBizException(new ErrorCode("Submit Bill fail", msg + submitResult.getMessage() + " " + ExceptionUtil.getErrorInfoDetails((List)submitResult.getAllErrorOrValidateInfo())), new Object[0]);
            }
            resultMsg.put("billid", submitResult.getSuccessPkIds().toArray(new Long[0])[0]);
            resultMsg.put("billno", orderDyo.getString("billno"));
            log.info("@@@@@@@@\u5f00\u59cb\u6839\u636e\u53c2\u6570\u6267\u884c\u5546\u57ce\u8ba2\u5355\u5ba1\u6838@@@@@@@@");
            String bizflow = MalOrderUtil.getBizFlowParam();
            if ((StringUtils.equalsIgnoreCase((CharSequence)bizflow, (CharSequence)MalBizflowParamEnum.ERP_PURORDER.getVal()) || StringUtils.equalsIgnoreCase((CharSequence)bizflow, (CharSequence)MalBizflowParamEnum.ERP_PURREQUEST.getVal())) && !(auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"mal_order", (Object[])submitResult.getSuccessPkIds().toArray(new Object[0]), (OperateOption)option)).isSuccess()) {
                log.error("@@@kd.scm.mal.formplugin.util.MalMakeOrderHelper.makeOrder4Jd,\u5ba1\u6838\u5546\u57ce\u8ba2\u5355\u5931\u8d25,-->" + ExceptionUtil.getErrorInfoDetails((List)auditResult.getAllErrorOrValidateInfo()));
                String msg = ResManager.loadKDString((String)"\u5546\u57ce\u8ba2\u5355\u5ba1\u6838\u5931\u8d25,\u539f\u56e0\uff1a", (String)"JdPlaceOrderService_2", (String)"scm-mal-common", (Object[])new Object[0]);
                throw new KDBizException(new ErrorCode("Audit Bill fail", msg + auditResult.getMessage() + " " + ExceptionUtil.getErrorInfoDetails((List)auditResult.getAllErrorOrValidateInfo())), new Object[0]);
            }
            log.info("@@@@@@@@\u6839\u636e\u53c2\u6570\u6267\u884c\u5546\u57ce\u8ba2\u5355\u5ba1\u6838\u6210\u529f@@@@@@@@");
            if (((Boolean)sourceDyo.get("fromcart")).booleanValue()) {
                log.info("@@@@@@@@\u5f00\u59cb\u5220\u9664\u8d2d\u7269\u8f66\u91cc\u9762\u7684\u8bb0\u5f55@@@@@@@@");
                MalProductUtil.deleteCartProds4Jd(skusList);
                log.info("@@@@@@@@\u5220\u9664\u8d2d\u7269\u8f66\u91cc\u9762\u7684\u8bb0\u5f55\u5b8c\u6210@@@@@@@@");
            }
        }
        catch (Exception e) {
            resultMsg.put("errMsg", e.getMessage());
            log.error("@@@JdPlaceOrderService.placeOrder\u5546\u57ce\u4e0b\u5355\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + ExceptionUtil.getStackTrace((Throwable)e));
            if (e instanceof KDBizException) {
                KDBizException kdBizException = (KDBizException)e;
                this.rollBackMalOrder(saveResult, kdBizException);
            }
            this.rollBackMalOrder(saveResult);
        }
        return resultMsg;
    }

    protected Map<String, Object> createJDOrder(DynamicObject sourceDyo, String orderBillNo, Map<String, Integer> qtyMap, int jdSupplierIndex) {
        String token;
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, String> params = new HashMap<String, String>(32);
        if (StringUtils.equals((CharSequence)EcPlatformEnum.ECPLATFORM_JD.getVal(), (CharSequence)this.getSource()) && StringUtils.isNotBlank((CharSequence)(token = JDAccessTokenUtil.getValidToken((String)sourceDyo.getString("invoiceorg.id"))))) {
            params.put("token", token);
        }
        params.put("thirdOrder", orderBillNo);
        StringBuilder skuStr = new StringBuilder();
        skuStr.append('[');
        for (Map.Entry<String, Integer> skuEntry : qtyMap.entrySet()) {
            skuStr.append('{');
            skuStr.append("\"skuId\":").append(skuEntry.getKey()).append(",\"num\":").append(skuEntry.getValue());
            skuStr.append(",\"bNeedGift\":").append(this.needGifts());
            skuStr.append(",\"yanbao\":").append("[]");
            skuStr.append("},");
        }
        String tempSku = skuStr.substring(0, skuStr.lastIndexOf(","));
        tempSku = tempSku + "]";
        params.put("sku", tempSku);
        Map<String, String> recieptMap = MalJdProductUtil.getRecieptInfo(sourceDyo.getString("receipt"));
        params.put("receiverName", recieptMap.get("receiptname"));
        String addressId = sourceDyo.getString("addressid");
        String[] addr = AddressUtil.getNumberArr((Long)Long.valueOf(addressId), (String)this.getSource());
        if (null == addr || addr.length < 3) {
            log.error("\u65b0\u7248\u5546\u57ce\u83b7\u53d6\u4eac\u4e1c\u4e0b\u5355\u5730\u5740\u5931\u8d25, \u5546\u57ce\u5730\u5740 = " + addressId + "\u4eac\u4e1c\u5730\u5740 = " + addr);
            throw new KDException(new ErrorCode("get JD address error", ResManager.loadKDString((String)"\u83b7\u53d6\u4eac\u4e1c\u4e0b\u5355\u5730\u5740\u5931\u8d25\u3002", (String)"JdPlaceOrderService_3", (String)"scm-mal-common", (Object[])new Object[0])), new Object[0]);
        }
        int size = addr.length;
        params.put("provinceId", addr[MalPlaceOrderConstant.PROVINCE_INDEX]);
        params.put("cityId", addr[MalPlaceOrderConstant.CITY_INDEX]);
        params.put("countyId", addr[MalPlaceOrderConstant.COUNTY_INDEX]);
        if (size > 3) {
            params.put("townId", addr[MalPlaceOrderConstant.TOWN_INDEX]);
        } else {
            params.put("townId", "0");
        }
        params.put("address", recieptMap.get("receiptAddr"));
        params.put("mobile", recieptMap.get("receiptphone"));
        params.put("email", recieptMap.get("receiptemail"));
        params.put("zip", recieptMap.get("receiptzip"));
        params.put("remark", sourceDyo.getString("remark" + jdSupplierIndex));
        params.put("invoiceState", "2");
        params.put("invoiceType", sourceDyo.get("invoicetype" + jdSupplierIndex).toString());
        params.put("invoiceTitle", sourceDyo.getString("invoiceorg.ffirmname.zh_CN").trim());
        params.put("invoiceContent", "1");
        params.put("paymentType", sourceDyo.get("paytype" + jdSupplierIndex).toString());
        params.put("regCode", sourceDyo.getString("invoiceorg.ftaxregnum").trim());
        params.put("regCompanyName", sourceDyo.getString("invoiceorg.ffirmname.zh_CN").trim());
        params.put("regPhone", sourceDyo.getString("invoiceorg.phone").trim());
        params.put("regAddr", sourceDyo.getString("invoiceorg.faddress").trim());
        params.put("regBank", sourceDyo.getString("invoiceorg.depositbank").trim());
        params.put("regBankAccount", sourceDyo.getString("invoiceorg.bankaccount").trim());
        params.put("invoiceName", recieptMap.get("receiptname"));
        params.put("invoicePhone", recieptMap.get("receiptphone"));
        params.put("invoiceProvice", addr[MalPlaceOrderConstant.PROVINCE_INDEX]);
        params.put("invoiceCity", addr[MalPlaceOrderConstant.CITY_INDEX]);
        params.put("invoiceCounty", addr[MalPlaceOrderConstant.COUNTY_INDEX]);
        params.put("invoiceAddress", null == params.get("townId") ? "" : params.get("townId").toString());
        params.put("isUseBalance", sourceDyo.get("paytype" + jdSupplierIndex).toString().equalsIgnoreCase("4") ? "1" : "0");
        log.info("\u751f\u6210\u4eac\u4e1c\u9884\u5360\u5e93\u5b58\u5355\u63a5\u53e3\u53c2\u6570" + params);
        Map data = (Map)EcApiUtil.parseResful((Object)ApiAccessor.invoke((String)JdApiParser.getJdApiNumber((String)this.getSource(), (String)"SRM_JD_ORDER_submitOrder"), params));
        log.info("\u8c03\u7528\u751f\u6210\u4eac\u4e1c\u9884\u5360\u5e93\u5b58\u5355\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\uff1a" + data);
        String jdOrderId = data.get("jdOrderId").toString();
        result.put("jdOrderId", jdOrderId);
        result.put("resultMap", data);
        result.put("sku", data.get("sku"));
        return result;
    }

    public String needGifts() {
        return "false";
    }

    private void writeBack2OrderInfo(DynamicObject sourceDyo, String jdOrderId, String billNo, Map<String, Object> result, Map<String, String> skuIdMap, int jdSupplierIndex) {
        HashMap<String, String> idSkuMap = new HashMap<String, String>((int)((double)skuIdMap.size() / 0.75));
        for (Map.Entry<String, String> entry : skuIdMap.entrySet()) {
            idSkuMap.put(entry.getValue(), entry.getKey());
        }
        QFilter filter = new QFilter("billno", "=", (Object)billNo);
        String head = DynamicObjectUtil.getSelectfields((String)"mal_order", (boolean)false);
        String entry = DynamicObjectUtil.getEntrySelectfields((String)"", (String)"mal_order", (String)"entryentity", (boolean)false);
        String selectFields = head + "," + entry;
        DynamicObject[] dyo = BusinessDataServiceHelper.load((String)"mal_order", (String)selectFields, (QFilter[])new QFilter[]{filter});
        dyo[0].set("jdorderid", (Object)jdOrderId);
        String jdParentOrderPkId = MalPlaceOrderUtils.getParentOrderPkId(jdOrderId, this.getSource()).toString();
        DynamicObject jdOrderDyn = MalPlaceOrderUtils.getOrderDyn(jdParentOrderPkId, this.getSource());
        dyo[0].set("ecorderid_id", (Object)jdParentOrderPkId);
        dyo[0].set("ecorderid", (Object)jdOrderDyn);
        dyo[0].set("orderstatus", (Object)EmalStatusUtil.getNumber((String)jdOrderDyn.get("jdorderstate").toString(), (String)"1", (String)this.getSource()));
        if (sourceDyo.getInt("paytype" + jdSupplierIndex) == 4) {
            dyo[0].set("jdorderstatus", (Object)JDOrderStatusEnum.CONFIRM.getName());
        } else {
            dyo[0].set("jdorderstatus", (Object)JDOrderStatusEnum.CREATE.getName());
        }
        for (DynamicObject temp : (DynamicObjectCollection)dyo[0].get("entryentity")) {
            String goodsId = temp.getString("goods.id");
            String goodsIdSku = (String)idSkuMap.get(goodsId);
            if (goodsIdSku == null) continue;
            List list = (List)result.get("sku");
            for (Map map : list) {
                if (!goodsIdSku.equalsIgnoreCase(map.get("skuId").toString())) continue;
                temp.set("price", (Object)new BigDecimal(map.get("price").toString()));
                temp.set("taxprice", (Object)new BigDecimal(map.get("price").toString()));
                temp.set("taxrate", (Object)new BigDecimal(map.get("tax").toString()));
            }
        }
        Cal4DynamicObj.reCalBill((DynamicObject)dyo[0], (String)"entryentity");
        SaveServiceHelper.save((DynamicObject[])dyo);
    }

    public static void saveJdParentOrder(Map<String, String> skuIdMap, Map<String, PriceInfo> priceMap, Map<String, Integer> qtyMap, Map<String, Object> result) {
        DynamicObject jdOrder = BusinessDataServiceHelper.newDynamicObject((String)"pbd_jdorder");
        JdPlaceOrderService.setJdOrderHeadInfo(jdOrder, result);
        JdPlaceOrderService.setJdOrderEntryInfo(jdOrder, skuIdMap, priceMap, qtyMap);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{jdOrder});
    }

    public static void setJdOrderHeadInfo(DynamicObject jdOrder, Map<String, Object> result) {
        String currency = MalOrderUtil.getDefaultCurrency();
        Date currentDate = new Date();
        Long personId = RequestContext.get().getCurrUserId();
        String jdOrderId = (String)result.get("jdOrderId");
        jdOrder.set("number", (Object)jdOrderId);
        jdOrder.set("jdorderid", (Object)jdOrderId);
        jdOrder.set("jdorderstate", (Object)"1");
        jdOrder.set("jdstate", (Object)"0");
        jdOrder.set("jdchildorderstatus", (Object)"1");
        jdOrder.set("invoicestate", (Object)PurEcInvoiceEnum.PREREQUEST.getVal());
        Map resultMap = (Map)result.get("resultMap");
        jdOrder.set("amount", (Object)new BigDecimal(resultMap.get("orderNakedPrice").toString()));
        jdOrder.set("tax", (Object)new BigDecimal(resultMap.get("orderTaxPrice").toString()));
        jdOrder.set("freight", (Object)new BigDecimal(resultMap.get("freight").toString()));
        jdOrder.set("taxamount", (Object)new BigDecimal(resultMap.get("orderPrice").toString()));
        if (StringUtils.isNotBlank((CharSequence)currency)) {
            jdOrder.set("currency", (Object)currency);
        } else {
            jdOrder.set("currency", (Object)"1");
        }
        jdOrder.set("status", (Object)"C");
        jdOrder.set("enable", (Object)"1");
        jdOrder.set("creator", (Object)personId);
        jdOrder.set("createtime", (Object)currentDate);
        jdOrder.set("modifier", (Object)personId);
        jdOrder.set("modifytime", (Object)currentDate);
        jdOrder.set("auditor", (Object)personId);
        jdOrder.set("auditdate", (Object)currentDate);
    }

    private static void setJdOrderEntryInfo(DynamicObject jdOrder, Map<String, String> skuIdMap, Map<String, PriceInfo> priceMap, Map<String, Integer> qtyMap) {
        DynamicObjectCollection entryDyoCol = (DynamicObjectCollection)jdOrder.get("entryentity");
        for (Map.Entry<String, Integer> skuMap : qtyMap.entrySet()) {
            DynamicObject entryDyo = entryDyoCol.addNew();
            entryDyo.set("goods", (Object)skuIdMap.get(skuMap.getKey()));
            entryDyo.set("qty", (Object)skuMap.getValue());
            entryDyo.set("taxprice", (Object)priceMap.get(skuMap.getKey()).getTaxPrice());
            entryDyo.set("jdprice", (Object)priceMap.get(skuMap.getKey()).getEcPrice());
        }
    }
}

