/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.placeorder.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.ecapi.entity.PriceInfo;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.ecapi.util.EmalParamsUtil;
import kd.scm.common.enums.BillEntryStatusEnum;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.FeatureCheckUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.mal.common.util.MalBizFowUtil;
import kd.scm.mal.common.util.MalPlaceOrderUtils;

@Deprecated
public class PlaceOrderService {
    private static Log log = LogFactory.getLog(PlaceOrderService.class);

    public Map<String, Object> checkLicense() {
        Map featureMap = FeatureCheckUtil.checkMalJdFeature();
        if (null != featureMap && null != featureMap.get("hasLicense") && null != featureMap.get("licenseMsg") && !((Boolean)featureMap.get("hasLicense")).booleanValue()) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("legal", Boolean.FALSE);
            result.put("licenseMsg", featureMap.get("licenseMsg"));
            return result;
        }
        return null;
    }

    public Map<String, Object> checkSaleable(String addressId, DynamicObjectCollection dyoCol, int supplierIndex, String supplierId) {
        return null;
    }

    public Map<String, Object> checkStatus(List<String> productIdList) {
        return null;
    }

    public Map<String, Object> placeOrder(int supplierSize, DynamicObject sourceDyo) {
        return null;
    }

    public String getSource() {
        return EcPlatformEnum.ECPLATFORM_SELF.getVal();
    }

    public void preHandleDynamicObj(DynamicObject sourceDyo, List<Long> goodsList, List<String> skusList) {
    }

    public void handleOrderHeadInfo(DynamicObject sourceDyo, DynamicObject orderDyo, String source, int supplierIndex) {
        log.info("@@@@@@@@\u5f00\u59cb\u5904\u7406\u5546\u57ce\u8ba2\u5355\u5355\u5934\u4fe1\u606f@@@@@@@@");
        ArrayList<String> sourcePropertyList = new ArrayList<String>();
        DataEntityPropertyCollection sourcePropertyCol = sourceDyo.getDataEntityType().getProperties();
        for (IDataEntityProperty sourceProperty : sourcePropertyCol) {
            sourcePropertyList.add(sourceProperty.getName());
        }
        ArrayList<String> orderPropertyList = new ArrayList<String>();
        DataEntityPropertyCollection orderPropertyCol = orderDyo.getDataEntityType().getProperties();
        for (IDataEntityProperty orderProperty : orderPropertyCol) {
            orderPropertyList.add(orderProperty.getName());
        }
        for (String proKey : sourcePropertyList) {
            if (!orderPropertyList.contains(proKey) || proKey.startsWith("entryentity")) continue;
            orderDyo.set(proKey, sourceDyo.get(proKey));
        }
        orderDyo.set("loccurr", (Object)MalOrderUtil.getEcCurrencyId((String)source));
        orderDyo.set("curr", (Object)MalOrderUtil.getEcCurrencyId((String)source));
        orderDyo.set("billstatus", (Object)BillStatusEnum.SAVE.getVal());
        orderDyo.set("platform", (Object)source);
        if (source.equalsIgnoreCase(EcPlatformEnum.ECPLATFORM_SELF.getVal())) {
            orderDyo.set("invtype", (Object)"2");
            orderDyo.set("invdetail", (Object)"1");
            orderDyo.set("paytype", (Object)"1");
        } else {
            orderDyo.set("malinvtype_id", (Object)EmalParamsUtil.getBdInvoiceTypeId((String)source));
            orderDyo.set("invdetail", sourceDyo.get("invoicestate" + supplierIndex));
            Long payTypePkId = EmalParamsUtil.getPayTypeId((String)source);
            orderDyo.set("malpaytype_id", (Object)payTypePkId);
            DynamicObject payTypeDyn = QueryServiceHelper.queryOne((String)"pbd_paytype", (String)"id,purcondition,settletypeid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)payTypePkId)});
            if (null != payTypeDyn) {
                orderDyo.set("paycond_id", payTypeDyn.get("purcondition"));
                orderDyo.set("settletype_id", payTypeDyn.get("settletypeid"));
            }
        }
        orderDyo.set("invway", (Object)"2");
        orderDyo.set("taxtype", (Object)"1");
        orderDyo.set("exchrate", (Object)BigDecimal.ONE.setScale(2));
        Date currentDate = new Date();
        Long personId = RequestContext.get().getCurrUserId();
        orderDyo.set("billdate", (Object)currentDate);
        orderDyo.set("creator", (Object)personId);
        orderDyo.set("createtime", (Object)currentDate);
        orderDyo.set("modifier", (Object)personId);
        orderDyo.set("modifytime", (Object)currentDate);
        orderDyo.set("ecsource", (Object)MalPlaceOrderUtils.getPlatformId(source));
        log.info("@@@@@@@@\u5904\u7406\u5546\u57ce\u8ba2\u5355\u5355\u5934\u4fe1\u606f\u5b8c\u6210@@@@@@@@");
    }

    public void handleOrderEntryInfo(DynamicObject sourceDyo, DynamicObject orderDyo, Map<Long, BigDecimal> taxRateMap, int supplierSize) {
        log.info("@@@@@@@@\u5f00\u59cb\u5904\u7406\u5546\u57ce\u8ba2\u5355\u5206\u5f55\u4fe1\u606f@@@@@@@@");
        DynamicObjectCollection entryDyoCol = (DynamicObjectCollection)orderDyo.get("entryentity");
        int seq = 1;
        for (int supplierIndex = 1; supplierIndex <= supplierSize; ++supplierIndex) {
            if (!sourceDyo.get("source" + supplierIndex).toString().equalsIgnoreCase("1")) continue;
            EntryProp sourceEntryProp = (EntryProp)sourceDyo.getDataEntityType().getProperties().get((Object)("entryentity" + supplierIndex));
            List sourceEntryProList = DynamicObjectUtil.getEntryentityProperties((IDataEntityType)sourceEntryProp.getItemType());
            sourceEntryProList.remove("id");
            EntryProp orderEntryProp = (EntryProp)orderDyo.getDataEntityType().getProperties().get((Object)"entryentity");
            List orderEntryProList = DynamicObjectUtil.getEntryentityProperties((IDataEntityType)orderEntryProp.getItemType());
            DynamicObjectCollection dyoCol = sourceDyo.getDynamicObjectCollection("entryentity" + supplierIndex);
            HashSet<Long> goodsIDS = new HashSet<Long>(1024);
            for (DynamicObject dyo : dyoCol) {
                Long goodsId = dyo.getLong("goods" + supplierIndex);
                goodsIDS.add(goodsId);
            }
            QFilter qFilter = new QFilter("goods.id", "in", goodsIDS);
            qFilter.and(new QFilter("mallstatus", "=", (Object)"B"));
            DynamicObjectCollection prodPools = QueryServiceHelper.query((String)"pmm_prodpool", (String)"isgoodvisible,id,goods.number,goods.id,protocol.purmode,protocol.billno,protocol.effectdate,protocol.invaliddate,entryentity.orgname,protocolentry.id,protocol.id", (QFilter[])qFilter.toArray());
            HashMap<Long, DynamicObject> goods_protocolMap = new HashMap<Long, DynamicObject>(1024);
            Long orgId = RequestContext.get().getOrgId();
            if (null != orderDyo.getDynamicObject("deporg")) {
                orgId = orderDyo.getDynamicObject("deporg").getLong("id");
            }
            for (DynamicObject prodpool : prodPools) {
                boolean isgoodvisible = prodpool.getBoolean("isgoodvisible");
                Long org = prodpool.getLong("entryentity.orgname");
                if (!isgoodvisible && !orgId.equals(org)) continue;
                goods_protocolMap.put(prodpool.getLong("goods.id"), prodpool);
            }
            for (DynamicObject dyo : dyoCol) {
                DynamicObject entryDyo = entryDyoCol.addNew();
                entryDyo.set("supplier", sourceDyo.get("supplier" + supplierIndex));
                entryDyo.set("note", sourceDyo.get("remark" + supplierIndex));
                for (String proKey : sourceEntryProList) {
                    String key = proKey.replace(String.valueOf(supplierIndex), "");
                    if (!orderEntryProList.contains(key)) continue;
                    Long goodsId = dyo.getLong("goods" + supplierIndex);
                    if (key.equals("taxrate")) {
                        entryDyo.set("taxrate", (Object)taxRateMap.get(goodsId));
                    } else if (key.equals("seq")) {
                        entryDyo.set(key, (Object)seq++);
                    } else {
                        entryDyo.set(key, dyo.get(proKey));
                    }
                    entryDyo.set("dctrate", (Object)BigDecimal.ZERO.setScale(2));
                    entryDyo.set("dctamount", (Object)BigDecimal.ZERO);
                    entryDyo.set("entrystatus", (Object)BillEntryStatusEnum.COMMON.getVal());
                    entryDyo.set("addvalue", (Object)"2");
                    DynamicObject prodPool = (DynamicObject)goods_protocolMap.get(goodsId);
                    if (null == prodPool || prodPool.getLong("protocol.id") == 0L) continue;
                    entryDyo.set("protocolsourceid", (Object)prodPool.getString("protocol.id"));
                    entryDyo.set("protocolno", (Object)prodPool.getString("protocol.billno"));
                    entryDyo.set("protocolsourceentryid", (Object)prodPool.getString("protocolentry.id"));
                }
                this.setComparePrice(entryDyo, dyo, supplierIndex);
            }
        }
        orderDyo.set("entryentity", (Object)entryDyoCol);
        log.info("@@@@@@@@\u5904\u7406\u5546\u57ce\u8ba2\u5355\u5206\u5f55\u4fe1\u606f\u5b8c\u6210@@@@@@@@");
    }

    private void setComparePrice(DynamicObject entryDyo, DynamicObject dyo, int supplierIndex) {
        entryDyo.set("compareremark", (Object)dyo.getString("compareremark" + supplierIndex));
        entryDyo.set("compareid", (Object)dyo.getString("compareid" + supplierIndex));
        String compareresult = dyo.getString("compareresult" + supplierIndex);
        if (compareresult.equals(ResManager.loadKDString((String)"\u672a\u6bd4\u4ef7", (String)"PlaceOrderService_0", (String)"scm-mal-common", (Object[])new Object[0]))) {
            entryDyo.set("compareresult", (Object)"A");
        }
        if (compareresult.equals(ResManager.loadKDString((String)"\u6700\u4f4e\u4ef7", (String)"PlaceOrderService_1", (String)"scm-mal-common", (Object[])new Object[0]))) {
            entryDyo.set("compareresult", (Object)"B");
        }
        if (compareresult.equals(ResManager.loadKDString((String)"\u975e\u6700\u4f4e\u4ef7", (String)"PlaceOrderService_2", (String)"scm-mal-common", (Object[])new Object[0]))) {
            entryDyo.set("compareresult", (Object)"C");
        }
    }

    public void handleOrderEntryInfo(String source, DynamicObject sourceDyo, DynamicObject orderDyo, Map<String, PriceInfo> priceMap, Map<String, String> skuIdMap, int supplierSize) {
        log.info("@@@@@@@@\u5f00\u59cb\u5904\u7406\u5546\u57ce\u8ba2\u5355\u5206\u5f55\u4fe1\u606f@@@@@@@@");
        DynamicObjectCollection entryDyoCol = (DynamicObjectCollection)orderDyo.get("entryentity");
        int seq = 1;
        for (int supplierIndex = 1; supplierIndex <= supplierSize; ++supplierIndex) {
            if (!sourceDyo.get("source" + supplierIndex).toString().equalsIgnoreCase(source)) continue;
            EntryProp sourceEntryProp = (EntryProp)sourceDyo.getDataEntityType().getProperties().get((Object)("entryentity" + supplierIndex));
            List sourceEntryProList = DynamicObjectUtil.getEntryentityProperties((IDataEntityType)sourceEntryProp.getItemType());
            sourceEntryProList.remove("id");
            EntryProp orderEntryProp = (EntryProp)orderDyo.getDataEntityType().getProperties().get((Object)"entryentity");
            List orderEntryProList = DynamicObjectUtil.getEntryentityProperties((IDataEntityType)orderEntryProp.getItemType());
            DynamicObjectCollection dyoCol = sourceDyo.getDynamicObjectCollection("entryentity" + supplierIndex);
            for (DynamicObject dyo : dyoCol) {
                DynamicObject entryDyo = entryDyoCol.addNew();
                entryDyo.set("supplier", sourceDyo.get("supplier" + supplierIndex));
                entryDyo.set("note", sourceDyo.get("remark" + supplierIndex));
                for (String proKey : sourceEntryProList) {
                    String key = proKey.replace(String.valueOf(supplierIndex), "");
                    if (!orderEntryProList.contains(key)) continue;
                    String goodsId = dyo.getString("goods" + supplierIndex);
                    if (key.equals("goods")) {
                        entryDyo.set("goods", (Object)skuIdMap.get(goodsId));
                    } else if (key.equals("taxrate")) {
                        entryDyo.set("taxrate", (Object)priceMap.get(goodsId).getTaxRate());
                    } else if (key.equals("seq")) {
                        entryDyo.set(key, (Object)seq++);
                    } else {
                        entryDyo.set(key, dyo.get(proKey));
                    }
                    entryDyo.set("dctrate", (Object)BigDecimal.ZERO.setScale(2));
                    entryDyo.set("dctamount", (Object)BigDecimal.ZERO);
                    entryDyo.set("entrystatus", (Object)BillEntryStatusEnum.COMMON.getVal());
                    entryDyo.set("addvalue", (Object)"2");
                }
                this.setComparePrice(entryDyo, dyo, supplierIndex);
            }
        }
        orderDyo.set("entryentity", (Object)entryDyoCol);
        log.info("@@@@@@@@\u5904\u7406\u5546\u57ce\u8ba2\u5355\u5206\u5f55\u4fe1\u606f\u5b8c\u6210@@@@@@@@");
    }

    public void updateMappingRelation(Map<String, Object> materialMappingMap) {
        Set<String> prodIdSet = materialMappingMap.keySet();
        this.handleMappingRelation(materialMappingMap, null, prodIdSet);
    }

    public void updateMappingRelation(Map<String, Object> materialMappingMap, Map<String, String> skuIdMap) {
        HashMap<String, String> idSkuMap = new HashMap<String, String>((int)((double)skuIdMap.size() / 0.75));
        for (Map.Entry<String, String> entry : skuIdMap.entrySet()) {
            idSkuMap.put(entry.getValue(), entry.getKey());
        }
        Set<String> prodIdSet = idSkuMap.keySet();
        this.handleMappingRelation(materialMappingMap, idSkuMap, prodIdSet);
    }

    public void handleMappingRelation(Map<String, Object> materialMappingMap, Map<String, String> idSkuMap, Set<String> prodIdSet) {
        String prodId;
        HashMap<Long, Long> prodAndMaterialMap = new HashMap<Long, Long>(materialMappingMap.size());
        if (idSkuMap != null && !idSkuMap.isEmpty()) {
            for (Map.Entry<String, Object> entry : idSkuMap.entrySet()) {
                String sku = (String)entry.getValue();
                prodId = entry.getKey();
                Object material = materialMappingMap.remove(sku);
                if (material instanceof Long) {
                    prodAndMaterialMap.put(Long.valueOf(prodId), (Long)material);
                    continue;
                }
                if (!(material instanceof DynamicObject)) continue;
                prodAndMaterialMap.put(Long.valueOf(prodId), ((DynamicObject)material).getLong("id"));
            }
        }
        for (Map.Entry<String, Object> entry : materialMappingMap.entrySet()) {
            Object material = entry.getValue();
            prodId = entry.getKey();
            if (material instanceof Long) {
                prodAndMaterialMap.put(Long.valueOf(prodId), (Long)material);
                continue;
            }
            if (!(material instanceof DynamicObject)) continue;
            prodAndMaterialMap.put(Long.valueOf(prodId), ((DynamicObject)material).getLong("id"));
        }
        DispatchServiceHelper.invokeBizService((String)"scm", (String)"pmm", (String)"IPmmMatMappingService", (String)"syncProdMaterialMapping", (Object[])new Object[]{prodAndMaterialMap});
    }

    protected void rollBackMalOrder(OperationResult operationResult, KDBizException e) {
        if (operationResult != null && operationResult.getSuccessPkIds() != null && operationResult.getSuccessPkIds().size() > 0) {
            Long pk = operationResult.getSuccessPkIds().toArray(new Long[0])[0];
            log.info("@@@MalMakeOrderHelper.rollBackMalOrder:\u5355\u636eID-->" + pk);
            QFilter pkFilter = new QFilter("id", "=", (Object)pk);
            if (StringUtils.equals((CharSequence)"Audit Bill fail", (CharSequence)e.getErrorCode().getCode())) {
                OperationResult opResult = OperationServiceHelper.executeOperate((String)"unsubmit", (String)"mal_order", (Object[])new Object[]{pk}, null);
                if (null != opResult && opResult.isSuccess()) {
                    this.deleteMalOrder(pk, pkFilter);
                } else if (null != opResult) {
                    log.info("@@@MalMakeOrderHelper.rollBackMalOrder:\u64a4\u9500\u5931\u8d25\uff0c\u5f02\u5e38\u7684\u5355\u636eID\uff1a" + pk + "\n" + ExceptionUtil.getErrorInfoDetails((List)opResult.getAllErrorOrValidateInfo()));
                } else {
                    log.info("@@@MalMakeOrderHelper.rollBackMalOrder:\u64a4\u9500\u5931\u8d25\uff0c\u5f02\u5e38\u7684\u5355\u636eID\uff1a" + pk + "\n");
                }
            } else {
                this.deleteMalOrder(pk, pkFilter);
            }
        }
    }

    protected void deleteMalOrder(Long pk, QFilter pkFilter) {
        log.info("@@@MalMakeOrderHelper.rollBackMalOrder:\u5f00\u59cb\u6267\u884c\u5220\u9664\u64cd\u4f5c");
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)"mal_order", (Object[])new Object[]{pk}, (OperateOption)MalBizFowUtil.createDefaultOpiton());
        if (operationResult.getSuccessPkIds().isEmpty()) {
            OperateOption option = MalBizFowUtil.createDefaultOpiton();
            option.setVariableValue("ignoreinteraction", String.valueOf(true));
            OperationResult cancelResult = OperationServiceHelper.executeOperate((String)"cancelorder", (String)"mal_order", (Object[])new Object[]{pk}, (OperateOption)option);
            log.info("@@@cancelorder.cancelResult:" + ExceptionUtil.getErrorInfoDetails((List)cancelResult.getAllErrorOrValidateInfo()));
            log.info(operationResult.getMessage() + " " + ExceptionUtil.getErrorInfoDetails((List)operationResult.getAllErrorOrValidateInfo()));
            log.info("@@@MalMakeOrderHelper.rollBackMalOrder:\u5f00\u59cb\u5f3a\u5236\u6267\u884c\u5220\u9664");
            DeleteServiceHelper.delete((String)"mal_order", (QFilter[])new QFilter[]{pkFilter});
            log.info("@@@MalMakeOrderHelper.rollBackMalOrder:\u6267\u884c\u5f3a\u5236\u5220\u9664\u6210\u529f");
        }
    }

    public void rollBackMalOrder(OperationResult operationResult) {
        if (operationResult != null && operationResult.getSuccessPkIds() != null && operationResult.getSuccessPkIds().size() > 0) {
            Long pk = operationResult.getSuccessPkIds().toArray(new Long[0])[0];
            log.info("@@@MalMakeOrderHelper.rollBackMalOrder:\u5355\u636eID-->" + pk);
            QFilter pkFilter = new QFilter("id", "=", (Object)pk);
            this.deleteMalOrder(pk, pkFilter);
        }
    }

    public void rollBackMalOrder(Map<String, Object> operationResult) {
        if (operationResult != null && operationResult.get("successPkIds") != null && ((List)operationResult.get("successPkIds")).size() > 0) {
            List data = (List)operationResult.get("successPkIds");
            Long pk = (Long)data.get(0);
            log.info("@@@MalMakeOrderHelper.rollBackMalOrder:\u5355\u636eID-->" + pk);
            QFilter pkFilter = new QFilter("id", "=", (Object)pk);
            this.deleteMalOrder(pk, pkFilter);
        }
    }
}

