/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.placeorder.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ecapi.entity.PriceInfo;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.ecapi.util.AddressUtil;
import kd.scm.common.ecapi.util.EmalStatusUtil;
import kd.scm.common.enums.PurEcInvoiceEnum;
import kd.scm.common.helper.apiconnector.api.ApiAccessor;
import kd.scm.common.helper.apiconnector.api.util.EcApiUtil;
import kd.scm.common.helper.apiconnector.api.util.Parser;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.cal.Cal4DynamicObj;
import kd.scm.mal.common.constant.MalPlaceOrderConstant;
import kd.scm.mal.common.enums.MalBizflowParamEnum;
import kd.scm.mal.common.placeorder.service.PlaceOrderService;
import kd.scm.mal.common.util.MalJdProductUtil;
import kd.scm.mal.common.util.MalPlaceOrderUtils;
import kd.scm.mal.common.util.MalProductUtil;

@Deprecated
public class XfsPlaceOrderService
extends PlaceOrderService {
    private static final Log log = LogFactory.getLog(XfsPlaceOrderService.class);

    @Override
    public String getSource() {
        return EcPlatformEnum.ECPLATFORM_XFS.getVal();
    }

    @Override
    public Map<String, Object> checkStatus(List<String> productIdList) {
        List<String> offList = MalPlaceOrderUtils.checkSkuStates(this.getSource(), productIdList);
        if (offList.size() > 0) {
            HashMap<String, Object> result = new HashMap<String, Object>(2);
            result.put("status", Boolean.FALSE);
            result.put("goodsList", offList);
            return result;
        }
        return null;
    }

    @Override
    public Map<String, Object> placeOrder(int supplierSize, DynamicObject sourceDyo) {
        HashMap<String, Object> resultMsg = new HashMap<String, Object>(4);
        resultMsg.put("source", this.getSource());
        LinkedHashMap<String, Object> materialMappingMap = new LinkedHashMap<String, Object>();
        DynamicObject orderDyo = BusinessDataServiceHelper.newDynamicObject((String)"mal_order");
        ArrayList<String> skusList = new ArrayList<String>();
        HashMap<String, String> nameMap = new HashMap<String, String>();
        HashMap<String, String> imgMap = new HashMap<String, String>();
        HashMap<String, Integer> qtyMap = new HashMap<String, Integer>();
        int xfsSupplierIndex = 0;
        for (int supplierIndex = 1; supplierIndex <= supplierSize; ++supplierIndex) {
            if (!sourceDyo.get("source" + supplierIndex).toString().equalsIgnoreCase(this.getSource())) continue;
            xfsSupplierIndex = supplierIndex;
            DynamicObjectCollection entryDyoCol = (DynamicObjectCollection)sourceDyo.get("entryentity" + supplierIndex);
            for (DynamicObject dyo : entryDyoCol) {
                String sku = dyo.getString("goods" + supplierIndex);
                Object materialId = dyo.get("material" + supplierIndex);
                skusList.add(sku);
                nameMap.put(sku, dyo.getString("goodsname" + supplierIndex));
                imgMap.put(sku, dyo.getString("goodsimg" + supplierIndex));
                qtyMap.put(sku, dyo.getInt("qty" + supplierIndex));
                materialMappingMap.put(sku, materialId);
            }
        }
        OperationResult saveResult = null;
        OperationResult submitResult = null;
        try {
            OperationResult auditResult;
            log.info("@@@@@@@@\u5f00\u59cb\u4fdd\u5b58\u946b\u65b9\u76db\u5546\u54c1@@@@@@@@");
            Map<String, String> skuIdMap = MalPlaceOrderUtils.getMalGoods(skusList, nameMap, imgMap, this.getSource());
            log.info("@@@@@@@@\u4fdd\u5b58\u946b\u65b9\u76db\u5546\u54c1\u6210\u529f@@@@@@@@");
            log.info("@@@@@@@@\u53d6\u946b\u65b9\u76db\u4ef7\u683c@@@@@@@@");
            Map<String, PriceInfo> priceMap = MalPlaceOrderUtils.getMalGoodsPrice(this.getSource(), skusList, null).get(this.getSource());
            log.info("@@@@@@@@\u53d6\u946b\u65b9\u76db\u4ef7\u683c\u6210\u529f@@@@@@@@");
            this.preHandleDynamicObj(sourceDyo, null, skusList);
            log.info("@@@@@@@@\u5904\u7406\u5546\u57ce\u5355\u5934\u4fe1\u606f@@@@@@@@");
            this.handleOrderHeadInfo(sourceDyo, orderDyo, this.getSource(), xfsSupplierIndex);
            log.info("@@@@@@@@\u5904\u7406\u5546\u57ce\u5355\u5934\u4fe1\u606f\u6210\u529f@@@@@@@@");
            log.info("@@@@@@@@\u5904\u7406\u5546\u57ce\u5206\u5f55\u4fe1\u606f@@@@@@@@");
            this.handleOrderEntryInfo(this.getSource(), sourceDyo, orderDyo, priceMap, skuIdMap, supplierSize);
            log.info("@@@@@@@@\u5904\u7406\u5546\u57ce\u5206\u5f55\u4fe1\u606f\u6210\u529f@@@@@@@@");
            log.info("@@@@@@@@\u5904\u7406\u76f8\u5173\u4ef7\u683c\u91d1\u989d\u5b57\u6bb5\u7684\u8ba1\u7b97@@@@@@@@");
            Cal4DynamicObj.calByTaxAmount((DynamicObject)orderDyo, (String)"entryentity");
            log.info("@@@@@@@@\u5904\u7406\u76f8\u5173\u4ef7\u683c\u91d1\u989d\u5b57\u6bb5\u7684\u8ba1\u7b97\u6210\u529f@@@@@@@@");
            log.info("@@@@@@@@\u6839\u636e\u5546\u57ce\u8ba2\u5355\u7f16\u7801\u89c4\u5219\u81ea\u52a8\u751f\u6210\u5355\u636e\u7f16\u7801@@@@@@@@");
            OperateOption option = OperateOption.create();
            option.setVariableValue("isStrict", "false");
            saveResult = SaveServiceHelper.saveOperate((String)"save", (String)"mal_order", (DynamicObject[])new DynamicObject[]{orderDyo}, (OperateOption)option);
            resultMsg.put("saveResult", saveResult);
            log.info("@@@@@@@@\u5f00\u59cb\u6839\u636e\u53c2\u6570\u66f4\u65b0\u5546\u54c1\u7269\u6599\u5bf9\u5e94\u5173\u7cfb\u8868\u4fe1\u606f@@@@@@@@");
            this.updateMappingRelation(materialMappingMap, skuIdMap);
            log.info("@@@@@@@@\u6839\u636e\u53c2\u6570\u66f4\u65b0\u5546\u54c1\u7269\u6599\u5bf9\u5e94\u5173\u7cfb\u8868\u4fe1\u606f\u5b8c\u6210@@@@@@@@");
            log.info("@@@@@@@@\u5f00\u59cb\u751f\u6210\u946b\u65b9\u76db\u9884\u5360\u5e93\u5b58\u5355@@@@@@@@");
            Map<String, Object> xfsResultMap = this.createXfsOrder(sourceDyo, orderDyo.getString("billno"), qtyMap, priceMap, xfsSupplierIndex);
            String orderId = (String)xfsResultMap.get("orderId");
            log.info("@@@@@@@@\u751f\u6210\u946b\u65b9\u76db\u9884\u5360\u5e93\u5b58\u5355\u5b8c\u6210@@@@@@@@");
            log.info("\u946b\u65b9\u76db\u9884\u5360\u5e93\u5b58\u5355ID:" + orderId);
            log.info("@@@@@@@@\u5f00\u59cb\u4fdd\u5b58\u946b\u65b9\u76db\u5355\u76f8\u5173\u4fe1\u606f@@@@@@@@");
            this.saveXfsParentOrder(xfsSupplierIndex, sourceDyo, skuIdMap, priceMap, qtyMap, xfsResultMap);
            log.info("@@@@@@@@\u4fdd\u5b58\u946b\u65b9\u76db\u5355\u76f8\u5173\u4fe1\u606f\u5b8c\u6210@@@@@@@@");
            log.info("@@@@@@@@\u5f00\u59cb\u66f4\u65b0\u5546\u57ce\u8ba2\u5355\u4fe1\u606f@@@@@@@@");
            this.writeBack2OrderInfo(orderId, orderDyo.getString("billno"), priceMap, skuIdMap);
            log.info("@@@@@@@@\u66f4\u65b0\u5546\u57ce\u8ba2\u5355\u4fe1\u606f\u5b8c\u6210@@@@@@@@");
            log.info("@@@\u946b\u65b9\u76db\u4e0b\u5355\u52a8\u6001\u5bf9\u8c61" + orderDyo);
            submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"mal_order", (Object[])saveResult.getSuccessPkIds().toArray(new Object[0]), (OperateOption)option);
            if (!submitResult.isSuccess()) {
                log.error("@@@\u63d0\u4ea4\u5546\u57ce\u8ba2\u5355\u5f02\u5e38-->" + ExceptionUtil.getErrorInfoDetails((List)submitResult.getAllErrorOrValidateInfo()));
                String msg = ResManager.loadKDString((String)"\u5355\u636e\u63d0\u4ea4\u5931\u8d25,\u539f\u56e0\uff1a", (String)"XfsPlaceOrderService_0", (String)"scm-mal-common", (Object[])new Object[0]);
                throw new KDBizException(new ErrorCode("Submit Bill fail", msg + submitResult.getMessage() + " " + ExceptionUtil.getErrorInfoDetails((List)submitResult.getAllErrorOrValidateInfo())), new Object[0]);
            }
            resultMsg.put("billid", submitResult.getSuccessPkIds().toArray(new Long[0])[0]);
            resultMsg.put("billno", orderDyo.getString("billno"));
            log.info("@@@@@@@@\u5f00\u59cb\u6839\u636e\u53c2\u6570\u6267\u884c\u5546\u57ce\u8ba2\u5355\u5ba1\u6838@@@@@@@@");
            String bizflow = MalOrderUtil.getBizFlowParam();
            if ((StringUtils.equalsIgnoreCase((CharSequence)bizflow, (CharSequence)MalBizflowParamEnum.ERP_PURORDER.getVal()) || StringUtils.equalsIgnoreCase((CharSequence)bizflow, (CharSequence)MalBizflowParamEnum.ERP_PURREQUEST.getVal())) && !(auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"mal_order", (Object[])submitResult.getSuccessPkIds().toArray(new Object[0]), (OperateOption)option)).isSuccess()) {
                log.error("@@@kd.scm.mal.formplugin.util.MalMakeOrderHelper.makeOrder4Jd,\u5ba1\u6838\u5546\u57ce\u8ba2\u5355\u5931\u8d25,-->" + ExceptionUtil.getErrorInfoDetails((List)auditResult.getAllErrorOrValidateInfo()));
                String msg = ResManager.loadKDString((String)"\u5546\u57ce\u8ba2\u5355\u5ba1\u6838\u5931\u8d25,\u539f\u56e0\uff1a", (String)"XfsPlaceOrderService_2", (String)"scm-mal-common", (Object[])new Object[0]);
                throw new KDBizException(new ErrorCode("Audit Bill fail", msg + auditResult.getMessage() + " " + ExceptionUtil.getErrorInfoDetails((List)auditResult.getAllErrorOrValidateInfo())), new Object[0]);
            }
            log.info("@@@@@@@@\u6839\u636e\u53c2\u6570\u6267\u884c\u5546\u57ce\u8ba2\u5355\u5ba1\u6838\u6210\u529f@@@@@@@@");
            if (((Boolean)sourceDyo.get("fromcart")).booleanValue()) {
                log.info("@@@@@@@@\u5f00\u59cb\u5220\u9664\u8d2d\u7269\u8f66\u91cc\u9762\u7684\u8bb0\u5f55@@@@@@@@");
                MalProductUtil.deleteCartProds4Jd(skusList);
                log.info("@@@@@@@@\u5220\u9664\u8d2d\u7269\u8f66\u91cc\u9762\u7684\u8bb0\u5f55\u5b8c\u6210@@@@@@@@");
            }
        }
        catch (Exception e) {
            resultMsg.put("errMsg", e.getMessage());
            log.error("@@@XfsPlaceOrderService.placeOrder\u5546\u57ce\u4e0b\u5355\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + ExceptionUtil.getStackTrace((Throwable)e));
            if (e instanceof KDBizException) {
                KDBizException kdBizException = (KDBizException)e;
                this.rollBackMalOrder(saveResult, kdBizException);
            }
            this.rollBackMalOrder(saveResult);
        }
        return resultMsg;
    }

    protected Map<String, Object> createXfsOrder(DynamicObject sourceDyo, String orderBillNo, Map<String, Integer> qtyMap, Map<String, PriceInfo> priceMap, int xfsSupplierIndex) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        StringBuilder logString = new StringBuilder();
        logString.append(ResManager.loadKDString((String)"\u751f\u6210\u946b\u65b9\u76db\u9884\u5360\u5e93\u5b58\u5355\u63a5\u53e3\u53c2\u6570", (String)"XfsPlaceOrderService_4", (String)"scm-mal-common", (Object[])new Object[0]));
        HashMap<String, Object> params = new HashMap<String, Object>(32);
        logString.append("projectId:").append(" ").append("\n");
        params.put("projectId", "");
        params.put("thirdOrder", orderBillNo);
        logString.append("thirdOrder:").append(orderBillNo).append("\n");
        ArrayList skuInfos = new ArrayList(qtyMap.size());
        BigDecimal amount = BigDecimal.ZERO;
        for (Map.Entry<String, Integer> skuEntry : qtyMap.entrySet()) {
            HashMap<String, Object> skuInfo = new HashMap<String, Object>();
            skuInfo.put("skuNo", skuEntry.getKey());
            skuInfo.put("buyNum", skuEntry.getValue());
            skuInfo.put("settlePrice", priceMap.get(skuEntry.getKey()).getTaxPrice().setScale(2, 4));
            amount = amount.add(priceMap.get(skuEntry.getKey()).getTaxPrice());
            skuInfos.add(skuInfo);
        }
        params.put("amount", sourceDyo.getBigDecimal("totalgoodsamt" + xfsSupplierIndex).setScale(2, 4));
        params.put("servFee", sourceDyo.getBigDecimal("freight" + xfsSupplierIndex).setScale(2, 4));
        params.put("sku", skuInfos);
        logString.append("sku:").append(SerializationUtils.toJsonString(skuInfos)).append("\n");
        Map<String, String> recieptMap = MalJdProductUtil.getRecieptInfo(sourceDyo.getString("receipt"));
        params.put("receiverName", recieptMap.get("receiptname"));
        params.put("receiverCompany", sourceDyo.getString("invoiceorg.ffirmname.zh_CN"));
        String addressId = sourceDyo.getString("addressid");
        Object[] addr = AddressUtil.getNumberArr((Long)Long.valueOf(addressId), (String)this.getSource());
        if (null == addr || addr.length < 3) {
            log.error("\u65b0\u7248\u5546\u57ce\u83b7\u53d6\u946b\u65b9\u76db\u4e0b\u5355\u5730\u5740\u5931\u8d25, \u5546\u57ce\u5730\u5740 = " + addressId + "\u946b\u65b9\u76db\u5730\u5740 = " + Arrays.toString(addr));
            throw new KDException(new ErrorCode("get XFS address error", ResManager.loadKDString((String)"\u83b7\u53d6\u946b\u65b9\u76db\u4e0b\u5355\u5730\u5740\u5931\u8d25\u3002", (String)"XfsPlaceOrderService_3", (String)"scm-mal-common", (Object[])new Object[0])), new Object[0]);
        }
        int size = addr.length;
        params.put("provinceId", addr[MalPlaceOrderConstant.PROVINCE_INDEX]);
        params.put("cityId", addr[MalPlaceOrderConstant.CITY_INDEX]);
        params.put("countyId", addr[MalPlaceOrderConstant.COUNTY_INDEX]);
        if (size > 3) {
            params.put("townId", addr[MalPlaceOrderConstant.TOWN_INDEX]);
        } else {
            params.put("townId", "0");
        }
        params.put("address", recieptMap.get("receiptAddr"));
        params.put("chnCustomerName", sourceDyo.getString("invoiceorg.ffirmname.zh_CN"));
        params.put("mobile", recieptMap.get("receiptphone"));
        params.put("remark", sourceDyo.getString("remark" + xfsSupplierIndex));
        log.info(logString.toString());
        Map data = (Map)EcApiUtil.parseResful((Object)ApiAccessor.invoke((String)"SRM_XFS_ORDER_submitPreOrder", params));
        log.info("\u8c03\u7528\u751f\u6210\u946b\u65b9\u76db\u9884\u5360\u5e93\u5b58\u5355\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\uff1a" + data);
        String orderId = data.get("orderNo").toString();
        result.put("orderId", orderId);
        result.put("resultMap", data);
        result.put("sku", skuInfos);
        return result;
    }

    private void writeBack2OrderInfo(String orderId, String billNo, Map<String, PriceInfo> priceMap, Map<String, String> skuIdMap) {
        HashMap<String, String> idSkuMap = new HashMap<String, String>((int)((double)skuIdMap.size() / 0.75));
        for (Map.Entry<String, String> entry : skuIdMap.entrySet()) {
            idSkuMap.put(entry.getValue(), entry.getKey());
        }
        QFilter filter = new QFilter("billno", "=", (Object)billNo);
        String head = DynamicObjectUtil.getSelectfields((String)"mal_order", (boolean)false);
        String entry = DynamicObjectUtil.getEntrySelectfields((String)"", (String)"mal_order", (String)"entryentity", (boolean)false);
        String selectFields = head + "," + entry;
        DynamicObject[] dyo = BusinessDataServiceHelper.load((String)"mal_order", (String)selectFields, (QFilter[])new QFilter[]{filter});
        dyo[0].set("jdorderid", (Object)orderId);
        String xfsParentOrderPkId = MalPlaceOrderUtils.getParentOrderPkId(orderId, this.getSource()).toString();
        DynamicObject xfsOrderDyn = MalPlaceOrderUtils.getOrderDyn(xfsParentOrderPkId, this.getSource());
        dyo[0].set("ecorderid_id", (Object)xfsParentOrderPkId);
        dyo[0].set("ecorderid", (Object)xfsOrderDyn);
        dyo[0].set("orderstatus", (Object)EmalStatusUtil.getNumber((String)xfsOrderDyn.get("state").toString(), (String)"1", (String)this.getSource()));
        for (DynamicObject temp : (DynamicObjectCollection)dyo[0].get("entryentity")) {
            String goodsId = temp.getString("goods.id");
            String goodsIdSku = (String)idSkuMap.get(goodsId);
            if (goodsIdSku == null) continue;
            PriceInfo priceInfo = priceMap.get(goodsIdSku);
            temp.set("taxprice", (Object)priceInfo.getTaxPrice());
            temp.set("taxrate", (Object)priceInfo.getTaxRate());
            temp.set("order_id", (Object)xfsParentOrderPkId);
            temp.set("order", (Object)xfsOrderDyn);
        }
        Cal4DynamicObj.reCalBill((DynamicObject)dyo[0], (String)"entryentity");
        SaveServiceHelper.save((DynamicObject[])dyo);
    }

    private void saveXfsParentOrder(int dlSupplierIndex, DynamicObject sourceDyo, Map<String, String> skuIdMap, Map<String, PriceInfo> priceMap, Map<String, Integer> qtyMap, Map<String, Object> result) {
        DynamicObject xfsOrder = BusinessDataServiceHelper.newDynamicObject((String)"pbd_order_xfs");
        Map<String, BigDecimal> amountParamMap = this.getAmountParam(priceMap, qtyMap);
        this.setXfsOrderHeadInfo(sourceDyo, dlSupplierIndex, xfsOrder, result, amountParamMap);
        XfsPlaceOrderService.setXfsOrderEntryInfo(xfsOrder, skuIdMap, priceMap, qtyMap);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{xfsOrder});
    }

    private void setXfsOrderHeadInfo(DynamicObject sourceDyo, int xfsSupplierIndex, DynamicObject xfsOrder, Map<String, Object> result, Map<String, BigDecimal> amountParamMap) {
        String currency = MalOrderUtil.getDefaultCurrency();
        Date currentDate = new Date();
        String orderId = (String)result.get("orderId");
        Map data = (Map)result.get("resultMap");
        xfsOrder.set("porderid", (Object)orderId);
        xfsOrder.set("orderid", (Object)orderId);
        xfsOrder.set("submitstate", (Object)"0");
        xfsOrder.set("orderstate", (Object)"1");
        xfsOrder.set("state", (Object)"10");
        xfsOrder.set("freight", (Object)(null == data.get("freight") ? BigDecimal.ZERO : new BigDecimal(Parser.toString(data.get("freight")))));
        xfsOrder.set("ordernakedamount", (Object)amountParamMap.get("orderNakedPrice"));
        xfsOrder.set("ordertaxamount", (Object)amountParamMap.get("orderTaxPrice"));
        xfsOrder.set("orderamount", (Object)amountParamMap.get("orderPrice"));
        if (StringUtils.isNotBlank((CharSequence)currency)) {
            xfsOrder.set("currency_id", (Object)currency);
        } else {
            xfsOrder.set("currency_id", (Object)"1");
        }
        xfsOrder.set("invoicestate", (Object)PurEcInvoiceEnum.PREREQUEST.getVal());
        xfsOrder.set("invoicetype", (Object)sourceDyo.get("invoicetype" + xfsSupplierIndex).toString());
        xfsOrder.set("createtime", (Object)currentDate);
    }

    private Map<String, BigDecimal> getAmountParam(Map<String, PriceInfo> priceInfoMap, Map<String, Integer> qtyMap) {
        HashMap<String, BigDecimal> resMap = new HashMap<String, BigDecimal>(8);
        BigDecimal totalTaxAmount = BigDecimal.ZERO;
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalTax = BigDecimal.ZERO;
        for (Map.Entry<String, Integer> entry : qtyMap.entrySet()) {
            String sku = entry.getKey();
            if (null == priceInfoMap.get(sku) || null == priceInfoMap.get(sku).getTaxPrice() || null == priceInfoMap.get(sku).getPrice()) continue;
            totalTaxAmount = totalTaxAmount.add(Parser.toBigDecimal((Object)entry.getValue()).multiply(priceInfoMap.get(sku).getTaxPrice()));
            totalAmount = totalAmount.add(Parser.toBigDecimal((Object)entry.getValue()).multiply(priceInfoMap.get(sku).getPrice()));
        }
        totalTax = totalTaxAmount.subtract(totalAmount);
        resMap.put("orderPrice", totalTaxAmount);
        resMap.put("orderNakedPrice", totalAmount);
        resMap.put("orderTaxPrice", totalTax);
        return resMap;
    }

    private static void setXfsOrderEntryInfo(DynamicObject xfsOrder, Map<String, String> skuIdMap, Map<String, PriceInfo> priceMap, Map<String, Integer> qtyMap) {
        DynamicObjectCollection entryDyoCol = (DynamicObjectCollection)xfsOrder.get("entryentity");
        for (Map.Entry<String, Integer> skuMap : qtyMap.entrySet()) {
            DynamicObject entryDyo = entryDyoCol.addNew();
            String sku = skuMap.getKey();
            entryDyo.set("goods", (Object)skuIdMap.get(sku));
            entryDyo.set("qty", (Object)skuMap.getValue());
            PriceInfo priceInfo = priceMap.get(sku);
            if (null == priceInfo) continue;
            entryDyo.set("price", (Object)(priceInfo.getTaxPrice() == null ? BigDecimal.ZERO : priceInfo.getTaxPrice()));
            entryDyo.set("nakedamount", (Object)(priceInfo.getPrice() == null ? BigDecimal.ZERO : priceInfo.getPrice()));
            entryDyo.set("taxamount", (Object)(priceInfo.getTax() == null ? BigDecimal.ZERO : priceInfo.getTax()));
            entryDyo.set("taxrate", (Object)(priceInfo.getTaxRate() == null ? BigDecimal.ZERO : priceInfo.getTaxRate()));
        }
    }
}

