/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.search;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.scm.common.ecapi.entity.GoodsInfo;
import kd.scm.mal.common.util.MalNewSearchUtils;

public class MalSearchModel {
    private static final String ALL = "all";
    private String searchType;
    private String searchText;
    private List<String> searchFields = new ArrayList<String>();
    private String selectedSource = "all";
    private String selectedCategory = "all";
    private String selectedBrand = "all";
    private int selectedSort = 0;
    @Deprecated
    private Set<String> sourceTags = new HashSet<String>();
    private Map<String, String> sourceTagsMap;
    @Deprecated
    private Set<String> categoryTags = new HashSet<String>();
    private Map<String, String> categoryTagsMap;
    @Deprecated
    private Set<String> brandTags = new HashSet<String>();
    private Map<String, String> brandTagsMap;
    private BigDecimal startPrice;
    private BigDecimal endPrice;
    private Boolean isQysp;
    private String priceSortText;
    private String salesSortText;
    private int categoryMore = 0;
    List<String> categoryMoreKeys = new ArrayList<String>();
    private int brandMore;
    private List<String> brandMoreKeys = new ArrayList<String>();
    public static final String PRICEDOWN = MalSearchModel.getLanPriceDown();
    public static final String PRICEUP = MalSearchModel.getLanPriceUp();
    public static final String PRICE = MalSearchModel.getLanPrice();
    public static final String SALESDOWN = MalSearchModel.getLanSalesDown();
    public static final String SALESUP = MalSearchModel.getLanSalesUp();
    public static final String SALES = MalSearchModel.getLanSales();
    public static final String DEFALUT = MalSearchModel.getLanDefault();
    private List<GoodsInfo> productList = new ArrayList<GoodsInfo>();

    public MalSearchModel() {
        this.priceSortText = PRICE;
        this.salesSortText = SALES;
        this.startPrice = BigDecimal.ZERO;
        this.endPrice = BigDecimal.ZERO;
        this.sourceTagsMap = new HashMap<String, String>(8);
        this.categoryTagsMap = new HashMap<String, String>(8);
        this.brandTagsMap = new HashMap<String, String>(8);
    }

    private static String getLanDefault() {
        return ResManager.loadKDString((String)"\u9ed8\u8ba4", (String)"MalSearchModel_0", (String)"scm-mal-common", (Object[])new Object[0]);
    }

    private static String getLanPriceDown() {
        return ResManager.loadKDString((String)"\u4ef7\u683c\u2193", (String)"MalSearchModel_1", (String)"scm-mal-common", (Object[])new Object[0]);
    }

    private static String getLanPriceUp() {
        return ResManager.loadKDString((String)"\u4ef7\u683c\u2191", (String)"MalSearchModel_2", (String)"scm-mal-common", (Object[])new Object[0]);
    }

    private static String getLanSalesDown() {
        return ResManager.loadKDString((String)"\u9500\u91cf\u2193", (String)"MalSearchModel_3", (String)"scm-mal-common", (Object[])new Object[0]);
    }

    private static String getLanSalesUp() {
        return ResManager.loadKDString((String)"\u9500\u91cf\u2191", (String)"MalSearchModel_4", (String)"scm-mal-common", (Object[])new Object[0]);
    }

    private static String getLanSales() {
        return ResManager.loadKDString((String)"\u9500\u91cf", (String)"MalSearchModel_5", (String)"scm-mal-common", (Object[])new Object[0]);
    }

    private static String getLanPrice() {
        return ResManager.loadKDString((String)"\u4ef7\u683c", (String)"MalSearchModel_6", (String)"scm-mal-common", (Object[])new Object[0]);
    }

    public int getBrandMore() {
        return this.brandMore;
    }

    public void setBrandMore(int brandMore) {
        this.brandMore = brandMore;
    }

    public List<String> getBrandMoreKeys() {
        return this.brandMoreKeys;
    }

    public void setBrandMoreKeys(List<String> brandMoreKeys) {
        this.brandMoreKeys = brandMoreKeys;
    }

    public List<String> getCategoryMoreKeys() {
        return this.categoryMoreKeys;
    }

    public void setCategoryMoreKeys(List<String> categoryMoreKeys) {
        this.categoryMoreKeys = categoryMoreKeys;
    }

    public int getCategoryMore() {
        return this.categoryMore;
    }

    public void setCategoryMore(int categoryMore) {
        this.categoryMore = categoryMore;
    }

    public Map<String, String> getSourceTagsMap() {
        return this.sourceTagsMap;
    }

    public void setSourceTagsMap(Map<String, String> sourceTagsMap) {
        this.sourceTagsMap = sourceTagsMap;
    }

    public Map<String, String> getCategoryTagsMap() {
        return this.categoryTagsMap;
    }

    public void setCategoryTagsMap(Map<String, String> categoryTagsMap) {
        this.categoryTagsMap = categoryTagsMap;
    }

    public Map<String, String> getBrandTagsMap() {
        return this.brandTagsMap;
    }

    public void setBrandTagsMap(Map<String, String> brandTagsMap) {
        this.brandTagsMap = brandTagsMap;
    }

    public int getSelectedSort() {
        return this.selectedSort;
    }

    public void setSelectedSort(int selectedSort) {
        this.selectedSort = selectedSort;
    }

    public Boolean getQysp() {
        return this.isQysp;
    }

    public void setQysp(Boolean qysp) {
        this.isQysp = qysp;
    }

    public String getPriceSortText() {
        return this.priceSortText;
    }

    public void setPriceSortText(String priceSortText) {
        this.priceSortText = priceSortText;
    }

    public String getSalesSortText() {
        return this.salesSortText;
    }

    public void setSalesSortText(String salesSortText) {
        this.salesSortText = salesSortText;
    }

    @Deprecated
    public Set<String> getSourceTags() {
        return this.sourceTags;
    }

    @Deprecated
    public void setSourceTags(Set<String> sourceTags) {
        this.sourceTags = sourceTags;
    }

    @Deprecated
    public Set<String> getCategoryTags() {
        return this.categoryTags;
    }

    @Deprecated
    public void setCategoryTags(Set<String> categoryTags) {
        this.categoryTags = categoryTags;
    }

    @Deprecated
    public Set<String> getBrandTags() {
        return this.brandTags;
    }

    @Deprecated
    public void setBrandTags(Set<String> brandTags) {
        this.brandTags = brandTags;
    }

    public List<String> getSearchFields() {
        return this.searchFields;
    }

    public String getSearchType() {
        return this.searchType;
    }

    public void setSearchType(String searchType) {
        this.searchType = searchType;
    }

    public void setSearchFields(List<String> searchFields) {
        this.searchFields = searchFields;
    }

    public String getSearchText() {
        return this.searchText;
    }

    public void setSearchText(String searchText) {
        this.searchText = searchText;
    }

    public String getSelectedSource() {
        return this.selectedSource;
    }

    public void setSelectedSource(String selectedSource) {
        this.selectedSource = selectedSource;
    }

    public String getSelectedCategory() {
        return this.selectedCategory;
    }

    public void setSelectedCategory(String selectedCategory) {
        this.selectedCategory = selectedCategory;
    }

    public String getSelectedBrand() {
        return this.selectedBrand;
    }

    public void setSelectedBrand(String selectedBrand) {
        this.selectedBrand = selectedBrand;
    }

    public BigDecimal getStartPrice() {
        return this.startPrice;
    }

    public void setStartPrice(BigDecimal startPrice) {
        this.startPrice = startPrice;
    }

    public BigDecimal getEndPrice() {
        return this.endPrice;
    }

    public void setEndPrice(BigDecimal endPrice) {
        this.endPrice = endPrice;
    }

    public List<GoodsInfo> getProductList() {
        return this.productList;
    }

    public void setProductList(List<GoodsInfo> productList) {
        this.productList = productList;
    }

    public List<GoodsInfo> filterByShopPrice(List<GoodsInfo> goodsInfos) {
        ArrayList<GoodsInfo> res = new ArrayList<GoodsInfo>();
        if (this.startPrice.compareTo(BigDecimal.ZERO) == 0 && this.endPrice.compareTo(BigDecimal.ZERO) == 0) {
            return goodsInfos.stream().filter(goodsInfo -> BigDecimal.ZERO.compareTo(goodsInfo.getShopPrice()) < 0).collect(Collectors.toList());
        }
        BigDecimal endPrice = this.endPrice;
        if (endPrice.compareTo(BigDecimal.ZERO) == 0) {
            endPrice = new BigDecimal("9999999999");
        }
        if (endPrice.compareTo(this.startPrice) < 0) {
            return res;
        }
        for (GoodsInfo goodsInfo2 : goodsInfos) {
            if (null == goodsInfo2.getShopPrice() || goodsInfo2.getShopPrice().compareTo(this.startPrice) < 0 || goodsInfo2.getShopPrice().compareTo(endPrice) > 0) continue;
            res.add(goodsInfo2);
        }
        return res;
    }

    public List<GoodsInfo> filterByQysp(List<GoodsInfo> goodsInfos) {
        List<Object> res = new ArrayList<GoodsInfo>(goodsInfos);
        if (this.isQysp != null && this.isQysp.booleanValue()) {
            res = goodsInfos.stream().filter(a -> {
                if (a.getCentralpurtype() != null && StringUtils.isNotEmpty((CharSequence)a.getCentralpurtype())) {
                    return a.getCentralpurtype().equals("1");
                }
                return false;
            }).collect(Collectors.toList());
            return res;
        }
        return res;
    }

    public List<GoodsInfo> filterAndSortBySelected(List<GoodsInfo> productList) {
        if (1 == this.selectedSort) {
            return this.sortByShopPrice(this.filterByShopPrice(this.filterByBrand(this.filterByCategory(this.filterBySource(this.filterByQysp(productList))))));
        }
        if (2 == this.selectedSort) {
            return this.sortBySales(this.filterByShopPrice(this.filterByBrand(this.filterByCategory(this.filterBySource(this.filterByQysp(productList))))));
        }
        return this.filterByBrand(this.filterByShopPrice(this.filterByCategory(this.filterBySource(this.filterByQysp(productList)))));
    }

    public List<GoodsInfo> filterByQyspAndShopPriceAndSortByShopPrice(List<GoodsInfo> productList) {
        return this.sortByShopPrice(this.filterByQysp(this.filterByShopPrice(productList)));
    }

    public List<GoodsInfo> filterByQyspAndShopPriceAndSortBySales(List<GoodsInfo> productList) {
        return this.sortBySales(this.filterByQysp(this.filterByShopPrice(productList)));
    }

    public List<GoodsInfo> filterByCategory(List<GoodsInfo> productList) {
        if (StringUtils.equals((CharSequence)this.selectedCategory, (CharSequence)ALL)) {
            return productList;
        }
        return productList.stream().filter(a -> StringUtils.equalsIgnoreCase((CharSequence)a.getCategoryId(), (CharSequence)this.selectedCategory.split("_")[1])).collect(Collectors.toList());
    }

    public List<GoodsInfo> filterByBrand(List<GoodsInfo> productList) {
        if (StringUtils.equals((CharSequence)this.selectedBrand, (CharSequence)ALL)) {
            return productList;
        }
        return productList.stream().filter(a -> StringUtils.equalsIgnoreCase((CharSequence)a.getBrandId(), (CharSequence)this.selectedBrand.split("_")[1])).collect(Collectors.toList());
    }

    public List<GoodsInfo> filterBySource(List<GoodsInfo> productList) {
        if (StringUtils.isNotEmpty((CharSequence)this.selectedSource)) {
            if (this.selectedSource.equals(ALL)) {
                return productList;
            }
            return productList.stream().filter(a -> a.getProductSource().equals(this.selectedSource)).collect(Collectors.toList());
        }
        return productList;
    }

    public List<GoodsInfo> sortByShopPrice(List<GoodsInfo> productList) {
        if (PRICEDOWN.equals(this.priceSortText)) {
            productList.sort(Comparator.comparing(GoodsInfo::getShopPrice).reversed());
        } else {
            productList.sort(Comparator.comparing(GoodsInfo::getShopPrice));
        }
        return productList;
    }

    public List<GoodsInfo> sortBySales(List<GoodsInfo> productList) {
        List<GoodsInfo> res = MalNewSearchUtils.getSales(productList);
        if (SALESUP.equals(this.salesSortText)) {
            res.sort(Comparator.comparing(GoodsInfo::getSales).reversed());
        } else {
            res.sort(Comparator.comparing(GoodsInfo::getSales));
        }
        return res;
    }

    public void changeSortText(String oldSortText) {
        if (PRICE.equals(oldSortText)) {
            this.priceSortText = PRICEUP;
            this.selectedSort = 1;
            this.salesSortText = SALES;
        }
        if (PRICEUP.equals(oldSortText)) {
            this.priceSortText = PRICEDOWN;
            this.selectedSort = 1;
            this.salesSortText = SALES;
        }
        if (PRICEDOWN.equals(oldSortText)) {
            this.priceSortText = PRICEUP;
            this.selectedSort = 1;
            this.salesSortText = SALES;
        }
        if (SALES.equals(oldSortText)) {
            this.salesSortText = SALESDOWN;
            this.selectedSort = 2;
            this.priceSortText = PRICE;
        }
        if (SALESDOWN.equals(oldSortText)) {
            this.salesSortText = SALESUP;
            this.selectedSort = 2;
            this.priceSortText = PRICE;
        }
        if (SALESUP.equals(oldSortText)) {
            this.salesSortText = SALESDOWN;
            this.selectedSort = 2;
            this.priceSortText = PRICE;
        }
        if (DEFALUT.equals(oldSortText)) {
            this.salesSortText = SALES;
            this.selectedSort = 0;
            this.priceSortText = PRICE;
        }
    }
}

