/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.service;

import java.util.HashMap;
import java.util.Map;
import kd.bos.exception.KDBizException;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.mal.common.service.IEcOrderAutoReceive;
import kd.scm.mal.common.service.impl.EcOrderCqAutoReceiveImpl;
import kd.scm.mal.common.service.impl.EcOrderEasAutoReceiveImpl;
import kd.scm.mal.common.service.impl.EcOrderRepcAutoReceiveImpl;
import kd.scm.mal.common.service.impl.EcOrderXkAutoReceiveImpl;

public class EcOrderAutoReceiveFactory {
    private static final Map<String, IEcOrderAutoReceive> serviceMap = new HashMap<String, IEcOrderAutoReceive>();

    public static IEcOrderAutoReceive getEcOrderAutoReceiveService(String sysType) {
        if (sysType.equals("0")) {
            if (serviceMap.get(sysType) == null) {
                serviceMap.put("0", new EcOrderCqAutoReceiveImpl());
            }
        } else if (sysType.equals("eas")) {
            if (serviceMap.get(sysType) == null) {
                serviceMap.put("eas", new EcOrderEasAutoReceiveImpl());
            }
        } else if (sysType.equals("k3cloud")) {
            if (serviceMap.get(sysType) == null) {
                serviceMap.put("k3cloud", new EcOrderXkAutoReceiveImpl());
            }
        } else if (sysType.equals("repc") && serviceMap.get(sysType) == null) {
            serviceMap.put("repc", new EcOrderRepcAutoReceiveImpl());
        }
        return serviceMap.get(sysType);
    }

    @Deprecated
    public static void registerService(String sysType, IEcOrderAutoReceive pluginService) {
    }

    @Deprecated
    public static void clearServiceMap() {
    }

    public static IEcOrderAutoReceive getEcOrderAutoReceiveServiceByConnectErp() {
        if (ApiConfigUtil.hasXKScmConfig()) {
            return EcOrderAutoReceiveFactory.getEcOrderAutoReceiveService("k3cloud");
        }
        if (ApiConfigUtil.hasCQScmConfig()) {
            return EcOrderAutoReceiveFactory.getEcOrderAutoReceiveService("0");
        }
        if (ApiConfigUtil.hasRepcConfig()) {
            return EcOrderAutoReceiveFactory.getEcOrderAutoReceiveService("repc");
        }
        if (ApiConfigUtil.hasEASConfig()) {
            return EcOrderAutoReceiveFactory.getEcOrderAutoReceiveService("eas");
        }
        throw new KDBizException("EcOrderAutoReceiveService not found.");
    }
}

