/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.service.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.BizTypeEnum;
import kd.scm.common.helper.apiconnector.api.util.Parser;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.JacksonJsonUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.SynOrderUtil;
import kd.scm.common.util.cal.Cal4DynamicObj;
import kd.scm.mal.common.enums.MalBizflowParamEnum;
import kd.scm.mal.common.service.AsyncPushBillService;
import kd.scm.mal.common.util.MalBizFowUtil;

public class AsyncPushEasOrderServiceImpl
implements AsyncPushBillService {
    @Override
    public DynamicObjectCollection assemblePushBillData(String billPk, String srcEntityKey) {
        if (StringUtils.isEmpty((CharSequence)billPk)) {
            return new DynamicObjectCollection();
        }
        QFilter filter = new QFilter("id", "=", (Object)Long.valueOf(billPk));
        return QueryServiceHelper.query((String)srcEntityKey, (String)this.getSelectFields(), (QFilter[])new QFilter[]{filter});
    }

    @Override
    public void handleAfterPushBillData(List<DynamicObject> targetData) {
        Set<Long> supplierIdSet = MalBizFowUtil.getSupplierIdSet(targetData);
        Map<Long, Object> bizPartnerMap = MalBizFowUtil.getBizPartner(supplierIdSet);
        for (DynamicObject data : targetData) {
            if (StringUtils.isBlank((CharSequence)data.getString("billno"))) {
                String readNumber = CodeRuleServiceHelper.getNumber((String)data.getDataEntityType().getName(), (DynamicObject)data, (String)data.getString("org.id"));
                data.set("billno", (Object)readNumber);
            }
            data.set("biztype", (Object)BizTypeEnum.PUR_STANDARD.getVal());
            Long supplierId = data.getLong("supplier.id");
            Object bizPartner = bizPartnerMap.get(supplierId);
            if (bizPartner != null) {
                data.set("bizpartner_id", bizPartner);
            }
            Cal4DynamicObj.calSum((DynamicObject)data, (String)"materialentry");
            MalBizFowUtil.setCenterBalance(data);
        }
    }

    @Override
    public void doTargetBizOperation(String entity, List<DynamicObject> targetData, Long userId) {
        DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (String)"bos_user");
        String bizflow = MalOrderUtil.getBizFlowParam();
        for (DynamicObject data : targetData) {
            data.set("creator", (Object)user);
            data.set("creator_id", (Object)userId);
            data.set("modifier_id", (Object)userId);
            data.set("modifier", (Object)user);
            data.set("createtime", (Object)new Date());
            data.set("modifytime", (Object)new Date());
            if (StringUtils.equalsIgnoreCase((CharSequence)bizflow, (CharSequence)MalBizflowParamEnum.MALORDER.getVal())) {
                data.set("auditor", (Object)user);
                data.set("auditor_id", (Object)userId);
                data.set("auditdate", (Object)new Date());
                data.set("billstatus", (Object)BillStatusEnum.AUDIT.getVal());
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)bizflow, (CharSequence)MalBizflowParamEnum.ERP_PURORDER.getVal())) {
                data.set("billstatus", (Object)BillStatusEnum.SUBMIT.getVal());
            }
            DynamicObjectCollection entryCol = data.getDynamicObjectCollection("materialentry");
            if (StringUtils.equalsIgnoreCase((CharSequence)bizflow, (CharSequence)MalBizflowParamEnum.MALORDER.getVal())) {
                data.set("cfmstatus", (Object)"A");
            }
            if (null == entryCol || entryCol.size() <= 0) continue;
            Object settleOrgId = 0L;
            Long orgId = ((DynamicObject)((DynamicObject)entryCol.get(0)).get("entryrcvorg")).getLong("id");
            Map result = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
            if (result.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u6838\u7b97\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5\u5e93\u5b58\u7ec4\u7ec7\u5bf9\u5e94\u6838\u7b97\u4e3b\u4f53\u7684\u6b63\u786e\u6027\u3002", (String)"AsyncPushEasOrderServiceImpl_0", (String)"scm-mal-common", (Object[])new Object[0]));
            }
            settleOrgId = Long.valueOf(result.get("id").toString());
            for (DynamicObject entrydyo : entryCol) {
                if ((Long)settleOrgId == 0L || null != entrydyo.get("entrysettleorg")) continue;
                entrydyo.set("entrysettleorg", settleOrgId);
            }
        }
        String msg = Parser.toString((Object)SynOrderUtil.synCreateEasOrder(targetData));
        if (StringUtils.equalsIgnoreCase((CharSequence)bizflow, (CharSequence)MalBizflowParamEnum.ERP_PURORDER.getVal())) {
            Map dataMap = (Map)JacksonJsonUtil.fromJson((String)msg, Map.class);
            HashMap billNoMap = new HashMap(8);
            for (DynamicObject data : targetData) {
                Map detailMap;
                Object obj = dataMap.get(data.getPkValue().toString());
                if (null == obj || !(obj instanceof Map) || !"200".equals((detailMap = (Map)obj).get("status"))) continue;
                DynamicObjectCollection entryDyos = data.getDynamicObjectCollection("materialentry");
                for (DynamicObject entry : entryDyos) {
                    billNoMap.put(Parser.toLong((Object)entry.get("srcentryid")), detailMap.get("billNumber"));
                }
            }
            String selectFields = "id,entryentity.id,entryentity.erpbillnumber,entryentity.erpbillstatus";
            QFilter filter = new QFilter("entryentity.id", "in", billNoMap.keySet());
            DynamicObject[] dyos = BusinessDataServiceHelper.load((String)"mal_order", (String)selectFields, (QFilter[])new QFilter[]{filter});
            if (null == dyos || dyos.length <= 0) {
                return;
            }
            for (DynamicObject bill : dyos) {
                DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entrys) {
                    String purOrderNo = (String)billNoMap.get(entry.getLong("id"));
                    entry.set("erpbillnumber", (Object)purOrderNo);
                    entry.set("erpbillstatus", (Object)BillStatusEnum.SUBMIT.getVal());
                }
            }
            SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])dyos);
        }
    }

    @Override
    public void handleAfterSaveTargetData(OperationResult opResult, String entity, Long srcCreatorId) {
    }
}

