/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.service.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.mal.common.enums.MalBizflowParamEnum;
import kd.scm.mal.common.service.AsyncPushBillService;
import kd.scm.mal.common.util.MalBizFowUtil;

public class AsyncPushPmOrderServiceImpl
implements AsyncPushBillService {
    Log logger = LogFactory.getLog(AsyncPushPmOrderServiceImpl.class);

    @Override
    public DynamicObjectCollection assemblePushBillData(String billPk, String srcEntityKey) {
        return AsyncPushBillService.super.assemblePushBillData(billPk, srcEntityKey);
    }

    @Override
    public void handleAfterPushBillData(List<DynamicObject> targetData) {
    }

    @Override
    public void doTargetBizOperation(String entity, List<DynamicObject> targetData, Long srcCreatorId) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(true));
        option.setVariableValue("isStrict", String.valueOf(false));
        option.setVariableValue("WF", String.valueOf(false));
        option.setVariableValue("ignoreValidation", String.valueOf(true));
        option.setVariableValue("ignoreinteraction", String.valueOf(true));
        OperationResult saveResult = MalBizFowUtil.doSaveOperation(entity, targetData, option);
        this.handleAfterSaveTargetData(saveResult, entity, srcCreatorId);
        String bizflow = MalOrderUtil.getBizFlowParam();
        if (StringUtils.equalsIgnoreCase((CharSequence)bizflow, (CharSequence)MalBizflowParamEnum.ERP_PURORDER.getVal())) {
            option.removeVariable("WF");
            MalBizFowUtil.doOperation(entity, "submit", saveResult.getSuccessPkIds().toArray(new Object[0]), option, true, true);
            this.writeMalOrderByPm(saveResult.getSuccessPkIds());
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)bizflow, (CharSequence)MalBizflowParamEnum.MALORDER.getVal())) {
            OperationResult submitResult = MalBizFowUtil.doOperation(entity, "submit", saveResult.getSuccessPkIds().toArray(new Object[0]), option, true, true);
            MalBizFowUtil.doOperation(entity, "audit", submitResult.getSuccessPkIds().toArray(new Object[0]), option, true, true);
        }
    }

    private void writeMalOrderByPm(List<Object> successPkIds) {
        HashSet<Long> pmOrderIds = new HashSet<Long>(16);
        for (Object objId : successPkIds) {
            if (ObjectUtils.isEmpty((Object)objId)) continue;
            pmOrderIds.add(Long.parseLong(String.valueOf(objId)));
        }
        QFilter qFilter = new QFilter("id", "in", pmOrderIds);
        String pmOrderSel = "billentry.soubillid soubillid,billentry.soubillentryid soubillentryid,billno";
        DynamicObjectCollection pmPurOrderBills = QueryServiceHelper.query((String)"pm_purorderbill", (String)pmOrderSel, (QFilter[])qFilter.toArray());
        HashMap<Long, String> pmBillNoMap = new HashMap<Long, String>();
        long malorderbillId = 0L;
        for (DynamicObject bill : pmPurOrderBills) {
            malorderbillId = bill.getLong("soubillid");
            long soubillentryid = bill.getLong("soubillentryid");
            pmBillNoMap.put(soubillentryid, bill.getString("billno"));
        }
        if (0L != malorderbillId) {
            DynamicObject[] orders;
            qFilter = new QFilter("id", "=", (Object)malorderbillId);
            String selectors = "billno,entryentity.id,entryentity.erpbillnumber,entryentity.erpbillstatus";
            for (DynamicObject order : orders = BusinessDataServiceHelper.load((String)"mal_order", (String)selectors, (QFilter[])qFilter.toArray())) {
                DynamicObjectCollection entrys = order.getDynamicObjectCollection("entryentity");
                for (DynamicObject row : entrys) {
                    long entryId = row.getLong("id");
                    if (null == pmBillNoMap.get(entryId)) continue;
                    row.set("erpbillnumber", pmBillNoMap.get(entryId));
                    row.set("erpbillstatus", (Object)"B");
                }
            }
            if (orders.length > 0) {
                SaveServiceHelper.save((DynamicObject[])orders);
            }
        }
    }

    @Override
    public void handleAfterSaveTargetData(OperationResult opResult, String entity, Long srcCreatorId) {
        DynamicObject[] dynamicObjects;
        this.logger.info("@@@AsyncPushPmOrderServiceImpl.srcCreatorId\u4e3a\uff1a" + srcCreatorId);
        QFilter filter = new QFilter("id", "in", (Object)opResult.getSuccessPkIds().toArray(new Long[0]));
        DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)srcCreatorId, (String)"bos_user");
        String selectFileds = "id,creator,modifier";
        for (DynamicObject dyo : dynamicObjects = BusinessDataServiceHelper.load((String)entity, (String)selectFileds, (QFilter[])new QFilter[]{filter})) {
            dyo.set("creator_id", (Object)srcCreatorId);
            dyo.set("creator", (Object)user);
            dyo.set("modifier_id", (Object)srcCreatorId);
            dyo.set("modifier", (Object)user);
        }
        try (TXHandle h = TX.required();){
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        }
        catch (Exception e) {
            this.logger.error("@@@AsyncPushPmOrderServiceImpl.\u4fdd\u5b58pmOrder\u5f02\u5e38\uff1a" + e.getMessage());
            this.logger.error("@@@AsyncPushPmOrderServiceImpl.\u4fdd\u5b58pmOrder\u5f02\u5e38,\u5806\u6808\u4fe1\u606f\uff1a" + ExceptionUtil.getStackTrace((Throwable)e));
            throw new KDBizException(new ErrorCode("handle target err", ResManager.loadKDString((String)"\u5904\u7406\u76ee\u6807\u5355\u5f02\u5e38\u3002", (String)"AsyncPushPmOrderServiceImpl_0", (String)"scm-mal-common", (Object[])new Object[0])), new Object[]{ExceptionUtil.getStackTrace((Throwable)e)});
        }
    }
}

