/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.service.impl;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scm.common.enums.BizTypeEnum;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.cal.Cal4DynamicObj;
import kd.scm.mal.common.enums.MalBizflowParamEnum;
import kd.scm.mal.common.service.AsyncPushBillService;
import kd.scm.mal.common.util.MalBizFowUtil;

public class AsyncPushPurOrderServiceImpl
implements AsyncPushBillService {
    Log logger = LogFactory.getLog(AsyncPushPurOrderServiceImpl.class);

    @Override
    public DynamicObjectCollection assemblePushBillData(String billPk, String srcEntityKey) {
        return AsyncPushBillService.super.assemblePushBillData(billPk, srcEntityKey);
    }

    @Override
    public void handleAfterPushBillData(List<DynamicObject> targetData) {
        Set<Long> supplierIdSet = MalBizFowUtil.getSupplierIdSet(targetData);
        Map<Long, Object> bizPartnerMap = MalBizFowUtil.getBizPartner(supplierIdSet);
        for (DynamicObject data : targetData) {
            data.set("biztype", (Object)BizTypeEnum.PUR_STANDARD.getVal());
            Long supplierId = data.getLong("supplier.id");
            Object bizPartner = bizPartnerMap.get(supplierId);
            if (bizPartner != null) {
                data.set("bizpartner_id", bizPartner);
            }
            Cal4DynamicObj.calSum((DynamicObject)data, (String)"materialentry");
            MalBizFowUtil.setCenterBalance(data);
        }
    }

    @Override
    public void doTargetBizOperation(String entity, List<DynamicObject> targetData, Long srcCreatorId) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(true));
        option.setVariableValue("isStrict", String.valueOf(false));
        option.setVariableValue("WF", String.valueOf(false));
        option.setVariableValue("ignoreValidation", String.valueOf(true));
        option.setVariableValue("ignoreinteraction", String.valueOf(true));
        OperationResult saveResult = MalBizFowUtil.doSaveOperation(entity, targetData, option);
        this.handleAfterSaveTargetData(saveResult, entity, srcCreatorId);
        String bizflow = MalOrderUtil.getBizFlowParam();
        Object[] ids = saveResult.getSuccessPkIds().toArray(new Object[0]);
        if (StringUtils.equalsIgnoreCase((CharSequence)bizflow, (CharSequence)MalBizflowParamEnum.ERP_PURORDER.getVal())) {
            MalBizFowUtil.doOperation(entity, "submit", ids, option, true, false);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)bizflow, (CharSequence)MalBizflowParamEnum.MALORDER.getVal())) {
            OperationResult submitResult = MalBizFowUtil.doOperation(entity, "submit", ids, option, true, false);
            MalBizFowUtil.doOperation(entity, "audit", submitResult.getSuccessPkIds().toArray(new Object[0]), option, true, false);
        }
    }

    @Override
    public void handleAfterSaveTargetData(OperationResult opResult, String entity, Long srcCreatorId) {
        QFilter filter = new QFilter("id", "in", (Object)opResult.getSuccessPkIds().toArray(new Long[0]));
        String selectFileds = "id,billno,billstatus,cfmstatus,creator,auditor,auditdate,materialentry.entryrcvorg,materialentry.entrysettleorg,materialentry.pobillno,materialentry.pobillid,materialentry.poentryid";
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)entity, (String)selectFileds, (QFilter[])new QFilter[]{filter});
        String bizflow = MalOrderUtil.getBizFlowParam();
        for (DynamicObject dyo : dynamicObjects) {
            if (StringUtils.equalsIgnoreCase((CharSequence)bizflow, (CharSequence)MalBizflowParamEnum.MALORDER.getVal())) {
                dyo.set("cfmstatus", (Object)"A");
            }
            dyo.set("creator", (Object)srcCreatorId);
            DynamicObjectCollection entryCol = dyo.getDynamicObjectCollection("materialentry");
            if (null == entryCol || entryCol.size() <= 0) continue;
            Long settleOrgId = 0L;
            DynamicObject entryRevOrg = ((DynamicObject)entryCol.get(0)).getDynamicObject("entryrcvorg");
            if (!Objects.isNull(entryRevOrg)) {
                Long orgId = entryRevOrg.getLong("id");
                Map result = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
                if (result.isEmpty()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u6838\u7b97\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5\u5e93\u5b58\u7ec4\u7ec7\u5bf9\u5e94\u6838\u7b97\u4e3b\u4f53\u7684\u6b63\u786e\u6027\u3002", (String)"AsyncPushPurOrderServiceImpl_0", (String)"scm-mal-common", (Object[])new Object[0]));
                }
                settleOrgId = Long.valueOf(result.get("id").toString());
            }
            for (DynamicObject entrydyo : entryCol) {
                if (settleOrgId != 0L && null == entrydyo.get("entrysettleorg")) {
                    entrydyo.set("entrysettleorg", (Object)settleOrgId);
                }
                entrydyo.set("pobillno", dyo.get("billno"));
                entrydyo.set("pobillid", dyo.get("id"));
                entrydyo.set("poentryid", entrydyo.get("id"));
            }
        }
        try (TXHandle h = TX.required();){
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        }
        catch (Exception e) {
            this.logger.error("@@@AsyncPushPurOrderServiceImpl.\u4fdd\u5b58purOrder\u5f02\u5e38\uff1a" + e.getMessage());
            this.logger.error("@@@AsyncPushPurOrderServiceImpl.\u4fdd\u5b58purOrder\u5f02\u5e38,\u5806\u6808\u4fe1\u606f\uff1a" + ExceptionUtil.getStackTrace((Throwable)e));
            throw new KDBizException(new ErrorCode("handle target err", ResManager.loadKDString((String)"\u5904\u7406\u76ee\u6807\u5355\u5f02\u5e38\u3002", (String)"AsyncPushPurOrderServiceImpl_1", (String)"scm-mal-common", (Object[])new Object[0])), new Object[]{ExceptionUtil.getStackTrace((Throwable)e)});
        }
    }
}

