/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.service.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.util.mal.MalNewOrderUtils;
import kd.scm.mal.common.service.IEcOrderAutoReceive;
import kd.scm.mal.common.service.impl.EcOrderPurAutoReceiveImpl;

public class EcOrderAutoReceiceProxy
implements IEcOrderAutoReceive {
    private static final Log log = LogFactory.getLog((String)EcOrderAutoReceiceProxy.class.getName());
    private final IEcOrderAutoReceive ecOrderAutoReceive;

    public EcOrderAutoReceiceProxy(IEcOrderAutoReceive ecOrderAutoReceive) {
        this.ecOrderAutoReceive = ecOrderAutoReceive;
    }

    @Override
    public void autoReceive(DynamicObject[] purOrders, Set<String> completeIds) {
        if (purOrders == null) {
            return;
        }
        List<Tuple<DynamicObject[], Set<String>>> pairs = this.splitPurOrdersByGoodsBizType(purOrders, completeIds);
        if (((DynamicObject[])pairs.get((int)0).item1).length > 0) {
            log.info("@@@\u6267\u884c\u5546\u54c1\u7c7b\u91c7\u8d2d\u6536\u8d27\uff1a" + pairs.get((int)0).item2);
            new EcOrderPurAutoReceiveImpl().autoReceive((DynamicObject[])pairs.get((int)0).item1, (Set)pairs.get((int)0).item2);
        }
        if (((DynamicObject[])pairs.get((int)1).item1).length > 0) {
            log.info("@@@\u6267\u884c\u975e\u5546\u54c1\u7c7b\u91c7\u8d2d\u6536\u8d27\uff1a" + pairs.get((int)1).item2);
            this.ecOrderAutoReceive.autoReceive((DynamicObject[])pairs.get((int)1).item1, (Set)pairs.get((int)1).item2);
        }
    }

    private List<Tuple<DynamicObject[], Set<String>>> splitPurOrdersByGoodsBizType(DynamicObject[] purOrders, Set<String> completeIds) {
        ArrayList<Tuple<DynamicObject[], Set<String>>> res = new ArrayList<Tuple<DynamicObject[], Set<String>>>();
        ArrayList<DynamicObject> goodsBizTypePurOrders = new ArrayList<DynamicObject>();
        HashSet goodsBizTypeCompleteIds = new HashSet();
        ArrayList<DynamicObject> notGoodsBizTypePurOrders = new ArrayList<DynamicObject>();
        HashSet<String> notGoodsBizTypeCompleteIds = new HashSet<String>(completeIds);
        for (DynamicObject purOrder : purOrders) {
            DynamicObjectCollection materialEntryCol = purOrder.getDynamicObjectCollection("materialentry");
            HashSet<String> entryIdSet = new HashSet<String>(materialEntryCol.size() * 2);
            for (DynamicObject entry : materialEntryCol) {
                if (!completeIds.contains(entry.getString("id"))) continue;
                entryIdSet.add(entry.getString("id"));
            }
            if (MalNewOrderUtils.checkIsGoodsBizType((DynamicObject)purOrder.getDynamicObject("businesstype"))) {
                goodsBizTypePurOrders.add(purOrder);
                goodsBizTypeCompleteIds.addAll(entryIdSet);
                continue;
            }
            notGoodsBizTypePurOrders.add(purOrder);
        }
        notGoodsBizTypeCompleteIds.removeAll(goodsBizTypeCompleteIds);
        res.add(new Tuple((Object)goodsBizTypePurOrders.toArray(new DynamicObject[0]), goodsBizTypeCompleteIds));
        res.add(new Tuple((Object)notGoodsBizTypePurOrders.toArray(new DynamicObject[0]), notGoodsBizTypeCompleteIds));
        return res;
    }
}

