/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.mal.common.service.IEcOrderAutoReceive;

public class EcOrderCqAutoReceiveImpl
implements IEcOrderAutoReceive {
    private static final Log log = LogFactory.getLog(EcOrderCqAutoReceiveImpl.class);

    @Override
    public void autoReceive(DynamicObject[] purOrders, Set<String> completeIds) {
        HashMap dataMap = new HashMap(purOrders.length);
        HashMap<String, String> pushParamMap = new HashMap<String, String>(purOrders.length);
        for (DynamicObject order : purOrders) {
            DynamicObjectCollection dynamicObjectCollection = order.getDynamicObjectCollection("materialentry");
            ArrayList<String> entryOrderIds = new ArrayList<String>(dynamicObjectCollection.size());
            String pk = order.getString("id");
            for (DynamicObject entry : dynamicObjectCollection) {
                String poentryId;
                String entryId = entry.getString("id");
                if (!completeIds.contains(entryId) || StringUtils.isBlank((CharSequence)(poentryId = entry.getString("poentryid")))) continue;
                entryOrderIds.add(poentryId);
            }
            dataMap.put(pk, entryOrderIds);
            pushParamMap.put(pk, ((DynamicObject)dynamicObjectCollection.get(0)).getString("purtype.checktype"));
        }
        String selectFields = "id,billentry.id";
        StringBuilder logString = new StringBuilder();
        ArrayList<String> errorInfos = new ArrayList<String>(dataMap.size());
        for (Map.Entry entry : dataMap.entrySet()) {
            String pk = (String)entry.getKey();
            String errmsg = "$$$$$$Execution of collaborative orders:" + pk + "push,param is" + (String)pushParamMap.get(pk) + ",entry ID:" + SerializationUtils.toJsonString(entry.getValue());
            logString.append(errmsg).append("\n");
            if (((List)entry.getValue()).size() < 1) continue;
            try {
                if (StringUtils.isBlank((CharSequence)((CharSequence)pushParamMap.get(pk))) || StringUtils.equals((CharSequence)((CharSequence)pushParamMap.get(pk)), (CharSequence)"1")) {
                    MalOrderUtil.doAutoPushAndAudit((String)"pm_purorderbill", (String)"im_purreceivebill", (String)"billentry", (List)((List)entry.getValue()), (String)selectFields, (boolean)false);
                    continue;
                }
                MalOrderUtil.doAutoPushAndAudit((String)"pm_purorderbill", (String)"im_purinbill", (String)"billentry", (List)((List)entry.getValue()), (String)selectFields, (boolean)false);
            }
            catch (Exception e) {
                errorInfos.add(e.getMessage());
            }
        }
        if (errorInfos.size() > 0) {
            StringBuilder errorInfoBuilder = new StringBuilder();
            for (String errorInfo : errorInfos) {
                errorInfoBuilder.append(errorInfo).append(System.lineSeparator());
            }
            throw new KDBizException(errorInfoBuilder.toString());
        }
        log.info(logString.toString());
    }
}

