/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.mal.common.service.IEcOrderAutoReceive;

public class EcOrderEasAutoReceiveImpl
implements IEcOrderAutoReceive {
    @Override
    public void autoReceive(DynamicObject[] purOrders, Set<String> completeIds) {
        HashMap<String, DynamicObject> purorderMap = new HashMap<String, DynamicObject>();
        for (DynamicObject dyo : purOrders) {
            purorderMap.clear();
            DynamicObjectCollection purOrderEntries = dyo.getDynamicObjectCollection("materialentry");
            for (DynamicObject entry : purOrderEntries) {
                String entryId = entry.getString("id");
                if (!completeIds.contains(entryId)) continue;
                purorderMap.put(entry.getString("id"), entry);
            }
            Map<String, List<Map<String, Object>>> pushParamMap = this.getPushParamMap(purorderMap);
            MalOrderUtil.callEASInterface(pushParamMap, purorderMap);
        }
    }

    protected Map<String, List<Map<String, Object>>> getPushParamMap(Map<String, DynamicObject> purorderMap) {
        HashMap<String, List<Map<String, Object>>> result = new HashMap<String, List<Map<String, Object>>>(purorderMap.size());
        for (Map.Entry<String, DynamicObject> entry : purorderMap.entrySet()) {
            List<HashMap<String, Object>> list = new ArrayList();
            DynamicObject entryobj = entry.getValue();
            DynamicObject parentobj = (DynamicObject)entryobj.getParent();
            if (null != result.get(parentobj.getPkValue().toString())) {
                list = (List)result.get(parentobj.getPkValue().toString());
            }
            HashMap<String, Object> detailMap = new HashMap<String, Object>();
            detailMap.put("warehouse", "");
            detailMap.put("location", "");
            detailMap.put("lot", "");
            detailMap.put("project", "");
            detailMap.put("trace", "");
            detailMap.put("unit", ((DynamicObject)entryobj.get("unit")).get("number"));
            detailMap.put("basicUnit", ((DynamicObject)entryobj.get("basicunit")).get("number"));
            detailMap.put("note", "");
            detailMap.put("entryId", entryobj.get("poentryid"));
            detailMap.put("billid", entryobj.get("pobillid"));
            detailMap.put("qty", entryobj.get("qty"));
            detailMap.put("srcEntryId", entryobj.getPkValue().toString());
            detailMap.put("srcBillId", parentobj.getPkValue().toString());
            detailMap.put("source", "mal");
            list.add(detailMap);
            result.put(parentobj.getPkValue().toString(), list);
        }
        return result;
    }
}

