/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.service.impl;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.scm.mal.common.service.IEcOrderAutoReceive;

public class EcOrderRepcAutoReceiveImpl
implements IEcOrderAutoReceive {
    private static final Log log = LogFactory.getLog((String)EcOrderRepcAutoReceiveImpl.class.getName());

    @Override
    public void autoReceive(DynamicObject[] purOrders, Set<String> completeIds) {
        log.info("EcOrderRepcAutoReceiveImpl.autoReceive:" + completeIds);
        HashSet<Long> complereMalOrderEntryIdSet = new HashSet<Long>();
        DynamicObject[] malOrders = this.loadMalOrders(purOrders, complereMalOrderEntryIdSet, completeIds);
        String errorInfo = (String)DispatchServiceHelper.invokeBizService((String)"repc", (String)"repe", (String)"ICreateReceiveFromMalSevice", (String)"createRepcReceiveFromMalOrder", (Object[])new Object[]{malOrders, Boolean.TRUE, complereMalOrderEntryIdSet});
        if (StringUtils.isNotBlank((CharSequence)errorInfo)) {
            throw new KDBizException(errorInfo);
        }
    }

    private DynamicObject[] loadMalOrders(DynamicObject[] purOrders, Set<Long> complereMalOrderEntryIdSet, Set<String> completeIds) {
        HashSet<Long> malOrderIdSet = new HashSet<Long>(purOrders.length * 2);
        for (DynamicObject purOrderDyn : purOrders) {
            DynamicObjectCollection entryCol = purOrderDyn.getDynamicObjectCollection("materialentry");
            for (DynamicObject entry : entryCol) {
                String malOrderEntryId;
                String malOrderId = entry.getString("srcbillid");
                if (StringUtils.isNotEmpty((CharSequence)malOrderId)) {
                    malOrderIdSet.add(Long.valueOf(malOrderId));
                }
                if (!StringUtils.isNotBlank((CharSequence)(malOrderEntryId = entry.getString("srcentryid"))) || !completeIds.contains(entry.getString("id"))) continue;
                complereMalOrderEntryIdSet.add(Long.valueOf(malOrderEntryId));
            }
        }
        return BusinessDataServiceHelper.load((Object[])malOrderIdSet.toArray(new Long[0]), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"mal_order").getDynamicObjectType());
    }
}

