/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.util.ApiUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.mal.common.service.IEcOrderAutoReceive;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class EcOrderXkAutoReceiveImpl
implements IEcOrderAutoReceive {
    private static final Log log = LogFactory.getLog((String)EcOrderXkAutoReceiveImpl.class.getName());
    private static final String CHECKTYPE_RECEIVE = "1";
    private static final String CHECKTYPE_INWARE = "2";

    @Override
    public void autoReceive(DynamicObject[] purOrders, Set<String> completeIds) {
        Set<DynamicObject> orderToInvare;
        String receiveRes;
        String errMsg;
        log.info("@@autoReceive.completeIds" + completeIds);
        StringBuilder errorMsg = new StringBuilder();
        Map<String, Set<DynamicObject>> orderMap = this.spiltByCheckType(purOrders, completeIds);
        Set<DynamicObject> orderToReceive = orderMap.get(CHECKTYPE_RECEIVE);
        if (orderToReceive != null && !orderToReceive.isEmpty() && StringUtils.isNotEmpty((CharSequence)(errMsg = this.extractErrMsg(receiveRes = this.pushReceive(orderToReceive))))) {
            errorMsg.append(errMsg).append("\r\n");
        }
        if ((orderToInvare = orderMap.get(CHECKTYPE_INWARE)) != null && !orderToInvare.isEmpty()) {
            String inwareRes = this.pushInware(orderToInvare);
            errorMsg.append(this.extractErrMsg(inwareRes));
        }
        if (errorMsg.length() > 0) {
            throw new KDBizException(errorMsg.toString());
        }
    }

    private String extractErrMsg(String receiveRes) {
        if (receiveRes.startsWith("[")) {
            JSONArray resJa = JSONArray.fromObject((Object)receiveRes);
            if (resJa.getJSONObject(0).containsKey((Object)"error")) {
                return resJa.getJSONObject(0).getString("error");
            }
        } else {
            JSONObject resJo = JSONObject.fromObject((Object)receiveRes);
            String[] res = new String[1];
            resJo.forEach((key, value) -> {
                JSONObject valueJo = JSONObject.fromObject((Object)String.valueOf(value));
                if (valueJo.containsKey((Object)"error") && StringUtils.isNotEmpty((CharSequence)valueJo.getString("error"))) {
                    res[0] = valueJo.getString("error");
                }
            });
            return res[0] == null ? "" : res[0];
        }
        return "";
    }

    private String pushInware(Set<DynamicObject> orderToInvare) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        Map<String, Object> billInfoMap = this.getBillInfo(orderToInvare, "insbillstatus");
        billInfoMap.put("billstatus", ParamUtil.getParam((String)"eae607fb000143ac", (String)"insbillstatus"));
        paramMap.put("tobilltype", "inware");
        paramMap.put("action", "toInware");
        paramMap.put("billtype", "pur_outstock");
        paramMap.put("data", billInfoMap);
        paramMap.put("code", "200");
        billInfoMap.put("botpNumber", this.getBotpRule("order", "inware", orderToInvare));
        log.info("@@pushInware.paramMap:" + paramMap);
        return ApiUtil.purSaloutToInware(paramMap);
    }

    private String pushReceive(Set<DynamicObject> orderToReceive) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        Map<String, Object> billInfoMap = this.getBillInfo(orderToReceive, "recbillstatus");
        billInfoMap.put("billstatus", ParamUtil.getParam((String)"eae607fb000143ac", (String)"recbillstatus"));
        paramMap.put("tobilltype", "receive");
        paramMap.put("action", "toReceive");
        paramMap.put("billtype", "pur_outstock");
        paramMap.put("data", billInfoMap);
        paramMap.put("code", "200");
        billInfoMap.put("botpNumber", this.getBotpRule("order", "receive", orderToReceive));
        ApiUtil.putUserNUmberData(paramMap, (String)"mal_order");
        log.info("@@pushReceive.paramMap:" + paramMap);
        return ApiUtil.purSaloutToRec(paramMap);
    }

    private String getBotpRule(String srcBill, String targetBill, Set<DynamicObject> purOrders) {
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        Map<String, Object> billInfoMap = this.getBotpBillInfoMap(purOrders);
        billInfoMap.put("targetBillType", targetBill);
        billInfoMap.put("srctype", srcBill);
        param.put("data", billInfoMap);
        param.put("code", "200");
        log.info("@@getBotpRule.param:" + param);
        String resStr = ApiUtil.botpQuery(param);
        log.info("@@getBotpRule.resStr:" + resStr);
        if (StringUtils.isEmpty((CharSequence)resStr) || "[]".equals(resStr) || !resStr.startsWith("[")) {
            log.warn("\u6ca1\u6709\u67e5\u8be2\u5230\u53ef\u7528\u7684\u8f6c\u6362\u89c4\u5219\u3002");
            return "";
        }
        JSONArray resJa = JSONArray.fromObject((Object)resStr);
        if (resJa.getJSONObject(0).containsKey((Object)"number")) {
            return resJa.getJSONObject(0).getString("number");
        }
        return "";
    }

    private Map<String, Object> getBotpBillInfoMap(Set<DynamicObject> purOrders) {
        HashMap<String, Object> res = new HashMap<String, Object>(16);
        HashSet<String> pobillIdSet = new HashSet<String>(16);
        HashSet<String> poentryIdSet = new HashSet<String>(16);
        for (DynamicObject purOrder : purOrders) {
            DynamicObjectCollection orderEntries = purOrder.getDynamicObjectCollection("materialentry");
            for (DynamicObject entry : orderEntries) {
                String pobillId = entry.getString("pobillid");
                String poentryId = entry.getString("poentryid");
                if (StringUtils.isNotEmpty((CharSequence)pobillId)) {
                    pobillIdSet.add(pobillId);
                }
                if (!StringUtils.isNotEmpty((CharSequence)poentryId)) continue;
                poentryIdSet.add(poentryId);
            }
        }
        res.put("billId", pobillIdSet);
        res.put("entryId", poentryIdSet);
        return res;
    }

    private Map<String, Set<DynamicObject>> spiltByCheckType(DynamicObject[] purOrders, Set<String> completeIds) {
        HashMap<String, Set<DynamicObject>> res = new HashMap<String, Set<DynamicObject>>(16);
        for (DynamicObject purOrder : purOrders) {
            DynamicObjectCollection orderEntries = purOrder.getDynamicObjectCollection("materialentry");
            for (DynamicObject entry : orderEntries) {
                HashSet<DynamicObject> orders;
                String entryId = entry.getString("id");
                String poentryId = entry.getString("poentryid");
                if (!completeIds.contains(entryId) || !StringUtils.isNotBlank((CharSequence)poentryId)) continue;
                String checkType = entry.getString("purtype.checktype");
                if (StringUtils.isEmpty((CharSequence)checkType)) {
                    checkType = CHECKTYPE_RECEIVE;
                }
                if ((orders = (HashSet<DynamicObject>)res.get(checkType)) == null) {
                    orders = new HashSet<DynamicObject>();
                    res.put(checkType, orders);
                }
                orders.add(purOrder);
            }
        }
        return res;
    }

    private Map<String, Object> getBillInfo(Set<DynamicObject> purOrders, String billType) {
        HashMap<String, Object> billInfoMap = new HashMap<String, Object>(32);
        HashSet<String> recOrgIdSet = new HashSet<String>(32);
        HashMap<String, String> orgNumberIdMap = new HashMap<String, String>(32);
        for (DynamicObject dyo : purOrders) {
            DynamicObjectCollection purOrderEntries = dyo.getDynamicObjectCollection("materialentry");
            ArrayList detailMapList = new ArrayList(32);
            String poBillId = "";
            for (DynamicObject entry : purOrderEntries) {
                HashMap<String, Object> detailMap = new HashMap<String, Object>();
                DynamicObject rcvOrgDyn = entry.getDynamicObject("entryrcvorg");
                recOrgIdSet.add(rcvOrgDyn.getString("id"));
                orgNumberIdMap.put(rcvOrgDyn.getString("number"), rcvOrgDyn.getString("id"));
                poBillId = entry.getString("pobillid");
                String poEntryId = entry.getString("poentryid");
                detailMap.put("entryId", poEntryId);
                detailMap.put("qty", entry.getBigDecimal("qty"));
                detailMapList.add(detailMap);
                billInfoMap.put(poBillId, detailMapList);
            }
        }
        Map<String, Object> billStatus1 = this.getParamByRecOrg(billType, recOrgIdSet, orgNumberIdMap);
        billInfoMap.put("billstatus1", billStatus1);
        return billInfoMap;
    }

    private Map<String, Object> getParamByRecOrg(String billType, Set<String> recOrgIdSet, Map<String, String> orgNumberIdMap) {
        HashMap<String, Object> res = new HashMap<String, Object>(16);
        Map paramMap = ParamUtil.getParam((String)"eae607fb000143ac", (String)billType, recOrgIdSet);
        log.info("@@getParamByRecOrg.param:" + paramMap);
        for (Map.Entry<String, String> numberIdEntry : orgNumberIdMap.entrySet()) {
            res.put(numberIdEntry.getKey(), paramMap.get(numberIdEntry.getValue()));
        }
        return res;
    }
}

