/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.service.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.ecapi.entity.GoodsInfo;
import kd.scm.mal.common.service.IGoodsAutoLoadStrategy;

public class SelectByNewStrategy
implements IGoodsAutoLoadStrategy {
    @Override
    public List<GoodsInfo> loadGoods(int limit, String categoryLongNumber) {
        ArrayList<GoodsInfo> goodsInfos = new ArrayList<GoodsInfo>();
        String selectFields = "entryentity.goods.id id,entryentity.goods.number number,entryentity.goods.name name,entryentity.goods.source source,entryentity.goods.shopprice shopprice,entryentity.goods.thumbnail thumbnail,entryentity.goods.supplier.name supplier.name,entryentity.goods.model model,entryentity.goods.centralpurtype centralpurtype,entryentity.goods.category.name category.name,entryentity.goods.category.number category.number";
        QFilter categoryFilter = null;
        if (StringUtils.isNotBlank((CharSequence)categoryLongNumber)) {
            String[] classLevels = categoryLongNumber.split("\\.");
            categoryFilter = classLevels.length == 3 ? new QFilter("entryentity.goods.category.number", "=", (Object)classLevels[2]) : (classLevels.length == 2 ? new QFilter("entryentity.goods.category.parent.number", "=", (Object)classLevels[1]) : new QFilter("entryentity.goods.category.parent.parent.number", "=", (Object)categoryLongNumber));
        }
        QFilter cfmstatusFilter = new QFilter("cfmstatus", "=", (Object)"B");
        QFilter timeFilter = new QFilter("cfmdate", ">=", (Object)this.getTime());
        QFilter mallstatusFilter = new QFilter("entryentity.goods.mallstatus", "=", (Object)"B");
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"pmm_prodaudit", (String)selectFields, (QFilter[])new QFilter[]{cfmstatusFilter, categoryFilter, timeFilter, mallstatusFilter}, (String)"cfmdate desc");){
            Iterator rowIterator = limit != -1 ? ds.limit(0, limit).iterator() : ds.iterator();
            HashSet<String> idSet = new HashSet<String>();
            while (rowIterator.hasNext()) {
                Row row = (Row)rowIterator.next();
                GoodsInfo goodsInfo = new GoodsInfo();
                if (!idSet.add(row.getString("id"))) continue;
                goodsInfo.setProductId(row.getString("id"));
                goodsInfo.setProductName(row.getString("name"));
                goodsInfo.setShopPrice(row.getBigDecimal("shopprice").setScale(2, 4));
                goodsInfo.setProductSource(row.getString("source"));
                goodsInfo.setProductNumber(row.getString("number"));
                goodsInfo.setSupplier(row.getString("supplier.name"));
                goodsInfo.setProductImgPath(row.getString("thumbnail"));
                goodsInfo.setProductModel(row.getString("model"));
                goodsInfo.setCategoryName(row.getString("category.name"));
                goodsInfo.setCategoryNumber(row.getString("category.number"));
                goodsInfo.setProductSource(row.getString("source"));
                goodsInfo.setCentralpurtype(row.getString("centralpurtype"));
                goodsInfos.add(goodsInfo);
            }
            ArrayList<GoodsInfo> arrayList = goodsInfos;
            return arrayList;
        }
    }

    public Date getTime() {
        Calendar ca = Calendar.getInstance();
        ca.setTime(new Date());
        ca.add(5, -7);
        return ca.getTime();
    }
}

