/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.DateUtil;

public class MalApiLogArchivingTask
extends AbstractTask {
    public void execute(RequestContext arg0, Map<String, Object> arg1) throws KDException {
        DynamicObject logSetting = this.getLongSetting();
        if (logSetting == null) {
            return;
        }
        this.handleArchivingData(logSetting);
        this.cleanData(logSetting);
    }

    public void handleArchivingData(DynamicObject logSetting) {
        int setCount = logSetting.getInt("autoarchiveamt") * 10000;
        int totalCount = this.getTotalCount("pbd_apilog");
        if (totalCount <= setCount) {
            return;
        }
        long times = totalCount % 1000 > 0 ? (long)(totalCount / 1000 + 1) : (long)(totalCount / 1000);
        int i = 0;
        while ((long)i < times) {
            this.autoArchiving();
            ++i;
        }
    }

    public void cleanData(DynamicObject logSetting) {
        int dateCount = logSetting.getInt("autocleartime");
        Date endDate = DateUtil.getPreviousSomeMonth((Date)new Date(), (int)dateCount);
        int totalCount = this.getTotalCount("pbd_apilog_back");
        int times = totalCount % 1000 > 0 ? totalCount / 1000 + 1 : totalCount / 1000;
        for (int i = 0; i < times; ++i) {
            this.autoClean(endDate);
        }
    }

    private DynamicObject getLongSetting() {
        String selectList = "id,autoarchiveamt,autocleartime";
        DynamicObject logSetting = QueryServiceHelper.queryOne((String)"pbd_apilogsettings", (String)selectList, (QFilter[])new QFilter[0]);
        return logSetting;
    }

    private int getTotalCount(String entity) {
        String select = "count(*) amt";
        DynamicObjectCollection col = QueryServiceHelper.query((String)entity, (String)select, (QFilter[])new QFilter[0]);
        return ((DynamicObject)col.get(0)).getInt("amt");
    }

    private void autoArchiving() {
        String selectFields = "id,extsysapi.id,systype,createtime,creator.id,status,end_time,params,params_tag,result,result_tag";
        DynamicObjectCollection dyoCol = new DynamicObjectCollection();
        ArrayList pkList = new ArrayList();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"MalApiLogArchivingTask", (String)"pbd_apilog", (String)selectFields, (QFilter[])new QFilter[0], (String)"createtime desc", (int)1000);){
            dataSet.forEach(row -> {
                pkList.add(row.get("id"));
                DynamicObject dyoNew = BusinessDataServiceHelper.newDynamicObject((String)"pbd_apilog_back");
                dyoNew.set("extsysapi_id", row.get("extsysapi.id"));
                dyoNew.set("systype", row.get("systype"));
                dyoNew.set("createtime", row.get("createtime"));
                dyoNew.set("creator_id", row.get("creator.id"));
                dyoNew.set("status", row.get("status"));
                dyoNew.set("end_time", row.get("end_time"));
                dyoNew.set("params", row.get("params"));
                dyoNew.set("params_tag", row.get("params_tag"));
                dyoNew.set("result", row.get("result"));
                dyoNew.set("result_tag", row.get("result_tag"));
                dyoCol.add((Object)dyoNew);
            });
            SaveServiceHelper.save((DynamicObject[])((DynamicObject[])dyoCol.toArray((Object[])new DynamicObject[0])));
            try (TXHandle h = TX.required();){
                try {
                    DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"pbd_apilog"), (Object[])pkList.toArray());
                }
                catch (Throwable e) {
                    h.markRollback();
                }
            }
        }
    }

    public void autoClean(Date endDate) {
        block26: {
            String selectFields = "id";
            QFilter endDateFilter = new QFilter("createtime", "<=", (Object)endDate);
            QFilter[] filters = new QFilter[]{endDateFilter};
            ArrayList pkList = new ArrayList();
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"MalApiLogArchivingTask", (String)"pbd_apilog_back", (String)selectFields, (QFilter[])filters, (String)"createtime ASC");){
                dataSet.forEach(row -> pkList.add(row.get("id")));
                if (pkList.size() <= 0) break block26;
                try (TXHandle h = TX.required();){
                    try {
                        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"pbd_apilog_back"), (Object[])pkList.toArray());
                    }
                    catch (Throwable e) {
                        h.markRollback();
                    }
                }
            }
        }
    }
}

