/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.util;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Label;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.ecapi.entity.GoodsInfo;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.enums.ProductSourceEnum;
import kd.scm.common.helper.apiconnector.api.util.EcApiUtil;
import kd.scm.common.jd.errorcode.JDAPIErrorCode;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.mal.common.info.Category2JsonInfo;
import kd.scm.mal.common.util.MalSearchUtils;
import net.sf.json.JSONArray;

public class MainPageUtils {
    private static final Log log = LogFactory.getLog(MainPageUtils.class);
    public static final String OPEN_TYPE = "opentype";
    private static final int SUBBYTE_LEN = 8;

    public static List<GoodsInfo> getProductByCategory(String category) {
        ArrayList<String> searchList = new ArrayList<String>();
        searchList.add("category");
        return MalSearchUtils.searchFromSelfByKey(category, searchList, null, false, new QFilter[0]);
    }

    public static Map<String, String> getSecondCategoryByFirst(DynamicObject[] col) {
        HashMap<String, String> secondCategoryMap = new HashMap<String, String>();
        for (DynamicObject dyn : col) {
            DynamicObject secondDyn = BusinessDataServiceHelper.loadSingle((String)"pbd_goodsclass", (String)"id,number,name,parent,source", (QFilter[])new QFilter[]{new QFilter("parent", "=", (Object)dyn.getLong("id")), new QFilter("isleaf", "=", (Object)Character.valueOf('0')), new QFilter("enable", "=", (Object)Character.valueOf('1'))});
            if (secondDyn == null) continue;
            secondCategoryMap.put(secondDyn.getString("id"), secondDyn.getString("name"));
        }
        return secondCategoryMap;
    }

    public static Map<String, String> getThirdCategoryBySecond(Map<String, String> secondCateGoryMap) {
        HashMap<String, String> thirdCategoryMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : secondCateGoryMap.entrySet()) {
            DynamicObject thirdDyn = BusinessDataServiceHelper.loadSingle((String)"pbd_goodsclass", (String)"id,number,name,parent,source", (QFilter[])new QFilter[]{new QFilter("parent", "=", (Object)Long.parseLong(entry.getKey())), new QFilter("enable", "=", (Object)Character.valueOf('1'))});
            if (thirdDyn == null) continue;
            thirdCategoryMap.put(thirdDyn.getString("id"), entry.getValue() + "_" + thirdDyn.getString("name"));
        }
        return thirdCategoryMap;
    }

    @Deprecated
    public static void showMainPage(String source, IFormView view, IDataModel model, IPageCache pageCache) {
        Map pageCacheAll;
        HashMap<String, String> pageCacheTempMap = new HashMap<String, String>();
        if (pageCache != null && (pageCacheAll = pageCache.getAll()) != null) {
            pageCacheTempMap.putAll(pageCacheAll);
        }
        long start = System.currentTimeMillis();
        try {
            int i;
            for (int i2 = 0; i2 < 8; ++i2) {
                if (view.getControl("search_entryentity" + i2) == null) continue;
                model.deleteEntryData("search_entryentity" + i2);
            }
            DynamicObject[] col = MainPageUtils.getAvailableCategory(source);
            if (col.length == 1) {
                view.setVisible(Boolean.FALSE, new String[]{"cardflex1"});
            }
            int index = 0;
            StringBuilder logString = new StringBuilder();
            for (i = 0; i < col.length && i < 8; ++i) {
                DynamicObject categoryDyn = col[i];
                List<Object> goodsInfos = new ArrayList();
                if (ProductSourceEnum.PRODUCTSOURCE_SELF.getVal().equals(source)) {
                    String longNumber = categoryDyn.getString("longnumber");
                    ArrayList<String> searchFields = new ArrayList<String>();
                    searchFields.add("catlongnumber");
                    goodsInfos = MalSearchUtils.searchFromSelfByKey(longNumber, searchFields, null, false, 12, new QFilter[0]);
                    model.setValue("category" + index, (Object)(categoryDyn.getString("name") + ";" + categoryDyn.getString("longnumber")));
                } else if (ProductSourceEnum.PRODUCTSOURCE_JD.getVal().equals(source)) {
                    String number = categoryDyn.getString("number");
                    String goodsInfoListStr = (String)pageCacheTempMap.get(number);
                    if (StringUtils.isNotEmpty((CharSequence)goodsInfoListStr)) {
                        goodsInfos = SerializationUtils.fromJsonStringToList((String)goodsInfoListStr, GoodsInfo.class);
                        logString.append(ResManager.loadKDString((String)"\u7f13\u5b58-->jd\u5206\u7c7b\u7f16\u7801", (String)"MainPageUtils_3", (String)"scm-mal-common", (Object[])new Object[0])).append(number).append(":").append(ResManager.loadKDString((String)"\u5206\u7c7b\u5546\u54c1\u6570\u91cf", (String)"MainPageUtils_4", (String)"scm-mal-common", (Object[])new Object[0])).append(goodsInfos.size()).append("\n");
                    } else {
                        goodsInfos = MalSearchUtils.searchFromJDByCategory(number, 1, 12);
                        logString.append(ResManager.loadKDString((String)"jd\u63a5\u53e3-->jd\u5206\u7c7b\u7f16\u7801", (String)"MainPageUtils_5", (String)"scm-mal-common", (Object[])new Object[0])).append(number).append(":").append(ResManager.loadKDString((String)"\u5206\u7c7b\u5546\u54c1\u6570\u91cf", (String)"MainPageUtils_4", (String)"scm-mal-common", (Object[])new Object[0])).append(goodsInfos.size()).append("\n");
                        if (goodsInfos.size() > 0) {
                            pageCacheTempMap.put(number, SerializationUtils.toJsonString(goodsInfos));
                        }
                    }
                    model.setValue("category" + index, (Object)(categoryDyn.getString("name") + ";" + categoryDyn.getString("number")));
                }
                Label label = (Label)view.getControl("category_labelap" + index);
                String cateGoryName = categoryDyn.getString("name");
                if (label != null && cateGoryName != null) {
                    label.setText(cateGoryName.split("_")[0]);
                }
                if (view.getControl("search_entryentity" + index) == null || goodsInfos.size() <= 0) continue;
                view.setVisible(Boolean.TRUE, new String[]{"cardflex" + index, "search_entryentity" + index});
                AbstractFormDataModel modelCus = (AbstractFormDataModel)model;
                MainPageUtils.showCustomCategoryGoodsList(goodsInfos, index + "", view, modelCus);
                ++index;
            }
            if (pageCache != null) {
                pageCache.put(pageCacheTempMap);
            }
            log.info(logString.toString());
            if (index < 8) {
                for (i = index; i < 8; ++i) {
                    view.setVisible(Boolean.FALSE, new String[]{"cardflex" + i});
                }
            }
            log.info("->\u9996\u9875\u5207\u6362\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            if (!(e instanceof KDBizException)) {
                throw new KDException(JDAPIErrorCode.SYS_ERROR, new Object[]{ExceptionUtil.getStackTrace((Throwable)e)});
            }
            for (int i = 0; i < 8; ++i) {
                view.setVisible(Boolean.FALSE, new String[]{"cardflex" + i});
            }
        }
    }

    public static DynamicObject[] getAvailableCategory(String source) {
        String selectFields = "id,number,longnumber,name,parent.id,parent.number,parent.name,level,isleaf,enable,status";
        QFilter sourceFilter = new QFilter("standard", "=", (Object)Long.valueOf(EcApiUtil.getStandard((String)source)));
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter isonhomepageFilter = new QFilter("isonhomepage", "=", (Object)"1");
        DynamicObject[] col = BusinessDataServiceHelper.load((String)"mdr_goodsclass", (String)selectFields, (QFilter[])new QFilter[]{sourceFilter, isonhomepageFilter, enableFilter}, (String)"id");
        return col;
    }

    public static void showCustomCategoryGoodsList(List<GoodsInfo> productList, String index, IFormView view, AbstractFormDataModel model) {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        CardEntry cardEntry = (CardEntry)view.getControl("search_entryentity" + index);
        if (productList.size() > 0) {
            view.setVisible(Boolean.TRUE, new String[]{"cardentryrowap0"});
            view.setVisible(Boolean.FALSE, new String[]{"nodataentryap0"});
            MainPageUtils.isPriceDown(productList);
            for (int i = 0; i < productList.size(); ++i) {
                vs.set("searchgoods_img" + index, (Object)productList.get(i).getProductImgPath(), i);
                vs.set("searchgoods_price" + index, (Object)productList.get(i).getShopPrice(), i);
                vs.set("productgoods_source" + index, (Object)productList.get(i).getProductSource(), i);
                vs.set("searchgoods_name" + index, (Object)(productList.get(i).getProductName() + "\t" + productList.get(i).getProductModel()), i);
                vs.set("searchgoods_pk" + index, (Object)productList.get(i).getProductId(), i);
                vs.set("supplier" + index, (Object)productList.get(i).getSupplier(), i);
                cardEntry.setChildVisible(false, i, new String[]{"pricedown" + index});
                cardEntry.setChildVisible(false, i, new String[]{"qysp" + index});
                if ("1".equals(productList.get(i).getCentralpurtype()) && view.getControl("qysp" + index) != null) {
                    vs.set("qysp" + index, (Object)ResManager.loadKDString((String)"\u7b7e\u7ea6\u5546\u54c1", (String)"MainPageUtils_0", (String)"scm-mal-common", (Object[])new Object[0]), i);
                    cardEntry.setChildVisible(true, i, new String[]{"qysp" + index});
                }
                if (!productList.get(i).isPriceDown()) continue;
                vs.set("pricedown" + index, (Object)ResManager.loadKDString((String)"\u964d\u4ef7", (String)"MainPageUtils_1", (String)"scm-mal-common", (Object[])new Object[0]), i);
                cardEntry.setChildVisible(true, i, new String[]{"pricedown" + index});
            }
        } else {
            view.setVisible(Boolean.TRUE, new String[]{"nodataentryap0"});
            view.setVisible(Boolean.FALSE, new String[]{"cardentryrowap0"});
            vs.set("searchgoods_pk" + index, (Object)"0", 0);
            vs.set("nodata_img0", (Object)(RequestContext.get().getClientFullContextPath() + "public/img/e7b3e1d2.no_data_rows.png"), 0);
        }
        if ("search_entryentity" + index != null) {
            model.batchCreateNewEntryRow("search_entryentity" + index, vs);
        }
        model.clearNoDataRow();
    }

    public static void setLabelVisible(boolean vi, int index, String key, IFormView view) {
        HashMap<String, Serializable> fieldMap = new HashMap<String, Serializable>();
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("qysp" + index);
        keys.add("pricedown" + index);
        fieldMap.put("k", keys);
        fieldMap.put("r", Integer.valueOf(0));
        fieldMap.put("vi", Boolean.valueOf(vi));
        view.updateControlMetadata(key, fieldMap);
    }

    public static boolean isPriceDown(String goodId) {
        Iterator iterator;
        QFilter statusFilter;
        QFilter goodIdFilter;
        String selectFields = "entryentity.shopprice_old,entryentity.shopprice,auditdate";
        QFilter dateFilter = new QFilter("auditdate", ">=", (Object)DateUtil.getDateByOffsetDay((Date)TimeServiceHelper.now(), (int)-7));
        QFilter[] filters = new QFilter[]{dateFilter, goodIdFilter = new QFilter("entryentity.goods", "=", (Object)Long.valueOf(goodId)), statusFilter = new QFilter("cfmstatus", "=", (Object)"B")};
        DynamicObjectCollection dyn = QueryServiceHelper.query((String)"pmm_priceaudit", (String)selectFields, (QFilter[])filters, (String)"auditdate desc");
        if (dyn.size() > 0 && (iterator = dyn.iterator()).hasNext()) {
            BigDecimal shoppriceold;
            DynamicObject dynamicObject = (DynamicObject)iterator.next();
            BigDecimal shopprice = dynamicObject.getBigDecimal("entryentity.shopprice");
            return shopprice.compareTo(shoppriceold = dynamicObject.getBigDecimal("entryentity.shopprice_old")) < 0;
        }
        return false;
    }

    public static void isPriceDown(List<GoodsInfo> productList) {
        String selectFields = "entryentity.goods.id,entryentity.shopprice_old,entryentity.shopprice,auditdate";
        QFilter dateFilter = new QFilter("auditdate", ">=", (Object)DateUtil.getDateByOffsetDay((Date)TimeServiceHelper.now(), (int)-7));
        ArrayList<Long> goodsIds = new ArrayList<Long>(productList.size());
        for (GoodsInfo goodsInfo : productList) {
            goodsIds.add(Long.valueOf(goodsInfo.getProductId()));
        }
        QFilter goodIdFilter = new QFilter("entryentity.goods", "in", goodsIds);
        QFilter statusFilter = new QFilter("cfmstatus", "=", (Object)"B");
        QFilter[] filters = new QFilter[]{dateFilter, goodIdFilter, statusFilter};
        DynamicObjectCollection dynCol = QueryServiceHelper.query((String)"pmm_priceaudit", (String)selectFields, (QFilter[])filters, (String)"auditdate desc");
        block1: for (GoodsInfo good : productList) {
            String productId = good.getProductId();
            for (int i = 0; i < dynCol.size(); ++i) {
                BigDecimal shoppriceold;
                DynamicObject dyn = (DynamicObject)dynCol.get(i);
                String id = dyn.getString("entryentity.goods.id");
                if (!productId.equals(id)) continue;
                BigDecimal shopprice = dyn.getBigDecimal("entryentity.shopprice");
                if (shopprice.compareTo(shoppriceold = dyn.getBigDecimal("entryentity.shopprice_old")) >= 0) continue block1;
                good.setPriceDown(true);
                continue block1;
            }
        }
    }

    public static long getDayIn() {
        return 7L;
    }

    public static void jumpToCart(IFormView view, ShowType showType) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("mal_shopcart");
        showParameter.setAppId("mal");
        showParameter.setCustomParam(OPEN_TYPE, (Object)showType);
        showParameter.getOpenStyle().setShowType(showType);
        view.showForm(showParameter);
    }

    public static ShowType getShowType(FormShowParameter fsp) {
        if (fsp.getCustomParam(OPEN_TYPE) != null) {
            return ShowType.valueOf((String)((String)fsp.getCustomParam(OPEN_TYPE)));
        }
        return ShowType.MainNewTabPage;
    }

    public static ShowType getShowType(IPageCache pageCache) {
        if (StringUtils.isNotBlank((CharSequence)pageCache.get(OPEN_TYPE))) {
            return ShowType.forValue((int)Integer.parseInt(pageCache.get(OPEN_TYPE)));
        }
        return ShowType.MainNewTabPage;
    }

    public static void showDetailPage(IFormView view, String productId, String source, String caption, ShowType showType) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("mal_productdetail");
        showParameter.getOpenStyle().setShowType(showType);
        HashMap<String, Object> detailParamMap = new HashMap<String, Object>();
        detailParamMap.put(OPEN_TYPE, showType);
        if (ProductSourceEnum.PRODUCTSOURCE_SELF.getName().equals(source) || ProductSourceEnum.PRODUCTSOURCE_SELF.getVal().equals(source)) {
            DynamicObject productDyn = BusinessDataServiceHelper.loadSingle((Object)productId, (String)"pbd_goods");
            detailParamMap.put("productDyn", SerializationUtils.toJsonString((Object)productDyn));
        }
        if (ProductSourceEnum.PRODUCTSOURCE_JD.getName().equals(source) || ProductSourceEnum.PRODUCTSOURCE_JD.getVal().equals(source)) {
            detailParamMap.put("productJdSku", productId);
        }
        showParameter.setCustomParams(detailParamMap);
        if (caption.length() > 6) {
            caption = caption.substring(0, 6);
        }
        showParameter.setCaption(caption);
        view.showForm(showParameter);
    }

    public static void showNewDetailPage(IFormView view, String productId, String source, String caption, ShowType showType) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("mal_newproductdetail");
        showParameter.getOpenStyle().setShowType(showType);
        HashMap<String, Object> detailParamMap = new HashMap<String, Object>();
        detailParamMap.put(OPEN_TYPE, showType);
        if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(source)) {
            detailParamMap.put("productSelfId", productId);
        } else {
            detailParamMap.put("productJdSku", productId);
            detailParamMap.put("productsource", source);
        }
        showParameter.setCustomParams(detailParamMap);
        if (caption.length() > 6) {
            caption = caption.substring(0, 6);
        }
        showParameter.setCaption(caption);
        view.showForm(showParameter);
    }

    public static void jumpToOrder(IFormView view, ShowType showType) {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("mal_order");
        parameter.setCustomParam(OPEN_TYPE, (Object)showType);
        parameter.setAppId("mal");
        parameter.getOpenStyle().setShowType(showType);
        view.showForm((FormShowParameter)parameter);
    }

    public static ProductSourceEnum getDefaultMal() {
        String appId = "UUPIH+47DAK";
        String defaultmal = ParamUtil.getParam((String)appId, (String)"defaultmal");
        return "".equals(defaultmal) ? ProductSourceEnum.PRODUCTSOURCE_SELF : ProductSourceEnum.fromVal((String)defaultmal);
    }

    public static JSONArray getCategory(String source) {
        return MainPageUtils.getCategory(source, 8);
    }

    public static JSONArray getCategory(String source, int byteLen) {
        long start = System.currentTimeMillis();
        ArrayList fistCategoryList = new ArrayList();
        HashMap categoryMap = new HashMap();
        String selectFields = "id,number,longnumber,name,parent.id,parent.number,parent.name,level,isleaf,enable,status";
        QFilter filter = new QFilter("standard", "=", (Object)Long.valueOf(EcApiUtil.getStandard((String)source)));
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        boolean selfColumnShow = false;
        if ("1".equals(source)) {
            String isselfshowalways = ParamUtil.getSysCtrlParam((String)"UUPIH+47DAK", (String)"isselfshowalways");
            selfColumnShow = !"1".equals(isselfshowalways);
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)MainPageUtils.class.getName(), (String)"mdr_goodsclass", (String)selectFields, (QFilter[])new QFilter[]{filter, enableFilter}, null);){
            ds.forEach(row -> {
                Category2JsonInfo node = new Category2JsonInfo();
                String nodeID = row.getString("id");
                node.setLongNumber(row.getString("longnumber"));
                node.setName(row.getString("name"));
                node.setId(nodeID);
                node.setLevel(row.getInteger("level"));
                node.setNumber(row.getString("number"));
                String parentid = row.getString("parent.id");
                if (node.getLevel() == 1) {
                    fistCategoryList.add(node);
                } else {
                    node.setParentid(parentid);
                }
                categoryMap.put(nodeID, node);
            });
        }
        catch (Exception e) {
            log.warn(ExceptionUtil.getStackTrace((Throwable)e));
        }
        for (Map.Entry entry : categoryMap.entrySet()) {
            Category2JsonInfo node = (Category2JsonInfo)entry.getValue();
            Category2JsonInfo parentNode = (Category2JsonInfo)categoryMap.get(node.getParentid());
            if (parentNode == null) continue;
            List<Category2JsonInfo> children = parentNode.getChildren();
            if (children == null) {
                children = new ArrayList<Category2JsonInfo>();
            }
            children.add(node);
            parentNode.setChildren(children);
        }
        ArrayList resArr = new ArrayList();
        ArrayList resItem = new ArrayList();
        if (!fistCategoryList.isEmpty()) {
            resItem.add(fistCategoryList.get(0));
        }
        int index = 0;
        int firstLen = selfColumnShow ? 0 : 2;
        for (int i = 1; i < fistCategoryList.size(); ++i) {
            Category2JsonInfo jo = (Category2JsonInfo)fistCategoryList.get(i);
            if (index < firstLen) {
                resItem.add(jo);
                ++index;
                continue;
            }
            index = 0;
            resArr.add(resItem);
            resItem = new ArrayList();
            resItem.add(jo);
        }
        if (!resItem.isEmpty()) {
            resArr.add(resItem);
        }
        JSONArray resJa = JSONArray.fromObject(resArr);
        log.info("@@getCategory cost:" + (System.currentTimeMillis() - start));
        return resJa;
    }

    public static String bSubstring(String s, int length) throws Exception {
        int i;
        byte[] bytes = s.getBytes("Unicode");
        int n = 0;
        for (i = 2; i < bytes.length && n < length; ++i) {
            if (i % 2 == 1) {
                ++n;
                continue;
            }
            if (bytes[i] == 0) continue;
            ++n;
        }
        if (i % 2 == 1) {
            i = bytes[i - 1] != 0 ? --i : ++i;
        }
        return new String(bytes, 0, i, "Unicode");
    }

    public static boolean isInsider() {
        DynamicObject userDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)"id,fullpinyin,usertypes,usertypes.category", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)RequestContext.get().getCurrUserId())});
        if (userDyn == null) {
            log.warn(MainPageUtils.class.getName() + ":current user is not exsit.");
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0d\u5b58\u5728\u3002", (String)"MainPageUtils_2", (String)"scm-mal-common", (Object[])new Object[0]));
        }
        DynamicObjectCollection userTpyeDynCol = userDyn.getDynamicObjectCollection("usertypes");
        for (DynamicObject userTpyeDyn : userTpyeDynCol) {
            if (!"1".equals(userTpyeDyn.getDynamicObject("fbasedataid").getString("category"))) continue;
            return true;
        }
        return false;
    }
}

