/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.util;

import java.util.Collection;
import java.util.HashSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.ecapi.jd.JdApiUtil;
import net.sf.json.JSONObject;

public class MalAddressUtil {
    private static final Log log = LogFactory.getLog((String)"MalAddressUtil");
    public static final String DEFAULTJDADRNUM = "19_1607_3155_62118";
    public static final char PARTITION = '_';

    public static DynamicObject getDefaultAddress() {
        String userId = String.valueOf(RequestContext.get().getCurrUserId());
        return MalAddressUtil.getAddress(userId);
    }

    public static DynamicObject getAddress(String userId) {
        QFilter typeQfilter;
        QFilter defaultQfilter;
        if (StringUtils.isEmpty((CharSequence)userId) || StringUtils.equals((CharSequence)"null", (CharSequence)userId)) {
            return null;
        }
        QFilter userIdQfilter = new QFilter("creator", "=", (Object)Long.parseLong(userId));
        QFilter[] qFilters = new QFilter[]{userIdQfilter, defaultQfilter = new QFilter("default", "=", (Object)Character.valueOf('1')), typeQfilter = new QFilter("type", "=", (Object)Character.valueOf('A'))};
        return MalAddressUtil.queryAddress(qFilters);
    }

    public static DynamicObject getAddressByWholeAddress(String wholeAddress) {
        QFilter[] qFilters = new QFilter[2];
        QFilter wholeaddressFilter = new QFilter("wholeaddress", "=", (Object)wholeAddress);
        QFilter userFilter = new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId());
        qFilters[0] = wholeaddressFilter;
        qFilters[1] = userFilter;
        return MalAddressUtil.queryAddress(qFilters);
    }

    public static DynamicObject getAdmindivisionById(String addressId) {
        if (StringUtils.isEmpty((CharSequence)addressId) || StringUtils.equals((CharSequence)"null", (CharSequence)addressId)) {
            return null;
        }
        QFilter filter = new QFilter("id", "=", (Object)Long.parseLong(addressId));
        QFilter[] filters = new QFilter[]{filter};
        String selectFields = "id,number,name,fullname,level,country";
        return QueryServiceHelper.queryOne((String)"bd_admindivision", (String)selectFields, (QFilter[])filters);
    }

    public static Long getDefaultAdmindivisionId() {
        DynamicObject addressDyn = MalAddressUtil.getDefaultAddress();
        if (addressDyn != null) {
            return addressDyn.getLong("address");
        }
        return 0L;
    }

    public static DynamicObject queryAddressById(Long addressId) {
        QFilter filter = new QFilter("id", "=", (Object)addressId);
        QFilter[] filters = new QFilter[]{filter};
        return MalAddressUtil.queryAddress(filters);
    }

    public static DynamicObjectCollection batchGetAdmindivisionById(Collection<String> addressIds) {
        HashSet addrIds = new HashSet((int)((double)addressIds.size() / 0.75));
        addressIds.forEach(id -> addrIds.add(Long.valueOf(id)));
        QFilter filter = new QFilter("id", "in", addrIds);
        QFilter[] filters = new QFilter[]{filter};
        String selectFields = "id,number,name,fullname";
        return QueryServiceHelper.query((String)"bd_admindivision", (String)selectFields, (QFilter[])filters);
    }

    public static DynamicObject getReceiptAddressDynByAddressNumber(String number) {
        QFilter addressNumberFilter = new QFilter("address", "=", (Object)number);
        QFilter[] filters = new QFilter[]{addressNumberFilter};
        return MalAddressUtil.queryAddress(filters);
    }

    public static DynamicObject queryAddress(QFilter[] filters) {
        String selectFields = "id,name,phone,address,wholeaddress,mapaddress,jdaddressnum,email,postalcode,type";
        return QueryServiceHelper.queryOne((String)"mal_address", (String)selectFields, (QFilter[])filters);
    }

    public static String getWholeAddress(String admindivisionId, String detailAddress) {
        DynamicObject admindivisionDyn = MalAddressUtil.getAdmindivisionById(admindivisionId);
        if (StringUtils.isEmpty((CharSequence)admindivisionId) || admindivisionDyn == null) {
            return detailAddress;
        }
        String fullName = admindivisionDyn.getString("fullname");
        String[] admindivisions = fullName.split(String.valueOf('_'));
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < admindivisions.length; ++i) {
            sb.append(admindivisions[i]);
        }
        sb.append(detailAddress);
        return sb.toString();
    }

    public static long getAddressIdByFullname(String fullname) {
        long adrId = 0L;
        QFilter filter = new QFilter("fullname", "=", (Object)fullname);
        QFilter[] filters = new QFilter[]{filter};
        String selectFields = "id";
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"bd_admindivision", (String)selectFields, (QFilter[])filters);
        if (dyn != null) {
            adrId = dyn.getLong("id");
        }
        return adrId;
    }

    public static boolean validateJdAddress(String addressName, String addressNum) {
        String jdAdrNum = MalAddressUtil.getJdAdrNumFromApi(addressName, true);
        if (MalAddressUtil.isMunicipality(addressName)) {
            String[] strs = jdAdrNum.split("_");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < strs.length; ++i) {
                if (i >= 2) continue;
                sb.append(strs[i]).append('_');
            }
            jdAdrNum = sb.delete(sb.length() - 1, sb.length()).toString();
        }
        return addressNum.contains(jdAdrNum);
    }

    public static boolean isMunicipality(String addressName) {
        if (addressName == null) {
            return false;
        }
        String regex = ResManager.loadKDString((String)".*(\u91cd\u5e86|\u5317\u4eac|\u4e0a\u6d77|\u5929\u6d25).*", (String)"MalAddressUtil_1", (String)"scm-mal-common", (Object[])new Object[0]);
        return addressName.matches(regex);
    }

    public static void validateJdOrderAddress(String admindivisionId, String addressNum) {
        DynamicObject admindivisionDyn = MalAddressUtil.getAdmindivisionById(admindivisionId);
        if (admindivisionDyn != null && !MalAddressUtil.validateJdAddress(admindivisionDyn.getString("fullname"), addressNum)) {
            log.error("@@\u63d0\u4ea4\u8ba2\u5355\u65f6\u6821\u9a8c\u5730\u5740\u5931\u8d25\uff1a" + admindivisionId + "|" + addressNum);
            throw new KDBizException(ResManager.loadKDString((String)"\u4eac\u4e1c\u5730\u5740\u6821\u9a8c\u5b58\u5728\u95ee\u9898\uff0c\u8bf7\u68c0\u67e5\u6536\u8d27\u5730\u5740\u5e76\u8865\u5145\u5b8c\u6574\uff0c\u53ef\u5c1d\u8bd5\u91cd\u65b0\u4fdd\u5b58\u6536\u8d27\u5730\u5740\u89e3\u51b3\u95ee\u9898\u3002", (String)"MalAddressUtil_0", (String)"scm-mal-common", (Object[])new Object[0]));
        }
    }

    public static String getJdAdrNumFromApi(String address, boolean isThird) {
        JSONObject jdAdr = JSONObject.fromObject((Object)JdApiUtil.getAddressJonString((String)address));
        StringBuilder sb = new StringBuilder();
        sb.append(jdAdr.getString("provinceId")).append('_').append(jdAdr.getString("cityId")).append('_').append(jdAdr.getString("countyId"));
        if (!isThird) {
            sb.append('_');
            if ("null".equals(jdAdr.getString("townId"))) {
                sb.append('0');
            } else {
                sb.append(jdAdr.getString("townId"));
            }
        }
        return sb.toString();
    }
}

