/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.util;

import java.util.HashSet;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class MalAuthorityUtils {
    private static Log log = LogFactory.getLog(MalAuthorityUtils.class);

    public static QFilter getMalOrderViewAuthorityFilter(String userId, String orgMark, String entityName) {
        DynamicObjectCollection data;
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)RequestContext.get().getCurrUserId(), (String)"mal", (String)entityName, (String)"47150e89000000ac");
        if (hasPermOrgResult.hasAllOrgPerm()) {
            return null;
        }
        boolean orgRule = false;
        boolean creatorRule = false;
        boolean allRule = false;
        QFilter userQFilter = new QFilter("creator", "=", (Object)Long.parseLong(userId));
        DynamicObjectCollection bizpersons = MalAuthorityUtils.getBizPartners(new String[]{"billcreator"}, "mal_bizperson", userId);
        HashSet<Long> billcreatores = new HashSet<Long>();
        if (bizpersons != null) {
            for (DynamicObject bizperson : bizpersons) {
                String prodclass = bizperson.getString("billcreator");
                if ("0".equals(prodclass)) continue;
                billcreatores.add(Long.valueOf(prodclass));
            }
        }
        if (null == (data = QueryServiceHelper.query((String)"mal_bizperson", (String)"creatorcontrol,orgcontrol", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)Long.parseLong(userId)).and(new QFilter("status", "=", (Object)"C")).and(new QFilter("enable", "=", (Object)"1"))})) || data.size() == 0) {
            return userQFilter;
        }
        List userOrgs = hasPermOrgResult.getHasPermOrgs();
        for (DynamicObject rule : data) {
            boolean creatorcontrol = (Boolean)rule.get("creatorcontrol");
            boolean orgcontrol = (Boolean)rule.get("orgcontrol");
            if (creatorcontrol) {
                creatorRule = true;
                continue;
            }
            if (!creatorcontrol && orgcontrol) {
                orgRule = true;
                continue;
            }
            if (creatorcontrol || orgcontrol) continue;
            allRule = true;
        }
        if (allRule) {
            return userQFilter.or(new QFilter(orgMark, "in", (Object)userOrgs)).or(new QFilter("creator", "in", billcreatores));
        }
        if (orgRule) {
            return userQFilter.or(new QFilter("creator", "in", billcreatores)).or(new QFilter(orgMark, "in", (Object)userOrgs));
        }
        if (creatorRule) {
            return userQFilter.or(new QFilter("creator", "in", billcreatores));
        }
        return userQFilter;
    }

    public static final DynamicObjectCollection getBizPartners(String[] selects, String entityName, String userId) {
        StringBuilder selectFields = new StringBuilder();
        for (String select : selects) {
            selectFields.append(select).append(".fbasedataid.id").append(' ').append(select).append(',');
        }
        DynamicObjectCollection bizperson = null;
        if (selectFields.length() > 0) {
            selectFields.delete(selectFields.length() - 1, selectFields.length());
            bizperson = QueryServiceHelper.query((String)entityName, (String)selectFields.toString(), (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)Long.parseLong(userId)).and(new QFilter("status", "=", (Object)"C")).and(new QFilter("enable", "=", (Object)"1"))});
        }
        return bizperson;
    }
}

