/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scm.common.enums.OrgTypeEnum;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.OrgUtil;
import kd.scm.mal.common.org.MalOrgServiceFactory;

public class MalBizFowUtil {
    private static Log log = LogFactory.getLog(MalBizFowUtil.class);

    public static void setCenterBalance(DynamicObject data) {
        DynamicObject purOrg = (DynamicObject)data.get("org");
        DynamicObject pursettleOrg = (DynamicObject)data.get("settleorg");
        DynamicObjectCollection entryCol = data.getDynamicObjectCollection("materialentry");
        DynamicObject invOrg = (DynamicObject)((DynamicObject)entryCol.get(0)).get("entryrcvorg");
        long purToSetOrgId = 0L;
        long invToSettOrgId = 0L;
        log.info("@@@\u96c6\u4e2d\u7ed3\u7b97\u903b\u8f91\u5904\u7406\u5f00\u59cb\uff1a");
        boolean hasRelation = MalOrgServiceFactory.hasDelegantRalation();
        if (null != purOrg) {
            if (hasRelation) {
                List purTSetIdList = OrgUtil.getToOrg((String)OrgTypeEnum.PURCHASE.getVal(), (String)OrgTypeEnum.ACCOUNTING.getVal(), (Long)purOrg.getLong("id"));
                if (purTSetIdList.size() > 0) {
                    purToSetOrgId = (Long)purTSetIdList.get(0);
                }
            } else {
                Map mpCompany = OrgUnitServiceHelper.getCompanyByOrg((Long)purOrg.getLong("id"), (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
                if (!mpCompany.isEmpty()) {
                    purToSetOrgId = Long.parseLong(mpCompany.get("id").toString());
                }
            }
            log.info("@@@\u96c6\u4e2d\u7ed3\u7b97\u903b\u8f91\u91c7\u8d2d\u7ec4\u7ec7\u59d4\u6258\u7684\u6838\u7b97\u7ec4\u7ec7\uff1a" + purToSetOrgId);
        }
        if (null != invOrg) {
            if (hasRelation) {
                List invToSettIdList = OrgUtil.getToOrg((String)OrgTypeEnum.INVENTORY.getVal(), (String)OrgTypeEnum.ACCOUNTING.getVal(), (Long)invOrg.getLong("id"));
                if (invToSettIdList.size() > 0) {
                    invToSettOrgId = (Long)invToSettIdList.get(0);
                }
            } else {
                Map poCompany = OrgUnitServiceHelper.getCompanyByOrg((Long)invOrg.getLong("id"), (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
                if (!poCompany.isEmpty()) {
                    invToSettOrgId = Long.parseLong(poCompany.get("id").toString());
                }
            }
            log.info("@@@\u96c6\u4e2d\u7ed3\u7b97\u903b\u8f91\u5e93\u5b58\u7ec4\u7ec7\u59d4\u6258\u7684\u6838\u7b97\u7ec4\u7ec7\uff1a" + invToSettOrgId);
        }
        if (purToSetOrgId == invToSettOrgId) {
            data.set("centersettle", (Object)"0");
        } else {
            if (pursettleOrg.getLong("id") == purToSetOrgId) {
                data.set("centersettle", (Object)"1");
            }
            if (pursettleOrg.getLong("id") == invToSettOrgId) {
                data.set("centersettle", (Object)"0");
            }
        }
        log.info("@@@\u96c6\u4e2d\u7ed3\u7b97\u503c\uff1a" + data.getString("centersettle"));
    }

    public static Set<Long> getSupplierIdSet(List<DynamicObject> targetData) {
        HashSet<Long> supplierIdSet = new HashSet<Long>();
        if (null != targetData && targetData.size() > 0) {
            for (DynamicObject dyo : targetData) {
                supplierIdSet.add(dyo.getLong("supplier.id"));
            }
        }
        return supplierIdSet;
    }

    public static Map<Long, Object> getBizPartner(Set<Long> supplierIdSet) {
        HashMap<Long, Object> bizPartnerMap = new HashMap<Long, Object>(supplierIdSet.size());
        QFilter filter = new QFilter("id", "in", supplierIdSet);
        DynamicObjectCollection dyoCol = QueryServiceHelper.query((String)"bd_supplier", (String)"id,bizpartner", (QFilter[])new QFilter[]{filter});
        if (null != dyoCol && dyoCol.size() > 0) {
            for (DynamicObject dyo : dyoCol) {
                bizPartnerMap.put(dyo.getLong("id"), dyo.getLong("bizpartner"));
            }
        }
        return bizPartnerMap;
    }

    public static OperationResult doSaveOperation(String entity, List<DynamicObject> targetData, OperateOption option) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entity);
        OperationResult opResult = OperationServiceHelper.executeOperate((String)"save", (String)entity, (DynamicObject[])targetData.toArray(new DynamicObject[0]), (OperateOption)option);
        if (null != opResult && !opResult.isSuccess()) {
            String err = ExceptionUtil.getErrorInfoDetails((List)opResult.getAllErrorOrValidateInfo());
            log.error("@@@doSaveOperation\u6267\u884c\u4fdd\u5b58\u64cd\u4f5c\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + err);
            throw new KDBizException(new ErrorCode("operation error", MessageFormat.format(ResManager.loadKDString((String)"{0}\u6267\u884c\u4fdd\u5b58\u64cd\u4f5c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458,\u5f02\u5e38\u539f\u56e0\uff1a{1}\u3002", (String)"MalBizFowUtil_0", (String)"scm-mal-common", (Object[])new Object[0]), mainType.getName(), opResult.getMessage() + err)), new Object[0]);
        }
        return opResult;
    }

    public static OperationResult doOperation(String entity, String opKey, Object[] ids, OperateOption option, boolean needRollBack, boolean useOperation) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entity);
        OperationResult opResult = OperationServiceHelper.executeOperate((String)opKey, (String)entity, (Object[])ids, (OperateOption)option);
        if (null != opResult && !opResult.isSuccess()) {
            if (needRollBack) {
                MalBizFowUtil.rollBackOrder(ids, entity, useOperation, option);
            }
            String err = ExceptionUtil.getErrorInfoDetails((List)opResult.getAllErrorOrValidateInfo());
            log.error("@@@doOperation\u6267\u884c\u64cd\u4f5c\uff1a" + opKey + "\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + err);
            throw new KDBizException(new ErrorCode("operation error", MessageFormat.format(ResManager.loadKDString((String)"{0}\u6267\u884c{1}\u64cd\u4f5c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458,\u5f02\u5e38\u539f\u56e0\uff1a{2}\u3002", (String)"MalBizFowUtil_1", (String)"scm-mal-common", (Object[])new Object[0]), mainType.getName(), opKey, opResult.getMessage() + err)), new Object[0]);
        }
        return opResult;
    }

    public static void rollBackOrder(Object[] ids, String entity, boolean useOperation, OperateOption option) {
        if (ObjectUtils.isEmpty((Object[])ids)) {
            return;
        }
        QFilter pkFilter = new QFilter("id", "in", (Object)ids);
        try (TXHandle h = TX.requiresNew();){
            if (useOperation) {
                OperationServiceHelper.executeOperate((String)"delete", (String)entity, (Object[])ids, (OperateOption)option);
            } else {
                DeleteServiceHelper.delete((String)entity, (QFilter[])new QFilter[]{pkFilter});
            }
            DeleteServiceHelper.delete((String)"botp_billtracker", (QFilter[])new QFilter[]{new QFilter("tbillid", "in", (Object)ids)});
        }
        catch (Exception e) {
            log.error("@@@rollBackPurOrder:\u56de\u6eda\u5f02\u5e38\uff0c\u5f02\u5e38\u7684\u5355\u636eID\uff1a" + Arrays.toString(ids) + "\n" + ExceptionUtil.getStackTrace((Throwable)e));
        }
    }

    public static OperateOption createDefaultOpiton() {
        OperateOption option = OperateOption.create();
        option.setVariableValue("isStrict", String.valueOf(false));
        option.setVariableValue("ishasright", String.valueOf(true));
        option.setVariableValue("WF", String.valueOf(false));
        option.setVariableValue("ignoreValidation", String.valueOf(true));
        return option;
    }

    public static List<DynamicObject> getPushTargetDataList(DynamicObjectCollection billColl, String srcEntity, String targetEntity) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(srcEntity);
        pushArgs.setTargetEntityNumber(targetEntity);
        pushArgs.setBuildConvReport(true);
        ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>();
        for (DynamicObject billData : billColl) {
            ListSelectedRow row = new ListSelectedRow((Object)billData.getLong("id"));
            row.setEntryEntityKey("entryentity");
            row.setEntryPrimaryKeyValue((Object)billData.getLong("entryentity"));
            selectedRowList.add(row);
        }
        pushArgs.setSelectedRows(selectedRowList);
        return MalBizFowUtil.push(pushArgs);
    }

    public static List<DynamicObject> getPushWithParamsTargetDataList(DynamicObjectCollection billColl, String srcEntity, String targetEntity, Map<String, String> customParams, List<String> splitType, String primaryKey, String entryEntityKey, String entryPrimaryKey, Map<String, Map<String, Object>> wrapPropertyMap) {
        HashMap<String, ArrayList<ListSelectedRow>> rowsMap = new HashMap<String, ArrayList<ListSelectedRow>>();
        ArrayList<DynamicObject> targetDataList = new ArrayList<DynamicObject>();
        for (DynamicObject billData : billColl) {
            String splitTypeId = MalBizFowUtil.getSplitType(billData, splitType);
            ListSelectedRow row = new ListSelectedRow((Object)billData.getLong(primaryKey));
            ArrayList<ListSelectedRow> listSelectedRows = (ArrayList<ListSelectedRow>)rowsMap.get(splitTypeId);
            row.setEntryEntityKey(entryEntityKey);
            row.setEntryPrimaryKeyValue((Object)billData.getLong(entryPrimaryKey));
            if (listSelectedRows != null) {
                listSelectedRows.add(row);
                continue;
            }
            listSelectedRows = new ArrayList<ListSelectedRow>();
            listSelectedRows.add(row);
            rowsMap.put(splitTypeId, listSelectedRows);
        }
        Set entrySet = rowsMap.entrySet();
        for (Map.Entry next : entrySet) {
            List value = (List)next.getValue();
            if (value == null || value.size() == 0) continue;
            PushArgs pushArgs = new PushArgs();
            pushArgs.setSourceEntityNumber(srcEntity);
            pushArgs.setTargetEntityNumber(targetEntity);
            pushArgs.setBuildConvReport(true);
            pushArgs.setSelectedRows(value);
            if (customParams != null) {
                pushArgs.getCustomParams().putAll(customParams);
            }
            if (wrapPropertyMap != null) {
                pushArgs.getCustomParams().put("data", SerializationUtils.toJsonString(wrapPropertyMap.get(next.getKey())));
            }
            List<DynamicObject> targetData = MalBizFowUtil.push(pushArgs);
            targetDataList.addAll(targetData);
        }
        return targetDataList;
    }

    public static List<DynamicObject> pushBySrcIdMap(String ruleId, String srcEntity, Map<Long, Set<Long>> srcIdMap, String srcEntryEntityKey, String targetEntity) {
        if (srcIdMap == null || srcIdMap.isEmpty()) {
            return new ArrayList<DynamicObject>();
        }
        PushArgs pushArgs = new PushArgs();
        if (StringUtils.isNotEmpty((CharSequence)ruleId)) {
            pushArgs.setRuleId(ruleId);
        }
        pushArgs.setSourceEntityNumber(srcEntity);
        pushArgs.setTargetEntityNumber(targetEntity);
        pushArgs.setBuildConvReport(true);
        ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>();
        for (Map.Entry<Long, Set<Long>> entry : srcIdMap.entrySet()) {
            Set<Long> srcEntryIdSet = entry.getValue();
            for (Long srcEntryId : srcEntryIdSet) {
                ListSelectedRow row = new ListSelectedRow((Object)entry.getKey());
                row.setEntryEntityKey(srcEntryEntityKey);
                row.setEntryPrimaryKeyValue((Object)srcEntryId);
                selectedRowList.add(row);
            }
        }
        pushArgs.setSelectedRows(selectedRowList);
        return MalBizFowUtil.push(pushArgs);
    }

    private static List<DynamicObject> push(PushArgs pushArgs) {
        ConvertOperationResult result;
        try {
            result = ConvertServiceHelper.push((PushArgs)pushArgs);
        }
        catch (Exception e) {
            throw new KDException(new ErrorCode("push error", ResManager.loadKDString((String)"\u4e0b\u63a8\u53d1\u751f\u4e86\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u6267\u884c\u3002", (String)"MalBizFowUtil_2", (String)"scm-mal-common", (Object[])new Object[0])), new Object[]{e.getMessage()});
        }
        if (result == null || !result.isSuccess()) {
            throw new KDBizException(new ErrorCode("push error", MessageFormat.format(ResManager.loadKDString((String)"\u4e0b\u63a8\u53d1\u751f\u4e86\u9519\u8bef\uff0c\u9519\u8bef\u539f\u56e0\uff1a{0},\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MalBizFowUtil_3", (String)"scm-mal-common", (Object[])new Object[0]), result != null ? ExceptionUtil.getBillPushReportsErrorMsg((ConvertOperationResult)result) : "result is null")), new Object[0]);
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)result.getTargetEntityNumber());
        return result.loadTargetDataObjects(BusinessDataServiceHelper::loadRefence, mainType);
    }

    public static void setBizTypeByPurtype(List<DynamicObject> dyoCol) {
        if (CollectionUtils.isEmpty(dyoCol)) {
            return;
        }
        HashMap<Long, Set> purTypeMap = new HashMap<Long, Set>(dyoCol.size());
        for (DynamicObject dyo : dyoCol) {
            Set purTypeSet = purTypeMap.computeIfAbsent(dyo.getLong("id"), s -> new HashSet());
            for (DynamicObject entry : dyo.getDynamicObjectCollection("entryentity")) {
                DynamicObject purtype = entry.getDynamicObject("purtype");
                if (Objects.isNull(purtype)) continue;
                if (!Objects.isNull(purtype.getDynamicObject("linetype"))) {
                    entry.set("linetype", (Object)purtype.getDynamicObject("linetype"));
                }
                purTypeSet.add(purtype.getString("number"));
            }
        }
        for (DynamicObject dyo : dyoCol) {
            Long pkId = dyo.getLong("id");
            Set purtypeSet = (Set)purTypeMap.get(pkId);
            if (!Objects.isNull(dyo.getDynamicObject("businesstype"))) continue;
            if (CollectionUtils.isEmpty((Collection)purtypeSet) || purtypeSet.size() > 1) {
                dyo.set("businesstype_id", (Object)422857170485263360L);
                continue;
            }
            if (StringUtils.equals((CharSequence)purtypeSet.toArray(new String[0])[0], (CharSequence)"PUR02_SYS")) {
                dyo.set("businesstype_id", (Object)422860896797212672L);
                continue;
            }
            if (StringUtils.equals((CharSequence)purtypeSet.toArray(new String[0])[0], (CharSequence)"PUR04_SYS")) {
                dyo.set("businesstype_id", (Object)744833764588533760L);
                continue;
            }
            dyo.set("businesstype_id", (Object)422857170485263360L);
        }
    }

    public static String getSplitType(DynamicObject bill, List<String> splitType) {
        StringBuilder stringBuilder = new StringBuilder();
        if (splitType == null || splitType.size() == 0) {
            splitType = new ArrayList<String>();
            splitType.add("id");
        }
        for (String split : splitType) {
            String s = bill.getString(split);
            stringBuilder.append(s).append("|");
        }
        return stringBuilder.toString();
    }

    public static String getPcAppId(String pcEntityKey) {
        String entityId = MetadataDao.getIdByNumber((String)pcEntityKey, (MetaCategory)MetaCategory.Entity);
        String appid = MetadataDao.getAppIdByFormId((String)entityId);
        if (StringUtils.isEmpty((CharSequence)appid)) {
            String errMsg = String.format(ResManager.loadKDString((String)"PC\u7aef\u5b9e\u4f53\u201c%s\u201d\u5339\u914d\u7684\u5e94\u7528\u5185\u7801\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MalBizFowUtil_4", (String)"scm-mal-common", (Object[])new Object[0]), pcEntityKey);
            throw new KDBizException(errMsg);
        }
        return appid;
    }

    public static Long getMainTableId(String className, String entityName) {
        Long mainTableId = 0L;
        Object[] parameters = new SqlParameter[2];
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("SELECT FId, FEntityKey, FTableId ");
        sBuilder.append("FROM T_META_EntityInfo ");
        sBuilder.append("WHERE FId = ? and FEntityKey = ? ");
        parameters[0] = new SqlParameter(":FId", 12, (Object)entityName);
        parameters[1] = new SqlParameter(":FEntityKey", 12, (Object)entityName);
        try (DataSet dataSet = DB.queryDataSet((String)className, (DBRoute)DBRoute.meta, (String)sBuilder.toString(), (Object[])parameters);){
            if (dataSet != null && !dataSet.isEmpty()) {
                for (Row row : dataSet) {
                    mainTableId = row.getLong("FTableId");
                }
            }
        }
        return mainTableId;
    }

    public static BFRowLinkDownNode getBFRowLinkDownNode(Long sourceEntityMainTableId, Long sourceId, Long targetEnetityMainTableId, List<Long> targetIdList) {
        BFRowLinkDownNode bfRowLinkDownNode = new BFRowLinkDownNode();
        BFRowId sourceBFRowId = new BFRowId();
        sourceBFRowId.setMainTableId(sourceEntityMainTableId);
        sourceBFRowId.setTableId(sourceEntityMainTableId);
        sourceBFRowId.setBillId(sourceId);
        sourceBFRowId.setEntryId(sourceId);
        bfRowLinkDownNode.setRowId(sourceBFRowId);
        HashMap<BFRowId, BFRowLinkDownNode> targetTNodes = new HashMap<BFRowId, BFRowLinkDownNode>();
        for (Long targetId : targetIdList) {
            BFRowId targetBFRowId = new BFRowId();
            BFRowLinkDownNode targetBFRowLinkDownNode = new BFRowLinkDownNode();
            targetBFRowId.setMainTableId(targetEnetityMainTableId);
            targetBFRowId.setTableId(targetEnetityMainTableId);
            targetBFRowId.setBillId(targetId);
            targetBFRowId.setEntryId(targetId);
            targetBFRowLinkDownNode.setRowId(targetBFRowId);
            targetTNodes.put(targetBFRowId, targetBFRowLinkDownNode);
        }
        bfRowLinkDownNode.setTNodes(targetTNodes);
        return bfRowLinkDownNode;
    }
}

