/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.MalFeeHandleHelper;

@Deprecated
public class MalFeeNewHandleHelper {
    private static final String BD_ADMINDIVISION = "bd_admindivision";
    private static String CACHEPREFIX = "mal_fee_";

    private static Map<String, String> getCacheHolder() {
        return MalFeeHandleHelper.getCacheHolder();
    }

    public static String getAddressLongNum(String addressId) {
        String longNum = "";
        QFilter idfilter = new QFilter("id", "=", (Object)Long.valueOf(addressId));
        DynamicObject address = QueryServiceHelper.queryOne((String)BD_ADMINDIVISION, (String)"id,longnumber", (QFilter[])new QFilter[]{idfilter});
        longNum = address.getString("longnumber");
        return longNum;
    }

    public static void calculateSelfSupplierFee(DynamicObject bill, String addressId, int supplierIndex, String supplierId) {
        MalFeeNewHandleHelper.preHandleData(bill, false, supplierIndex, supplierId);
        MalFeeNewHandleHelper.calExtendFee(bill, supplierIndex);
        MalFeeNewHandleHelper.calAvgFreight(bill, addressId, supplierIndex, supplierId);
        MalFeeNewHandleHelper.handleTaxAmount(bill.getDynamicObjectCollection("entryentity" + supplierIndex), true, supplierIndex);
        bill.set("subtotalamount" + supplierIndex, (Object)bill.getBigDecimal("totalextamount" + supplierIndex).add(bill.getBigDecimal("totalgoodsamt" + supplierIndex).add(bill.getBigDecimal("freight" + supplierIndex))));
    }

    public static void calculateSupplierFee(DynamicObject bill, String addressId, int supplierIndex, String supplierId, BigDecimal freight) {
        MalFeeNewHandleHelper.calAvgFreight(bill, supplierIndex, supplierId);
        bill.set("freight" + supplierIndex, (Object)freight);
        MalFeeNewHandleHelper.handleTaxAmount(bill.getDynamicObjectCollection("entryentity" + supplierIndex), false, supplierIndex);
        BigDecimal totalGoodsAmt = BigDecimal.ZERO;
        DynamicObjectCollection dyoCol = bill.getDynamicObjectCollection("entryentity" + supplierIndex);
        for (DynamicObject dyo : dyoCol) {
            totalGoodsAmt = totalGoodsAmt.add(dyo.getBigDecimal("goodprice" + supplierIndex).multiply(dyo.getBigDecimal("qty" + supplierIndex)));
        }
        bill.set("totalgoodsamt" + supplierIndex, (Object)totalGoodsAmt);
        bill.set("subtotalamount" + supplierIndex, (Object)bill.getBigDecimal("totalgoodsamt" + supplierIndex).add(freight));
    }

    public static void calExtendFee(DynamicObject bill, int supplierIndex) {
        int pricePrecision = ((DynamicObject)bill.get("curr")).getInt("priceprecision");
        String goodsId = "";
        BigDecimal goodPrice = BigDecimal.ZERO;
        BigDecimal taxPrice = BigDecimal.ZERO;
        BigDecimal extAmount = BigDecimal.ZERO;
        BigDecimal maxAmount = BigDecimal.ZERO;
        BigDecimal perAmount = BigDecimal.ZERO;
        BigDecimal qty = BigDecimal.ZERO;
        BigDecimal totalExtAmount = BigDecimal.ZERO;
        BigDecimal rowTotalExtAmount = BigDecimal.ZERO;
        BigDecimal totalGoodsAmt = BigDecimal.ZERO;
        DynamicObjectCollection dyoCol = bill.getDynamicObjectCollection("entryentity" + supplierIndex);
        for (DynamicObject dyo : dyoCol) {
            goodsId = dyo.getString("goods" + supplierIndex);
            goodPrice = dyo.getBigDecimal("goodprice" + supplierIndex);
            qty = dyo.getBigDecimal("qty" + supplierIndex);
            totalGoodsAmt = totalGoodsAmt.add(goodPrice.multiply(qty));
            taxPrice = goodPrice;
            rowTotalExtAmount = BigDecimal.ZERO;
            String extFeeCacheIds = MalFeeNewHandleHelper.getCacheHolder().get(CACHEPREFIX + goodsId);
            if (StringUtils.equalsIgnoreCase((CharSequence)extFeeCacheIds, (CharSequence)"NOEXTFEE")) {
                dyo.set("extamount" + supplierIndex, (Object)extAmount);
                dyo.set("taxprice" + supplierIndex, (Object)taxPrice);
            } else {
                for (String key : extFeeCacheIds.split(",")) {
                    extAmount = BigDecimal.ZERO;
                    String feeAmount = MalFeeNewHandleHelper.getCacheHolder().get(key);
                    if (null != feeAmount) {
                        perAmount = CommonUtil.getBigDecimalPro((Object)feeAmount.split("_")[0]);
                        maxAmount = CommonUtil.getBigDecimalPro((Object)feeAmount.split("_")[1]);
                    }
                    if (qty.multiply(perAmount).compareTo(maxAmount) <= 0) {
                        taxPrice = taxPrice.add(perAmount);
                        extAmount = extAmount.add(perAmount.multiply(qty));
                    } else {
                        extAmount = maxAmount;
                        taxPrice = goodPrice.add(maxAmount.divide(qty, RoundingMode.HALF_UP)).setScale(pricePrecision, RoundingMode.HALF_UP);
                    }
                    rowTotalExtAmount = rowTotalExtAmount.add(extAmount);
                }
            }
            dyo.set("extamount" + supplierIndex, (Object)rowTotalExtAmount);
            dyo.set("taxprice" + supplierIndex, (Object)taxPrice);
            totalExtAmount = totalExtAmount.add(rowTotalExtAmount);
        }
        bill.set("totalextamount" + supplierIndex, (Object)totalExtAmount);
        bill.set("totalgoodsamt" + supplierIndex, (Object)totalGoodsAmt);
    }

    public static void calAvgFreight(DynamicObject bill, String addressId, int count, String supplierId) {
        String addressLongNum = MalFeeNewHandleHelper.getAddressLongNum(addressId);
        ProductInfo supGroup = MalFeeNewHandleHelper.getSupGroup(bill.getDynamicObjectCollection("entryentity" + count), BigDecimal.ZERO, true, count, supplierId);
        MalFeeNewHandleHelper.setProdInfoSupFreight(addressLongNum, supGroup, supplierId);
        MalFeeNewHandleHelper.handleAvgFreight4Entry(supGroup, bill, true, count);
    }

    public static BigDecimal getOrderTotalAmount(DynamicObject bill, int count, String supplierId) {
        ProductInfo supGroup = MalFeeNewHandleHelper.getSupGroup(bill.getDynamicObjectCollection("entryentity" + count), BigDecimal.ZERO, true, count, supplierId);
        return supGroup.getTotalAmount();
    }

    public static void calAvgFreight(DynamicObject bill, int supplierIndex, String supplierId) {
        ProductInfo supGroup = MalFeeNewHandleHelper.getSupGroup(bill.getDynamicObjectCollection("entryentity" + supplierIndex), BigDecimal.ZERO, false, supplierIndex, supplierId);
        MalFeeNewHandleHelper.handleAvgFreight4Entry(supGroup, bill, true, supplierIndex);
    }

    private static void handleTaxAmount(DynamicObjectCollection dyoCol, boolean isContainsExt, int count) {
        BigDecimal taxAmount = BigDecimal.ZERO;
        for (DynamicObject dyo : dyoCol) {
            taxAmount = isContainsExt ? dyo.getBigDecimal("goodamount" + count).add(dyo.getBigDecimal("extamount" + count)).add(dyo.getBigDecimal("avgfreight" + count)) : dyo.getBigDecimal("goodamount" + count).add(dyo.getBigDecimal("avgfreight" + count));
            dyo.set("taxamount" + count, (Object)taxAmount);
        }
    }

    public static ProductInfo getSupGroup(DynamicObjectCollection dyoCol, BigDecimal freight, boolean isContainsExt, int supplierIndex, String supplierId) {
        String goodsId = "";
        HashMap<String, EntryInfo> map = null;
        map = new HashMap<String, EntryInfo>();
        for (DynamicObject dyo : dyoCol) {
            goodsId = dyo.getString("goods" + supplierIndex);
            map.put(goodsId, new EntryInfo(goodsId, dyo.getBigDecimal("qty" + supplierIndex), dyo.getBigDecimal("goodprice" + supplierIndex), isContainsExt ? dyo.getBigDecimal("taxprice" + supplierIndex) : dyo.getBigDecimal("goodprice" + supplierIndex), BigDecimal.ZERO, isContainsExt ? dyo.getBigDecimal("extamount" + supplierIndex) : BigDecimal.ZERO, dyo.getBigDecimal("goodamount" + supplierIndex)));
        }
        return new ProductInfo(supplierId, freight, BigDecimal.ZERO, map);
    }

    public static Map<String, List<String>> getSupGoodsGroupMap(DynamicObjectCollection dyoCol, int supplierIndex, String supplierId) {
        HashMap<String, List<String>> resultMap = new HashMap<String, List<String>>(2);
        ArrayList<String> goodsList = new ArrayList<String>();
        String goodsNum = "";
        for (DynamicObject dyo : dyoCol) {
            goodsNum = dyo.getString("goodsnum" + supplierIndex);
            goodsList.add(goodsNum);
        }
        resultMap.put(supplierId, goodsList);
        return resultMap;
    }

    public static void handleAvgFreight4Entry(ProductInfo supGroup, DynamicObject bill, boolean isContainsExt, int count) {
        int pricePrecision = ((DynamicObject)bill.get("curr")).getInt("priceprecision");
        int amtPrecision = ((DynamicObject)bill.get("curr")).getInt("amtprecision");
        BigDecimal totalSupFreight = BigDecimal.ZERO;
        BigDecimal rowTaxAmount = BigDecimal.ZERO;
        BigDecimal rowFreight = BigDecimal.ZERO;
        BigDecimal taxPrice = BigDecimal.ZERO;
        BigDecimal totalSupAmount = BigDecimal.ZERO;
        BigDecimal totalFreight = BigDecimal.ZERO;
        BigDecimal leftFreight = BigDecimal.ZERO;
        Map<String, EntryInfo> entryMap = null;
        HashMap<String, EntryInfo> allEntryMap = new HashMap<String, EntryInfo>();
        BigDecimal freight = BigDecimal.ZERO;
        totalSupFreight = supGroup.getTotalFreight();
        totalSupAmount = supGroup.getTotalAmount();
        leftFreight = totalSupFreight;
        entryMap = supGroup.getEntryList();
        int i = 0;
        for (Map.Entry<String, EntryInfo> goodsIdMap : entryMap.entrySet()) {
            rowTaxAmount = goodsIdMap.getValue().getTaxAmount();
            if (++i < entryMap.size()) {
                rowFreight = totalSupFreight.multiply(rowTaxAmount).divide(totalSupAmount, RoundingMode.HALF_UP).setScale(amtPrecision, RoundingMode.HALF_UP);
                leftFreight = leftFreight.subtract(rowFreight);
            } else {
                rowFreight = leftFreight;
            }
            taxPrice = goodsIdMap.getValue().getTaxprice().add(rowFreight.divide(goodsIdMap.getValue().getQty(), RoundingMode.HALF_UP)).setScale(pricePrecision, RoundingMode.HALF_UP);
            goodsIdMap.getValue().setAvgfreight(rowFreight);
            goodsIdMap.getValue().setTaxprice(taxPrice);
        }
        allEntryMap.putAll(entryMap);
        totalFreight = totalFreight.add(totalSupFreight);
        String goodsId = "";
        DynamicObjectCollection dyoCol = bill.getDynamicObjectCollection("entryentity" + count);
        for (DynamicObject dyo : dyoCol) {
            goodsId = dyo.getString("goods" + count);
            dyo.set("avgfreight" + count, (Object)((EntryInfo)allEntryMap.get(goodsId)).getAvgfreight());
            dyo.set("taxprice" + count, (Object)((EntryInfo)allEntryMap.get(goodsId)).getTaxprice());
        }
        freight = totalFreight;
        bill.set("freight" + count, (Object)freight);
    }

    public static void setProdInfoSupFreight(String addressLongNum, ProductInfo supGroup, String supplierId) {
        Map freightInfoMap = null;
        String result = MalFeeNewHandleHelper.getCacheHolder().get(CACHEPREFIX + supplierId);
        if (StringUtils.isNotBlank((CharSequence)result)) {
            freightInfoMap = (Map)SerializationUtils.fromJsonString((String)MalFeeNewHandleHelper.getCacheHolder().get(CACHEPREFIX + supplierId), Map.class);
        }
        MalFeeNewHandleHelper.setTotalFreight(freightInfoMap, supGroup, addressLongNum);
    }

    public static BigDecimal getFreightFree(String addressId, String supplierId) {
        String freightMsg;
        Map freightInfoMap = null;
        String result = MalFeeNewHandleHelper.getCacheHolder().get(CACHEPREFIX + supplierId);
        String addressLongNum = MalFeeNewHandleHelper.getAddressLongNum(addressId);
        if (StringUtils.isNotBlank((CharSequence)result)) {
            freightInfoMap = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
        }
        BigDecimal freightFree = null;
        freightFree = null == freightInfoMap || freightInfoMap.isEmpty() ? BigDecimal.ZERO : (StringUtils.isNotBlank((CharSequence)(freightMsg = MalFeeNewHandleHelper.getFinalFreight(addressLongNum, freightInfoMap))) ? CommonUtil.getBigDecimalPro((Object)freightMsg.split("_")[0]) : BigDecimal.ZERO);
        return freightFree;
    }

    private static void setTotalFreight(Map<String, String> freightInfoMap, ProductInfo info, String addressLongNum) {
        if (null == freightInfoMap || freightInfoMap.isEmpty()) {
            info.setTotalFreight(BigDecimal.ZERO);
        } else {
            String freightMsg = MalFeeNewHandleHelper.getFinalFreight(addressLongNum, freightInfoMap);
            if (StringUtils.isNotBlank((CharSequence)freightMsg)) {
                if (CommonUtil.getBigDecimalPro((Object)freightMsg.split("_")[0]).compareTo(info.getTotalAmount()) > 0) {
                    info.setTotalFreight(CommonUtil.getBigDecimalPro((Object)freightMsg.split("_")[1]));
                } else {
                    info.setTotalFreight(BigDecimal.ZERO);
                }
            } else if (StringUtils.equals((CharSequence)"true", (CharSequence)freightInfoMap.get("isNational"))) {
                freightMsg = freightInfoMap.get("basefreight");
                info.setTotalFreight(CommonUtil.getBigDecimalPro((Object)freightMsg.split("_")[1]));
            } else {
                info.setTotalFreight(BigDecimal.ZERO);
            }
        }
    }

    public static String getFinalFreight(String addressLongNum, Map<String, String> freightInfoMap) {
        String freightMsg = "";
        for (Map.Entry<String, String> longNumMap : freightInfoMap.entrySet()) {
            if (StringUtils.equals((CharSequence)"basefreight", (CharSequence)longNumMap.getKey()) || StringUtils.equals((CharSequence)"isNational", (CharSequence)longNumMap.getKey())) continue;
            String[] longNumS = longNumMap.getKey().split(",");
            if (StringUtils.contains((CharSequence)longNumMap.getKey(), (CharSequence)".")) {
                for (String splitNum : longNumS) {
                    if (!addressLongNum.contains(splitNum)) continue;
                    freightMsg = longNumMap.getValue();
                    break;
                }
            }
            if (!StringUtils.isBlank((CharSequence)freightMsg) || StringUtils.contains((CharSequence)longNumMap.getKey(), (CharSequence)".")) continue;
            for (String splitNum : longNumS) {
                if (!addressLongNum.contains(splitNum)) continue;
                freightMsg = longNumMap.getValue();
            }
        }
        return freightMsg;
    }

    public static void preHandleData(DynamicObject bill, boolean isForceCahce, int supplierIndex, String supplierId) {
        DynamicObjectCollection dyoCol = bill.getDynamicObjectCollection("entryentity" + supplierIndex);
        ArrayList<String> goodsIdList = new ArrayList<String>();
        HashSet<String> supplierIdSet = new HashSet<String>();
        String goodsId = "";
        for (DynamicObject dyo : dyoCol) {
            goodsId = dyo.getString("goods" + supplierIndex);
            if (StringUtils.isBlank((CharSequence)MalFeeNewHandleHelper.getCacheHolder().get(CACHEPREFIX + goodsId))) {
                goodsIdList.add(goodsId);
            }
            if (!StringUtils.isBlank((CharSequence)MalFeeNewHandleHelper.getCacheHolder().get(CACHEPREFIX + supplierId)) && !isForceCahce) continue;
            supplierIdSet.add(supplierId);
        }
        if (goodsIdList.size() > 0) {
            MalFeeNewHandleHelper.cacheExtFee(goodsIdList);
        }
        if (supplierIdSet.size() > 0) {
            MalFeeNewHandleHelper.cacheFreight(supplierIdSet);
        }
    }

    public static void cacheExtFee(List<String> goodsIdList) {
        Map<String, Object> resultMap = MalFeeNewHandleHelper.getExtendFeeMap(goodsIdList);
        Map goodsFeeMap = (Map)resultMap.get("goodsFeeMap");
        Set feeIdSet = (Set)resultMap.get("feeIdSet");
        MalFeeNewHandleHelper.updateCacheExtFee(feeIdSet);
        for (Map.Entry goodsIdMap : goodsFeeMap.entrySet()) {
            if (StringUtils.isBlank((CharSequence)((CharSequence)goodsIdMap.getValue()))) {
                MalFeeNewHandleHelper.getCacheHolder().put(CACHEPREFIX + (String)goodsIdMap.getKey(), "NOEXTFEE");
                continue;
            }
            MalFeeNewHandleHelper.getCacheHolder().put(CACHEPREFIX + (String)goodsIdMap.getKey(), CACHEPREFIX + ((String)goodsIdMap.getValue()).replaceAll(",", "," + CACHEPREFIX));
        }
    }

    public static void updateCacheExtFee(Set<String> feeIdSet) {
        HashSet<Long> feeIds = new HashSet<Long>(feeIdSet.size());
        for (String feeId : feeIdSet) {
            feeIds.add(Long.valueOf(feeId));
        }
        String extFeeFields = "id,cost,maxcost";
        QFilter extFeeFilter = new QFilter("id", "in", feeIds);
        DynamicObjectCollection feeDyoCol = QueryServiceHelper.query((String)"ent_surcharge", (String)extFeeFields, (QFilter[])new QFilter[]{extFeeFilter});
        if (null != feeDyoCol && feeDyoCol.size() > 0) {
            String cacheKey = "";
            String cacheValue = "";
            for (DynamicObject dyo : feeDyoCol) {
                cacheKey = CACHEPREFIX + dyo.getString("id");
                cacheValue = dyo.getString("cost") + "_" + dyo.getString("maxcost");
                MalFeeNewHandleHelper.getCacheHolder().put(cacheKey, cacheValue);
            }
        }
    }

    public static void cacheFreight(Set<String> supplierIdSet) {
        String cacheKey = "";
        String cacheValue = "";
        String supplierId = "";
        HashMap<String, String> freightMap = null;
        HashSet<Long> suppliers = new HashSet<Long>(supplierIdSet.size());
        for (String supplier : supplierIdSet) {
            suppliers.add(Long.valueOf(supplier));
        }
        String freightFields = "supplier.id,national,basefreight,entryentity.longnumber,entryentity.price,entryentity.freight";
        QFilter freightFilter = new QFilter("supplier", "in", suppliers);
        DynamicObject[] freightDyoCol = BusinessDataServiceHelper.load((String)"ent_freightscheme", (String)freightFields, (QFilter[])new QFilter[]{freightFilter}, (String)"entryentity.longnumber desc");
        if (null != freightDyoCol && freightDyoCol.length > 0) {
            for (DynamicObject dyo : freightDyoCol) {
                supplierId = dyo.getString("supplier.id");
                DynamicObjectCollection entryCol = dyo.getDynamicObjectCollection("entryentity");
                freightMap = new HashMap<String, String>();
                for (DynamicObject entryDyo : entryCol) {
                    String longNum = entryDyo.getString("longnumber");
                    if (!StringUtils.isNotBlank((CharSequence)longNum)) continue;
                    freightMap.put(longNum, entryDyo.getString("price") + "_" + entryDyo.getString("freight"));
                }
                freightMap.put("basefreight", "0.00_" + dyo.getString("basefreight"));
                freightMap.put("isNational", dyo.getString("national"));
                cacheKey = CACHEPREFIX + supplierId;
                cacheValue = SerializationUtils.toJsonString(freightMap);
                MalFeeNewHandleHelper.getCacheHolder().put(cacheKey, cacheValue);
            }
        }
    }

    private static Map<String, Object> getExtendFeeMap(List<String> goodsIdList) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        HashMap<String, String> goodsFeeMap = new HashMap<String, String>();
        HashSet<String> feeIdSet = new HashSet<String>();
        ArrayList<Long> goods = new ArrayList<Long>(goodsIdList.size());
        for (String good : goodsIdList) {
            goods.add(Long.valueOf(good));
        }
        QFilter filter = new QFilter("id", "in", goods);
        String selectFields = "id,surchargeid";
        DynamicObjectCollection goodDyoCol = QueryServiceHelper.query((String)"pbd_goods", (String)selectFields, (QFilter[])new QFilter[]{filter});
        String extenFeeIds = "";
        String goodsId = "";
        if (null != goodDyoCol && goodDyoCol.size() > 0) {
            for (DynamicObject dyo : goodDyoCol) {
                goodsId = dyo.getString("id");
                extenFeeIds = dyo.getString("surchargeid");
                goodsFeeMap.put(goodsId, extenFeeIds);
                if (StringUtils.isBlank((CharSequence)extenFeeIds)) continue;
                for (String feeId : extenFeeIds.split(",")) {
                    feeIdSet.add(feeId);
                }
            }
            resultMap.put("feeIdSet", feeIdSet);
            resultMap.put("goodsFeeMap", goodsFeeMap);
        }
        return resultMap;
    }

    static class EntryInfo {
        private String goods;
        private BigDecimal qty;
        private BigDecimal goodprice;
        private BigDecimal taxprice;
        private BigDecimal avgfreight;
        private BigDecimal extamount;
        private BigDecimal taxAmount;

        public EntryInfo(String goods, BigDecimal qty, BigDecimal goodprice, BigDecimal taxprice, BigDecimal avgfreight, BigDecimal extamount, BigDecimal taxAmount) {
            this.goods = goods;
            this.qty = qty;
            this.goodprice = goodprice;
            this.taxprice = taxprice;
            this.avgfreight = avgfreight;
            this.extamount = extamount;
            this.taxAmount = taxAmount;
        }

        public String getGoods() {
            return this.goods;
        }

        public void setGoods(String goods) {
            this.goods = goods;
        }

        public BigDecimal getQty() {
            return this.qty;
        }

        public void setQty(BigDecimal qty) {
            this.qty = qty;
        }

        public BigDecimal getGoodprice() {
            return this.goodprice;
        }

        public void setGoodprice(BigDecimal goodprice) {
            this.goodprice = goodprice;
        }

        public BigDecimal getTaxprice() {
            return this.taxprice;
        }

        public void setTaxprice(BigDecimal taxprice) {
            this.taxprice = taxprice;
        }

        public BigDecimal getAvgfreight() {
            return this.avgfreight;
        }

        public void setAvgfreight(BigDecimal avgfreight) {
            this.avgfreight = avgfreight;
        }

        public BigDecimal getExtamount() {
            return this.extamount;
        }

        public void setExtamount(BigDecimal extamount) {
            this.extamount = extamount;
        }

        public BigDecimal getTaxAmount() {
            return this.taxAmount;
        }

        public void setTaxAmount(BigDecimal taxAmount) {
            this.taxAmount = taxAmount;
        }

        public String toString() {
            return "EntryInfo [goods=" + this.goods + ", qty=" + this.qty + ", goodprice=" + this.goodprice + ", taxprice=" + this.taxprice + ", avgfreight=" + this.avgfreight + ", extamount=" + this.extamount + ", taxAmount=" + this.taxAmount + "]";
        }
    }

    static class ProductInfo {
        private String supplier;
        private BigDecimal totalFreight;
        private BigDecimal totalAmount;
        private Map<String, EntryInfo> entryList;

        public ProductInfo(String supplier, BigDecimal totalFreight, BigDecimal totalAmount, Map<String, EntryInfo> entryList) {
            this.supplier = supplier;
            this.entryList = entryList;
            this.totalFreight = totalFreight;
            this.totalAmount = totalAmount;
            this.calSupTotalAmount();
        }

        private void calSupTotalAmount() {
            if (this.entryList != null) {
                for (Map.Entry<String, EntryInfo> map : this.entryList.entrySet()) {
                    this.totalAmount = this.totalAmount.add(map.getValue().getTaxAmount());
                }
            }
        }

        public String getSupplier() {
            return this.supplier;
        }

        public void setSupplier(String supplier) {
            this.supplier = supplier;
        }

        public BigDecimal getTotalFreight() {
            return this.totalFreight;
        }

        public void setTotalFreight(BigDecimal totalFreight) {
            this.totalFreight = totalFreight;
        }

        public BigDecimal getTotalAmount() {
            return this.totalAmount;
        }

        public void setTotalAmount(BigDecimal totalAmount) {
            this.totalAmount = totalAmount;
        }

        public Map<String, EntryInfo> getEntryList() {
            return this.entryList;
        }

        public void setEntryList(Map<String, EntryInfo> entryList) {
            this.entryList = entryList;
        }
    }
}

