/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ecapi.entity.GoodsInfo;
import kd.scm.common.ecapi.entity.PriceInfo;
import kd.scm.common.ecapi.jd.JDAccessTokenUtil;
import kd.scm.common.ecapi.jd.JdApiUtil;
import kd.scm.common.ecapi.jd.JdProdUtil;
import kd.scm.common.ecapi.jd.entity.JdPictureInfo;
import kd.scm.common.ecapi.jd.entity.JdStockInfo;
import kd.scm.common.enums.MalStatusEnum;
import kd.scm.common.enums.ProductSourceEnum;
import kd.scm.common.util.MalOrderUtil;
import net.sf.json.JSONObject;

public class MalJdProductUtil {
    private static Log log = LogFactory.getLog(MalJdProductUtil.class);
    private static final String IMGPREFIX = "http://img13.360buyimg.com/n1/";
    private static final String JDSUPPLER = "486095512240421888";
    private static Map<String, String> cacheMap = new HashMap<String, String>();

    public static String getAccessToken() {
        String enterpriseId = RequestContext.getOrCreate().getTenantId();
        String token = JDAccessTokenUtil.getAccessTokenByKD((String)enterpriseId);
        return token;
    }

    public static String getProdDetailJson(String sku, int num, String token) {
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("sku", sku);
        params.put("queryExts", "isJDLogistics");
        String detailStr = JdApiUtil.getJdApiResponse((String)"/api/product/getDetail", params, null).getResponseData();
        return detailStr;
    }

    public static void setJdProductInfoPrice(List<GoodsInfo> jdProductList, Map<String, PriceInfo> priceMap) {
        for (int i = 0; i < jdProductList.size(); ++i) {
            String sku = jdProductList.get(i).getProductId();
            PriceInfo priceInfo = priceMap.get(sku);
            if (priceInfo != null) {
                jdProductList.get(i).setShopPrice(priceInfo.getShowprice());
                continue;
            }
            jdProductList.get(i).setShopPrice(BigDecimal.ZERO.setScale(2));
        }
    }

    public static GoodsInfo getJdProductInfo(JSONObject sku) {
        return JdProdUtil.getJdProductInfo((JSONObject)sku);
    }

    public static String getCatNameFromJDapi(String catId) {
        return JdProdUtil.getCatNameFromJDapi((String)catId);
    }

    public static GoodsInfo getJdProdInfo4Detail(String detail) {
        JSONObject node = JSONObject.fromObject((Object)detail);
        if (!node.isNullObject() && node.getBoolean("success")) {
            JSONObject sku = node.getJSONObject("result");
            PriceInfo price = JdApiUtil.getJdPriceBySku((String)sku.getString("sku"));
            String area = "19_1607_3155";
            JdStockInfo stockInfo = JdApiUtil.getJdStockBySku((String)sku.getString("sku"), (String)area);
            MalJdProductUtil.getJdGoodsInfo(sku, price, stockInfo);
        }
        return new GoodsInfo();
    }

    private static void getJdGoodsInfo(JSONObject skuJo, PriceInfo price, JdStockInfo stockInfo) {
        GoodsInfo jdProInfo = new GoodsInfo();
        jdProInfo.setProductId(skuJo.getString("sku"));
        jdProInfo.setProductImgPath(IMGPREFIX + skuJo.getString("imagePath"));
        jdProInfo.setProductName(skuJo.getString("name"));
        jdProInfo.setProductSource(ProductSourceEnum.PRODUCTSOURCE_JD.getVal());
        jdProInfo.setProductDesc(stockInfo.getDesc());
        jdProInfo.setProductModel("");
        jdProInfo.setRemark(skuJo.getString("sku"));
        jdProInfo.setSupplier(JDSUPPLER);
        String jdUnit = MalOrderUtil.getJDUnit();
        if (null != jdUnit) {
            jdProInfo.setProductUnitID(jdUnit);
        } else {
            jdProInfo.setProductUnitID("11");
        }
        jdProInfo.setProductCurrID("1");
        if (price != null) {
            jdProInfo.setPrice(price.getPrice());
            jdProInfo.setTaxPrice(price.getTaxPrice());
            jdProInfo.setShopPrice(price.getShowprice());
            jdProInfo.setTaxRate(price.getTaxRate());
        } else {
            jdProInfo.setPrice(BigDecimal.ZERO.setScale(2));
            jdProInfo.setTaxPrice(BigDecimal.ZERO.setScale(2));
            jdProInfo.setShopPrice(BigDecimal.ZERO.setScale(2));
        }
        jdProInfo.setStockQty(new BigDecimal("1000.00"));
        jdProInfo.setStockState("1");
        jdProInfo.setProductDetail(skuJo.getString("introduction"));
        jdProInfo.setSpecification(skuJo.getString("param"));
        jdProInfo.setPackinglist(skuJo.getString("wareQD"));
        String shouhou = "<div>\u5177\u4f53\u552e\u540e\u4fe1\u606f\u89c1\u4eac\u4e1c\u5546\u54c1\u9875\u9762&nbsp<a  href=\"https://item.jd.com/" + jdProInfo.getProductId() + ".html\" target=\"_blank\" >" + jdProInfo.getProductName() + "</a></div>";
        jdProInfo.setGuarantee(shouhou);
        ArrayList<String> skus = new ArrayList<String>();
        skus.add(jdProInfo.getProductId());
        Map picMap = JdApiUtil.getAllPicture(skus);
        List pics = (List)picMap.get(jdProInfo.getProductId());
        int index = 0;
        for (int i = 0; i < pics.size(); ++i) {
            JdPictureInfo pic = (JdPictureInfo)pics.get(i);
            if (index >= 4) continue;
            if (pic.isPrimary() == 1) {
                jdProInfo.setProductImgPath(IMGPREFIX + pic.getPath());
                continue;
            }
            if (index == 0) {
                jdProInfo.setPicture1(IMGPREFIX + pic.getPath());
                ++index;
                continue;
            }
            if (index == 1) {
                jdProInfo.setPicture2(IMGPREFIX + pic.getPath());
                ++index;
                continue;
            }
            if (index == 2) {
                jdProInfo.setPicture3(IMGPREFIX + pic.getPath());
                ++index;
                continue;
            }
            if (index != 3) continue;
            jdProInfo.setPicture4(IMGPREFIX + pic.getPath());
            ++index;
        }
        String cid = skuJo.getString("category").split(";")[2];
        jdProInfo.setCategoryName(MalJdProductUtil.getCatNameFromJDapi(cid));
        jdProInfo.setCategoryNumber(cid);
        jdProInfo.setCentralpurtype("1");
    }

    public static GoodsInfo getJdProductInfo4Detail(JSONObject sku) {
        return JdProdUtil.getJdProductInfo4Detail((JSONObject)sku);
    }

    public static List<String> checkJdSkuStates(List<String> skuList) {
        ArrayList<String> prodNumberList = new ArrayList<String>();
        Map result = JdApiUtil.getSkuStateMap(skuList);
        for (Map.Entry entry : result.entrySet()) {
            if (!"0".equals(entry.getValue())) continue;
            prodNumberList.add((String)entry.getKey());
        }
        return prodNumberList;
    }

    public static Map<String, Long> saveJdGoods(List<String> skusList, Map<String, String> nameMap, Map<String, String> imgMap) {
        ArrayList<String> needSaveSkusList = new ArrayList<String>(skusList);
        QFilter filter = new QFilter("number", "in", skusList);
        DynamicObjectCollection existDyoCol = QueryServiceHelper.query((String)"pbd_goods", (String)"id,number", (QFilter[])new QFilter[]{filter});
        if (existDyoCol != null && existDyoCol.size() > 0) {
            for (DynamicObject dyo : existDyoCol) {
                String number = dyo.getString("number");
                needSaveSkusList.remove(number);
            }
        }
        if (needSaveSkusList.size() > 0) {
            Object[] prods = new DynamicObject[needSaveSkusList.size()];
            DynamicObject prod = new DynamicObject();
            StringBuilder logString = new StringBuilder();
            for (int i = 0; i < needSaveSkusList.size(); ++i) {
                prod = BusinessDataServiceHelper.newDynamicObject((String)"pbd_goods");
                Long supplier = Long.valueOf(JDSUPPLER);
                String number = (String)needSaveSkusList.get(i);
                prod.set("number", (Object)number);
                prod.set("name", (Object)nameMap.get(number));
                prod.set("thumbnail", (Object)imgMap.get(number));
                logString.append("supplier:").append(supplier).append("pro.getString(supplier)\uff1a").append(prod.getString("supplier")).append("\n");
                prod.set("supplier_id", (Object)supplier);
                String jdUnit = MalOrderUtil.getJDUnit();
                if (StringUtils.isNotBlank((CharSequence)jdUnit)) {
                    prod.set("unit_id", (Object)jdUnit);
                } else {
                    prod.set("unit_id", (Object)"11");
                }
                prod.set("curr", (Object)"1");
                prod.set("origin", (Object)1);
                prod.set("status", (Object)"C");
                prod.set("enable", (Object)"1");
                prod.set("source", (Object)"2");
                prod.set("mallStatus", (Object)MalStatusEnum.B.getVal());
                prods[i] = prod;
            }
            log.info(logString.toString());
            SaveServiceHelper.save((IDataEntityType)prod.getDataEntityType(), (Object[])prods);
        }
        QFilter allFilter = new QFilter("number", "in", skusList);
        DynamicObjectCollection dyoCol = QueryServiceHelper.query((String)"pbd_goods", (String)"id,number", (QFilter[])new QFilter[]{allFilter});
        HashMap<String, Long> skuId = new HashMap<String, Long>(dyoCol.size());
        if (dyoCol.size() > 0) {
            for (DynamicObject dyo : dyoCol) {
                skuId.put(dyo.getString("number"), dyo.getLong("id"));
            }
        }
        return skuId;
    }

    public static Map<String, String> getDefualtReciept() {
        Long userId = RequestContext.get().getCurrUserId();
        HashMap<String, String> recieptMap = new HashMap<String, String>();
        QFilter creatorFilter = new QFilter("creator", "=", (Object)userId);
        QFilter defualtFilter = new QFilter("default", "=", (Object)"1");
        String selectFields = "id,name,phone,wholeaddress,email,mapaddress,postalcode,jdaddressnum";
        DynamicObject dyo = QueryServiceHelper.queryOne((String)"mal_address", (String)selectFields, (QFilter[])new QFilter[]{defualtFilter, creatorFilter});
        if (null != dyo) {
            recieptMap.put("receiptname", dyo.getString("name"));
            recieptMap.put("receiptphone", dyo.getString("phone"));
            recieptMap.put("receiptemail", dyo.getString("email"));
            recieptMap.put("receiptAddr", dyo.getString("mapaddress"));
            recieptMap.put("receiptzip", dyo.getString("postalcode"));
            recieptMap.put("receiptjdadress", dyo.getString("jdaddressnum"));
        }
        return recieptMap;
    }

    public static Map<String, String> getRecieptInfo(String addresId) {
        HashMap<String, String> recieptMap = new HashMap<String, String>(16);
        QFilter filter = new QFilter("id", "=", (Object)Long.valueOf(addresId));
        String selectFields = "id,name,phone,wholeaddress,email,mapaddress,postalcode,jdaddressnum";
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"mal_address", (String)selectFields, (QFilter[])new QFilter[]{filter});
        recieptMap.put("receiptname", dynamicObject.getString("name"));
        recieptMap.put("receiptphone", dynamicObject.getString("phone"));
        recieptMap.put("receiptemail", dynamicObject.getString("email"));
        recieptMap.put("receiptAddr", dynamicObject.getString("mapaddress"));
        recieptMap.put("receiptzip", dynamicObject.getString("postalcode"));
        recieptMap.put("receiptjdadress", dynamicObject.getString("jdaddressnum"));
        return recieptMap;
    }

    public static void clearCacheMap() {
        log.info("cacheMap: " + cacheMap.entrySet());
        cacheMap.clear();
    }
}

