/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.fulltext.FTCompare;
import kd.bos.fulltext.FTDataType;
import kd.bos.fulltext.FTFilter;
import kd.bos.fulltext.FTRowData;
import kd.bos.fulltext.FTValue;
import kd.bos.fulltext.FullTextFactory;
import kd.bos.fulltext.FullTextQuery;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.ecapi.entity.GoodsInfo;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.ParamConfigUtil;
import kd.scm.common.util.ValidateMatchUtil;
import kd.scm.mal.common.util.MalAuthorityUtils;
import kd.scm.mal.common.util.MalProductUtil;

@Deprecated
public class MalNewSearchUtils {
    private static Log logger = LogFactory.getLog(MalNewSearchUtils.class);
    private static final String RETURN_FILEDS = "id_string,number_string,name_zh_cn_string,source_string,classid_string,brandid_string,classname_string,classnumber_string,brandname_string,brandnumber_string,mainpic_string,model_string,mallstatus_string,price_float,centralpurtype_string,suppliername_string,classlongnumber_string";
    private static final String REGION = "pur";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String BRAND_NAME = "brandname";
    private static final String CLASS_NAME = "classname";
    private static final String SUPPLIER_NAME = "suppliername";
    private static final String PRICE = "price";
    private static final String MALL_STATUS = "mallstatus";
    private static final String[] ENTITY_GOODS = new String[]{"pbd_goods", "pbd_mallgoods"};
    private static final String SEARCH_SUPPLIER = "supplier.name";

    public static List<GoodsInfo> searchMallGoods(String searchText, List<String> searchFields, Float startPrice, Float endPrice, Object source, List<String> categoryLongNumnberList, int pageNo, int pageSize) {
        String field;
        ArrayList<GoodsInfo> productList = new ArrayList<GoodsInfo>(1);
        if (StringUtils.isBlank((CharSequence)searchText)) {
            return productList;
        }
        if (searchText.length() > 1000) {
            return productList;
        }
        ArrayList<FTRowData> result = new ArrayList(1);
        pageNo = pageNo == 0 ? 1 : pageNo;
        pageSize = pageSize == 0 ? 1000 : pageSize;
        boolean isAccurateSearch = searchFields.size() == 1;
        logger.info("@@malsearch param:" + searchText + "|" + searchFields + "|" + startPrice + "|" + endPrice + "|" + source + "|" + categoryLongNumnberList + "|" + pageNo + "|" + pageSize);
        FullTextQuery fq = FullTextFactory.getFullTextQuery((String)REGION);
        FTFilter filterStatus = new FTFilter(MALL_STATUS, FTCompare.EQ, FTValue.normal((FTDataType)FTDataType.STRING, (Object[])new Object[]{"B"})).or(new FTFilter(MALL_STATUS, FTCompare.EQ, FTValue.normal((FTDataType)FTDataType.STRING, (Object[])new Object[]{"1"})));
        if (null != source) {
            if (null == categoryLongNumnberList) {
                return new ArrayList<GoodsInfo>();
            }
            FTFilter filterSource = new FTFilter("source", FTCompare.EQ, FTValue.normal((FTDataType)FTDataType.STRING, (Object[])new Object[]{source.toString()}));
            FTFilter filterCategory = new FTFilter("classlongnumber", FTCompare.IN, FTValue.normal((FTDataType)FTDataType.STRING, (Object[])categoryLongNumnberList.toArray()));
            result = fq.searchMuiltExp(ENTITY_GOODS, RETURN_FILEDS, filterStatus.and(filterSource).and(filterCategory).toExp(), pageNo, pageSize);
            return MalNewSearchUtils.convertResult(result);
        }
        FTFilter filterPrice = null;
        if (null != startPrice && null != endPrice) {
            filterPrice = new FTFilter(PRICE, FTCompare.GT, FTValue.normal((FTDataType)FTDataType.FLOAT, (Object[])new Object[]{startPrice})).and(new FTFilter(PRICE, FTCompare.LT, FTValue.normal((FTDataType)FTDataType.FLOAT, (Object[])new Object[]{endPrice})));
        }
        FTFilter filterSupplier = null;
        if (searchFields.contains(SEARCH_SUPPLIER)) {
            filterSupplier = MalNewSearchUtils.getSupplierFilter(searchText);
        }
        FTFilter filterBrand = new FTFilter(BRAND_NAME, MalNewSearchUtils.getFTCompare(), FTValue.normal((FTDataType)FTDataType.STRING, (Object[])new Object[]{searchText}));
        FTFilter filterClassify = new FTFilter(CLASS_NAME, MalNewSearchUtils.getFTCompare(), FTValue.normal((FTDataType)FTDataType.STRING, (Object[])new Object[]{searchText}));
        FTFilter filterCode = new FTFilter(NUMBER, FTCompare.EQ, FTValue.normal((FTDataType)FTDataType.STRING, (Object[])new Object[]{searchText}));
        FTFilter filterModel = new FTFilter("model", MalNewSearchUtils.getFTCompare(), FTValue.normal((FTDataType)FTDataType.STRING, (Object[])new Object[]{searchText}));
        FTFilter filterTotal = filterStatus;
        filterTotal = isAccurateSearch ? (StringUtils.equalsIgnoreCase((CharSequence)(field = searchFields.get(0)), (CharSequence)"brand") ? filterStatus.and(filterBrand) : (StringUtils.equalsIgnoreCase((CharSequence)field, (CharSequence)"models") ? filterStatus.and(filterModel) : (StringUtils.equalsIgnoreCase((CharSequence)field, (CharSequence)"classify") ? filterStatus.and(filterClassify) : (StringUtils.equalsIgnoreCase((CharSequence)field, (CharSequence)SEARCH_SUPPLIER) ? filterStatus.and(filterSupplier) : filterStatus.and(MalNewSearchUtils.getNameFilter(searchText).or(filterCode)))))) : (null != filterSupplier && searchFields.size() > 1 ? filterStatus.and(MalNewSearchUtils.getNameFilter(searchText).or(filterCode).or(filterSupplier)) : filterStatus.and(MalNewSearchUtils.getNameFilter(searchText).or(filterBrand).or(filterClassify).or(filterCode).or(filterSupplier)));
        if (null != filterPrice) {
            filterTotal.and(filterPrice);
        }
        logger.info("@@mal fulltext query filter:" + filterTotal.toExp());
        result = fq.searchMuiltExp(ENTITY_GOODS, RETURN_FILEDS, filterTotal.toExp(), pageNo, pageSize);
        return MalNewSearchUtils.convertResult(result);
    }

    public static List<GoodsInfo> searchByClick(String searchText, String searchFields, String source, String category, String brand, Float startPrice, Float endPrice, String centralPurType) {
        ArrayList<GoodsInfo> productList = new ArrayList<GoodsInfo>(1);
        if (StringUtils.isBlank((CharSequence)searchText) || StringUtils.isBlank((CharSequence)searchFields)) {
            return productList;
        }
        if (searchText.length() > 1000) {
            return productList;
        }
        List<String> searchFieldList = Arrays.asList(searchFields.split("_"));
        FTFilter filterTotal = null;
        FTFilter filterStatus = new FTFilter(MALL_STATUS, FTCompare.EQ, FTValue.normal((FTDataType)FTDataType.STRING, (Object[])new Object[]{"B"})).or(new FTFilter(MALL_STATUS, FTCompare.EQ, FTValue.normal((FTDataType)FTDataType.STRING, (Object[])new Object[]{"1"})));
        FTFilter filterSupplier = null;
        if (searchFieldList.contains(SEARCH_SUPPLIER)) {
            filterSupplier = MalNewSearchUtils.getSupplierFilter(searchText);
        }
        FTFilter filterPrice = null;
        if (null != startPrice && null != endPrice && BigDecimal.valueOf(startPrice.floatValue()).compareTo(BigDecimal.ZERO) != 0 && BigDecimal.valueOf(endPrice.floatValue()).compareTo(BigDecimal.ZERO) != 0) {
            filterPrice = new FTFilter(PRICE, FTCompare.GT, FTValue.normal((FTDataType)FTDataType.FLOAT, (Object[])new Object[]{startPrice})).and(new FTFilter(PRICE, FTCompare.LT, FTValue.normal((FTDataType)FTDataType.FLOAT, (Object[])new Object[]{endPrice})));
        }
        FTFilter filterName = new FTFilter(NAME, FTCompare.MATCH, FTValue.lang((Lang)Lang.zh_CN, (String[])new String[]{searchText}));
        FTFilter filterBrand = new FTFilter(BRAND_NAME, FTCompare.MATCH, FTValue.normal((FTDataType)FTDataType.STRING, (Object[])new Object[]{searchText}));
        FTFilter filterClassify = new FTFilter(CLASS_NAME, FTCompare.MATCH, FTValue.normal((FTDataType)FTDataType.STRING, (Object[])new Object[]{searchText}));
        FTFilter filterNamePy = new FTFilter(NAME, FTCompare.MATCH, FTValue.pinyin((String[])new String[]{searchText}));
        FTFilter filterCode = new FTFilter(NUMBER, FTCompare.EQ, FTValue.normal((FTDataType)FTDataType.STRING, (Object[])new Object[]{searchText}));
        filterTotal = null != filterSupplier && searchFieldList.size() > 1 ? filterStatus.and(filterName.or(filterBrand).or(filterClassify).or(filterNamePy).or(filterCode).or(filterSupplier)) : (null != filterSupplier && searchFieldList.size() == 1 ? filterStatus.and(filterSupplier) : filterStatus.and(filterName.or(filterBrand).or(filterClassify).or(filterNamePy).or(filterCode)));
        if (null != filterPrice) {
            filterTotal.and(filterPrice);
        }
        if (!StringUtils.isEmpty((CharSequence)brand)) {
            filterTotal.and(new FTFilter("brandid", FTCompare.EQ, FTValue.normal((FTDataType)FTDataType.STRING, (Object[])new Object[]{brand})));
        }
        if (!StringUtils.isEmpty((CharSequence)category)) {
            filterTotal.and(new FTFilter("classid", FTCompare.EQ, FTValue.normal((FTDataType)FTDataType.STRING, (Object[])new Object[]{category})));
        }
        if (!StringUtils.isEmpty((CharSequence)source)) {
            filterTotal.and(new FTFilter("source", FTCompare.EQ, FTValue.normal((FTDataType)FTDataType.STRING, (Object[])new Object[]{source})));
        }
        if (!StringUtils.isEmpty((CharSequence)centralPurType)) {
            filterTotal.and(new FTFilter("centralpurtype", FTCompare.EQ, FTValue.normal((FTDataType)FTDataType.STRING, (Object[])new Object[]{"1"})));
        }
        FullTextQuery fq = FullTextFactory.getFullTextQuery((String)REGION);
        List result = fq.searchMuiltExp(ENTITY_GOODS, RETURN_FILEDS, filterTotal.toExp(), 1, 1000);
        return MalNewSearchUtils.convertResult(result);
    }

    public static List<GoodsInfo> search(String searchContent, List<String> searchFields, Object source, List<String> categoryLongNumnberList) {
        List<GoodsInfo> result = MalNewSearchUtils.searchMallGoods(searchContent, searchFields, null, null, source, categoryLongNumnberList, 1, 1000);
        return result;
    }

    public static List<GoodsInfo> convertResult(List<FTRowData> result) {
        if (null == result) {
            return new ArrayList<GoodsInfo>(1);
        }
        logger.info("@@@result size:" + result.size());
        ArrayList<GoodsInfo> productList = new ArrayList<GoodsInfo>(result.size());
        HashMap<String, String> ecSupplierNameMap = new HashMap<String, String>(8);
        for (FTRowData rowData : result) {
            GoodsInfo goodsInfo = new GoodsInfo();
            goodsInfo.setProductId(rowData.getPkId());
            String number = MalNewSearchUtils.getValueByKey(NUMBER, rowData);
            goodsInfo.setProductName(MalProductUtil.contactProdNumber(MalNewSearchUtils.getValueByKey("name_zh_cn", rowData), number));
            goodsInfo.setProductModel(MalNewSearchUtils.getValueByKey("model", rowData));
            goodsInfo.setProductImgPath(MalNewSearchUtils.getValueByKey("mainpic", rowData));
            goodsInfo.setProductNumber(number);
            goodsInfo.setProductSource(MalNewSearchUtils.getValueByKey("source", rowData));
            goodsInfo.setCategoryName(MalNewSearchUtils.getValueByKey(CLASS_NAME, rowData));
            goodsInfo.setCategoryNumber(MalNewSearchUtils.getValueByKey("classlongnumber", rowData));
            goodsInfo.setShopPrice(null == MalNewSearchUtils.getValueByKey("price_float", rowData) ? BigDecimal.ZERO : new BigDecimal(MalNewSearchUtils.getValueByKey("price_float", rowData)));
            goodsInfo.setCentralpurtype(MalNewSearchUtils.getValueByKey("centralpurtype", rowData));
            goodsInfo.setBrandNumber(MalNewSearchUtils.getValueByKey("brandnumber", rowData));
            goodsInfo.setBrandName(MalNewSearchUtils.getValueByKey(BRAND_NAME, rowData));
            String source = rowData.get("source").toString();
            if ("1".equalsIgnoreCase(source)) {
                goodsInfo.setSupplier(MalNewSearchUtils.getValueByKey(SUPPLIER_NAME, rowData));
            } else {
                DynamicObject supplierObj;
                if (StringUtils.isBlank((CharSequence)((CharSequence)ecSupplierNameMap.get(source))) && Objects.nonNull(supplierObj = MalOrderUtil.getEcSupplier((String)source))) {
                    ecSupplierNameMap.put(source, supplierObj.getString("malsupplier.name"));
                }
                goodsInfo.setSupplier((String)ecSupplierNameMap.get(source));
            }
            goodsInfo.setBrandId(MalNewSearchUtils.getValueByKey("brandid", rowData));
            goodsInfo.setCategoryId(MalNewSearchUtils.getValueByKey("classid", rowData));
            productList.add(goodsInfo);
        }
        return productList;
    }

    private static String getValueByKey(String keyName, FTRowData rowData) {
        if (rowData.get(keyName) == null) {
            return null;
        }
        if (rowData.get(keyName) instanceof List) {
            return ((List)rowData.get(keyName)).get(0).toString();
        }
        return rowData.get(keyName).toString();
    }

    public static boolean isPriceSearch(String startPricestr, String endPricestr) {
        boolean flag = false;
        if (startPricestr.length() == 0 && endPricestr.length() > 0 && ValidateMatchUtil.isDouble((String)endPricestr) && ValidateMatchUtil.isPositiveNumber((String)endPricestr) || endPricestr.length() == 0 && startPricestr.length() > 0 && ValidateMatchUtil.isDouble((String)startPricestr) && ValidateMatchUtil.isPositiveNumber((String)startPricestr) || startPricestr.length() > 0 && endPricestr.length() > 0 && ValidateMatchUtil.isDouble((String)endPricestr) && ValidateMatchUtil.isPositiveNumber((String)endPricestr) && ValidateMatchUtil.isDouble((String)startPricestr) && ValidateMatchUtil.isPositiveNumber((String)startPricestr) && Double.parseDouble(startPricestr) - Double.parseDouble(endPricestr) <= 0.0) {
            flag = true;
        }
        return flag;
    }

    public static List<GoodsInfo> getSales(List<GoodsInfo> productList) {
        ArrayList<Long> goodsIdList = new ArrayList<Long>(productList.size());
        for (GoodsInfo goodsInfo : productList) {
            goodsIdList.add(Long.valueOf(goodsInfo.getProductId()));
        }
        QFilter goodsFilter = new QFilter("entryentity.goods.id", "in", goodsIdList);
        QFilter billstatusFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter orgFilter = MalAuthorityUtils.getMalOrderViewAuthorityFilter(RequestContext.get().getUserId(), "deporg.id", "mal_order");
        Set purillStatusSet = Stream.of(BillStatusEnum.AUDIT.getVal(), BillStatusEnum.CLOSED.getVal()).collect(Collectors.toSet());
        QFilter purillStatusFilter = new QFilter("entryentity.erpbillstatus", "in", purillStatusSet);
        QFilter timeFilter = new QFilter("createtime", ">=", (Object)MalNewSearchUtils.getTime());
        String selectFields = "entryentity.goods.id id,entryentity.goods.number number,entryentity.qty";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"MalNewSearchUtils", (String)"mal_order", (String)selectFields, (QFilter[])new QFilter[]{goodsFilter, billstatusFilter, timeFilter, orgFilter, purillStatusFilter}, null);
             DataSet groupByDs = ds.copy().groupBy(new String[]{"id"}).sum("entryentity.qty").finish().orderBy(new String[]{"entryentity.qty desc"});){
            Iterator groupByDsItr = groupByDs.iterator();
            HashMap<Long, BigDecimal> countMap = new HashMap<Long, BigDecimal>();
            StringBuilder logString = new StringBuilder();
            while (groupByDsItr.hasNext()) {
                Row row = (Row)groupByDsItr.next();
                countMap.put(row.getLong("id"), row.getBigDecimal("entryentity.qty"));
                logString.append("@@").append(row.getString("id")).append(":").append(SerializationUtils.toJsonString((Object)row.getBigDecimal("entryentity.qty"))).append("\n");
            }
            logger.info(logString.toString());
            Iterator<GoodsInfo> iterator = productList.iterator();
            while (iterator.hasNext()) {
                GoodsInfo goodsInfo;
                String id = (goodsInfo = iterator.next()).getProductId();
                BigDecimal qty = (BigDecimal)countMap.get(Long.valueOf(id));
                goodsInfo.setSales(qty == null ? BigDecimal.ZERO : qty);
            }
        }
        return productList;
    }

    public static Date getTime() {
        Calendar ca = Calendar.getInstance();
        ca.setTime(new Date());
        ca.add(1, -1);
        return ca.getTime();
    }

    private static FTFilter getNameFilter(String searchText) {
        FTFilter filterName = new FTFilter(NAME, MalNewSearchUtils.getFTCompare(), FTValue.lang((Lang)Lang.zh_CN, (String[])new String[]{searchText}));
        if (!MalProductUtil.isContainChinese(searchText)) {
            filterName.or(new FTFilter(NAME, FTCompare.LIKE, FTValue.pinyin((String[])new String[]{searchText})));
        }
        return filterName;
    }

    private static FTFilter getSupplierFilter(String searchText) {
        EcPlatformEnum[] values;
        boolean hasChinese = MalProductUtil.isContainChinese(searchText);
        FTFilter filterSupplier = new FTFilter(SUPPLIER_NAME, MalNewSearchUtils.getFTCompare(), FTValue.normal((FTDataType)FTDataType.STRING, (Object[])new Object[]{searchText}));
        if (!hasChinese) {
            filterSupplier = filterSupplier.or(new FTFilter(SUPPLIER_NAME, FTCompare.LIKE, FTValue.pinyin((String[])new String[]{searchText})));
        }
        for (EcPlatformEnum ecPlatformEnum : values = EcPlatformEnum.values()) {
            String name = ecPlatformEnum.getName();
            if (!name.contains(searchText.trim())) continue;
            filterSupplier.or(new FTFilter("source", FTCompare.EQ, FTValue.normal((FTDataType)FTDataType.STRING, (Object[])new Object[]{ecPlatformEnum.getVal()})));
            break;
        }
        return filterSupplier;
    }

    private static FTCompare getFTCompare() {
        return ParamConfigUtil.getCacheBooleanParamConfig((String)"enableExactMatch") != false ? FTCompare.LIKE : FTCompare.MATCH;
    }
}

