/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.util;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ecapi.entity.PriceInfo;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.ecapi.jd.JDAccessTokenUtil;
import kd.scm.common.ecapi.util.AddressUtil;
import kd.scm.common.ecapi.util.EmalStatusUtil;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.JDOrderStatusEnum;
import kd.scm.common.enums.PurEcInvoiceEnum;
import kd.scm.common.helper.apiconnector.api.ApiAccessor;
import kd.scm.common.helper.apiconnector.api.util.EcApiUtil;
import kd.scm.common.helper.apiconnector.api.util.EcGroupApiUtil;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.JDOrderUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.cal.Cal4DynamicObj;
import kd.scm.common.util.mal.MalNewOrderUtils;
import kd.scm.mal.common.constant.MalPlaceOrderConstant;
import kd.scm.mal.common.util.MalJdProductUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class MalPlaceOrderUtils {
    private static final String BD_LINETYPE = "bd_linetype";
    private static final Log log = LogFactory.getLog(MalPlaceOrderUtils.class);
    private static final Set<String> DIRECT_PROVINCE_NUM_LIST = Stream.of("00123", "00141", "002675", "003134").collect(Collectors.toSet());

    @Deprecated
    public static BigDecimal getMalFreight(String source, String address, String paymentType, DynamicObjectCollection dyoCol, int supplierIndex, String addrDetail) {
        QFilter filter;
        DynamicObject data;
        String level;
        BigDecimal freight = BigDecimal.ZERO;
        if (source.equalsIgnoreCase(EcPlatformEnum.ECPLATFORM_XY.getVal()) || source.equalsIgnoreCase(EcPlatformEnum.ECPLATFORM_CG.getVal()) || source.equalsIgnoreCase(EcPlatformEnum.ECPLATFORM_ZKH.getVal())) {
            return freight;
        }
        HashMap params = new HashMap();
        HashMap<String, String> commonParam = new HashMap<String, String>(1);
        HashMap malParams = new HashMap(1);
        HashMap<String, Serializable> skuNums = new HashMap<String, Serializable>(dyoCol.size());
        BigDecimal taxAmount = BigDecimal.ZERO;
        for (DynamicObject dyo : dyoCol) {
            if (StringUtils.equals((CharSequence)EcPlatformEnum.ECPLATFORM_XFS.getVal(), (CharSequence)source)) {
                HashMap<String, Object> skuNum = new HashMap<String, Object>();
                skuNum.put("skuNo", dyo.getString("goods" + supplierIndex));
                skuNum.put("buyNum", dyo.getInt("qty" + supplierIndex));
                skuNum.put("settlePrice", dyo.getBigDecimal("goodamount" + supplierIndex).setScale(2, RoundingMode.HALF_UP));
                skuNums.put(dyo.getString("goods" + supplierIndex), skuNum);
                continue;
            }
            skuNums.put(dyo.getString("goods" + supplierIndex), Integer.valueOf(dyo.getInt("qty" + supplierIndex)));
            if (!StringUtils.equals((CharSequence)EcPlatformEnum.ECPLATFORM_DL.getVal(), (CharSequence)source)) continue;
            taxAmount = taxAmount.add(dyo.getBigDecimal("goodamount" + supplierIndex));
        }
        malParams.put("skuNums", skuNums);
        if (StringUtils.isEmpty((CharSequence)address)) {
            address = "0";
        }
        if (StringUtils.equals((CharSequence)(level = (data = QueryServiceHelper.queryOne((String)"bd_admindivision", (String)"level", (QFilter[])new QFilter[]{filter = new QFilter("id", "=", (Object)Long.valueOf(address))})).get("level").toString()), (CharSequence)"3") || StringUtils.equals((CharSequence)level, (CharSequence)"2")) {
            commonParam.put("countyId", address);
        }
        if (data.get("level").toString().equalsIgnoreCase("4")) {
            commonParam.put("townId", address);
        }
        if (source.equalsIgnoreCase(EcPlatformEnum.ECPLATFORM_SUNING.getVal())) {
            commonParam.put("addrDetail", addrDetail);
        } else if (source.equalsIgnoreCase(EcPlatformEnum.ECPLATFORM_DL.getVal())) {
            commonParam.put("addrDetail", taxAmount.toPlainString());
        } else {
            commonParam.put("addrDetail", "");
        }
        commonParam.put("paymentType", paymentType);
        params.put("common_params", commonParam);
        params.put(source, malParams);
        freight = (BigDecimal)EcGroupApiUtil.getEcFreight(params).get(source);
        if (null == freight) {
            log.error("\u65b0\u7248\u5546\u57ce\u83b7\u53d6\u7535\u5546\u8ba2\u5355\u8fd0\u8d39\u4e3a\u7a7a\u3002\u8bf7\u6c42\u53c2\u6570\uff1asource= " + source + ", commonParam = " + commonParam);
            String msg = ResManager.loadKDString((String)"\u83b7\u53d6\u7535\u5546\u8ba2\u5355\u8fd0\u8d39\u4e3a\u7a7a\u3002", (String)"MalPlaceOrderUtils_0", (String)"scm-mal-common", (Object[])new Object[0]);
            throw new KDBizException(new ErrorCode("getMalGoodsPrice error", EcPlatformEnum.fromVal((String)source).getName() + msg), new Object[0]);
        }
        return freight;
    }

    public static Map<String, Map<String, PriceInfo>> getMalGoodsPrice(String source, List<String> skusList, String addressid) {
        Map result = null;
        HashMap params = new HashMap();
        HashMap<String, List<String>> malParams = new HashMap<String, List<String>>(1);
        HashMap<String, String> commonParam = new HashMap<String, String>(1);
        String cityId = "";
        if (source.equalsIgnoreCase(EcPlatformEnum.ECPLATFORM_SUNING.getVal())) {
            cityId = MalPlaceOrderUtils.getCityId(addressid);
        }
        commonParam.put("cityId", cityId);
        malParams.put("skuIds", skusList);
        params.put("common_params", commonParam);
        params.put(source, malParams);
        result = EcGroupApiUtil.getEcPrice(params);
        if (null == result.get(source)) {
            log.error("\u65b0\u7248\u5546\u57ce\u83b7\u53d6\u7535\u5546\u5546\u54c1\u4ef7\u683c\u4e3a\u7a7a\u3002\u8bf7\u6c42\u53c2\u6570\uff1asource= " + source + ", skus= " + skusList + ", cityId = " + cityId);
            String msg = ResManager.loadKDString((String)"\u83b7\u53d6\u7535\u5546\u5546\u54c1\u4ef7\u683c\u4e3a\u7a7a\u3002", (String)"MalPlaceOrderUtils_1", (String)"scm-mal-common", (Object[])new Object[0]);
            throw new KDException(new ErrorCode("getMalGoodsPrice error", EcPlatformEnum.fromVal((String)source).getName() + msg), new Object[0]);
        }
        return result;
    }

    public static Map<String, Map<String, String>> getSnOrderDetail(String orderId) {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>(4);
        try {
            Map data = EcApiUtil.getSnOrderDetail((String)orderId);
            List orderItemList = (List)data.get("orderItemList");
            for (Map map : orderItemList) {
                HashMap<String, String> detail = new HashMap<String, String>(6);
                detail.put("qty", map.get("skuNum").toString());
                detail.put("price", map.get("unitPrice").toString());
                detail.put("taxRate", map.get("taxRate").toString());
                detail.put("skuAmt", map.get("skuAmt").toString());
                Object refundMoney = map.get("refundMoney");
                detail.put("refundMoney", refundMoney == null ? "" : refundMoney.toString());
                result.put(map.get("commdtyCode").toString(), detail);
            }
        }
        catch (Exception e) {
            log.warn("getSnOrderDetail:" + ExceptionUtil.getStackTrace((Throwable)e), (Throwable)e);
        }
        return result;
    }

    public static List<String> checkSkuStates(String source, List<String> skusList) {
        ArrayList<String> result = new ArrayList<String>(1);
        HashMap params = new HashMap();
        HashMap<String, List<String>> malParams = new HashMap<String, List<String>>(1);
        malParams.put("skuIds", skusList);
        params.put(source, malParams);
        Map data = (Map)EcGroupApiUtil.getEcSkuState(params).get(source);
        if (null == data) {
            log.error("\u65b0\u7248\u5546\u57ce\u83b7\u53d6\u7535\u5546\u5546\u54c1\u4e0a\u4e0b\u67b6\u72b6\u6001\u5f02\u5e38\u3002\u8bf7\u6c42\u53c2\u6570\uff1asource= " + source + ", params= " + params + ", malParams = " + malParams);
            String msg = ResManager.loadKDString((String)"\u83b7\u53d6\u5546\u54c1\u4e0a\u4e0b\u67b6\u72b6\u6001\u8ba2\u5355\u5f02\u5e38\u3002", (String)"MalPlaceOrderUtils_2", (String)"scm-mal-common", (Object[])new Object[0]);
            throw new KDException(new ErrorCode("checkSkuStates error", EcPlatformEnum.fromVal((String)source).getName() + msg), new Object[0]);
        }
        for (Map.Entry entry : data.entrySet()) {
            if (!"0".equals(entry.getValue())) continue;
            result.add((String)entry.getKey());
        }
        return result;
    }

    public static Map<String, Object> createSnOrder(DynamicObject sourceDyo, String orderBillNo, Map<String, Integer> qtyMap, Map<String, BigDecimal> goodPriceMap, int snSupplierIndex) {
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        HashMap<String, Object> params = new HashMap<String, Object>(32);
        params.put("thirdOrder", orderBillNo);
        ArrayList skuList = new ArrayList(qtyMap.size());
        for (Map.Entry<String, Integer> skuEntry : qtyMap.entrySet()) {
            HashMap<String, String> map = new HashMap<String, String>(4);
            map.put("skuId", skuEntry.getKey());
            map.put("num", skuEntry.getValue().toString());
            map.put("unitPrice", goodPriceMap.get(skuEntry.getKey()).toString());
            skuList.add(map);
        }
        params.put("sku", skuList);
        Map<String, String> recieptMap = MalJdProductUtil.getRecieptInfo(sourceDyo.getString("receipt"));
        params.put("receiverName", recieptMap.get("receiptname"));
        String addressId = sourceDyo.getString("addressid");
        Object[] addr = AddressUtil.getNumberArr((Long)Long.valueOf(addressId), (String)"3");
        if (null == addr || addr.length < 3) {
            log.error("\u65b0\u7248\u5546\u57ce\u83b7\u53d6\u82cf\u5b81\u4e0b\u5355\u5730\u5740\u5931\u8d25, \u5546\u57ce\u5730\u5740 = " + addressId + "\u82cf\u5b81\u5730\u5740 = " + Arrays.toString(addr));
            throw new KDException(new ErrorCode("get SN address error", ResManager.loadKDString((String)"\u83b7\u53d6\u82cf\u5b81\u4e0b\u5355\u5730\u5740\u5931\u8d25\u3002", (String)"MalPlaceOrderUtils_3", (String)"scm-mal-common", (Object[])new Object[0])), new Object[0]);
        }
        int size = addr.length;
        params.put("provinceId", addr[MalPlaceOrderConstant.PROVINCE_INDEX]);
        params.put("cityId", addr[MalPlaceOrderConstant.CITY_INDEX]);
        params.put("countyId", addr[MalPlaceOrderConstant.COUNTY_INDEX]);
        params.put("invoiceProvice", addr[MalPlaceOrderConstant.PROVINCE_INDEX]);
        params.put("invoiceCity", addr[MalPlaceOrderConstant.CITY_INDEX]);
        params.put("invoiceCounty", addr[MalPlaceOrderConstant.COUNTY_INDEX]);
        if (size > 3) {
            params.put("townId", addr[MalPlaceOrderConstant.TOWN_INDEX]);
        } else {
            params.put("townId", "");
        }
        params.put("address", recieptMap.get("receiptAddr"));
        params.put("mobile", recieptMap.get("receiptphone"));
        params.put("email", recieptMap.get("receiptemail"));
        params.put("zip", recieptMap.get("receiptzip"));
        params.put("remark", sourceDyo.getString("remark" + snSupplierIndex));
        params.put("invoiceState", "0");
        params.put("invoiceType", sourceDyo.get("invoicetype" + snSupplierIndex).toString());
        params.put("invoiceTitle", sourceDyo.getString("invoiceorg.ffirmname.zh_CN").trim());
        params.put("invoiceContent", "1");
        params.put("paymentType", sourceDyo.get("paytype" + snSupplierIndex).toString());
        params.put("amount", sourceDyo.getBigDecimal("totalgoodsamt" + snSupplierIndex).toString());
        params.put("servFee", sourceDyo.getBigDecimal("freight" + snSupplierIndex).toString());
        params.put("regCode", sourceDyo.getString("invoiceorg.ftaxregnum").trim());
        params.put("regCompanyName", sourceDyo.getString("invoiceorg.ffirmname.zh_CN").trim());
        params.put("regPhone", sourceDyo.getString("invoiceorg.phone").trim());
        params.put("regAddr", sourceDyo.getString("invoiceorg.faddress").trim());
        params.put("regBank", sourceDyo.getString("invoiceorg.depositbank").trim());
        params.put("regBankAccount", sourceDyo.getString("invoiceorg.bankaccount").trim());
        params.put("invoiceName", recieptMap.get("receiptname"));
        params.put("invoicePhone", recieptMap.get("receiptphone"));
        params.put("invoiceAddress", null == params.get("townId") ? "" : params.get("townId"));
        log.info("\u751f\u6210\u82cf\u5b81\u9884\u5360\u5e93\u5b58\u5355\u63a5\u53e3\u53c2\u6570" + params);
        Map data = (Map)EcApiUtil.parseResful((Object)ApiAccessor.invoke((String)"SRM_SN_ORDER_addMixpayorder", params));
        log.info("\u8c03\u7528\u751f\u6210\u82cf\u5b81\u9884\u5360\u5e93\u5b58\u5355\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\uff1a" + data);
        String snOrderId = data.get("orderId").toString();
        result.put("snOrderId", snOrderId);
        result.put("resultMap", data);
        result.put("skus", data.get("skus"));
        return result;
    }

    public static Map<String, String> getMalGoods(List<String> skusList, Map<String, String> nameMap, Map<String, String> imgMap, String source) {
        HashMap<String, String> skuIdMap = new HashMap<String, String>();
        QFilter filter = new QFilter("number", "in", skusList).and(new QFilter("source", "=", (Object)source));
        DynamicObjectCollection dyoCol = QueryServiceHelper.query((String)"pbd_goods", (String)"id,number", (QFilter[])new QFilter[]{filter});
        if (dyoCol != null && dyoCol.size() > 0) {
            for (DynamicObject dyo : dyoCol) {
                skuIdMap.put(dyo.getString("number"), dyo.getString("id"));
            }
        }
        if (MapUtils.isEmpty(skuIdMap)) {
            log.error("\u65b0\u7248\u5546\u57ce\u6839\u636esku\u83b7\u53d6pbd_goods\u8d44\u6599ID\u5931\u8d25");
            String msg = ResManager.loadKDString((String)"\u83b7\u53d6pbd_goods\u8d44\u6599ID\u5931\u8d25\u3002", (String)"MalPlaceOrderUtils_4", (String)"scm-mal-common", (Object[])new Object[0]);
            throw new KDException(new ErrorCode("get pbd_goods error", EcPlatformEnum.fromVal((String)source).getName() + msg), new Object[0]);
        }
        return skuIdMap;
    }

    public static Map<String, Map<String, String>> saveSnParentOrder(int snSupplierIndex, DynamicObject sourceDyo, Map<String, String> skuIdMap, Map<String, PriceInfo> priceMap, Map<String, Integer> qtyMap, Map<String, Object> resultMap) {
        List list = (List)resultMap.get("skus");
        String snOrderId = resultMap.get("orderId").toString();
        Map<String, Map<String, String>> orderDetail = MalPlaceOrderUtils.getSnOrderDetail(snOrderId);
        for (int i = 0; i < list.size(); ++i) {
            DynamicObject snOrder = BusinessDataServiceHelper.newDynamicObject((String)"pbd_order_sn");
            MalPlaceOrderUtils.setSnOrderHeadInfo(snSupplierIndex, sourceDyo, snOrder, resultMap, false, (Map)list.get(i));
            MalPlaceOrderUtils.setSnOrderEntryInfo(orderDetail, snOrderId, snOrder, skuIdMap, priceMap, qtyMap, (Map)list.get(i));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{snOrder});
        }
        DynamicObject snParentOrder = BusinessDataServiceHelper.newDynamicObject((String)"pbd_order_sn");
        MalPlaceOrderUtils.setSnOrderHeadInfo(snSupplierIndex, sourceDyo, snParentOrder, resultMap, true, (Map)list.get(0));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{snParentOrder});
        return orderDetail;
    }

    public static void writeBack2OrderInfo4Sn(Map<String, Map<String, String>> orderDetail, DynamicObject sourceDyo, String snOrderId, String billNo, Map<String, Object> resultMap, Map<String, String> skuIdMap, int jdSupplierIndex) {
        HashMap<String, String> idSkuMap = new HashMap<String, String>((int)((double)skuIdMap.size() / 0.75));
        for (Map.Entry<String, String> entry : skuIdMap.entrySet()) {
            idSkuMap.put(entry.getValue(), entry.getKey());
        }
        QFilter filter = new QFilter("billno", "=", (Object)billNo);
        String head = DynamicObjectUtil.getSelectfields((String)"mal_order", (boolean)false);
        String entry = DynamicObjectUtil.getEntrySelectfields((String)"", (String)"mal_order", (String)"entryentity", (boolean)false);
        String selectFields = head + "," + entry;
        DynamicObject[] dyo = BusinessDataServiceHelper.load((String)"mal_order", (String)selectFields, (QFilter[])new QFilter[]{filter});
        dyo[0].set("jdorderid", (Object)snOrderId);
        String snParentOrderPkId = MalPlaceOrderUtils.getParentOrderPkId(snOrderId, EcPlatformEnum.ECPLATFORM_SUNING.getVal()).toString();
        DynamicObject snParentOrderDyn = MalPlaceOrderUtils.getOrderDyn(snParentOrderPkId, EcPlatformEnum.ECPLATFORM_SUNING.getVal());
        dyo[0].set("ecorderid_id", (Object)snParentOrderPkId);
        dyo[0].set("ecorderid", (Object)snParentOrderDyn);
        dyo[0].set("orderstatus", (Object)EmalStatusUtil.getNumber((String)snParentOrderDyn.get("orderstate").toString(), (String)"1", (String)EcPlatformEnum.ECPLATFORM_SUNING.getVal()));
        for (DynamicObject temp : (DynamicObjectCollection)dyo[0].get("entryentity")) {
            String goodsId = temp.getString("goods.id");
            String goodsIdSku = (String)idSkuMap.get(goodsId);
            if (goodsIdSku == null) continue;
            List list = (List)resultMap.get("skus");
            for (Map map : list) {
                if (!goodsIdSku.equalsIgnoreCase(map.get("skuId").toString())) continue;
                Map<String, String> detail = orderDetail.get(goodsIdSku);
                temp.set("taxamount", (Object)new BigDecimal(detail.get("skuAmt")));
                temp.set("taxrate", (Object)new BigDecimal(detail.get("taxRate")).multiply(new BigDecimal(100)));
                String snOrderPkId = MalPlaceOrderUtils.getOrderPkId(snOrderId, EcPlatformEnum.ECPLATFORM_SUNING.getVal(), goodsIdSku).toString();
                DynamicObject snOrderDyn = MalPlaceOrderUtils.getOrderDyn(snOrderPkId, EcPlatformEnum.ECPLATFORM_SUNING.getVal());
                temp.set("order_id", (Object)snOrderPkId);
                temp.set("order", (Object)snOrderDyn);
            }
        }
        Cal4DynamicObj.reCalBill((DynamicObject)dyo[0], (String)"entryentity");
        SaveServiceHelper.save((DynamicObject[])dyo);
    }

    public static String getPlatformId(String source) {
        return MalNewOrderUtils.getPlatformId((String)source);
    }

    public static String getOrderId(String source, String pkId) {
        return MalNewOrderUtils.getOrderId((String)source, (String)pkId);
    }

    public static Object getParentOrderPkId(String orderId, String source) {
        return MalNewOrderUtils.getParentOrderPkId((String)orderId, (String)source);
    }

    public static Object getOrderPkId(String parentOrderId, String source, String skuId) {
        return MalNewOrderUtils.getOrderPkId((String)parentOrderId, (String)source, (String)skuId);
    }

    public static DynamicObject getOrderDyn(String orderPkId, String source) {
        return MalNewOrderUtils.getOrderDyn((String)orderPkId, (String)source);
    }

    public static String getCityId(String address) {
        String cityId = "";
        if (StringUtils.isNotEmpty((CharSequence)address) && !"null".equals(address)) {
            QFilter filter1 = new QFilter("id", "=", (Object)Long.valueOf(address));
            DynamicObject data1 = QueryServiceHelper.queryOne((String)"bd_admindivision", (String)"id,level,longnumber", (QFilter[])new QFilter[]{filter1});
            if (null == data1 || StringUtils.isBlank((CharSequence)data1.getString("longnumber"))) {
                return cityId;
            }
            String[] numbers = data1.getString("longnumber").split("\\.");
            if (numbers.length > 1 && DIRECT_PROVINCE_NUM_LIST.contains(numbers[0])) {
                QFilter filter2 = new QFilter("number", "=", (Object)numbers[0]).and(new QFilter("level", "=", (Object)1));
                DynamicObject data2 = QueryServiceHelper.queryOne((String)"bd_admindivision", (String)"id", (QFilter[])new QFilter[]{filter2});
                return data2.getString("id");
            }
            if (numbers.length < 2) {
                return "";
            }
            QFilter filter3 = new QFilter("number", "=", (Object)numbers[1]).and(new QFilter("parent.number", "=", (Object)numbers[0]));
            DynamicObject data3 = QueryServiceHelper.queryOne((String)"bd_admindivision", (String)"id", (QFilter[])new QFilter[]{filter3});
            cityId = data3.getString("id");
        }
        return cityId;
    }

    public static Map<String, Boolean> judgeFacProduct(String cityId, List<String> skus) {
        HashMap<String, Boolean> res = new HashMap<String, Boolean>();
        HashMap<String, Object> snPara = new HashMap<String, Object>();
        snPara.put("cityId", cityId);
        snPara.put("skuIds", skus);
        Map judgeFacProductResMap = (Map)ApiAccessor.invoke((String)"SRM_SN_GOODS_getJudgefacproduct", snPara);
        if (((Boolean)judgeFacProductResMap.get("success")).booleanValue()) {
            List resultMapList = (List)judgeFacProductResMap.get("result");
            resultMapList.forEach(resultMap -> res.put((String)resultMap.get("skuId"), "01".equals(resultMap.get("isFactorySend"))));
        }
        return res;
    }

    public static Map<String, Boolean> judgeFacProductByOrder(String snPOrderId) {
        HashMap<String, Boolean> resMap = new HashMap<String, Boolean>(16);
        Map snOrder = EcApiUtil.getSnOrderDetail((String)snPOrderId);
        List orderItemList = (List)snOrder.get("orderItemList");
        for (Map map : orderItemList) {
            if (null == map.get("isFactorySend") || !map.get("isFactorySend").toString().equalsIgnoreCase("1") || null == map.get("commdtyCode")) continue;
            resMap.put(map.get("commdtyCode").toString(), Boolean.TRUE);
        }
        return resMap;
    }

    public static Map<String, Object> malConfirmRecevie(Object[] ids) {
        HashMap<String, Object> data = new HashMap<String, Object>(2);
        StringBuilder result = new StringBuilder();
        HashSet<String> unconfirmOrder = new HashSet<String>();
        HashSet<String> notNeedconfirmOrder = new HashSet<String>();
        String selectProperties = "id,billno,platform,ecorderid pOrder,entryentity.order order, entryentity.goods.number sku, receipt.address address";
        QFilter filter = new QFilter("id", "in", (Object)ids).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal()).and("platform", "!=", (Object)EcPlatformEnum.ECPLATFORM_SELF.getVal());
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection malOrders = QueryServiceHelper.query((String)"mal_order", (String)selectProperties, (QFilter[])filters);
        if (malOrders.isEmpty()) {
            result.append(ResManager.loadKDString((String)"\u6ee1\u8db3\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\u4e14\u7535\u5546\u5e73\u53f0\u4e0d\u662f\u81ea\u5efa\u5546\u57ce\u7684\u5546\u57ce\u8ba2\u5355\u624d\u80fd\u66f4\u65b0\u7535\u5546\u72b6\u6001\u3002", (String)"MalPlaceOrderUtils_9", (String)"scm-mal-common", (Object[])new Object[0]));
            data.put("totalMsg", result.toString());
            return data;
        }
        HashMap<String, Map<String, Map<String, Set<String>>>> requestMap = new HashMap<String, Map<String, Map<String, Set<String>>>>(malOrders.size());
        HashMap factorySkusMap = new HashMap(malOrders.size());
        StringBuilder logStringOne = new StringBuilder();
        for (DynamicObject order : malOrders) {
            String billNo = order.getString("billno");
            logStringOne.append("$$$$$$$").append(billNo).append("\n");
            String source = order.getString("platform");
            if (!source.equalsIgnoreCase(EcPlatformEnum.ECPLATFORM_SUNING.getVal())) continue;
            String pOrderPkId = order.getString("pOrder");
            String pOrderId = MalNewOrderUtils.getOrderId((String)source, (String)pOrderPkId);
            Map snOrder = EcApiUtil.getSnOrderDetail((String)pOrderId);
            List orderItemList = (List)snOrder.get("orderItemList");
            ArrayList<String> skus = new ArrayList<String>(orderItemList.size());
            for (Map map : orderItemList) {
                if (null == map.get("isFactorySend") || map.get("isFactorySend").toString().equalsIgnoreCase("0") || null == map.get("commdtyCode")) continue;
                skus.add(map.get("commdtyCode").toString());
            }
            factorySkusMap.put(billNo, skus);
        }
        log.info(logStringOne.toString());
        StringBuilder logStringTwo = new StringBuilder();
        StringBuilder logStringThree = new StringBuilder();
        for (DynamicObject order : malOrders) {
            HashSet<String> skuSet;
            HashMap<String, HashSet<String>> orderSkuMap;
            List factorySkus;
            String billno = order.getString("billno");
            logStringTwo.append("$$$$$$$").append(billno).append("\n");
            String source = order.getString("platform");
            if (source.equalsIgnoreCase(EcPlatformEnum.ECPLATFORM_SELF.getVal())) {
                unconfirmOrder.add(billno);
                continue;
            }
            if (source.equalsIgnoreCase(EcPlatformEnum.ECPLATFORM_XY.getVal())) {
                notNeedconfirmOrder.add(billno);
                continue;
            }
            String sku = order.getString("sku");
            if (source.equalsIgnoreCase(EcPlatformEnum.ECPLATFORM_SUNING.getVal()) && (CollectionUtils.isEmpty((Collection)(factorySkus = (List)factorySkusMap.get(billno))) || !factorySkus.contains(sku))) {
                result.append(MessageFormat.format(ResManager.loadKDString((String)"\u5355\u636e{0}\u4e2d\u5546\u54c1[{1}]\u4e0d\u662f\u5382\u9001\u5546\u54c1\u4e0d\u9700\u786e\u8ba4\u6536\u8d27\u3002", (String)"MalPlaceOrderUtils_5", (String)"scm-mal-common", (Object[])new Object[0]), billno, sku)).append('\n');
                continue;
            }
            String pOrderPkId = order.getString("pOrder");
            String pOrderId = MalNewOrderUtils.getOrderId((String)source, (String)pOrderPkId);
            String orderPkId = order.getString("order");
            String orderId = "";
            if (!StringUtils.isBlank((CharSequence)orderPkId) && !"0".equalsIgnoreCase(orderPkId)) {
                orderId = MalNewOrderUtils.getSubOrderId((String)source, (String)orderPkId);
            }
            if (StringUtils.isBlank((CharSequence)orderId)) {
                unconfirmOrder.add(billno);
                continue;
            }
            logStringThree.append(ResManager.loadKDString((String)"\u786e\u8ba4", (String)"MalPlaceOrderUtils_10", (String)"scm-mal-common", (Object[])new Object[0])).append(EcPlatformEnum.fromVal((String)source).getName()).append(ResManager.loadKDString((String)"\u8ba2\u5355\u83b7\u53d6\u5b50\u8ba2\u5355\u53f7:", (String)"MalPlaceOrderUtils_11", (String)"scm-mal-common", (Object[])new Object[0])).append(orderId).append("\n");
            String key = source.equalsIgnoreCase(EcPlatformEnum.ECPLATFORM_JD.getVal()) || source.equalsIgnoreCase(EcPlatformEnum.ECPLATFORM_JDPRO.getVal()) ? orderId : pOrderId;
            HashMap malConfirmMap = (HashMap)requestMap.get(billno);
            if (MapUtils.isEmpty((Map)malConfirmMap)) {
                malConfirmMap = new HashMap(malOrders.size());
            }
            if (MapUtils.isEmpty((Map)(orderSkuMap = (HashMap<String, HashSet<String>>)malConfirmMap.get(source)))) {
                orderSkuMap = new HashMap<String, HashSet<String>>(malOrders.size());
            }
            if (CollectionUtils.isEmpty((Collection)(skuSet = (HashSet<String>)orderSkuMap.get(key)))) {
                skuSet = new HashSet<String>(malOrders.size());
            }
            skuSet.add(sku);
            orderSkuMap.put(key, skuSet);
            malConfirmMap.put(source, orderSkuMap);
            requestMap.put(billno, malConfirmMap);
        }
        log.info(logStringTwo.toString());
        log.info(logStringThree.toString());
        if (unconfirmOrder.size() > 0) {
            result.append(MessageFormat.format(ResManager.loadKDString((String)"\u5355\u636e{0}\u4e0d\u662f\u6b63\u5f0f\u8ba2\u5355\u6216\u975e\u7535\u5546\u8ba2\u5355\uff0c\u4e0d\u80fd\u786e\u8ba4\u6536\u8d27\u3002", (String)"MalPlaceOrderUtils_6", (String)"scm-mal-common", (Object[])new Object[0]), ((Object)unconfirmOrder).toString())).append('\n');
        }
        if (notNeedconfirmOrder.size() > 0) {
            result.append(MessageFormat.format(ResManager.loadKDString((String)"\u5355\u636e{0}\u4e0d\u9700\u786e\u8ba4\u6536\u8d27\u3002", (String)"MalPlaceOrderUtils_7", (String)"scm-mal-common", (Object[])new Object[0]), ((Object)notNeedconfirmOrder).toString())).append('\n');
        }
        if (MapUtils.isNotEmpty(requestMap)) {
            Map<String, Map<String, Object>> response = MalPlaceOrderUtils.confirmRecieve(requestMap);
            for (Map.Entry<String, Map<String, Object>> entry : response.entrySet()) {
                Map<String, Object> detail = entry.getValue();
                if (null == detail.get("msg")) continue;
                result.append(detail.get("msg"));
            }
            data.put("response", response);
        }
        data.put("totalMsg", result.toString());
        return data;
    }

    @Deprecated
    protected static Map<String, Map<String, Object>> confirmRecieve(Map<String, Map<String, Map<String, Set<String>>>> requestMap) {
        HashMap<String, Map<String, Object>> data = new HashMap<String, Map<String, Object>>(requestMap.size());
        StringBuilder result = new StringBuilder();
        StringBuilder logString = new StringBuilder();
        HashMap<String, String> billNoSettloOrgIdMap = new HashMap<String, String>();
        DynamicObjectCollection malOrderCol = QueryServiceHelper.query((String)"mal_order", (String)"billno,settleorg.id", (QFilter[])new QFilter[]{new QFilter("billno", "in", requestMap.keySet())});
        for (DynamicObject malOrderDyn : malOrderCol) {
            billNoSettloOrgIdMap.put(malOrderDyn.getString("billno"), malOrderDyn.getString("settleorg.id"));
        }
        for (Map.Entry<String, Map<String, Map<String, Set<String>>>> map : requestMap.entrySet()) {
            HashMap<String, Object> message;
            String billNo = map.getKey();
            if (result.length() > 0) {
                result.delete(0, result.length() - 1);
            }
            if (MapUtils.isEmpty((Map)(message = (HashMap<String, Object>)data.get(billNo)))) {
                message = new HashMap<String, Object>(4);
            }
            for (Map.Entry<String, Map<String, Set<String>>> detail : map.getValue().entrySet()) {
                String source = detail.getKey();
                Map<String, Set<String>> orderSkuMap = detail.getValue();
                for (Map.Entry<String, Set<String>> order : orderSkuMap.entrySet()) {
                    String orderId = order.getKey();
                    Set<String> skuIdSet = order.getValue();
                    try {
                        String token;
                        HashMap<String, String> skuConfirmMap = new HashMap<String, String>();
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        String time = sdf.format(new Date());
                        if (!StringUtils.isEmpty((CharSequence)source) && source.equalsIgnoreCase(EcPlatformEnum.ECPLATFORM_SUNING.getVal())) {
                            for (String sku : skuIdSet) {
                                skuConfirmMap.put(sku, time);
                            }
                        }
                        HashMap<String, Object> diffParams = new HashMap<String, Object>(2);
                        HashMap<String, HashMap<String, Object>> params = new HashMap<String, HashMap<String, Object>>(2);
                        diffParams.put("orderId", orderId);
                        diffParams.put("skuConfirmMap", skuConfirmMap);
                        if ((EcPlatformEnum.ECPLATFORM_JD.getVal().equals(source) || EcPlatformEnum.ECPLATFORM_JDPRO.getVal().equals(source)) && StringUtils.isNotBlank((CharSequence)((CharSequence)billNoSettloOrgIdMap.get(billNo))) && StringUtils.isNotBlank((CharSequence)(token = JDAccessTokenUtil.getValidToken((String)((String)billNoSettloOrgIdMap.get(billNo)), (String)source)))) {
                            diffParams.put("token", token);
                        }
                        params.put(source, diffParams);
                        Map res = EcGroupApiUtil.confirmOrderReceive(params);
                        Map resultDetail = (Map)res.get(source);
                        if (null != resultDetail && Boolean.parseBoolean((String)resultDetail.get("success"))) {
                            logString.append(EcPlatformEnum.fromVal((String)source).getName()).append(ResManager.loadKDString((String)"\u786e\u8ba4\u6536\u8d27 ", (String)"MalPlaceOrderUtils_12", (String)"scm-mal-common", (Object[])new Object[0])).append(ResManager.loadKDString((String)"\u6210\u529f\uff01\u8ba2\u5355\u53f7:", (String)"MalPlaceOrderUtils_13", (String)"scm-mal-common", (Object[])new Object[0])).append(orderId).append("\n");
                            message.put("source", source);
                            message.put("skus", skuIdSet);
                            message.put("orderId", orderId);
                            continue;
                        }
                        result.append(EcPlatformEnum.fromVal((String)source).getName());
                        result.append(MessageFormat.format(ResManager.loadKDString((String)"\u8ba2\u5355{0}\u786e\u8ba4\u6536\u8d27\u5931\u8d25\uff1a{1}\u3002", (String)"MalPlaceOrderUtils_8", (String)"scm-mal-common", (Object[])new Object[0]), orderId, null == resultDetail ? "" : (null == resultDetail.get("message") ? "" : resultDetail.get("message"))));
                        result.append('\n');
                        message.put("msg", result.toString());
                    }
                    catch (Exception e) {
                        result.append(EcPlatformEnum.fromVal((String)source).getName());
                        result.append(MessageFormat.format(ResManager.loadKDString((String)"\u8ba2\u5355{0}\u786e\u8ba4\u6536\u8d27\u5931\u8d25\uff1a{1}\u3002", (String)"MalPlaceOrderUtils_8", (String)"scm-mal-common", (Object[])new Object[0]), orderId, e.getMessage()));
                        result.append('\n');
                        message.put("msg", result.toString());
                        log.info(SerializationUtils.toJsonString(message));
                    }
                }
            }
            data.put(billNo, message);
        }
        log.info(logString.toString());
        return data;
    }

    private static void setSnOrderHeadInfo(int snSupplierIndex, DynamicObject sourceDyo, DynamicObject snOrder, Map<String, Object> resultMap, boolean parentOrder, Map<String, Object> skuMap) {
        Long currency = MalOrderUtil.getEcCurrencyId((String)EcPlatformEnum.ECPLATFORM_SUNING.getVal());
        Date currentDate = new Date();
        String snOrderId = resultMap.get("orderId").toString();
        snOrder.set("porderid", (Object)snOrderId);
        if (parentOrder) {
            snOrder.set("orderid", (Object)snOrderId);
            snOrder.set("freight", (Object)BigDecimal.valueOf(Double.parseDouble(resultMap.get("freight").toString())));
            DynamicObjectCollection orderDyn = QueryServiceHelper.query((String)"pbd_order_sn", (String)"orderamount,ordernakedamount,ordertaxamount", (QFilter[])new QFilter[]{new QFilter("porderid", "=", (Object)snOrderId)});
            for (DynamicObject subOrder : orderDyn) {
                snOrder.set("orderamount", null == snOrder.get("orderamount") ? subOrder.get("orderamount") : ((BigDecimal)snOrder.get("orderamount")).add((BigDecimal)subOrder.get("orderamount")));
                snOrder.set("ordernakedamount", null == snOrder.get("ordernakedamount") ? subOrder.get("ordernakedamount") : ((BigDecimal)snOrder.get("ordernakedamount")).add((BigDecimal)subOrder.get("ordernakedamount")));
                snOrder.set("ordertaxamount", null == snOrder.get("ordertaxamount") ? subOrder.get("ordertaxamount") : ((BigDecimal)snOrder.get("ordertaxamount")).add((BigDecimal)subOrder.get("ordertaxamount")));
            }
        } else {
            snOrder.set("orderid", (Object)skuMap.get("orderItemId").toString());
        }
        snOrder.set("invoicestate", (Object)PurEcInvoiceEnum.PREREQUEST.getVal());
        snOrder.set("suborderstate", (Object)"1");
        snOrder.set("orderstate", (Object)"1");
        snOrder.set("invoicetype", (Object)sourceDyo.get("invoicetype" + snSupplierIndex).toString());
        snOrder.set("submitstate", (Object)"0");
        if (StringUtils.isNotBlank((Object)currency)) {
            snOrder.set("currency_id", (Object)currency);
        } else {
            snOrder.set("currency_id", (Object)"1");
        }
        snOrder.set("createtime", (Object)currentDate);
    }

    private static void setSnOrderEntryInfo(Map<String, Map<String, String>> orderDetail, String snOrderId, DynamicObject snOrder, Map<String, String> skuIdMap, Map<String, PriceInfo> priceMap, Map<String, Integer> qtyMap, Map<String, Object> skuResultMap) {
        String sku = skuResultMap.get("skuId").toString();
        DynamicObjectCollection entryDyoCol = (DynamicObjectCollection)snOrder.get("entryentity");
        for (Map.Entry<String, Integer> skuMap : qtyMap.entrySet()) {
            if (!sku.equalsIgnoreCase(skuMap.getKey())) continue;
            Map<String, String> detail = orderDetail.get(sku);
            DynamicObject entryDyo = entryDyoCol.addNew();
            entryDyo.set("goods", (Object)skuIdMap.get(skuMap.getKey()));
            entryDyo.set("qty", (Object)skuMap.getValue());
            entryDyo.set("price", (Object)new BigDecimal(detail.get("price")));
            entryDyo.set("nakedamount", (Object)priceMap.get(skuMap.getKey()).getPrice());
            entryDyo.set("taxamount", (Object)priceMap.get(skuMap.getKey()).getTax());
            entryDyo.set("taxrate", (Object)new BigDecimal(detail.get("taxRate")));
            snOrder.set("orderamount", (Object)new BigDecimal(detail.get("skuAmt")));
            snOrder.set("ordernakedamount", (Object)priceMap.get(skuMap.getKey()).getPrice().multiply(new BigDecimal(skuMap.getValue())));
            snOrder.set("ordertaxamount", (Object)priceMap.get(skuMap.getKey()).getTax().multiply(new BigDecimal(skuMap.getValue())));
            snOrder.set("freight", (Object)new BigDecimal(detail.get("skuAmt")).subtract(new BigDecimal(detail.get("price")).multiply(new BigDecimal(detail.get("qty")))));
        }
    }

    public static Set<String> malOrderInvalidProcessor(Set<String> orderSet, String source) {
        boolean isallcancelFlag = QueryServiceHelper.exists((String)"pur_updateparamconfig", (QFilter[])new QFilter[]{new QFilter("paramkey", "=", (Object)"ispartcancel").and(new QFilter("paramvalue", "=", (Object)"N"))});
        boolean isCQ = ApiConfigUtil.hasCQScmConfig();
        if (orderSet != null && !CollectionUtils.isEmpty(orderSet) && StringUtils.isNotEmpty((CharSequence)source)) {
            DynamicObject[] orders;
            QFilter filter;
            HashSet<String> successOrders = new HashSet<String>(orderSet.size());
            String sourceTag = EcPlatformEnum.fromVal((String)source).getName();
            if (source.equalsIgnoreCase(EcPlatformEnum.ECPLATFORM_JD.getVal()) || source.equalsIgnoreCase(EcPlatformEnum.ECPLATFORM_JDPRO.getVal())) {
                filter = new QFilter("number", "in", orderSet);
                log.info("\u672c\u6b21\u6d88\u606f\u66f4\u65b0\u7684\u7535\u5546\u8ba2\u5355\u53f7\uff1a" + orderSet);
                DynamicObject[] dyos = BusinessDataServiceHelper.load((String)"pbd_jdorder", (String)"number,jdorderstate,jdorderid", (QFilter[])new QFilter[]{filter});
                if (null == dyos || dyos.length <= 0) {
                    return successOrders;
                }
                log.info("@@@\u83b7\u53d6\u4eac\u4e1c\u5355\u4e2a\u6570" + dyos.length);
                for (DynamicObject bill : dyos) {
                    bill.set("jdorderstate", (Object)"0");
                    orderSet.add(bill.getString("jdorderid"));
                }
                SaveServiceHelper.save((DynamicObject[])dyos);
            } else {
                filter = new QFilter("orderid", "in", orderSet);
                log.info("\u672c\u6b21\u6d88\u606f\u66f4\u65b0\u7684" + sourceTag + "\u8ba2\u5355\u53f7\uff1a" + orderSet);
                String orderMark = MalNewOrderUtils.getPlatformId((String)source);
                DynamicObject[] dyos = BusinessDataServiceHelper.load((String)orderMark, (String)"orderid,orderstate,state", (QFilter[])new QFilter[]{filter});
                if (null == dyos || dyos.length <= 0) {
                    return successOrders;
                }
                log.info("@@@\u83b7\u53d6" + sourceTag + "\u8ba2\u5355\u4e2a\u6570" + dyos.length);
                for (DynamicObject dynamicObject : dyos) {
                    if (source.equalsIgnoreCase(EcPlatformEnum.ECPLATFORM_SUNING.getVal())) {
                        dynamicObject.set("orderstate", (Object)"5");
                    }
                    if (source.equalsIgnoreCase(EcPlatformEnum.ECPLATFORM_XY.getVal()) || source.equalsIgnoreCase(EcPlatformEnum.ECPLATFORM_CG.getVal()) || source.equalsIgnoreCase(EcPlatformEnum.ECPLATFORM_DL.getVal()) || EcPlatformEnum.ECPLATFORM_XFS.getVal().equals(source) || EcPlatformEnum.ECPLATFORM_ZKH.getVal().equals(source)) {
                        dynamicObject.set("orderstate", (Object)"0");
                    }
                    if (!EcPlatformEnum.ECPLATFORM_XFS.getVal().equals(source)) continue;
                    dynamicObject.set("state", (Object)"90");
                }
                SaveServiceHelper.save((DynamicObject[])dyos);
            }
            boolean defaultMalVersion = MalOrderUtil.getDefaultMalVersion();
            QFilter orderfilter = new QFilter("jdorderid", "in", orderSet);
            if (defaultMalVersion && (source.equalsIgnoreCase(EcPlatformEnum.ECPLATFORM_JD.getVal()) || source.equalsIgnoreCase(EcPlatformEnum.ECPLATFORM_JDPRO.getVal()))) {
                orderfilter.or(new QFilter("entryentity.order.number", "in", orderSet));
            }
            if (null == (orders = BusinessDataServiceHelper.load((String)"mal_order", (String)"id,entryentity.entrystatus,entryentity.order,ecorderid.jdorderstate,orderstatus,settleorg,creator,billno,billstatus,jdorderid,entryentity.erpbillstatus,entryentity.erplogstatus,entryentity.erpbillnumber", (QFilter[])new QFilter[]{orderfilter})) || orders.length <= 0) {
                return successOrders;
            }
            DynamicObject[] malOrderArrays = new DynamicObject[1];
            log.info("@@@\u83b7\u53d6\u5546\u57ce\u8ba2\u5355\u4e2a\u6570" + orders.length);
            StringBuilder logString = new StringBuilder();
            HashSet<Long> pbdJDOrderIds = new HashSet<Long>(16);
            for (DynamicObject info : orders) {
                if (!defaultMalVersion || !source.equalsIgnoreCase(EcPlatformEnum.ECPLATFORM_JD.getVal()) && !source.equalsIgnoreCase(EcPlatformEnum.ECPLATFORM_JDPRO.getVal())) continue;
                if (null != info.get("ecorderid")) {
                    pbdJDOrderIds.add(info.getLong("ecorderid.id"));
                }
                DynamicObjectCollection entrys = info.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entrys) {
                    if (null == entry.get("order")) continue;
                    pbdJDOrderIds.add(entry.getLong("order.id"));
                }
            }
            HashMap<Long, DynamicObject> hashMap = new HashMap<Long, DynamicObject>(16);
            if (pbdJDOrderIds.size() > 0) {
                QFilter qFilter = new QFilter("id", "in", pbdJDOrderIds);
                DynamicObjectCollection pbdJdOrders = QueryServiceHelper.query((String)"pbd_jdorder", (String)"id,jdorderstate", (QFilter[])qFilter.toArray());
                for (DynamicObject row : pbdJdOrders) {
                    hashMap.put(row.getLong("id"), row);
                }
            }
            HashSet<Long> needCancelJdOrderId = new HashSet<Long>(16);
            for (DynamicObject object : orders) {
                try {
                    Object entry32;
                    ArrayList<String> orderEntryIds = new ArrayList<String>(16);
                    DynamicObjectCollection entrys = object.getDynamicObjectCollection("entryentity");
                    if ((isCQ || !isallcancelFlag) && defaultMalVersion && (source.equalsIgnoreCase(EcPlatformEnum.ECPLATFORM_JD.getVal()) || source.equalsIgnoreCase(EcPlatformEnum.ECPLATFORM_JDPRO.getVal()))) {
                        Object jdorderstate = "";
                        if (null != object.get("ecorderid") && null != hashMap.get(object.getLong("ecorderid.id"))) {
                            jdorderstate = ((DynamicObject)hashMap.get(object.getLong("ecorderid.id"))).getString("jdorderstate");
                        }
                        if (null != object.get("ecorderid") && orderSet.contains(object.getString("ecorderid.number")) && orderSet.size() > 1) {
                            for (DynamicObject entry : entrys) {
                                String childJdorderNumber;
                                if (null == entry.get("order") || !orderSet.contains(childJdorderNumber = entry.getString("order.number"))) continue;
                                orderEntryIds.add(entry.getString("id"));
                            }
                        }
                        logString.append("orderSet=").append(SerializationUtils.toJsonString(orderSet)).append(System.lineSeparator()).append("orderEntryIds=").append(SerializationUtils.toJsonString(orderEntryIds)).append(System.lineSeparator());
                        for (DynamicObject entry : entrys) {
                            String childJdorderstate = "";
                            if (null != entry.get("order") && null != hashMap.get(entry.getLong("order.id"))) {
                                childJdorderstate = ((DynamicObject)hashMap.get(entry.getLong("order.id"))).getString("jdorderstate");
                            }
                            if (!StringUtils.isEmpty((CharSequence)entry.getString("erpbillnumber")) && ("0".equals(jdorderstate) || "0".equals(childJdorderstate))) {
                                entry.set("erpbillstatus", (Object)"Z");
                                entry.set("erplogstatus", (Object)"");
                                entry.set("entrystatus", (Object)"F");
                            }
                            if (!"0".equals(jdorderstate) && !"0".equals(childJdorderstate)) continue;
                            entry.set("entrystatus", (Object)"F");
                        }
                    } else {
                        for (Object entry32 : entrys) {
                            if (StringUtils.isEmpty((CharSequence)entry32.getString("erpbillnumber"))) continue;
                            entry32.set("erpbillstatus", (Object)"Z");
                            entry32.set("erplogstatus", (Object)"");
                            entry32.set("entrystatus", (Object)"F");
                        }
                    }
                    malOrderArrays[0] = object;
                    boolean isPartCancel = false;
                    entry32 = entrys.iterator();
                    while (entry32.hasNext()) {
                        DynamicObject entry22 = (DynamicObject)entry32.next();
                        if ("F".equals(entry22.getString("entrystatus"))) continue;
                        isPartCancel = true;
                    }
                    if ((isCQ || !isallcancelFlag) && defaultMalVersion && (source.equalsIgnoreCase(EcPlatformEnum.ECPLATFORM_JD.getVal()) || source.equalsIgnoreCase(EcPlatformEnum.ECPLATFORM_JDPRO.getVal()))) {
                        if (!isPartCancel) {
                            object.set("orderstatus", (Object)JDOrderStatusEnum.JDCANCEL.getVal());
                            if (null != object.get("ecorderid")) {
                                needCancelJdOrderId.add(object.getLong("ecorderid.id"));
                            }
                            entry32 = entrys.iterator();
                            while (entry32.hasNext()) {
                                DynamicObject entry;
                                entry = (DynamicObject)entry32.next();
                                if (null == entry.get("order")) continue;
                                needCancelJdOrderId.add(entry.getLong("order.id"));
                            }
                        }
                    } else {
                        object.set("orderstatus", (Object)JDOrderStatusEnum.JDCANCEL.getVal());
                    }
                    SaveServiceHelper.save((DynamicObject[])malOrderArrays);
                    OperateOption option = OperateOption.create();
                    option.setVariableValue("ishasright", String.valueOf(true));
                    option.setVariableValue("isStrict", String.valueOf(false));
                    if (isPartCancel) {
                        option.setVariableValue("entryIds", SerializationUtils.toJsonString(orderEntryIds));
                    }
                    logString.append("orderEntryIds=").append(SerializationUtils.toJsonString(orderEntryIds)).append(System.lineSeparator());
                    option.setVariableValue("closeentryIds", SerializationUtils.toJsonString(orderEntryIds));
                    option.setVariableValue("ismsg", "1");
                    ArrayList<Long> billIds = new ArrayList<Long>(16);
                    billIds.add(object.getLong("id"));
                    OperationResult cancelorderRes = OperationServiceHelper.executeOperate((String)"cancelorder", (String)"mal_order", (Object[])billIds.toArray(new Object[0]), (OperateOption)option);
                    if (!cancelorderRes.isSuccess()) {
                        logString.append("cancelorderRes\uff1a").append(ExceptionUtil.getErrorInfoDetails((List)cancelorderRes.getAllErrorOrValidateInfo()));
                        throw new KDBizException(ExceptionUtil.getErrorInfoDetails((List)cancelorderRes.getAllErrorOrValidateInfo()));
                    }
                    logString.append(ResManager.loadKDString((String)"\u7535\u5546\u8ba2\u5355\u5df2\u5931\u6548\uff0c\u66f4\u65b0\u5546\u57ce\u8ba2\u5355\u7684\u4e0b\u6e38\u8ba2\u5355\u72b6\u6001\u5f00\u59cb\u3002", (String)"MalPlaceOrderUtils_14", (String)"scm-mal-common", (Object[])new Object[0])).append("\n");
                    HashSet<String> malOrderIds = new HashSet<String>(malOrderArrays.length);
                    for (DynamicObject dynamicObject : malOrderArrays) {
                        if (!StringUtils.isNotBlank((CharSequence)dynamicObject.getString("id"))) continue;
                        malOrderIds.add(dynamicObject.getString("id"));
                    }
                    QFilter mainBillfilter = new QFilter("billentry.srcbillid", "in", malOrderIds);
                    HashSet<String> pmOrderNumbers = new HashSet<String>(malOrderArrays.length);
                    if (ApiConfigUtil.hasCQScmConfig() && StringUtils.equalsIgnoreCase((CharSequence)"2", (CharSequence)MalOrderUtil.getBizFlowParam())) {
                        DynamicObject[] purOrderBills = BusinessDataServiceHelper.load((String)"pm_purorderbill", (String)"id,cancelstatus,billno,billentry.srcbillid", (QFilter[])new QFilter[]{mainBillfilter});
                        logString.append(ResManager.loadKDString((String)"\u7535\u5546\u8ba2\u5355\u5df2\u5931\u6548\uff0c\u66f4\u65b0\u5546\u57ce\u4e0b\u6e38\u91c7\u8d2d\u8ba2\u5355\u6570\u91cf: ", (String)"MalPlaceOrderUtils_15", (String)"scm-mal-common", (Object[])new Object[0])).append(purOrderBills.length).append("\n");
                        for (DynamicObject order : purOrderBills) {
                            if (!StringUtils.isNotBlank((CharSequence)order.getString("billno"))) continue;
                            pmOrderNumbers.add(order.getString("billno"));
                        }
                        if (!isPartCancel) {
                            JDOrderUtil.cancelOrder((DynamicObject[])purOrderBills, (String)"cancelstatus", (String)"B", (boolean)true, (String)"2");
                        }
                    }
                    DynamicObjectCollection malOrders = QueryServiceHelper.query((String)"mal_order", (String)"id,billno,entryentity.erpbillnumber", (QFilter[])new QFilter[]{orderfilter});
                    HashSet<String> hashSet = new HashSet<String>(malOrders.size());
                    for (DynamicObject malOrder : malOrders) {
                        if (!StringUtils.isNotBlank((CharSequence)malOrder.getString("entryentity.erpbillnumber"))) continue;
                        hashSet.add(malOrder.getString("entryentity.erpbillnumber"));
                    }
                    if (defaultMalVersion && (source.equalsIgnoreCase(EcPlatformEnum.ECPLATFORM_JD.getVal()) || source.equalsIgnoreCase(EcPlatformEnum.ECPLATFORM_JDPRO.getVal()))) {
                        ArrayList<String> srcEntryIds = new ArrayList<String>(orderEntryIds);
                        if (srcEntryIds.size() > 0) {
                            logString.append("srcEntryIds:").append(SerializationUtils.toJsonString(srcEntryIds)).append(System.lineSeparator());
                            MalPlaceOrderUtils.dealPurorderStatus(srcEntryIds);
                        }
                    } else {
                        QFilter erpFilter = hashSet.size() > 0 ? new QFilter("billno", "in", hashSet) : (pmOrderNumbers.size() > 0 ? new QFilter("billno", "in", pmOrderNumbers) : new QFilter("billno", "=", (Object)"0"));
                        DynamicObject[] purOrders = BusinessDataServiceHelper.load((String)"pur_order", (String)"id,billstatus,billno,cfmstatus,logstatus", (QFilter[])new QFilter[]{erpFilter});
                        logString.append(ResManager.loadKDString((String)"\u7535\u5546\u8ba2\u5355\u5df2\u5931\u6548\uff0c\u66f4\u65b0\u5546\u57ce\u4e0b\u6e38\u4f9b\u5e94\u534f\u540c\u91c7\u8d2d\u8ba2\u5355\u6570\u91cf: ", (String)"MalPlaceOrderUtils_16", (String)"scm-mal-common", (Object[])new Object[0])).append(purOrders.length).append("\n");
                        for (DynamicObject purOrder : purOrders) {
                            purOrder.set("billstatus", (Object)BillStatusEnum.CANCELED.getVal());
                            purOrder.set("cfmstatus", (Object)"");
                            purOrder.set("logstatus", (Object)"");
                            logString.append(ResManager.loadKDString((String)"\u7535\u5546\u8ba2\u5355\u5df2\u5931\u6548\uff0c\u66f4\u65b0\u5546\u57ce\u8ba2\u5355\u7684\u4e0b\u6e38\u8ba2\u5355\u72b6\u6001\u7ed3\u675f\u3002", (String)"MalPlaceOrderUtils_17", (String)"scm-mal-common", (Object[])new Object[0])).append("\n");
                            SaveServiceHelper.save((DynamicObject[])purOrders);
                        }
                    }
                    if (orderSet.size() == 1) {
                        successOrders.add(malOrderArrays[0].getString("jdorderid"));
                    } else {
                        successOrders.clear();
                        successOrders.addAll(orderSet);
                        successOrders.remove(malOrderArrays[0].getString("jdorderid"));
                    }
                    JDOrderUtil.orderInvalidSendMessage((DynamicObject[])malOrderArrays);
                    if ((isCQ || !isallcancelFlag) && orderEntryIds.size() > 0) {
                        MalPlaceOrderUtils.ruturnBudget(object, orderEntryIds);
                    } else {
                        MalPlaceOrderUtils.ruturnBudget(object);
                    }
                    logString.append(ResManager.loadKDString((String)"\u7535\u5546\u8ba2\u5355\u5df2\u5931\u6548\uff0c\u8fd4\u8fd8\u9884\u7b97\u4f59\u989d\uff0c\u8ba2\u5355id:", (String)"MalPlaceOrderUtils_18", (String)"scm-mal-common", (Object[])new Object[0])).append(object.getLong("id")).append("\n");
                }
                catch (Exception exception) {
                    logString.append("malOrderInvalidProcessor fail--->").append(ExceptionUtil.getStackTrace((Throwable)exception)).append(System.lineSeparator());
                }
            }
            if (needCancelJdOrderId.size() > 0) {
                DynamicObject[] dyos;
                QFilter filter2 = new QFilter("id", "in", needCancelJdOrderId);
                for (DynamicObject bill : dyos = BusinessDataServiceHelper.load((String)"pbd_jdorder", (String)"number,jdorderstate,jdorderid", (QFilter[])new QFilter[]{filter2})) {
                    bill.set("jdorderstate", (Object)"0");
                }
                if (dyos.length > 0) {
                    SaveServiceHelper.save((DynamicObject[])dyos);
                }
            }
            log.info(logString.toString());
            return successOrders;
        }
        return new HashSet<String>();
    }

    private static void dealPurorderStatus(Collection<String> srcEntryIds) {
        DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IPurOrderService", (String)"cancelOrderUpdateStatus", (Object[])new Object[]{srcEntryIds});
    }

    private static void ruturnBudget(DynamicObject object, List<String> orderEntryIds) {
        String orderid = String.valueOf(object.getLong("id"));
        for (String entryId : orderEntryIds) {
            MalPlaceOrderUtils.deal\uff32uturnBudgetByEntryId(orderid, entryId);
        }
    }

    private static void deal\uff32uturnBudgetByEntryId(String orderid, String entryId) {
        DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"BgControlService", (String)"releaseBudget", (Object[])new Object[]{"mal_order", orderid, entryId});
    }

    public static void ruturnBudget(DynamicObject object) {
        Long settleorgid = object.getLong("settleorg.id");
        String orderid = String.valueOf(object.getLong("id"));
        DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"BgControlService", (String)"returnBudget", (Object[])new Object[]{"mal_order", orderid, "delete"});
    }

    public static void xyPackageMsgPostProcessor(Map<String, String> orderPackageMap) {
        if (MapUtils.isEmpty(orderPackageMap)) {
            return;
        }
        for (Map.Entry<String, String> map : orderPackageMap.entrySet()) {
            DynamicObject[] dyn;
            Map result;
            String packageId = map.getKey();
            String orderId = map.getValue();
            if (!StringUtils.isNotEmpty((CharSequence)orderId) || MapUtils.isEmpty((Map)(result = EcApiUtil.getXyOrderPackage((String)packageId))) || null == result.get("result") || null == result.get("success") || Boolean.valueOf(result.get("success").toString()).equals(Boolean.FALSE)) continue;
            Map detail = (Map)result.get("result");
            String sendNo = (String)detail.get("deliveryCode");
            List deliveryItems = (List)detail.get("deliveryItems");
            HashSet<String> skus = new HashSet<String>(deliveryItems.size());
            for (Map item : deliveryItems) {
                skus.add(item.get("skuId").toString());
            }
            QFilter idFilter = new QFilter("orderid", "=", (Object)orderId);
            for (DynamicObject entry : dyn = BusinessDataServiceHelper.load((String)"pbd_order_xy", (String)"id,entryentity.goods,entryentity.goods.number,packageid,sendno", (QFilter[])new QFilter[]{idFilter})) {
                DynamicObjectCollection entryentity = entry.getDynamicObjectCollection("entryentity");
                for (DynamicObject dynamicObject : entryentity) {
                    String entrySku = (String)dynamicObject.get("goods.number");
                    if (!StringUtils.isNotBlank((CharSequence)entrySku) || !skus.contains(entrySku)) continue;
                    dynamicObject.set("packageid", (Object)packageId);
                    dynamicObject.set("sendno", (Object)sendNo);
                }
            }
            SaveServiceHelper.save((DynamicObject[])dyn);
        }
    }

    public static QFilter getMaterialFiltersByPurtype(DynamicObject purTypeDyn) {
        if (purTypeDyn == null) {
            return null;
        }
        QFilter filter = null;
        DynamicObject lineType = BusinessDataServiceHelper.loadSingleFromCache((Object)purTypeDyn.getLong("linetype.id"), (String)BD_LINETYPE);
        if (lineType != null) {
            HashSet<Long> serviceAttributeIdSet = new HashSet<Long>(16);
            serviceAttributeIdSet.add((Long)lineType.getDynamicObject("serviceattribute").getPkValue());
            filter = new QFilter("serviceattribute.fbasedataid_id", "in", serviceAttributeIdSet);
        }
        return filter;
    }

    public static Set<Long> getServiceAttrIdSetByMaterial(DynamicObject materialDyn) {
        DynamicObjectCollection serviceAttrCol;
        HashSet<Long> serviceAttrIdSet = new HashSet<Long>();
        if (materialDyn != null && (serviceAttrCol = materialDyn.getDynamicObjectCollection("serviceattribute")) != null && !serviceAttrCol.isEmpty()) {
            serviceAttrCol.forEach(serviceAttr -> {
                DynamicObject serviceAttrDyn = serviceAttr.getDynamicObject("fbasedataid");
                if (serviceAttrDyn != null) {
                    serviceAttrIdSet.add(serviceAttrDyn.getLong("id"));
                }
            });
        }
        return serviceAttrIdSet;
    }
}

