/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import kd.scm.common.ecapi.entity.GoodsInfo;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.MalStatusEnum;
import kd.scm.common.enums.ProductSourceEnum;
import kd.scm.common.enums.StockEnum;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.ParamConfigUtil;
import kd.scm.malcore.enums.MallStatusEnum;
import net.sf.json.JSONObject;

public class MalProductUtil {
    private static final Log log = LogFactory.getLog(MalProductUtil.class);
    public static final String DETAILSELECTFEILDS = "id,number,content,guarantee,packinglist,specification,thumbnail,picture1,picture2,picture3,picture4,centralpurtype,supplier.name,shopprice,taxprice,taxrate,source,mallstatus,unit.id,price,name,model,content_tag,specification_tag";

    public static List<String> checkProdMalStates(List<String> prodIdList) {
        ArrayList<String> prodNumberList = new ArrayList<String>(prodIdList.size());
        ArrayList<String> removeProdNumbers = new ArrayList<String>(prodIdList.size());
        ArrayList prodLongIdList = new ArrayList(prodIdList.size());
        prodIdList.forEach(id -> prodLongIdList.add(Long.valueOf(id.trim())));
        QFilter fiter = new QFilter("goods.id", "in", prodLongIdList);
        DynamicObjectCollection dyoCol = QueryServiceHelper.query((String)"pmm_prodpool", (String)"goods.number,mallstatus", (QFilter[])new QFilter[]{fiter});
        for (DynamicObject dyo : dyoCol) {
            if (!dyo.getString("mallstatus").equals("B") && !prodNumberList.contains(dyo.getString("goods.number"))) {
                prodNumberList.add(dyo.getString("goods.number"));
            }
            if (!dyo.getString("mallstatus").equals("B")) continue;
            removeProdNumbers.add(dyo.getString("goods.number"));
        }
        prodNumberList.removeAll(removeProdNumbers);
        return prodNumberList;
    }

    public static List<String> checkProdSupplierStates(List<String> prodIdList) {
        ArrayList<String> prodNumberList = new ArrayList<String>(prodIdList.size());
        ArrayList<String> removeProdNumbers = new ArrayList<String>(prodIdList.size());
        ArrayList prodLongIdList = new ArrayList(prodIdList.size());
        prodIdList.forEach(id -> prodLongIdList.add(Long.valueOf(id.trim())));
        QFilter fiter = new QFilter("goods.id", "in", prodLongIdList);
        DynamicObjectCollection dyoCol = QueryServiceHelper.query((String)"pmm_prodpool", (String)"goods.number,mallstatus,goods.supplier.mallstatus", (QFilter[])new QFilter[]{fiter});
        for (DynamicObject dyo : dyoCol) {
            if (!"B".equals(dyo.getString("goods.supplier.mallstatus")) && !prodNumberList.contains(dyo.getString("goods.number"))) {
                prodNumberList.add(dyo.getString("goods.number"));
            }
            if (!"B".equals(dyo.getString("goods.supplier.mallstatus"))) continue;
            removeProdNumbers.add(dyo.getString("goods.number"));
        }
        prodNumberList.removeAll(removeProdNumbers);
        return prodNumberList;
    }

    public static List<String> checkProdMalStatesWithSource(List<String> prodIdList) {
        ArrayList<String> prodNumberList = new ArrayList<String>(prodIdList.size());
        ArrayList<Long> idList = new ArrayList<Long>(prodIdList.size());
        ArrayList<String> removeProdNumbers = new ArrayList<String>(prodIdList.size());
        for (String str : prodIdList) {
            idList.add(Long.parseLong(str));
        }
        QFilter fiter = new QFilter("id", "in", idList);
        DynamicObjectCollection dyoCol = QueryServiceHelper.query((String)"pmm_prodpool", (String)"goods.source,goods.number,mallstatus,goods.supplier.mallstatus", (QFilter[])new QFilter[]{fiter});
        for (DynamicObject dyo : dyoCol) {
            if (!(dyo.getString("mallstatus").equals("B") && "B".equals(dyo.getString("goods.supplier.mallstatus")) || prodNumberList.contains(dyo.getString("goods.number")))) {
                prodNumberList.add(dyo.getString("goods.number") + "+" + dyo.getString("goods.source"));
            }
            if (!dyo.getString("mallstatus").equals("B") || !"B".equals(dyo.getString("goods.supplier.mallstatus"))) continue;
            removeProdNumbers.add(dyo.getString("goods.number") + "+" + dyo.getString("goods.source"));
        }
        prodNumberList.removeAll(removeProdNumbers);
        return prodNumberList;
    }

    public static GoodsInfo getProductInfo(DynamicObject dyo) {
        GoodsInfo productInfo = new GoodsInfo();
        productInfo.setProductId(dyo.getString("id"));
        productInfo.setProductNumber(dyo.getString("number"));
        productInfo.setProductImgPath(dyo.getString("thumbnail"));
        productInfo.setProductName(dyo.getString("name"));
        productInfo.setProductModel(dyo.getString("model"));
        productInfo.setShopPrice(dyo.getBigDecimal("shopprice"));
        productInfo.setTaxPrice(dyo.getBigDecimal("taxprice"));
        productInfo.setProductSource(dyo.getString("source"));
        productInfo.setSupplier(dyo.getString("supplier.name"));
        productInfo.setProductSource(ProductSourceEnum.PRODUCTSOURCE_SELF.getVal());
        productInfo.setCategoryNumber(dyo.getString("category.number"));
        productInfo.setCategoryName(dyo.getString("category.name"));
        productInfo.setCentralpurtype(dyo.getString("centralpurtype"));
        return productInfo;
    }

    @Deprecated
    public static GoodsInfo getProductInfo4Detail(JSONObject prodInfoJO) {
        GoodsInfo goodsInfo = new GoodsInfo();
        String lang = RequestContext.get().getLang().toString();
        if (prodInfoJO != null) {
            String content_tag = prodInfoJO.getString("content_tag");
            if (!StringUtils.isEmpty((CharSequence)content_tag)) {
                goodsInfo.setProductDetail(content_tag);
            } else {
                goodsInfo.setProductDetail(prodInfoJO.getString("content"));
            }
            String specification = prodInfoJO.getString("specification_tag");
            if (!StringUtils.isEmpty((CharSequence)specification)) {
                goodsInfo.setSpecification(specification);
            } else {
                goodsInfo.setSpecification(prodInfoJO.getString("specification"));
            }
            goodsInfo.setGuarantee(prodInfoJO.getString("guarantee"));
            goodsInfo.setPackinglist(prodInfoJO.getString("packinglist"));
            goodsInfo.setProductImgPath(prodInfoJO.getString("thumbnail"));
            goodsInfo.setPicture1(prodInfoJO.getString("picture1"));
            goodsInfo.setPicture2(prodInfoJO.getString("picture2"));
            goodsInfo.setPicture3(prodInfoJO.getString("picture3"));
            goodsInfo.setPicture4(prodInfoJO.getString("picture4"));
            goodsInfo.setCentralpurtype(prodInfoJO.getString("centralpurtype"));
            if (!prodInfoJO.getJSONObject("supplier").isNullObject()) {
                if (prodInfoJO.getJSONObject("supplier").getJSONObject("name").containsKey((Object)lang)) {
                    goodsInfo.setSupplier(prodInfoJO.getJSONObject("supplier").getJSONObject("name").getString(lang));
                } else if (prodInfoJO.getJSONObject("supplier").getJSONObject("name").containsKey((Object)"zh_CN")) {
                    goodsInfo.setSupplier(prodInfoJO.getJSONObject("supplier").getJSONObject("name").getString("zh_CN"));
                }
            }
            goodsInfo.setShopPrice(BigDecimal.valueOf(prodInfoJO.getDouble("shopprice")));
            goodsInfo.setTaxPrice(BigDecimal.valueOf(prodInfoJO.getDouble("taxprice")));
            goodsInfo.setTaxRate(BigDecimal.valueOf(prodInfoJO.getDouble("taxrate")));
            goodsInfo.setProductId(prodInfoJO.getString("id"));
            goodsInfo.setProductSource(prodInfoJO.getString("source"));
            goodsInfo.setProductNumber(prodInfoJO.getString("number"));
            goodsInfo.setStockState("mallstatus");
            if (!prodInfoJO.getJSONObject("unit").isNullObject()) {
                goodsInfo.setProductUnitID(prodInfoJO.getJSONObject("unit").getString("id"));
            }
            goodsInfo.setPrice(BigDecimal.valueOf(prodInfoJO.getDouble("price")));
            if (prodInfoJO.getJSONObject("name").containsKey((Object)lang)) {
                goodsInfo.setProductName(prodInfoJO.getJSONObject("name").getString(lang));
            } else if (prodInfoJO.getJSONObject("name").containsKey((Object)"zh_CN")) {
                goodsInfo.setProductName(prodInfoJO.getJSONObject("name").getString("zh_CN"));
            }
            if (prodInfoJO.getJSONObject("model").containsKey((Object)lang)) {
                goodsInfo.setProductModel(prodInfoJO.getJSONObject("model").getString(lang));
            } else if (prodInfoJO.getJSONObject("model").containsKey((Object)"zh_CN")) {
                goodsInfo.setProductModel(prodInfoJO.getJSONObject("model").getString("zh_CN"));
            }
        }
        return goodsInfo;
    }

    public static GoodsInfo getProductInfo4Detail(DataSet prodInfoDs) {
        Iterator rows = prodInfoDs.iterator();
        if (rows.hasNext()) {
            Row row = (Row)rows.next();
            GoodsInfo goodsInfo = new GoodsInfo();
            String content_tag = row.getString("content_tag");
            if (!StringUtils.isEmpty((CharSequence)content_tag)) {
                goodsInfo.setProductDetail(content_tag);
            } else {
                goodsInfo.setProductDetail(row.getString("content"));
            }
            String specification = row.getString("specification_tag");
            if (!StringUtils.isEmpty((CharSequence)specification)) {
                goodsInfo.setSpecification(specification);
            } else {
                goodsInfo.setSpecification(row.getString("specification"));
            }
            goodsInfo.setGuarantee(row.getString("guarantee"));
            goodsInfo.setPackinglist(row.getString("packinglist"));
            goodsInfo.setProductImgPath(row.getString("thumbnail"));
            goodsInfo.setPicture1(row.getString("picture1"));
            goodsInfo.setPicture2(row.getString("picture2"));
            goodsInfo.setPicture3(row.getString("picture3"));
            goodsInfo.setPicture4(row.getString("picture4"));
            goodsInfo.setCentralpurtype(row.getString("centralpurtype"));
            goodsInfo.setSupplier(row.getString("supplier.name"));
            goodsInfo.setShopPrice(row.getBigDecimal("shopprice"));
            goodsInfo.setTaxPrice(row.getBigDecimal("taxprice"));
            goodsInfo.setTaxRate(row.getBigDecimal("taxrate"));
            goodsInfo.setProductId(row.getString("id"));
            goodsInfo.setProductSource(row.getString("source"));
            goodsInfo.setProductNumber(row.getString("number"));
            goodsInfo.setStockState(StockEnum.SALE.getName());
            goodsInfo.setProductUnitID(row.getString("unit.id"));
            goodsInfo.setPrice(row.getBigDecimal("price"));
            goodsInfo.setProductName(row.getString("name"));
            goodsInfo.setProductModel(row.getString("model"));
            goodsInfo.setAttributeMap(MalProductUtil.getGoodsInfoAttr(goodsInfo.getProductId()));
            return goodsInfo;
        }
        return null;
    }

    public static Map<Object, Map<Object, Object>> getGoodsInfoAttr(String goodsInfoId) {
        QFilter idFilter = new QFilter("id", "=", (Object)Long.parseLong(goodsInfoId));
        DynamicObjectCollection prodManageDyoCol = QueryServiceHelper.query((String)"pmm_prodmanage", (String)"prodattributeentry,prodattributeentry.prodattribute prodattributeid,prodattributeentry.prodattribute.name attributename,prodattributeentry.prodattributevalue,prodattributeentry.prodattributevalue.name attributevaluename,prodattributeentry.prodattribute.prodattributegroup prodattributegroupid,prodattributeentry.prodattribute.prodattributegroup.name attributegroupname", (QFilter[])new QFilter[]{idFilter}, (String)"prodattributeentry.seq");
        Map groupMap = prodManageDyoCol.stream().collect(Collectors.groupingBy(e -> e.getString("prodattributegroupid"), LinkedHashMap::new, Collectors.toList()));
        LinkedHashMap<Object, Map<Object, Object>> map = new LinkedHashMap<Object, Map<Object, Object>>(1024);
        for (Map.Entry entry : groupMap.entrySet()) {
            List list = (List)entry.getValue();
            Map attributeMap = list.stream().collect(Collectors.groupingBy(e -> e.getString("prodattributeid"), LinkedHashMap::new, Collectors.toList()));
            LinkedHashMap valueMap = new LinkedHashMap(1024);
            for (Map.Entry attributeEntry : attributeMap.entrySet()) {
                ArrayList<String> attributeValueList = new ArrayList<String>(((List)attributeEntry.getValue()).size());
                for (DynamicObject obj : (List)attributeEntry.getValue()) {
                    attributeValueList.add(obj.getString("attributevaluename"));
                }
                valueMap.put(attributeEntry.getKey(), attributeValueList);
            }
            map.put(entry.getKey(), valueMap);
        }
        return map;
    }

    public static List<String> getListByProperty(DynamicObjectCollection selectedRowsDyObject, String property) {
        ArrayList<String> proList = new ArrayList<String>();
        for (DynamicObject dyObj : selectedRowsDyObject) {
            proList.add(dyObj.getString(property));
        }
        return proList;
    }

    public static boolean isAllNumber(String str) {
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
        return pattern.matcher(str).matches();
    }

    public static boolean HasDigit(String content) {
        boolean flag = false;
        Pattern p = Pattern.compile(".*\\d+.*");
        Matcher m = p.matcher(content);
        if (m.matches()) {
            flag = true;
        }
        return flag;
    }

    public static boolean isContainChinese(String str) {
        Pattern p = Pattern.compile("[\u4e00-\u9fa5]");
        Matcher m = p.matcher(str);
        return m.find();
    }

    public static String formatProdNumber(List<String> prodNumberList) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < prodNumberList.size(); ++i) {
            if (i == prodNumberList.size() - 1) {
                sb.append(prodNumberList.get(i));
                continue;
            }
            sb.append(prodNumberList.get(i)).append(',');
        }
        return sb.toString();
    }

    public static void deleteCartProds(List<Long> goodsList) {
        Long userId = RequestContext.get().getCurrUserId();
        QFilter personFiter = new QFilter("person", "=", (Object)userId);
        if (null != goodsList && goodsList.size() > 0) {
            QFilter filters = new QFilter("goods", "in", goodsList);
            personFiter.and(filters);
        }
        QFilter orgFilter = new QFilter("org", "=", (Object)0L);
        orgFilter.or(new QFilter("org", "=", (Object)RequestContext.get().getOrgId()));
        personFiter.and(orgFilter);
        DynamicObject[] dyobjs = BusinessDataServiceHelper.load((String)"mal_shopcartbill", (String)"id", (QFilter[])personFiter.toArray());
        if (null != dyobjs && dyobjs.length > 0) {
            Object[] pks = new Object[dyobjs.length];
            for (int i = 0; i < dyobjs.length; ++i) {
                pks[i] = dyobjs[i].get("id");
            }
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"mal_shopcartbill");
            DeleteServiceHelper.delete((IDataEntityType)obj.getDataEntityType(), (Object[])pks);
        }
    }

    public static void deleteCartProds4Jd(List<String> goodsList) {
        QFilter[] filters;
        QFilter personFiter = new QFilter("person", "=", (Object)RequestContext.get().getCurrUserId());
        if (null != goodsList && goodsList.size() > 0) {
            QFilter pkFiter = new QFilter("remark", "in", goodsList);
            filters = new QFilter[]{personFiter, pkFiter};
        } else {
            filters = new QFilter[]{personFiter};
        }
        DynamicObject[] dyobjs = BusinessDataServiceHelper.load((String)"mal_shopcartbill", (String)"id", (QFilter[])filters);
        if (null != dyobjs && dyobjs.length > 0) {
            Object[] pks = new Object[dyobjs.length];
            for (int i = 0; i < dyobjs.length; ++i) {
                pks[i] = dyobjs[i].get("id");
            }
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"mal_shopcartbill");
            DeleteServiceHelper.delete((IDataEntityType)obj.getDataEntityType(), (Object[])pks);
        }
    }

    public static Map<String, BigDecimal> getAvailableqty(List<String> goodsList) {
        ArrayList<Long> goodsIdList = new ArrayList<Long>(goodsList.size());
        for (String id : goodsList) {
            if (!StringUtils.isNotEmpty((CharSequence)id)) continue;
            goodsIdList.add(Long.valueOf(id));
        }
        BigDecimal value = BigDecimal.ZERO;
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        String selectFields = "goods,availableqty";
        QFilter goodsidFilter = new QFilter("goods", "in", goodsIdList);
        DynamicObjectCollection dyoCol = QueryServiceHelper.query((String)"pmm_inventory", (String)selectFields, (QFilter[])new QFilter[]{goodsidFilter});
        if (dyoCol != null && dyoCol.size() > 0) {
            for (DynamicObject dyo : dyoCol) {
                String id = dyo.getString("goods");
                value = CommonUtil.getBigDecimalPro((Object)dyo.getString("availableqty"));
                resultMap.put(id, value);
            }
        }
        return resultMap;
    }

    public static Map<String, BigDecimal> getMalProdPrice(List<String> skuList) {
        QFilter filter = new QFilter("number", "in", skuList);
        DynamicObjectCollection goodsDyos = QueryServiceHelper.query((String)"pbd_goods", (String)"id,number,shopprice", (QFilter[])new QFilter[]{filter});
        HashMap<String, BigDecimal> price = new HashMap<String, BigDecimal>();
        for (DynamicObject goodsDyo : goodsDyos) {
            price.put(goodsDyo.getString("number"), goodsDyo.getBigDecimal("shopprice"));
        }
        return price;
    }

    @Deprecated
    public static int getCartNumber() {
        int cartNo = 0;
        Long userId = RequestContext.get().getCurrUserId();
        QFilter filter = new QFilter("person", "=", (Object)userId);
        QFilter orgFilter = new QFilter("org", "=", (Object)0L);
        orgFilter.or(new QFilter("org", "=", (Object)RequestContext.get().getOrgId()));
        filter.and(orgFilter);
        DynamicObjectCollection dyoCol = QueryServiceHelper.query((String)"mal_shopcartbill", (String)"id,qty", (QFilter[])new QFilter[]{filter});
        if (null != dyoCol && dyoCol.size() > 0) {
            for (DynamicObject dyo : dyoCol) {
                cartNo += dyo.getInt("qty");
            }
        }
        return cartNo;
    }

    public static BigDecimal getAvailableqty(String goodsid, String unitid) {
        BigDecimal bigDecimal = BigDecimal.ZERO;
        QFilter goodsidFilter = new QFilter("goods", "=", (Object)Long.parseLong(goodsid));
        QFilter unitidFilter = new QFilter("unit", "=", (Object)Long.parseLong(unitid));
        String selectFields = "availableqty";
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"pmm_inventory", (String)selectFields, (QFilter[])new QFilter[]{goodsidFilter, unitidFilter});
        if (dyn != null) {
            bigDecimal = CommonUtil.getBigDecimalPro((Object)dyn.getString("availableqty"));
        }
        return bigDecimal;
    }

    public static boolean isMalBizConfigExist() {
        QFilter enablefilter = new QFilter("enable", "=", (Object)"1");
        QFilter statusfilter = new QFilter("status", "=", (Object)"C");
        DynamicObject dyo = BusinessDataServiceHelper.loadSingleFromCache((String)"pmm_bizconfig", (QFilter[])new QFilter[]{enablefilter, statusfilter});
        if (null != dyo) {
            return true;
        }
        DynamicObjectCollection dyoCol = QueryServiceHelper.query((String)"pmm_bizconfig", (String)"id", (QFilter[])new QFilter[]{enablefilter, statusfilter}, (String)"entryentity.price asc");
        return null != dyoCol && dyoCol.size() > 0;
    }

    public static Map<String, String> saveJdGoods(List<String> skusList, Map<String, String> nameMap, Map<String, String> imgMap) {
        QFilter allFilter;
        DynamicObjectCollection dyoCol;
        HashMap<String, String> skuId = new HashMap<String, String>();
        ArrayList<String> needSaveSkusList = new ArrayList<String>(skusList);
        QFilter filter = new QFilter("number", "in", skusList).and(new QFilter("source", "=", (Object)EcPlatformEnum.ECPLATFORM_JD.getVal()));
        DynamicObjectCollection existDyoCol = QueryServiceHelper.query((String)"pbd_goods", (String)"id,number", (QFilter[])new QFilter[]{filter});
        if (existDyoCol != null && existDyoCol.size() > 0) {
            for (DynamicObject dyo : existDyoCol) {
                String number = dyo.getString("number");
                needSaveSkusList.remove(number);
            }
        }
        if (needSaveSkusList.size() > 0) {
            Object[] prods = new DynamicObject[needSaveSkusList.size()];
            DynamicObject prod = new DynamicObject();
            for (int i = 0; i < needSaveSkusList.size(); ++i) {
                prod = BusinessDataServiceHelper.newDynamicObject((String)"pbd_goods");
                Long supplier = Long.valueOf("486095512240421888");
                String number = (String)needSaveSkusList.get(i);
                prod.set("number", (Object)number);
                prod.set("name", (Object)nameMap.get(number));
                prod.set("thumbnail", (Object)imgMap.get(number));
                prod.set("supplier_id", (Object)supplier);
                String jdUnit = MalOrderUtil.getJDUnit();
                if (StringUtils.isNotBlank((CharSequence)jdUnit)) {
                    prod.set("unit_id", (Object)jdUnit);
                } else {
                    prod.set("unit_id", (Object)"11");
                }
                prod.set("curr_id", (Object)"1");
                prod.set("origin", (Object)1);
                prod.set("status", (Object)"C");
                prod.set("enable", (Object)"1");
                prod.set("source", (Object)"2");
                prod.set("mallStatus", (Object)MalStatusEnum.B.getVal());
                prods[i] = prod;
            }
            SaveServiceHelper.save((IDataEntityType)prod.getDataEntityType(), (Object[])prods);
        }
        if ((dyoCol = QueryServiceHelper.query((String)"pbd_goods", (String)"id,number", (QFilter[])new QFilter[]{allFilter = new QFilter("number", "in", skusList).and(new QFilter("source", "=", (Object)EcPlatformEnum.ECPLATFORM_JD.getVal()))})) != null && dyoCol.size() > 0) {
            for (DynamicObject dyo : dyoCol) {
                skuId.put(dyo.getString("number"), dyo.getString("id"));
            }
        }
        return skuId;
    }

    public static Map<String, String> getRecieptInfo(String addresId) {
        HashMap<String, String> recieptMap = new HashMap<String, String>();
        Long userId = RequestContext.get().getCurrUserId();
        QFilter idFilter = new QFilter("id", "=", (Object)Long.valueOf(addresId));
        QFilter creatorFilter = new QFilter("creator", "=", (Object)userId);
        String selectFields = "id,name,phone,wholeaddress,email,mapaddress,postalcode,jdaddressnum,address";
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"mal_address", (String)selectFields, (QFilter[])new QFilter[]{idFilter, creatorFilter});
        if (dynamicObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7528\u6237\u5730\u5740\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u7ef4\u62a4\u5730\u5740\u3002", (String)"MalProductUtil_0", (String)"scm-mal-common", (Object[])new Object[0]));
        }
        recieptMap.put("receiptname", dynamicObject.getString("name"));
        recieptMap.put("receiptphone", dynamicObject.getString("phone"));
        recieptMap.put("receiptemail", dynamicObject.getString("email"));
        recieptMap.put("receiptAddr", dynamicObject.getString("mapaddress"));
        recieptMap.put("receiptzip", dynamicObject.getString("postalcode"));
        recieptMap.put("receiptjdadress", dynamicObject.getString("jdaddressnum"));
        recieptMap.put("admindivisionId", dynamicObject.getString("address"));
        return recieptMap;
    }

    public static String contactProdNumber(String name, String number) {
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        if (ParamConfigUtil.getCacheBooleanParamConfig((String)"showgoodsnumber").booleanValue()) {
            sb.append(ResManager.loadKDString((String)"\uff08\u5546\u54c1\u7f16\u7801\uff1a{0}\uff09", (String)"MalProductUtil_1", (String)"scm-mal-common", (Object[])new Object[]{number}));
        }
        return sb.toString();
    }

    public static List<DynamicObject> getProdPools(QFilter[] qFilters, String selectors) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!selectors.contains("isgoodvisible")) {
            stringBuilder.append("isgoodvisible").append(',');
        }
        if (!selectors.contains("entryentity.orgname")) {
            stringBuilder.append("entryentity.orgname").append(',');
        }
        stringBuilder.append(selectors);
        DynamicObjectCollection pmmProdpools = QueryServiceHelper.query((String)"pmm_prodpool", (String)stringBuilder.toString(), (QFilter[])qFilters);
        long orgId = RequestContext.get().getOrgId();
        ArrayList<DynamicObject> infos = new ArrayList<DynamicObject>(1024);
        for (DynamicObject prodpool : pmmProdpools) {
            long org = prodpool.getLong("entryentity.orgname");
            boolean isgoodvisible = prodpool.getBoolean("isgoodvisible");
            if (isgoodvisible) {
                infos.add(prodpool);
                continue;
            }
            if (org != orgId) continue;
            infos.add(prodpool);
        }
        return infos;
    }

    public static List<DynamicObject> getProdPools(QFilter[] qFilters, String selectors, boolean isChaeckOrg) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!selectors.contains("isgoodvisible")) {
            stringBuilder.append("isgoodvisible").append(',');
        }
        if (!selectors.contains("entryentity.orgname")) {
            stringBuilder.append("entryentity.orgname").append(',');
        }
        stringBuilder.append(selectors);
        DynamicObjectCollection pmmProdpools = QueryServiceHelper.query((String)"pmm_prodpool", (String)stringBuilder.toString(), (QFilter[])qFilters);
        long orgId = RequestContext.get().getOrgId();
        ArrayList<DynamicObject> infos = new ArrayList<DynamicObject>(1024);
        for (DynamicObject prodpool : pmmProdpools) {
            long org = prodpool.getLong("entryentity.orgname");
            boolean isgoodvisible = prodpool.getBoolean("isgoodvisible");
            if (isChaeckOrg) {
                if (isgoodvisible) {
                    infos.add(prodpool);
                    continue;
                }
                if (org != orgId) continue;
                infos.add(prodpool);
                continue;
            }
            infos.add(prodpool);
        }
        return infos;
    }

    public static List<Long> getProdIdsByOrg(List<Long> prodIds, Long orgId) {
        QFilter qFilter = new QFilter("mallstatus", "=", (Object)MallStatusEnum.SOLD.getVal());
        qFilter.and(new QFilter("goods.id", "in", prodIds));
        DynamicObjectCollection pmmProdpools = QueryServiceHelper.query((String)"pmm_prodpool", (String)"goods.number,goods.id,isgoodvisible,entryentity.orgname,id", (QFilter[])qFilter.toArray());
        ArrayList<Long> infoIds = new ArrayList<Long>(1024);
        for (DynamicObject prodpool : pmmProdpools) {
            long org = prodpool.getLong("entryentity.orgname");
            boolean isgoodvisible = prodpool.getBoolean("isgoodvisible");
            if (isgoodvisible) {
                infoIds.add(prodpool.getLong("goods.id"));
                continue;
            }
            if (org != orgId) continue;
            infoIds.add(prodpool.getLong("goods.id"));
        }
        return infoIds;
    }

    public static Boolean setMsgView(IFormView view, List<Long> prodLongIDs, String option) {
        Map<String, String> msgMap = MalProductUtil.checkProdStatusAndOrg(prodLongIDs, option, RequestContext.get().getOrgId());
        boolean isView = MalProductUtil.getIsView(view, msgMap);
        return isView;
    }

    public static Boolean setMsgView(IFormView view, List<Long> prodLongIDs, String option, Long orgId) {
        log.info("orgId=" + orgId);
        Map<String, String> msgMap = MalProductUtil.checkProdStatusAndOrg(prodLongIDs, option, orgId);
        boolean isView = MalProductUtil.getIsView(view, msgMap);
        return isView;
    }

    private static boolean getIsView(IFormView view, Map<String, String> msgMap) {
        boolean isView = false;
        if (msgMap.size() > 0) {
            String title = "";
            String detail = "";
            for (Map.Entry<String, String> map : msgMap.entrySet()) {
                title = map.getKey();
                detail = map.getValue();
            }
            if (detail.isEmpty()) {
                view.showMessage(title);
            } else {
                view.showMessage(title, detail, MessageTypes.Default);
            }
            isView = true;
        }
        return isView;
    }

    public static Map<String, String> checkProdStatusAndOrg(List<Long> prodIds, String option, Long orgId) {
        HashMap<String, String> msgMap = new HashMap<String, String>(1024);
        QFilter qFilter = new QFilter("goods.id", "in", prodIds);
        qFilter.and(new QFilter("goods.source", "=", (Object)EcPlatformEnum.ECPLATFORM_SELF.getVal()));
        String selectors = "entryentity.orgname,protocol.purmode,mallstatus,goods.number,goods.name,goods.id,isgoodvisible";
        DynamicObjectCollection pmmProdpools = QueryServiceHelper.query((String)"pmm_prodpool", (String)selectors, (QFilter[])qFilter.toArray());
        QFilter prodQFilter = new QFilter("id", "in", prodIds);
        prodQFilter.and(new QFilter("source", "=", (Object)EcPlatformEnum.ECPLATFORM_SELF.getVal()));
        prodQFilter.and(new QFilter("status", "!=", (Object)"C"));
        DynamicObjectCollection pmmProds = QueryServiceHelper.query((String)"pmm_prodmanage", (String)"id,number", (QFilter[])prodQFilter.toArray());
        HashMap<Long, String> prodStatus_numberMap = new HashMap<Long, String>(1024);
        for (DynamicObject prod : pmmProds) {
            Long id = prod.getLong("id");
            String number = prod.getString("number");
            prodStatus_numberMap.put(id, number);
        }
        HashSet<Object> statusProdSet = new HashSet<Object>(1024);
        HashMap<Object, HashSet<Long>> orgIdMap = new HashMap<Object, HashSet<Long>>(1024);
        HashMap<Long, String> prod_numberMap = new HashMap<Long, String>(1024);
        for (DynamicObject prodpool : pmmProdpools) {
            Long id = prodpool.getLong("goods.id");
            String number = prodpool.getString("goods.number");
            String name = prodpool.getString("goods.name");
            String mallstatus = prodpool.getString("mallstatus");
            prod_numberMap.put(id, number + id + name);
            if (!"B".equals(mallstatus)) continue;
            statusProdSet.add(id);
            long org = prodpool.getLong("entryentity.orgname");
            boolean isgoodvisible = prodpool.getBoolean("isgoodvisible");
            HashSet<Long> orgIdSet = (HashSet<Long>)orgIdMap.get(id);
            if (null == orgIdSet) {
                orgIdSet = new HashSet<Long>(1024);
            }
            if (isgoodvisible) {
                orgIdSet.add(orgId);
            } else if (org == orgId) {
                orgIdSet.add(orgId);
            }
            orgIdMap.put(id, orgIdSet);
        }
        if (prodIds.size() == 1 && prod_numberMap.size() > 0) {
            Set orgIdSet;
            if (orgIdMap.containsKey(prodIds.get(0)) && !(orgIdSet = (Set)orgIdMap.get(prodIds.get(0))).contains(orgId)) {
                String msg = MalProductUtil.getOrgErrMsg(option, false);
                msgMap.put(msg, "");
                return msgMap;
            }
            if (statusProdSet.size() == 0 || prodStatus_numberMap.size() > 0) {
                String msg = MalProductUtil.getProdStatusErrMsg(option, false);
                msgMap.put(msg, "");
                return msgMap;
            }
        } else {
            String msg;
            HashSet<Long> needCheckStatusProdSet = new HashSet<Long>(1024);
            HashSet<Long> needCheckOrgProdSet = new HashSet<Long>(1024);
            for (Long prodId : prodIds) {
                Set orgIdSet;
                if (!statusProdSet.contains(prodId) && prod_numberMap.containsKey(prodId) || prodStatus_numberMap.containsKey(prodId)) {
                    needCheckStatusProdSet.add(prodId);
                }
                if (null == (orgIdSet = (Set)orgIdMap.get(prodId)) || orgIdSet.contains(orgId) || !prod_numberMap.containsKey(prodId)) continue;
                needCheckOrgProdSet.add(prodId);
            }
            if (needCheckOrgProdSet.size() > 0 && needCheckOrgProdSet.size() <= prodIds.size()) {
                msg = MalProductUtil.getOrgErrMsg(option, true);
                msgMap.put(msg, MalProductUtil.getMsgDetail(needCheckOrgProdSet, prod_numberMap));
                return msgMap;
            }
            if (needCheckStatusProdSet.size() > 0 && needCheckStatusProdSet.size() <= prodIds.size() || prodStatus_numberMap.size() > 0) {
                msg = MalProductUtil.getProdStatusErrMsg(option, true);
                prod_numberMap.putAll(prodStatus_numberMap);
                msgMap.put(msg, MalProductUtil.getMsgDetail(needCheckStatusProdSet, prod_numberMap));
                return msgMap;
            }
        }
        return msgMap;
    }

    private static String getTempMegDetail(DynamicObjectCollection pmmProdpools, List<Long> prodIds) {
        if (prodIds.size() > 1) {
            HashSet<Long> prodIdsClone = new HashSet<Long>(prodIds.size());
            prodIdsClone.addAll(prodIds);
            Set existIds = pmmProdpools.stream().map(k -> k.getLong("goods.id")).collect(Collectors.toSet());
            prodIdsClone.removeAll(existIds);
            QFilter qFilter = new QFilter("id", "in", prodIdsClone);
            DynamicObjectCollection goods = QueryServiceHelper.query((String)"pmm_prodmanage", (String)"id,number", (QFilter[])qFilter.toArray());
            Map<Long, String> prod_numberMap = goods.stream().collect(Collectors.toMap(k -> k.getLong("id"), k -> k.getString("number")));
            return MalProductUtil.getMsgDetail(prodIdsClone, prod_numberMap);
        }
        return "";
    }

    private static String getMsgDetail(Set<Long> needCheckStatusProdSet, Map<Long, String> prod_numberMap) {
        StringBuilder stringBuilder = new StringBuilder();
        String title = ResManager.loadKDString((String)"\u5546\u54c1\u7f16\u7801", (String)"MalProductUtil_2", (String)"scm-mal-common", (Object[])new Object[0]);
        String name = ResManager.loadKDString((String)"\u5546\u54c1\u540d\u79f0", (String)"MalProductUtil_3", (String)"scm-mal-common", (Object[])new Object[0]);
        for (Long prodId : needCheckStatusProdSet) {
            String[] keys = prod_numberMap.get(prodId).split(String.valueOf(prodId));
            stringBuilder.append(title).append(':').append(keys[0]).append("     ").append(name).append(':').append(keys[1]).append("\n");
        }
        return stringBuilder.toString();
    }

    private static String getOrgErrMsg(String option, boolean isBatch) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ResManager.loadKDString((String)"\u90e8\u5206", (String)"MalProductUtil_19", (String)"scm-mal-common", (Object[])new Object[0]));
        String msg = "";
        switch (option) {
            case "addcart": {
                msg = ResManager.loadKDString((String)"\u5546\u54c1\u5728\u5f53\u524d\u7ec4\u7ec7\u4e2d\u4e0d\u53ef\u552e\uff0c\u65e0\u6cd5\u52a0\u5165\u8d2d\u7269\u8f66\uff0c\u8bf7\u8054\u7cfb\u4f01\u4e1a\u91c7\u8d2d\u8fd0\u8425\u4e13\u5458\u5904\u7406\u3002", (String)"MalProductUtil_21", (String)"scm-mal-common", (Object[])new Object[0]);
                break;
            }
            case "addpurscheme": {
                msg = ResManager.loadKDString((String)"\u5546\u54c1\u5728\u5f53\u524d\u7ec4\u7ec7\u4e2d\u4e0d\u53ef\u552e\uff0c\u65e0\u6cd5\u52a0\u5165\u91c7\u8d2d\u65b9\u6848\uff0c\u8bf7\u8054\u7cfb\u4f01\u4e1a\u91c7\u8d2d\u8fd0\u8425\u4e13\u5458\u5904\u7406\u3002", (String)"MalProductUtil_22", (String)"scm-mal-common", (Object[])new Object[0]);
                break;
            }
            case "addcompare": {
                msg = ResManager.loadKDString((String)"\u5546\u54c1\u5728\u5f53\u524d\u7ec4\u7ec7\u4e2d\u4e0d\u53ef\u552e\uff0c\u65e0\u6cd5\u52a0\u5165\u5bf9\u6bd4\uff0c\u8bf7\u8054\u7cfb\u4f01\u4e1a\u91c7\u8d2d\u8fd0\u8425\u4e13\u5458\u5904\u7406\u3002", (String)"MalProductUtil_23", (String)"scm-mal-common", (Object[])new Object[0]);
                break;
            }
            case "settle": {
                msg = ResManager.loadKDString((String)"\u5546\u54c1\u5728\u5f53\u524d\u7ec4\u7ec7\u4e2d\u4e0d\u53ef\u552e\uff0c\u65e0\u6cd5\u4e0b\u5355\uff0c\u8bf7\u8054\u7cfb\u4f01\u4e1a\u91c7\u8d2d\u8fd0\u8425\u4e13\u5458\u5904\u7406\u3002", (String)"MalProductUtil_24", (String)"scm-mal-common", (Object[])new Object[0]);
                break;
            }
            case "compare": {
                msg = ResManager.loadKDString((String)"\u5546\u54c1\u5728\u5f53\u524d\u7ec4\u7ec7\u4e2d\u4e0d\u53ef\u552e\uff0c\u65e0\u6cd5\u5bf9\u6bd4\uff0c\u8bf7\u8054\u7cfb\u4f01\u4e1a\u91c7\u8d2d\u8fd0\u8425\u4e13\u5458\u5904\u7406\u3002", (String)"MalProductUtil_25", (String)"scm-mal-common", (Object[])new Object[0]);
                break;
            }
            case "addpurchase": {
                msg = ResManager.loadKDString((String)"\u5546\u54c1\u5728\u5f53\u524d\u7ec4\u7ec7\u4e2d\u4e0d\u53ef\u552e\uff0c\u65e0\u6cd5\u52a0\u5165\u9009\u8d2d\uff0c\u8bf7\u8054\u7cfb\u4f01\u4e1a\u91c7\u8d2d\u8fd0\u8425\u4e13\u5458\u5904\u7406\u3002", (String)"MalProductUtil_26", (String)"scm-mal-common", (Object[])new Object[0]);
                break;
            }
            case "makeorder": {
                msg = ResManager.loadKDString((String)"\u5546\u54c1\u5728\u5f53\u524d\u7ec4\u7ec7\u4e2d\u4e0d\u53ef\u552e\uff0c\u65e0\u6cd5\u63d0\u4ea4\u8ba2\u5355\uff0c\u8bf7\u8054\u7cfb\u4f01\u4e1a\u91c7\u8d2d\u8fd0\u8425\u4e13\u5458\u5904\u7406\u3002", (String)"MalProductUtil_27", (String)"scm-mal-common", (Object[])new Object[0]);
                break;
            }
            case "quickmake": {
                msg = ResManager.loadKDString((String)"\u5546\u54c1\u5728\u5f53\u524d\u7ec4\u7ec7\u4e2d\u4e0d\u53ef\u552e\uff0c\u65e0\u6cd5\u4e0b\u5355\uff0c\u8bf7\u8054\u7cfb\u4f01\u4e1a\u91c7\u8d2d\u8fd0\u8425\u4e13\u5458\u5904\u7406\u3002", (String)"MalProductUtil_24", (String)"scm-mal-common", (Object[])new Object[0]);
            }
        }
        msg = MalProductUtil.getBatchMsg(isBatch, stringBuilder, msg);
        return msg;
    }

    private static String getBatchMsg(boolean isBatch, StringBuilder stringBuilder, String msg) {
        if (isBatch) {
            msg = stringBuilder.append(msg).toString();
        }
        return msg;
    }

    private static String getProdStatusErrMsg(String option, boolean isBatch) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ResManager.loadKDString((String)"\u90e8\u5206", (String)"MalProductUtil_19", (String)"scm-mal-common", (Object[])new Object[0]));
        String msg = "";
        switch (option) {
            case "addcart": {
                msg = ResManager.loadKDString((String)"\u5546\u54c1\u5df2\u4e0b\u67b6\uff0c\u65e0\u6cd5\u52a0\u5165\u8d2d\u7269\u8f66\uff0c\u8bf7\u8054\u7cfb\u4f01\u4e1a\u91c7\u8d2d\u8fd0\u8425\u4e13\u5458\u5904\u7406\u3002", (String)"MalProductUtil_28", (String)"scm-mal-common", (Object[])new Object[0]);
                break;
            }
            case "addpurscheme": {
                msg = ResManager.loadKDString((String)"\u5546\u54c1\u5df2\u4e0b\u67b6\uff0c\u65e0\u6cd5\u52a0\u5165\u91c7\u8d2d\u65b9\u6848\uff0c\u8bf7\u8054\u7cfb\u4f01\u4e1a\u91c7\u8d2d\u8fd0\u8425\u4e13\u5458\u5904\u7406\u3002", (String)"MalProductUtil_29", (String)"scm-mal-common", (Object[])new Object[0]);
                break;
            }
            case "addcompare": {
                msg = ResManager.loadKDString((String)"\u5546\u54c1\u5df2\u4e0b\u67b6\uff0c\u65e0\u6cd5\u52a0\u5165\u5bf9\u6bd4\uff0c\u8bf7\u8054\u7cfb\u4f01\u4e1a\u91c7\u8d2d\u8fd0\u8425\u4e13\u5458\u5904\u7406\u3002", (String)"MalProductUtil_30", (String)"scm-mal-common", (Object[])new Object[0]);
                break;
            }
            case "settle": {
                msg = ResManager.loadKDString((String)"\u5546\u54c1\u5df2\u4e0b\u67b6\uff0c\u65e0\u6cd5\u4e0b\u5355\uff0c\u8bf7\u8054\u7cfb\u4f01\u4e1a\u91c7\u8d2d\u8fd0\u8425\u4e13\u5458\u5904\u7406\u3002", (String)"MalProductUtil_17", (String)"scm-mal-common", (Object[])new Object[0]);
                break;
            }
            case "compare": {
                msg = ResManager.loadKDString((String)"\u5546\u54c1\u5df2\u4e0b\u67b6\uff0c\u65e0\u6cd5\u5bf9\u6bd4\uff0c\u8bf7\u8054\u7cfb\u4f01\u4e1a\u91c7\u8d2d\u8fd0\u8425\u4e13\u5458\u5904\u7406\u3002", (String)"MalProductUtil_32", (String)"scm-mal-common", (Object[])new Object[0]);
                break;
            }
            case "addpurchase": {
                msg = ResManager.loadKDString((String)"\u5546\u54c1\u5df2\u4e0b\u67b6\uff0c\u65e0\u6cd5\u52a0\u5165\u9009\u8d2d\uff0c\u8bf7\u8054\u7cfb\u4f01\u4e1a\u91c7\u8d2d\u8fd0\u8425\u4e13\u5458\u5904\u7406\u3002", (String)"MalProductUtil_16", (String)"scm-mal-common", (Object[])new Object[0]);
                break;
            }
            case "makeorder": {
                msg = ResManager.loadKDString((String)"\u5546\u54c1\u5df2\u4e0b\u67b6\uff0c\u65e0\u6cd5\u4e0b\u5355\uff0c\u8bf7\u8054\u7cfb\u4f01\u4e1a\u91c7\u8d2d\u8fd0\u8425\u4e13\u5458\u5904\u7406\u3002", (String)"MalProductUtil_17", (String)"scm-mal-common", (Object[])new Object[0]);
                break;
            }
            case "quickmake": {
                msg = ResManager.loadKDString((String)"\u5546\u54c1\u5df2\u4e0b\u67b6\uff0c\u65e0\u6cd5\u4e0b\u5355,\u8bf7\u8054\u7cfb\u4f01\u4e1a\u91c7\u8d2d\u8fd0\u8425\u4e13\u5458\u5904\u7406\u3002", (String)"MalProductUtil_18", (String)"scm-mal-common", (Object[])new Object[0]);
            }
        }
        msg = MalProductUtil.getBatchMsg(isBatch, stringBuilder, msg);
        return msg;
    }

    public static String getSalesDesc(BigDecimal sales) {
        String wan = ResManager.loadKDString((String)"\u4e07+", (String)"MalProductUtil_20", (String)"scm-mal-common", (Object[])new Object[0]);
        if (sales.compareTo(new BigDecimal("1000")) < 0) {
            return sales.stripTrailingZeros().toPlainString();
        }
        if (sales.compareTo(new BigDecimal("2000")) < 0) {
            return "1000+";
        }
        if (sales.compareTo(new BigDecimal("3000")) < 0) {
            return "2000+";
        }
        if (sales.compareTo(new BigDecimal("4000")) < 0) {
            return "3000+";
        }
        if (sales.compareTo(new BigDecimal("5000")) < 0) {
            return "4000+";
        }
        if (sales.compareTo(new BigDecimal("6000")) < 0) {
            return "5000+";
        }
        if (sales.compareTo(new BigDecimal("7000")) < 0) {
            return "6000+";
        }
        if (sales.compareTo(new BigDecimal("8000")) < 0) {
            return "7000+";
        }
        if (sales.compareTo(new BigDecimal("9000")) < 0) {
            return "8000+";
        }
        if (sales.compareTo(new BigDecimal("10000")) < 0) {
            return "9000+";
        }
        if (sales.compareTo(new BigDecimal("20000")) < 0) {
            return "1" + wan;
        }
        if (sales.compareTo(new BigDecimal("30000")) < 0) {
            return "2" + wan;
        }
        if (sales.compareTo(new BigDecimal("40000")) < 0) {
            return "3" + wan;
        }
        if (sales.compareTo(new BigDecimal("50000")) < 0) {
            return "4" + wan;
        }
        if (sales.compareTo(new BigDecimal("60000")) < 0) {
            return "5" + wan;
        }
        if (sales.compareTo(new BigDecimal("70000")) < 0) {
            return "6" + wan;
        }
        if (sales.compareTo(new BigDecimal("80000")) < 0) {
            return "7" + wan;
        }
        if (sales.compareTo(new BigDecimal("90000")) < 0) {
            return "8" + wan;
        }
        if (sales.compareTo(new BigDecimal("100000")) < 0) {
            return "9" + wan;
        }
        return "10" + wan;
    }

    public static Map<Long, String> getGoodsId2PlatformMap(List<Long> goodsIds) {
        HashMap<Long, String> res = new HashMap<Long, String>();
        DynamicObjectCollection prodPoolsDyns = MalProductUtil.getGoodsDyns(goodsIds);
        for (DynamicObject prodPoolDyn : prodPoolsDyns) {
            res.put(prodPoolDyn.getLong("id"), prodPoolDyn.getString("source"));
        }
        if (goodsIds.size() > res.size()) {
            DynamicObjectCollection ecGoodsDyns = MalProductUtil.queryMallGoods(new HashSet<Long>(goodsIds));
            for (DynamicObject ecGoodsDyn : ecGoodsDyns) {
                res.put(ecGoodsDyn.getLong("id"), ecGoodsDyn.getString("source"));
            }
        }
        return res;
    }

    private static DynamicObjectCollection getGoodsDyns(List<Long> goodsIds) {
        String selectFields = "id,source";
        QFilter filter = new QFilter("id", "in", goodsIds);
        return QueryServiceHelper.query((String)"pmm_prodmanage", (String)selectFields, (QFilter[])new QFilter[]{filter});
    }

    private static DynamicObjectCollection queryMallGoods(Set<Long> nonSyncGoodsIdSet) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(3);
        filters.add(new QFilter("status", "=", (Object)BillStatusEnum.AUDIT.getVal()));
        filters.add(new QFilter("enable", "=", (Object)"1"));
        filters.add(new QFilter("id", "in", nonSyncGoodsIdSet));
        String selectFields = "id,number,name,mainpic,source,model,group,group.number,group.name,unitid,brandid,createtime,barcode";
        return QueryServiceHelper.query((String)"pbd_mallgoods", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]));
    }

    public static Map<BigDecimal, Long> getTaxrate2TaxrateIdMap() {
        HashMap<BigDecimal, Long> res = new HashMap<BigDecimal, Long>(32);
        QFilter tqfilter = new QFilter("taxcategoryid.number", "=", (Object)"001");
        Map taxrateMap = BusinessDataServiceHelper.loadFromCache((String)"bd_taxrate", (String)"id,number,name,taxrate", (QFilter[])new QFilter[]{tqfilter}, (String)"issystem");
        for (DynamicObject taxrateDyn : taxrateMap.values()) {
            res.put(taxrateDyn.getBigDecimal("taxrate").stripTrailingZeros(), taxrateDyn.getLong("id"));
        }
        return res;
    }

    public static String getPictureUrl(String pictureUrl) {
        if (StringUtils.isEmpty((CharSequence)pictureUrl) || pictureUrl.contains("http") || pictureUrl.contains("https")) {
            return pictureUrl;
        }
        return UrlService.getImageFullUrl((String)pictureUrl);
    }

    public static DynamicObject[] syncEcGoodsToGoodsManage(Set<Long> goodsIdSet) {
        log.info("syncToGoodsManage goodsIdSet:" + goodsIdSet);
        if (goodsIdSet.isEmpty()) {
            return new DynamicObject[0];
        }
        Set<Long> nonSyncGoodsIdSet = MalProductUtil.filterNonSyncGoodsIds(goodsIdSet);
        Map<Long, DynamicObject> id2GoodsManageMap = MalProductUtil.covertEcGoodsToProdManage(goodsIdSet);
        if (!id2GoodsManageMap.isEmpty()) {
            ArrayList<DynamicObject> updateGoodsDyns = new ArrayList<DynamicObject>(goodsIdSet.size());
            ArrayList<DynamicObject> saveGoodsDyns = new ArrayList<DynamicObject>(goodsIdSet.size());
            for (DynamicObject goodsDyn : id2GoodsManageMap.values()) {
                if (nonSyncGoodsIdSet.contains(goodsDyn.getLong("id"))) {
                    saveGoodsDyns.add(goodsDyn);
                    continue;
                }
                updateGoodsDyns.add(goodsDyn);
            }
            if (!updateGoodsDyns.isEmpty()) {
                SaveServiceHelper.update((DynamicObject[])updateGoodsDyns.toArray(new DynamicObject[0]));
            }
            if (!saveGoodsDyns.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])saveGoodsDyns.toArray(new DynamicObject[0]));
            }
            log.info("success.save:{0},update:{1}", (Object)saveGoodsDyns.size(), (Object)updateGoodsDyns.size());
            return id2GoodsManageMap.values().toArray(new DynamicObject[0]);
        }
        return null;
    }

    public static Map<Long, DynamicObject> covertEcGoodsToProdManage(Set<Long> goodsIdSet) {
        if (goodsIdSet.isEmpty()) {
            return new HashMap<Long, DynamicObject>();
        }
        DynamicObjectCollection ecGoodsCol = MalProductUtil.queryMallGoods(goodsIdSet);
        HashMap<Long, DynamicObject> res = new HashMap<Long, DynamicObject>(goodsIdSet.size() << 2);
        Map<String, DynamicObject> runningAuthDyos = MalProductUtil.getRunningAuthDyos();
        for (DynamicObject ecGoods : ecGoodsCol) {
            DynamicObject authDyo = runningAuthDyos.get(ecGoods.getString("source"));
            if (authDyo == null) continue;
            DynamicObject prod = MalProductUtil.convertEcGoodsToProdManage(ecGoods, authDyo);
            res.put(prod.getLong("id"), prod);
        }
        return res;
    }

    private static Map<String, DynamicObject> getRunningAuthDyos() {
        QFilter filter = new QFilter("openstatus", "=", (Object)"2").and(new QFilter("enable", "=", (Object)"1"));
        Map authDyoMap = BusinessDataServiceHelper.loadFromCache((String)"pmm_ecadmit", (String)"platform,malsupplier,malsupplier.id,standard,standard.id,mesureunits,mesureunits.id,currency,currency.id", (QFilter[])new QFilter[]{filter});
        HashMap<String, DynamicObject> res = new HashMap<String, DynamicObject>(authDyoMap.size() << 2);
        HashSet<Long> supplierIdSet = new HashSet<Long>(authDyoMap.size());
        for (DynamicObject authDyo : authDyoMap.values()) {
            supplierIdSet.add(authDyo.getLong("malsupplier.id"));
            res.put(authDyo.getString("platform"), authDyo);
        }
        Map supplierMap = BusinessDataServiceHelper.loadFromCache((Object[])supplierIdSet.toArray(), (String)"bd_malsupplier");
        for (DynamicObject authDyo : res.values()) {
            authDyo.set("malsupplier", supplierMap.get(authDyo.get("malsupplier.id")));
        }
        return res;
    }

    private static Set<Long> filterNonSyncGoodsIds(Set<Long> goodsIdSet) {
        HashSet<Long> nonSynGoodsIdSet = new HashSet<Long>(goodsIdSet);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"pmm_prodmanage", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", goodsIdSet)}, null);){
            ds.forEach(row -> nonSynGoodsIdSet.remove(row.getLong("id")));
        }
        return nonSynGoodsIdSet;
    }

    private static DynamicObject convertEcGoodsToProdManage(DynamicObject ecGoods, DynamicObject authDyo) {
        String source = ecGoods.getString("source");
        DynamicObject prod = BusinessDataServiceHelper.newDynamicObject((String)"pmm_prodmanage");
        DynamicObject supplierDyn = authDyo.getDynamicObject("malsupplier");
        prod.set("id", ecGoods.get("id"));
        prod.set("number", (Object)ecGoods.getString("number"));
        prod.set("name", (Object)ecGoods.getString("name"));
        prod.set("model", (Object)ecGoods.getString("model"));
        prod.set("thumbnail", (Object)ecGoods.getString("mainpic"));
        if (supplierDyn != null) {
            prod.set("supplier", (Object)supplierDyn);
        }
        prod.set("standard", (Object)authDyo.getLong("standard.id"));
        prod.set("unit", (Object)ecGoods.getLong("unitid"));
        prod.set("curr", (Object)authDyo.getLong("currency.id"));
        prod.set("category_id", (Object)ecGoods.getLong("group"));
        DynamicObject categoryDyn = BusinessDataServiceHelper.newDynamicObject((String)"mdr_goodsclass");
        categoryDyn.set("number", ecGoods.get("group.number"));
        categoryDyn.set("name", ecGoods.get("group.name"));
        categoryDyn.set("id", (Object)ecGoods.getLong("group"));
        prod.set("category", (Object)categoryDyn);
        prod.set("origin", (Object)"1");
        prod.set("status", (Object)"C");
        prod.set("enable", (Object)"1");
        prod.set("source", (Object)source);
        prod.set("mallStatus", (Object)MalStatusEnum.B.getVal());
        prod.set("brand", (Object)ecGoods.getLong("brandid"));
        prod.set("centralpurtype", (Object)"1");
        prod.set("barcode", (Object)ecGoods.getString("barcode"));
        return prod;
    }

    private static DynamicObject getEcSupplierDyn(String source) {
        Long supplierId = MalOrderUtil.getEcSupplierId((String)source);
        if (supplierId != 0L) {
            return BusinessDataServiceHelper.loadSingleFromCache((Object)supplierId, (String)"bd_supplier");
        }
        return null;
    }
}

