/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.fulltext.QMatches;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.ecapi.entity.GoodsInfo;
import kd.scm.common.ecapi.entity.PriceInfo;
import kd.scm.common.ecapi.jd.JdApiUtil;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.ProductSourceEnum;
import kd.scm.common.jd.errorcode.JDAPIErrorCode;
import kd.scm.common.jd.util.JDHttpsUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.mal.common.util.MainPageUtils;
import kd.scm.mal.common.util.MalJdProductUtil;
import kd.scm.mal.common.util.MalProductUtil;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class MalSearchUtils {
    private static Log logger = LogFactory.getLog(MalSearchUtils.class);
    private static final String SEARCH_FILED_LONGNUMBER = "catlongnumber";
    public static final int SEARCH_SIZE = 200;

    public static List<GoodsInfo> search(String searchContent, List<String> searchFields) {
        ArrayList<GoodsInfo> productList = new ArrayList<GoodsInfo>();
        productList.addAll(MalSearchUtils.searchFromSelfByKey(searchContent, searchFields));
        if (MalSearchUtils.isJdAutoExists()) {
            productList.addAll(MalSearchUtils.searchFromJDByKey(searchContent, searchFields));
        }
        return productList;
    }

    private static boolean isJdAutoExists() {
        QFilter filter = new QFilter("platform", "=", (Object)"2").and(new QFilter("openstatus", "=", (Object)"2"));
        return QueryServiceHelper.exists((String)"pmm_ecadmit", (QFilter[])new QFilter[]{filter});
    }

    public static List<GoodsInfo> searchFromJDByKey(String searchContent, List<String> searchFields) {
        MalJdProductUtil.clearCacheMap();
        ArrayList<GoodsInfo> resultList = new ArrayList<GoodsInfo>();
        try {
            HashMap<String, PriceInfo> priceMap = new HashMap();
            String token = MalJdProductUtil.getAccessToken();
            JSONObject node = null;
            JSONArray skus = null;
            JSONObject sku = null;
            Set<String> catSet = MalSearchUtils.getDisabledCategoryNumber(ProductSourceEnum.PRODUCTSOURCE_JD);
            if (StringUtils.isNotBlank((CharSequence)searchContent)) {
                StringBuilder logString = new StringBuilder();
                for (int j = 0; j < 2; ++j) {
                    ArrayList<String> skuList = new ArrayList<String>();
                    ArrayList<GoodsInfo> jdProductList = new ArrayList<GoodsInfo>();
                    String data = "token=" + token + "&keyword=" + searchContent + "&pageSize=100&pageIndex=" + (j + 1);
                    String json = JDHttpsUtil.httpsJDPost((String)" https://bizapi.jd.com/api/search/search", (String)data);
                    node = JSONObject.fromObject((Object)json);
                    if (node.getBoolean("success")) {
                        GoodsInfo goodsInfo;
                        if (node.getJSONObject("result").get("hitResult") != null && !node.getJSONObject("result").get("hitResult").equals("null")) {
                            skus = node.getJSONObject("result").getJSONArray("hitResult");
                            for (int i = 0; i < skus.size(); ++i) {
                                sku = skus.getJSONObject(i);
                                goodsInfo = MalJdProductUtil.getJdProductInfo(sku);
                                if (catSet.contains(goodsInfo.getCategoryNumber())) continue;
                                jdProductList.add(goodsInfo);
                                skuList.add(sku.getString("wareId"));
                            }
                        } else {
                            String str;
                            if (j > 0) break;
                            if (MalProductUtil.isAllNumber(searchContent) && (node = JSONObject.fromObject((Object)(str = JDHttpsUtil.httpsJDPost((String)"https://bizapi.jd.com/api/product/getDetail", (String)("&token=" + token + "&sku=" + searchContent))))).getBoolean("success") && !catSet.contains((goodsInfo = MalJdProductUtil.getJdProductInfo4Detail(sku = node.getJSONObject("result"))).getCategoryNumber())) {
                                jdProductList.add(goodsInfo);
                                skuList.add(sku.getString("sku"));
                            }
                        }
                    } else {
                        logString.append("data:").append(data).append("\n");
                        logString.append(node.getString("resultMessage")).append("\n");
                    }
                    if (skuList.size() <= 0) continue;
                    priceMap = JdApiUtil.batchGetJdPriceMap(skuList);
                    MalJdProductUtil.setJdProductInfoPrice(jdProductList, priceMap);
                    resultList.addAll(jdProductList);
                }
                logger.info(logString.toString());
            }
        }
        catch (Exception e) {
            if (e instanceof KDBizException) {
                logger.error(e.getMessage() + "-------->" + ExceptionUtil.getStackTrace((Throwable)e));
            }
            throw new KDException(JDAPIErrorCode.SYS_ERROR, new Object[]{ExceptionUtil.getStackTrace((Throwable)e)});
        }
        return resultList;
    }

    public static Set<String> getDisabledCategoryNumber(ProductSourceEnum productSourceEnum) {
        QFilter malFilter = new QFilter("source", "=", (Object)productSourceEnum.getVal());
        QFilter enableFilter = new QFilter("enable", "=", (Object)"0");
        QFilter levelFilter = new QFilter("level", "=", (Object)3);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)MainPageUtils.class.getName(), (String)"pbd_goodsclass", (String)"number", (QFilter[])new QFilter[]{malFilter, enableFilter, levelFilter}, null);){
            Iterator iterator = dataSet.iterator();
            HashSet<String> set = new HashSet<String>();
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                set.add(row.getString("number"));
            }
            HashSet<String> hashSet = set;
            return hashSet;
        }
    }

    public static List<GoodsInfo> searchFromJDByCategory(String searchContent, int pageIndex, int pageSize) {
        if (pageIndex == 0) {
            return new ArrayList<GoodsInfo>();
        }
        ArrayList<GoodsInfo> goodsInfos = new ArrayList<GoodsInfo>();
        try {
            HashMap<String, String> paramMap = new HashMap<String, String>(16);
            String catId = searchContent;
            String[] longNumberArr = searchContent.split("\\.");
            if (longNumberArr.length > 0) {
                catId = longNumberArr[longNumberArr.length - 1];
            }
            for (int i = pageIndex; i <= pageSize / 100 + 1; ++i) {
                paramMap.put("catId", catId);
                paramMap.put("pageIndex", String.valueOf(i));
                if (pageSize >= 100) {
                    paramMap.put("pageSize", "100");
                    pageSize -= 100;
                } else if (pageSize > 0) {
                    paramMap.put("pageSize", String.valueOf(pageSize));
                } else {
                    return goodsInfos;
                }
                goodsInfos.addAll(JdApiUtil.searchGoodsFromJd(paramMap));
                paramMap.clear();
            }
        }
        catch (Exception e) {
            if (!(e instanceof KDBizException)) {
                throw new KDException(JDAPIErrorCode.SYS_ERROR, new Object[]{ExceptionUtil.getStackTrace((Throwable)e)});
            }
            logger.error(e.getMessage() + "-------->" + ExceptionUtil.getStackTrace((Throwable)e));
        }
        return goodsInfos;
    }

    public static List<GoodsInfo> searchFromSelfByKey(String keyWord, List<String> searchFields, String orderBys, boolean isOnlyShowQysp, QFilter ... priceRangeFilter) {
        String entityKey = "pbd_goods";
        String selectFields = "id,number,thumbnail,name,model,taxprice,shopprice,source,supplier.name,category.name,category.number,centralpurtype,supplier.mallstatus";
        List<QFilter> filters = MalSearchUtils.getSearchFromSelfByKeyQFilters(keyWord, searchFields, ProductSourceEnum.PRODUCTSOURCE_SELF.getVal());
        if (isOnlyShowQysp) {
            filters.add(new QFilter("centralpurtype", "=", (Object)"1"));
        }
        if (priceRangeFilter != null && priceRangeFilter.length > 0) {
            filters.add(priceRangeFilter[0]);
        }
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)entityKey, (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]), (String)orderBys);
        return MalSearchUtils.tran2GoodsInfoList(dynamicObjects);
    }

    public static List<GoodsInfo> searchFromSelfByKey(String keyWord, List<String> searchFields, String orderBys, boolean isOnlyShowQysp, int top, QFilter ... priceRangeFilter) {
        String entityKey = "pbd_goods";
        String selectFields = "id,number,thumbnail,name,model,taxprice,shopprice,source,supplier.name,category.name,category.number,centralpurtype";
        List<QFilter> filters = MalSearchUtils.getSearchFromSelfByKeyQFilters(keyWord, searchFields, ProductSourceEnum.PRODUCTSOURCE_SELF.getVal());
        if (isOnlyShowQysp) {
            filters.add(new QFilter("centralpurtype", "=", (Object)"1"));
        }
        if (priceRangeFilter != null && priceRangeFilter.length > 0) {
            filters.add(priceRangeFilter[0]);
        }
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)entityKey, (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]), (String)orderBys, (int)top);
        return MalSearchUtils.tran2GoodsInfoList(dynamicObjects);
    }

    private static List<GoodsInfo> searchFromSelfByKey(String keyWord, List<String> searchFields) {
        DynamicObjectCollection dynamicObjects;
        String entityKey = "pbd_goods";
        if ("1".equals(MalSearchUtils.getMalSearchSysParam())) {
            dynamicObjects = MalSearchUtils.fullTextSearch(keyWord);
        } else {
            String selectFields = "id,number,thumbnail,name,model,taxprice,shopprice,source,supplier.name,category.name,category.number,centralpurtype";
            List<QFilter> filters = MalSearchUtils.getSearchFromSelfByKeyQFilters(keyWord, searchFields, ProductSourceEnum.PRODUCTSOURCE_SELF.getVal());
            dynamicObjects = QueryServiceHelper.query((String)entityKey, (String)selectFields, (QFilter[])filters.toArray(new QFilter[filters.size()]), null);
        }
        return MalSearchUtils.tran2GoodsInfoList(dynamicObjects);
    }

    private static DynamicObjectCollection fullTextSearch(String keyWord) {
        return null;
    }

    private static List<QFilter> getSearchFromSelfByKeyQFilters(String keyWord, List<String> searchFields, String source) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter searchFieldFilter = null;
        filters.add(new QFilter("source", "=", (Object)source));
        filters.add(new QFilter("mallstatus", "=", (Object)"B"));
        filters.add(new QFilter("status", "=", (Object)BillStatusEnum.AUDIT.getVal()));
        filters.add(new QFilter("enable", "=", (Object)"1"));
        filters.add(new QFilter("supplier.mallstatus", "=", (Object)"B"));
        filters.add(new QFilter("category.enable", "=", (Object)"1"));
        if (searchFields != null && searchFields.size() > 0) {
            for (String fild : searchFields) {
                if (searchFieldFilter == null) {
                    if (StringUtils.equals((CharSequence)fild, (CharSequence)SEARCH_FILED_LONGNUMBER)) {
                        searchFieldFilter = new QFilter(fild, "like", (Object)(keyWord + "%"));
                        continue;
                    }
                    searchFieldFilter = QMatches.ftlike((String[])new String[]{keyWord}, (String[])new String[]{fild});
                    continue;
                }
                searchFieldFilter.or(QMatches.ftlike((String[])new String[]{keyWord}, (String[])new String[]{fild}));
            }
        }
        if (searchFieldFilter != null) {
            filters.add(searchFieldFilter);
        }
        return filters;
    }

    private static List<GoodsInfo> tran2GoodsInfoList(DynamicObjectCollection dynamicObjects) {
        ArrayList<GoodsInfo> selfProductList = new ArrayList<GoodsInfo>();
        if (dynamicObjects == null) {
            return selfProductList;
        }
        HashSet<String> pkSet = new HashSet<String>();
        for (int i = 0; i < dynamicObjects.size(); ++i) {
            DynamicObject dyo = (DynamicObject)dynamicObjects.get(i);
            GoodsInfo product = MalProductUtil.getProductInfo(dyo);
            if (pkSet.contains(product.getProductId())) continue;
            pkSet.add(product.getProductId());
            selfProductList.add(product);
        }
        return selfProductList;
    }

    public static DynamicObjectCollection searchGoodsByKeyForERPSearch(String keyWord, List<String> searchFields, String source) {
        List<QFilter> qFilters = MalSearchUtils.getSearchFromSelfByKeyQFilters(keyWord, searchFields, source);
        String selectFields = "id,number,name,shopprice price,model model,unit.id unit,materiel,thumbnail";
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"pbd_goods", (String)selectFields, (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]), null);
        return dynamicObjects;
    }

    public static void toSearch(String searchApKey, SearchEnterEvent searchEnterEvent, AbstractFormPlugin plugin, ShowType showType) {
        Search search = (Search)searchEnterEvent.getSource();
        List searchFields = searchEnterEvent.getFieldNames();
        String searchText = searchEnterEvent.getText();
        if (StringUtils.equals((CharSequence)searchApKey, (CharSequence)search.getKey()) && StringUtils.isNotEmpty((CharSequence)searchText)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("mal_search");
            showParameter.getOpenStyle().setShowType(showType);
            HashMap<String, Object> searchParamMap = new HashMap<String, Object>();
            searchParamMap.put("searchText", searchText);
            searchParamMap.put("searchFields", searchFields);
            searchParamMap.put("opentype", showType);
            showParameter.setCustomParams(searchParamMap);
            plugin.getView().showForm(showParameter);
        }
    }

    private static String getMalSearchSysParam() {
        String appId = "UUPIH+47DAK";
        String isfulltext = ParamUtil.getParam((String)appId, (String)"isfulltext");
        return "".equals(isfulltext) ? "0" : isfulltext;
    }
}

