/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.webapi.api;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.url.UrlService;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.enums.ProductSourceEnum;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.webApi.IWebApiService;
import kd.scm.mal.business.factory.MalBusinessFactory;
import kd.scm.mal.business.model.menu.BussinessCard;
import kd.scm.mal.business.model.menu.MenuItem;
import kd.scm.mal.business.org.service.MalOrgSwitchService;
import kd.scm.mal.business.service.MalNewShopCenterService;
import kd.scm.mal.business.shopcart.service.MalShopCartService;
import kd.scm.mal.common.addcart.MalAddToCartHelper;
import kd.scm.mal.common.addcart.impl.MalSelfAddToCart;
import kd.scm.mal.domain.service.DomainServiceFactory;
import kd.scm.mal.domain.service.MalEsSearchService;
import kd.scm.mal.webapi.dto.MainPageConfigDto;
import kd.scm.mal.webapi.dto.PurchaseingCenter;
import kd.scm.mal.webapi.dto.SiteNav;
import kd.scm.mal.webapi.service.IMainPageConfigService;
import kd.scm.mal.webapi.service.IMainPageService;
import kd.scm.mal.webapi.service.impl.MainPageConfigServiceImplNew;
import kd.scm.mal.webapi.service.impl.MainPageServiceImplNew;
import net.sf.json.JSONObject;

public class MainPageApiNew
implements IWebApiService {
    private static final String REDIRECT = "redirect";
    private final IMainPageConfigService mainPageConfigService;
    private final IMainPageService mainPageService = new MainPageServiceImplNew();
    private static final Log log = LogFactory.getLog((String)MainPageApiNew.class.getName());

    public MainPageApiNew() {
        this.mainPageConfigService = new MainPageConfigServiceImplNew();
    }

    public ApiResult getMainPageConfig(Map<String, Object> map) {
        try {
            MainPageConfigDto mainPageConfigDto = this.mainPageConfigService.getMainPageConfig();
            return ApiResult.success((Object)JSONObject.fromObject((Object)mainPageConfigDto));
        }
        catch (KDBizException e) {
            JSONObject redirectJo = new JSONObject();
            redirectJo.put((Object)REDIRECT, (Object)(UrlService.getDomainContextUrl() + "/index.html?formId=error_403&cancelMessage=" + e.getMessage() + "&opentype=" + ShowType.NewWindow + "&accountId=" + RequestContext.get().getAccountId()));
            log.error(ExceptionUtil.getStackTrace((Throwable)e));
            return ApiResult.success((Object)redirectJo);
        }
        catch (Exception e) {
            log.error(ExceptionUtil.getStackTrace((Throwable)e));
            return ApiResult.fail((String)ExceptionUtil.getStackTrace((Throwable)e));
        }
    }

    public ApiResult sceneseAddToCart(Map<String, Object> map) {
        if (map.containsKey("sceneseid") && map.get("sceneseid") != null) {
            boolean flag;
            String sceneseid = map.get("sceneseid").toString();
            String tagid = null;
            if (map.containsKey("tagid") && !StringUtil.isEmpty((String)((String)map.get("tagid")))) {
                tagid = map.get("tagid").toString();
            }
            ArrayList<Long> selfprodIds = new ArrayList<Long>(64);
            ArrayList<Long> mallprodIds = new ArrayList<Long>(64);
            QFilter filter = new QFilter("id", "=", (Object)Long.parseLong(sceneseid));
            if (StringUtils.isNotBlank((CharSequence)tagid)) {
                filter.and("entryentity.scenariotag.id", "=", (Object)Long.parseLong(tagid));
            }
            DynamicObjectCollection entrys = QueryServiceHelper.query((String)"pmm_scenarioscheme", (String)"id,entryentity.goods,entryentity.source,entryentity.goods.id,entryentity.goods.number", (QFilter[])filter.toArray());
            int failgoodscount = 0;
            for (Object entry : entrys) {
                if ("pmm_prodmanage".equals(entry.getString("entryentity.source"))) {
                    selfprodIds.add(entry.getLong("entryentity.goods"));
                    continue;
                }
                mallprodIds.add(entry.getLong("entryentity.goods.id"));
            }
            List<Long> failIds = this.checkProdStatusAndOrg(selfprodIds, RequestContext.get().getOrgId());
            for (Long pk : selfprodIds) {
                if (failIds.contains(pk)) {
                    ++failgoodscount;
                    continue;
                }
                flag = MalAddToCartHelper.addCartNew((Long)pk, (String)ProductSourceEnum.PRODUCTSOURCE_SELF.getVal());
                if (flag) continue;
                ++failgoodscount;
            }
            for (Long pk : mallprodIds) {
                flag = MalAddToCartHelper.addCartNew((Long)pk, (String)"pbd_mallgoods");
                if (flag) continue;
                ++failgoodscount;
            }
            if (failgoodscount > 0) {
                String error = String.format(ResManager.loadKDString((String)"\u6210\u529f\u52a0\u5165 %1$s\u4ef6\u5546\u54c1\uff0c\u5931\u8d25%2$s\u4ef6\uff08\u5b58\u5728\u5df2\u4e0b\u67b6\u3001\u4e0d\u53ef\u552e\u6216\u65e0\u5e93\u5b58\u7684\u5546\u54c1\uff09\u4ef6\u5546\u54c1\u3002", (String)"MainPageApiNew_14", (String)"scm-mal-webapi", (Object[])new Object[0]), entrys.size() - failgoodscount, failgoodscount);
                HashMap<String, Object> data = new HashMap<String, Object>(3);
                data.put("message", error);
                data.put("issuccess", false);
                data.put("carnumber", MalAddToCartHelper.getAddToCartService((String)ProductSourceEnum.PRODUCTSOURCE_SELF.getVal()).getShopCartNum());
                return ApiResult.success(data);
            }
            HashMap<String, Object> data = new HashMap<String, Object>(3);
            data.put("issuccess", true);
            data.put("message", ResManager.loadKDString((String)"\u52a0\u5165\u8d2d\u7269\u8f66\u6210\u529f\u3002", (String)"MainPageApiNew_15", (String)"scm-mal-webapi", (Object[])new Object[0]));
            data.put("carnumber", MalAddToCartHelper.getAddToCartService((String)ProductSourceEnum.PRODUCTSOURCE_SELF.getVal()).getShopCartNum());
            return ApiResult.success(data);
        }
        return ApiResult.fail((String)ResManager.loadKDString((String)"\u52a0\u5165\u8d2d\u7269\u8f66\u5931\u8d25\u3002", (String)"MainPageApiNew_0", (String)"scm-mal-webapi", (Object[])new Object[0]));
    }

    public ApiResult addToCart(Map<String, Object> map) {
        if (map.containsKey("pk") && map.containsKey("source")) {
            long pk = Long.parseLong(map.get("pk").toString());
            String source = (String)map.get("source");
            try {
                ((MalShopCartService)MalBusinessFactory.serviceOf(MalShopCartService.class)).addToCart(Long.valueOf(pk), source, BigDecimal.ONE);
            }
            catch (Exception e) {
                ApiResult.fail((String)e.getMessage());
            }
            return ApiResult.success((Object)MalAddToCartHelper.getAddToCartService((String)source).getShopCartNum());
        }
        return ApiResult.fail((String)ResManager.loadKDString((String)"\u52a0\u5165\u8d2d\u7269\u8f66\u5931\u8d25\u3002", (String)"MainPageApiNew_0", (String)"scm-mal-webapi", (Object[])new Object[0]));
    }

    public ApiResult getCartNum(Map<String, Object> map) {
        return ApiResult.success((Object)new MalSelfAddToCart().getShopCartNum());
    }

    public ApiResult loadJdProducts(Map<String, Object> map) {
        Object rank = map.get("rank");
        if (rank != null) {
            return ApiResult.success((Object)this.mainPageService.loadJdProducts(String.valueOf(rank)));
        }
        return ApiResult.fail((String)ResManager.loadKDString((String)"\u52a0\u8f7d\u5931\u8d25", (String)"MainPageApiNew_1", (String)"scm-mal-webapi", (Object[])new Object[0]));
    }

    public ApiResult getNavJo(Map<String, Object> map) {
        Object source = map.get("source");
        if (source != null) {
            return ApiResult.success((Object)this.mainPageService.getNavJo(String.valueOf(source)));
        }
        return ApiResult.fail((String)ResManager.loadKDString((String)"\u52a0\u8f7d\u5931\u8d25", (String)"MainPageApiNew_1", (String)"scm-mal-webapi", (Object[])new Object[0]));
    }

    public ApiResult loadMalSwiper(Map<String, Object> map) {
        Object rank = map.get("rank");
        if (rank != null) {
            return ApiResult.success((Object)this.mainPageService.loadMalSwiper(String.valueOf(rank)));
        }
        return ApiResult.fail((String)ResManager.loadKDString((String)"\u52a0\u8f7d\u5931\u8d25", (String)"MainPageApiNew_1", (String)"scm-mal-webapi", (Object[])new Object[0]));
    }

    public ApiResult loadBottombox(Map<String, Object> map) {
        Object rank = map.get("rank");
        if (rank != null) {
            return ApiResult.success((Object)this.mainPageService.loadBottombox(String.valueOf(rank)));
        }
        return ApiResult.fail((String)ResManager.loadKDString((String)"\u52a0\u8f7d\u5931\u8d25", (String)"MainPageApiNew_1", (String)"scm-mal-webapi", (Object[])new Object[0]));
    }

    public ApiResult loadStoreBody(Map<String, Object> map) {
        Object rank = map.get("rank");
        if (rank != null) {
            return ApiResult.success((Object)this.mainPageService.loadStoreBody(String.valueOf(rank)));
        }
        return ApiResult.fail((String)ResManager.loadKDString((String)"\u52a0\u8f7d\u5931\u8d25", (String)"MainPageApiNew_1", (String)"scm-mal-webapi", (Object[])new Object[0]));
    }

    public ApiResult loadCardBody(Map<String, Object> map) {
        Object rank = map.get("rank");
        if (rank != null) {
            return ApiResult.success((Object)this.mainPageService.loadCardBody(String.valueOf(rank)));
        }
        return ApiResult.fail((String)ResManager.loadKDString((String)"\u52a0\u8f7d\u5931\u8d25", (String)"MainPageApiNew_1", (String)"scm-mal-webapi", (Object[])new Object[0]));
    }

    public ApiResult service(Map<String, Object> map) {
        return null;
    }

    public ApiResult getFloors(Map<String, Object> map) {
        String floorsStr = (String)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pmm", (String)"PmmMainPageConfigService", (String)"getFloors", (Object[])new Object[]{this.getConfigId(map), map.get("start"), map.get("size")});
        return ApiResult.success((Object)JSONObject.fromObject((Object)floorsStr));
    }

    public ApiResult getBaseMainPageConfig(Map<String, Object> map) {
        try {
            Long configId = this.getConfigId(map);
            String baseMainPageConfig = (String)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pmm", (String)"PmmMainPageConfigService", (String)"getBaseMainPageConfig", (Object[])new Object[]{configId});
            JSONObject data = JSONObject.fromObject((Object)baseMainPageConfig);
            return ApiResult.success((Object)data);
        }
        catch (KDBizException e) {
            log.warn(ExceptionUtil.getStackTrace((Throwable)e));
            return ApiResult.fail((String)(UrlService.getDomainContextUrl() + "/index.html?formId=error_403&cancelMessage=" + e.getMessage() + "&opentype=" + ShowType.NewWindow + "&accountId=" + RequestContext.get().getAccountId()));
        }
        catch (Exception e) {
            log.warn(ExceptionUtil.getStackTrace((Throwable)e));
            return ApiResult.fail((String)ExceptionUtil.getStackTrace((Throwable)e));
        }
    }

    private Long getConfigId(Map<String, Object> map) {
        Object configId = map.get("configId");
        if (StringUtils.isBlank((Object)configId)) {
            QFilter filter = new QFilter("enable", "=", (Object)"1").and("isonhomepage", "=", (Object)true);
            DynamicObject configDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"pmm_compconfig", (QFilter[])new QFilter[]{filter});
            if (configDyn != null) {
                configId = configDyn.getLong("id");
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5230\u201c\u5546\u57ce\u7ba1\u7406-\u57fa\u7840\u8bbe\u7f6e-\u5546\u57ce\u9996\u9875\u914d\u7f6e\u201d\u4e2d\u542f\u7528\u9996\u9875\u914d\u7f6e\u9891\u9053\u3002", (String)"MainPageApiNew_13", (String)"scm-mal-webapi", (Object[])new Object[0]));
            }
        }
        return Long.valueOf(String.valueOf(configId));
    }

    private List<BussinessCard> innerGetBussinessCards() {
        return new MalNewShopCenterService().getBussinessCards();
    }

    public ApiResult getBussinessCards(Map<String, Object> map) {
        return ApiResult.success(this.innerGetBussinessCards());
    }

    public ApiResult getSiteNav(Map<String, Object> map) {
        return ApiResult.success((Object)this.getSiteNav());
    }

    public SiteNav getSiteNav() {
        SiteNav siteNav = new SiteNav();
        PurchaseingCenter purchaseingCenter = new PurchaseingCenter();
        purchaseingCenter.setOrgId(RequestContext.get().getOrgId());
        DynamicObject orgDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)RequestContext.get().getOrgId(), (String)"bos_org");
        if (orgDyn != null) {
            purchaseingCenter.setName(orgDyn.getString("name"));
        }
        siteNav.setPurchaseingCenter(purchaseingCenter);
        ArrayList<MenuItem> menuItems = new ArrayList<MenuItem>();
        MenuItem appMenuItem = new MenuItem();
        appMenuItem.setKey(1L);
        appMenuItem.setName(ResManager.loadKDString((String)"\u8fd4\u56de\u5e94\u7528\u4e2d\u5fc3", (String)"MainPageApiNew_2", (String)"scm-mal-webapi", (Object[])new Object[0]));
        appMenuItem.setUrl(UrlService.getDomainContextUrl() + "?accountId=" + RequestContext.get().getAccountId());
        menuItems.add(appMenuItem);
        MenuItem shopCenterMenuItem = new MenuItem();
        shopCenterMenuItem.setName(ResManager.loadKDString((String)"\u4e2a\u4eba\u4e2d\u5fc3", (String)"MainPageApiNew_4", (String)"scm-mal-webapi", (Object[])new Object[0]));
        shopCenterMenuItem.setKey(3L);
        ArrayList<MenuItem> subMenuItems = new ArrayList<MenuItem>();
        MenuItem orderMenuItem = new MenuItem();
        orderMenuItem.setDropdown(true);
        orderMenuItem.setName(ResManager.loadKDString((String)"\u6211\u7684\u8ba2\u5355", (String)"MainPageApiNew_5", (String)"scm-mal-webapi", (Object[])new Object[0]));
        orderMenuItem.setUrl(this.getUrl("mal_order", ResManager.loadKDString((String)"\u6211\u7684\u8ba2\u5355", (String)"MainPageApiNew_5", (String)"scm-mal-webapi", (Object[])new Object[0])));
        orderMenuItem.setKey(4L);
        subMenuItems.add(orderMenuItem);
        MenuItem afterSaleMenuItem = new MenuItem();
        afterSaleMenuItem.setDropdown(true);
        afterSaleMenuItem.setName(ResManager.loadKDString((String)"\u6211\u7684\u552e\u540e", (String)"MainPageApiNew_6", (String)"scm-mal-webapi", (Object[])new Object[0]));
        afterSaleMenuItem.setKey(5L);
        afterSaleMenuItem.setUrl(this.getUrl("mal_returnreq", ResManager.loadKDString((String)"\u6211\u7684\u552e\u540e", (String)"MainPageApiNew_6", (String)"scm-mal-webapi", (Object[])new Object[0])));
        subMenuItems.add(afterSaleMenuItem);
        MenuItem addrMenuItem = new MenuItem();
        addrMenuItem.setDropdown(true);
        addrMenuItem.setName(ResManager.loadKDString((String)"\u5730\u5740\u7ba1\u7406", (String)"MainPageApiNew_7", (String)"scm-mal-webapi", (Object[])new Object[0]));
        addrMenuItem.setKey(6L);
        addrMenuItem.setUrl(this.getUrl("mal_address", ResManager.loadKDString((String)"\u5730\u5740\u7ba1\u7406", (String)"MainPageApiNew_7", (String)"scm-mal-webapi", (Object[])new Object[0])));
        subMenuItems.add(addrMenuItem);
        shopCenterMenuItem.setSubMenuItems(subMenuItems);
        menuItems.add(shopCenterMenuItem);
        MenuItem accountMenuItem = new MenuItem();
        accountMenuItem.setName(ResManager.loadKDString((String)"\u7535\u5546\u7ed3\u7b97", (String)"MainPageApiNew_8", (String)"scm-mal-webapi", (Object[])new Object[0]));
        accountMenuItem.setKey(7L);
        ArrayList<MenuItem> subAccountMenuItems = new ArrayList<MenuItem>();
        MenuItem accountDataMenuItem = new MenuItem();
        accountDataMenuItem.setDropdown(true);
        accountDataMenuItem.setName(ResManager.loadKDString((String)"\u5bf9\u8d26\u6570\u636e", (String)"MainPageApiNew_9", (String)"scm-mal-webapi", (Object[])new Object[0]));
        accountDataMenuItem.setKey(8L);
        accountDataMenuItem.setUrl(this.getUrl("pur_thirddata", accountDataMenuItem.getName()));
        subAccountMenuItems.add(accountDataMenuItem);
        MenuItem ecAccountMenuItem = new MenuItem();
        ecAccountMenuItem.setDropdown(true);
        ecAccountMenuItem.setName(ResManager.loadKDString((String)"\u7535\u5546\u5bf9\u8d26", (String)"MainPageApiNew_10", (String)"scm-mal-webapi", (Object[])new Object[0]));
        ecAccountMenuItem.setKey(9L);
        ecAccountMenuItem.setUrl(this.getUrl("pur_thirdcheckorder", ecAccountMenuItem.getName()));
        subAccountMenuItems.add(ecAccountMenuItem);
        MenuItem ecInvoiceRequestMenuItem = new MenuItem();
        ecInvoiceRequestMenuItem.setDropdown(true);
        ecInvoiceRequestMenuItem.setName(ResManager.loadKDString((String)"\u7535\u5546\u5f00\u7968", (String)"MainPageApiNew_11", (String)"scm-mal-webapi", (Object[])new Object[0]));
        ecInvoiceRequestMenuItem.setKey(10L);
        ecInvoiceRequestMenuItem.setUrl(this.getUrl("pur_invoicerequest", ecInvoiceRequestMenuItem.getName()));
        subAccountMenuItems.add(ecInvoiceRequestMenuItem);
        MenuItem invoiceMenuItem = new MenuItem();
        invoiceMenuItem.setDropdown(true);
        invoiceMenuItem.setName(ResManager.loadKDString((String)"\u53d1\u7968\u7b7e\u6536", (String)"MainPageApiNew_12", (String)"scm-mal-webapi", (Object[])new Object[0]));
        invoiceMenuItem.setKey(11L);
        invoiceMenuItem.setUrl(this.getUrl("pur_invoice", invoiceMenuItem.getName()));
        subAccountMenuItems.add(invoiceMenuItem);
        accountMenuItem.setSubMenuItems(subAccountMenuItems);
        menuItems.add(accountMenuItem);
        siteNav.setMenuItems(menuItems);
        return siteNav;
    }

    private String getUrl(String formId, String caption) {
        return UrlService.getDomainContextUrl() + "/index.html?formId=mal_newshopcenter&showFormId=" + formId + "&formCaption=" + caption + "&accountId=" + RequestContext.get().getAccountId();
    }

    public ApiResult getSearchOption(Map<String, Object> map) {
        return ApiResult.success((Object)((MalEsSearchService)DomainServiceFactory.serviceOf(MalEsSearchService.class)).getSearchOption());
    }

    public ApiResult getCart(Map<String, Object> map) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("count", new MalSelfAddToCart().getShopCartNum());
        res.put("url", UrlService.getDomainContextUrl() + "/index.html?formId=mal_newshopcart&opentype=" + ShowType.NewWindow + "&accountId=" + RequestContext.get().getAccountId());
        return ApiResult.success(res);
    }

    public ApiResult getOrgs(Map<String, Object> map) {
        int pageSize = (Integer)map.get("pageSize");
        int current = (Integer)map.get("current");
        long userId = RequestContext.get().getCurrUserId();
        List paramFilters = (List)map.get("filters");
        QFilter customFilter = new QFilter("enable", "=", (Object)"1");
        if (!ObjectUtils.isEmpty((Object)paramFilters)) {
            for (Map paramFilter : paramFilters) {
                String searchField = (String)paramFilter.get("searchField");
                Object searchText = paramFilter.get("searchText");
                if (StringUtils.isNotBlank((CharSequence)searchField) && "orgName".equals(searchField)) {
                    customFilter.and("name", "like", (Object)("%" + searchText + "%"));
                }
                if (!StringUtils.isNotBlank((CharSequence)searchField) || !"orgNumber".equals(searchField)) continue;
                customFilter.and("number", "like", (Object)("%" + searchText + "%"));
            }
        }
        return ApiResult.success((Object)((MalOrgSwitchService)MalBusinessFactory.serviceOf(MalOrgSwitchService.class)).getOrgs(userId, current, pageSize, customFilter));
    }

    public ApiResult switchOrg(Map<String, Object> map) {
        long orgId = Long.parseLong(String.valueOf(map.getOrDefault("orgId", "-1")));
        Boolean setDefault = (Boolean)map.getOrDefault("setDefault", Boolean.FALSE);
        if (orgId != -1L) {
            ((MalOrgSwitchService)MalBusinessFactory.serviceOf(MalOrgSwitchService.class)).switchOrg(orgId, setDefault.booleanValue());
            return ApiResult.success((Object)"");
        }
        return ApiResult.success((Object)"orgId is null");
    }

    private List<Long> checkProdStatusAndOrg(List<Long> prodIds, Long orgId) {
        ArrayList<Long> failIds = new ArrayList<Long>();
        QFilter qFilter = new QFilter("goods.id", "in", prodIds);
        qFilter.and(new QFilter("goods.source", "=", (Object)EcPlatformEnum.ECPLATFORM_SELF.getVal()));
        String selectors = "entryentity.orgname,protocol.purmode,mallstatus,goods.number,goods.id,isgoodvisible";
        DynamicObjectCollection pmmProdpools = QueryServiceHelper.query((String)"pmm_prodpool", (String)selectors, (QFilter[])qFilter.toArray());
        QFilter prodQFilter = new QFilter("id", "in", prodIds);
        prodQFilter.and(new QFilter("source", "=", (Object)EcPlatformEnum.ECPLATFORM_SELF.getVal()));
        prodQFilter.and(new QFilter("status", "!=", (Object)"C"));
        DynamicObjectCollection pmmProds = QueryServiceHelper.query((String)"pmm_prodmanage", (String)"id,number", (QFilter[])prodQFilter.toArray());
        HashMap<Long, String> prodStatus_numberMap = new HashMap<Long, String>(1024);
        for (DynamicObject prod : pmmProds) {
            Long id = prod.getLong("id");
            String number = prod.getString("number");
            prodStatus_numberMap.put(id, number);
        }
        HashSet<Long> statusProdSet = new HashSet<Long>(1024);
        HashMap<Long, HashSet<Long>> orgIdMap = new HashMap<Long, HashSet<Long>>(1024);
        HashMap<Long, String> prod_numberMap = new HashMap<Long, String>(1024);
        for (DynamicObject prodpool : pmmProdpools) {
            Long id = prodpool.getLong("goods.id");
            String number = prodpool.getString("goods.number");
            String mallstatus = prodpool.getString("mallstatus");
            prod_numberMap.put(id, number);
            if (!"B".equals(mallstatus)) continue;
            statusProdSet.add(id);
            long org = prodpool.getLong("entryentity.orgname");
            boolean isgoodvisible = prodpool.getBoolean("isgoodvisible");
            HashSet<Long> orgIdSet = (HashSet<Long>)orgIdMap.get(id);
            if (null == orgIdSet) {
                orgIdSet = new HashSet<Long>(1024);
            }
            if (isgoodvisible) {
                orgIdSet.add(orgId);
            } else if (org == orgId) {
                orgIdSet.add(orgId);
            }
            orgIdMap.put(id, orgIdSet);
        }
        if (prodIds.size() == 1 && prod_numberMap.size() > 0) {
            Set orgIdSet;
            if (orgIdMap.containsKey(prodIds.get(0)) && !(orgIdSet = (Set)orgIdMap.get(prodIds.get(0))).contains(orgId)) {
                return prodIds;
            }
            if (statusProdSet.size() == 0 || prodStatus_numberMap.size() > 0) {
                return prodIds;
            }
        } else {
            for (Long prodId : prodIds) {
                Set orgIdSet;
                if (!statusProdSet.contains(prodId) && prod_numberMap.containsKey(prodId) || prodStatus_numberMap.containsKey(prodId)) {
                    failIds.add(prodId);
                }
                if (null == (orgIdSet = (Set)orgIdMap.get(prodId)) || orgIdSet.contains(orgId) || !prod_numberMap.containsKey(prodId)) continue;
                failIds.add(prodId);
            }
        }
        return failIds;
    }
}

