/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.webapi.controller;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiGetMapping;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.custom.annotation.ApiRequestBody;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.mal.business.factory.MalBusinessFactory;
import kd.scm.mal.business.placeorder.entity.MalCreateOrderResult;
import kd.scm.mal.business.placeorder.entity.MalToPlaceOrderItem;
import kd.scm.mal.business.placeorder.entity.MalToPlaceOrderParam;
import kd.scm.mal.business.placeorder.service.MalPlaceOrderService;
import kd.scm.mal.business.placeorder.vo.MalPlaceOrderVo;
import kd.scm.mal.webapi.dto.MalCreatedOrderInfo;
import kd.scm.mal.webapi.dto.OrderGoodsInfo;

@ApiController(value="mal", desc="\u5546\u57ce\u8ba2\u5355\u670d\u52a1")
@ApiMapping(value="mal_order")
public class MalOrderController
implements Serializable {
    @ApiGetMapping(value="cancel")
    public CustomApiResult<String> cancelorder(@ApiParam(value="\u5546\u57ce\u8ba2\u5355\u7f16\u53f7", required=true) @ApiParam(value="\u5546\u57ce\u8ba2\u5355\u7f16\u53f7", required=true) String billno) {
        String errorMessage;
        String errorCode;
        QFilter qFilter = new QFilter("billno", "=", (Object)billno);
        DynamicObjectCollection dynList = QueryServiceHelper.query((String)"mal_order", (String)"id,billno", (QFilter[])qFilter.toArray());
        if (dynList != null && !dynList.isEmpty()) {
            ArrayList<Long> ids = new ArrayList<Long>();
            for (DynamicObject dyn : dynList) {
                ids.add(dyn.getLong("id"));
            }
            OperateOption option = OperateOption.create();
            option.setVariableValue("isStrict", String.valueOf(false));
            option.setVariableValue("ishasright", String.valueOf(true));
            OperationResult result = OperationServiceHelper.executeOperate((String)"cancelorder", (String)"mal_order", (Object[])ids.toArray(), (OperateOption)option);
            if (result != null && result.isSuccess()) {
                return CustomApiResult.success((Object)ResManager.loadKDString((String)"\u53d6\u6d88\u5546\u57ce\u8ba2\u5355\u6210\u529f\u3002", (String)"MalOrderController_0", (String)"scm-mal-webapi", (Object[])new Object[0]));
            }
            String message = result == null ? null : ExceptionUtil.getErrorInfoDetails((List)result.getAllErrorOrValidateInfo());
            errorCode = "611";
            if (StringUtils.isBlank((CharSequence)message)) {
                message = ResManager.loadKDString((String)"\u53d6\u6d88\u5546\u57ce\u8ba2\u5355\u5931\u8d25\u3002", (String)"MalOrderController_1", (String)"scm-mal-webapi", (Object[])new Object[0]);
            }
            errorMessage = message;
        } else {
            errorCode = ApiErrorCode.Data_NotFound.getStatusCode();
            errorMessage = ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e", (String)"MalOrderController_2", (String)"scm-mal-webapi", (Object[])new Object[0]);
        }
        return CustomApiResult.fail((String)errorCode, (String)errorMessage);
    }

    @ApiPostMapping(value="createOrder")
    public CustomApiResult<List<MalCreatedOrderInfo>> createOrder(@ApiRequestBody(value="\u4e0b\u5355\u53c2\u6570") MalPlaceOrderVo malPlaceOrderVo) {
        MalCreateOrderResult malCreateOrderResult = ((MalPlaceOrderService)MalBusinessFactory.serviceOf(MalPlaceOrderService.class)).createMalOrder(malPlaceOrderVo, null);
        if (malCreateOrderResult.getErrorMsgs().isEmpty()) {
            List<MalCreatedOrderInfo> malCreatedOrderInfoList = this.getCreatedOrderInfoList(malCreateOrderResult);
            return CustomApiResult.success(malCreatedOrderInfoList);
        }
        return CustomApiResult.fail((String)ApiErrorCode.Data_Invalid.getStatusCode(), (String)StringUtils.join((Object[])malCreateOrderResult.getErrorMsgs().toArray(), (String)System.lineSeparator()));
    }

    /*
     * Loose catch block
     */
    @ApiPostMapping(value="rePlaceOrder")
    public CustomApiResult<MalPlaceOrderVo> rePlaceOrder(@ApiParam(value="\u5546\u57ce\u8ba2\u5355id", required=true, example="1767428028671078400") @ApiParam(value="\u5546\u57ce\u8ba2\u5355id", required=true, example="1767428028671078400") Long id) {
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        String selectFields = "id,billno,businesstype.id,person.id,entryentity.goods.id,entryentity.goods.number,entryentity.goods.source,entryentity.qty,entryentity.goodsuse.id,entryentity.entrycostproject.id,entryentity.purtype.id,entryentity.linetype.id,entryentity.compareid,deporg.id,receipt.id";
        Throwable throwable = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"mal_order", (String)selectFields, (QFilter[])qFilter.toArray(), null);){
            CustomApiResult customApiResult;
            MalToPlaceOrderParam malToPlaceOrderParam = null;
            ArrayList<MalToPlaceOrderItem> malToPlaceOrderItems = new ArrayList<MalToPlaceOrderItem>();
            for (Row row : dataSet) {
                if (malToPlaceOrderParam == null) {
                    Object person;
                    malToPlaceOrderParam = new MalToPlaceOrderParam();
                    Object businessType = row.get("businesstype.id");
                    if (businessType != null) {
                        malToPlaceOrderParam.setBusinessType(Long.valueOf(businessType.toString()));
                    }
                    if ((person = row.get("person.id")) != null) {
                        malToPlaceOrderParam.setPersonId(Long.valueOf(person.toString()));
                    }
                    Long depOrgId = row.getLong("deporg.id");
                    malToPlaceOrderParam.setDptOrgId(depOrgId);
                    malToPlaceOrderParam.setReceiptId(Long.valueOf(0L));
                }
                String goodsId = row.getString("entryentity.goods.id");
                String goodsNumber = row.getString("entryentity.goods.number");
                String source = row.getString("entryentity.goods.source");
                BigDecimal qty = row.getBigDecimal("entryentity.qty");
                Long goodsUseId = row.getLong("entryentity.goodsuse.id");
                Long costProjectId = row.getLong("entryentity.entrycostproject.id");
                Long purTypeId = row.getLong("entryentity.purtype.id");
                Long lineTypeId = row.getLong("entryentity.linetype.id");
                MalToPlaceOrderItem malToPlaceOrderItem = new MalToPlaceOrderItem();
                malToPlaceOrderItem.setGoodsId(Long.valueOf(goodsId));
                malToPlaceOrderItem.setGoodsNumber(goodsNumber);
                malToPlaceOrderItem.setPlatform(source);
                malToPlaceOrderItem.setQty(qty);
                malToPlaceOrderItem.setCostProjectId(costProjectId);
                malToPlaceOrderItem.setGoodsUseId(goodsUseId);
                malToPlaceOrderItem.setPurTypeId(purTypeId);
                malToPlaceOrderItem.setLineTypeId(lineTypeId);
                String compareId = row.getString("entryentity.compareid");
                malToPlaceOrderItem.setCompareId(Long.valueOf(StringUtils.isBlank((CharSequence)compareId) ? 0L : Long.parseLong(compareId)));
                malToPlaceOrderItems.add(malToPlaceOrderItem);
            }
            if (malToPlaceOrderParam == null) {
                Iterator iterator = CustomApiResult.fail((String)ApiErrorCode.Data_NotFound.getStatusCode(), (String)ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e", (String)"MalOrderController_2", (String)"scm-mal-webapi", (Object[])new Object[0]));
                return iterator;
            }
            malToPlaceOrderParam.setMalToPlaceOrderItemList(malToPlaceOrderItems);
            try {
                MalPlaceOrderVo malPlaceOrderVo = ((MalPlaceOrderService)MalBusinessFactory.serviceOf(MalPlaceOrderService.class)).toPlaceOrder(malToPlaceOrderParam);
                customApiResult = CustomApiResult.success((Object)malPlaceOrderVo);
                return customApiResult;
            }
            catch (Exception e) {
                block25: {
                    block26: {
                        customApiResult = CustomApiResult.fail((String)ApiErrorCode.Data_Invalid.getStatusCode(), (String)e.getMessage());
                        if (dataSet == null) break block25;
                        if (throwable == null) break block26;
                        try {
                            dataSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block25;
                    }
                    dataSet.close();
                }
                return customApiResult;
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
            }
        }
    }

    private List<MalCreatedOrderInfo> getCreatedOrderInfoList(MalCreateOrderResult malCreateOrderResult) {
        ArrayList<MalCreatedOrderInfo> createdOrderInfos = new ArrayList<MalCreatedOrderInfo>(malCreateOrderResult.getMalOrderDynList().size());
        for (DynamicObject malOrderDyn : malCreateOrderResult.getMalOrderDynList()) {
            MalCreatedOrderInfo malCreatedOrderInfo = new MalCreatedOrderInfo();
            malCreatedOrderInfo.setPlatform(malOrderDyn.getString("platform"));
            malCreatedOrderInfo.setMalOrderId(malOrderDyn.getLong("id"));
            ArrayList<OrderGoodsInfo> orderGoodsInfos = new ArrayList<OrderGoodsInfo>();
            DynamicObjectCollection entryCol = malOrderDyn.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryCol) {
                OrderGoodsInfo orderGoodsInfo = new OrderGoodsInfo();
                orderGoodsInfo.setGoodsId(entry.getLong("goods.id"));
                orderGoodsInfo.setGoodsName(entry.getString("goods.name"));
                orderGoodsInfo.setGoodsNumber(entry.getString("goods.number"));
                orderGoodsInfo.setTaxPrice(entry.getBigDecimal("taxprice"));
                orderGoodsInfo.setQty(entry.getBigDecimal("qty"));
                orderGoodsInfos.add(orderGoodsInfo);
            }
            malCreatedOrderInfo.setOrderGoodsInfoList(orderGoodsInfos);
            createdOrderInfos.add(malCreatedOrderInfo);
        }
        return createdOrderInfos;
    }
}

