/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.webapi.controller;

import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiGetMapping;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.custom.annotation.ApiRequestBody;
import kd.bos.openapi.common.custom.annotation.ApiResponseBody;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scm.mal.business.factory.MalBusinessFactory;
import kd.scm.mal.business.org.entity.MalOrgRelation;
import kd.scm.mal.business.org.service.MalOrgRelationService;
import kd.scm.mal.business.org.service.MalOrgSwitchService;
import kd.scm.mal.common.info.PageInfo;
import kd.scm.mal.common.org.IMalOrgService;
import kd.scm.mal.common.org.MalOrgServiceFactory;
import kd.scm.mal.webapi.dto.ParamFilter;
import kd.scm.mal.webapi.dto.QueryOrgsParam;

@ApiController(value="mal", desc="\u5546\u57ce\u7ec4\u7ec7\u670d\u52a1")
@ApiMapping(value="org")
public class MalOrgController {
    @ApiPostMapping(value="getOrgs")
    public CustomApiResult<@ApiResponseBody(value="\u5f53\u524d\u9875\u7ec4\u7ec7\u4fe1\u606f") PageInfo> getOrgs(@ApiRequestBody(value="\u83b7\u53d6\u7ec4\u7ec7\u53c2\u6570") QueryOrgsParam queryOrgsParam) {
        QFilter filter = null;
        long userId = RequestContext.getOrCreate().getCurrUserId();
        if (!ObjectUtils.isEmpty(queryOrgsParam.getParamFilterList())) {
            for (ParamFilter paramFilter : queryOrgsParam.getParamFilterList()) {
                if (!StringUtils.isNotBlank((CharSequence)paramFilter.getSearchField()) || !StringUtils.isNotBlank((CharSequence)paramFilter.getSerarchText())) continue;
                if (StringUtils.equals((CharSequence)"userId", (CharSequence)paramFilter.getSearchField())) {
                    userId = Long.parseLong(paramFilter.getSerarchText());
                    continue;
                }
                if (filter == null) {
                    filter = new QFilter(paramFilter.getSearchField(), "like", (Object)("%" + paramFilter.getSerarchText() + "%"));
                }
                if (queryOrgsParam.isOr()) {
                    filter.or(paramFilter.getSearchField(), "like", (Object)("%" + paramFilter.getSerarchText() + "%"));
                    continue;
                }
                filter.and(paramFilter.getSearchField(), "like", (Object)("%" + paramFilter.getSerarchText() + "%"));
            }
        }
        return CustomApiResult.success((Object)((MalOrgSwitchService)MalBusinessFactory.serviceOf(MalOrgSwitchService.class)).getOrgs(userId, queryOrgsParam.getPageNum(), queryOrgsParam.getPageSize(), filter));
    }

    @ApiPostMapping(value="switchOrg")
    public CustomApiResult<Void> switchOrg(@ApiParam(value="\u7ec4\u7ec7id", required=true, example="100000") @ApiParam(value="\u7ec4\u7ec7id", required=true, example="100000") long orgId, @ApiParam(value="\u662f\u5426\u8bbe\u7f6e\u4e3a\u9ed8\u8ba4\u7ec4\u7ec7", required=true) @ApiParam(value="\u662f\u5426\u8bbe\u7f6e\u4e3a\u9ed8\u8ba4\u7ec4\u7ec7", required=true) boolean isDefault) {
        ((MalOrgSwitchService)MalBusinessFactory.serviceOf(MalOrgSwitchService.class)).switchOrg(orgId, isDefault);
        return CustomApiResult.success(null);
    }

    @ApiGetMapping(value="getOrgRelationByUserId")
    public CustomApiResult<MalOrgRelation> getOrgRelationByUserId(@ApiParam(value="\u7528\u6237id", required=true, example="1655673329207607296") @ApiParam(value="\u7528\u6237id", required=true, example="1655673329207607296") long userId) {
        return CustomApiResult.success((Object)((MalOrgRelationService)MalBusinessFactory.serviceOf(MalOrgRelationService.class)).getOrgRelationByUserId(Long.valueOf(userId)));
    }

    @ApiGetMapping(value="getOrgRelationByDepOrgId")
    public CustomApiResult<MalOrgRelation> getOrgRelationByDepOrgId(@ApiParam(value="\u7533\u8bf7\u90e8\u95e8id", required=true, example="100000") @ApiParam(value="\u7533\u8bf7\u90e8\u95e8id", required=true, example="100000") long depOrgId) {
        return CustomApiResult.success((Object)((MalOrgRelationService)MalBusinessFactory.serviceOf(MalOrgRelationService.class)).getOrgRelationByDptOrgId(Long.valueOf(depOrgId)));
    }

    @ApiGetMapping(value="getPurOrgIdListByDepId")
    public CustomApiResult<List<Long>> getPurOrgIdListByDepOrgId(@ApiParam(value="\u7533\u8bf7\u90e8\u95e8id", required=true, example="100000") @ApiParam(value="\u7533\u8bf7\u90e8\u95e8id", required=true, example="100000") long depOrgId) {
        IMalOrgService malOrgService = MalOrgServiceFactory.getMalOrgService();
        return CustomApiResult.success((Object)malOrgService.getPurchaseOrgList(Long.valueOf(depOrgId)));
    }

    @ApiGetMapping(value="getRcvOrgIdListByPurOrgId")
    public CustomApiResult<List<Long>> getRcvOrgIdListByPurOrgId(@ApiParam(value="\u91c7\u8d2d\u7ec4\u7ec7id", required=true, example="100000") @ApiParam(value="\u91c7\u8d2d\u7ec4\u7ec7id", required=true, example="100000") long purOrgId) {
        IMalOrgService malOrgService = MalOrgServiceFactory.getMalOrgService();
        return CustomApiResult.success((Object)malOrgService.getInvOrgList(Long.valueOf(purOrgId)));
    }

    @ApiGetMapping(value="getSettleOrgIdList")
    public CustomApiResult<List<Long>> getSettleOrgIdList(@ApiParam(value="\u7533\u8bf7\u90e8\u95e8id", required=true, example="100000") @ApiParam(value="\u7533\u8bf7\u90e8\u95e8id", required=true, example="100000") long depOrgId, @ApiParam(value="\u6536\u8d27\u7ec4\u7ec7id", required=true, example="100000") @ApiParam(value="\u6536\u8d27\u7ec4\u7ec7id", required=true, example="100000") long rcvOrgId, @ApiParam(value="\u91c7\u8d2d\u7ec4\u7ec7id", required=true, example="100000") @ApiParam(value="\u91c7\u8d2d\u7ec4\u7ec7id", required=true, example="100000") long purOrgId) {
        boolean hasRelation = MalOrgServiceFactory.hasDelegantRalation();
        long orgId = hasRelation ? rcvOrgId : depOrgId;
        IMalOrgService malOrgService = MalOrgServiceFactory.getMalOrgService();
        return CustomApiResult.success((Object)malOrgService.getSettleOrgList(Long.valueOf(purOrgId), Long.valueOf(orgId)));
    }

    @ApiGetMapping(value="getExpenseOrgIdListBySettleOrgId")
    public CustomApiResult<List<Long>> getExpenseOrgIdListBySettleOrgId(@ApiParam(value="\u6838\u7b97\u7ec4\u7ec7id", required=true, example="100000") @ApiParam(value="\u6838\u7b97\u7ec4\u7ec7id", required=true, example="100000") long settleOrgId) {
        ArrayList<Long> orgIds = new ArrayList<Long>(1);
        orgIds.add(settleOrgId);
        List subOrgIds = OrgUnitServiceHelper.getAdminOrgRelation(orgIds, (boolean)true);
        return CustomApiResult.success((Object)subOrgIds);
    }
}

