/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.webapi.controller;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiGetMapping;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.scm.common.es.storage.EsFilterField;
import kd.scm.common.es.storage.EsSearchParam;
import kd.scm.mal.domain.model.goods.MalGoods;
import kd.scm.mal.domain.model.goods.MalGoodsInfo;
import kd.scm.mal.domain.model.goods.MalMatGoodsInitParam;
import kd.scm.mal.domain.model.goods.MalSaleAttr;
import kd.scm.mal.domain.model.goods.MalSimilarGoods;
import kd.scm.mal.domain.model.recommend.RecommendRule;
import kd.scm.mal.domain.model.recommend.SearchParam;
import kd.scm.mal.domain.model.search.MalEsSearchParam;
import kd.scm.mal.domain.model.search.MalSearchResult;
import kd.scm.mal.domain.service.DomainServiceFactory;
import kd.scm.mal.domain.service.MalConverRuleService;
import kd.scm.mal.domain.service.MalEsSearchService;
import kd.scm.malcore.domain.LadderPriceInfo;

@ApiController(value="mal", desc="\u5546\u57ce\u641c\u7d22\u670d\u52a1")
@ApiMapping(value="product")
public class MalProductController
implements Serializable {
    private static final Log log = LogFactory.getLog((String)MalProductController.class.getName());

    @ApiGetMapping(value="getDetail")
    public CustomApiResult<MalGoodsInfo> getDetail(@ApiParam(value="\u5546\u54c1id", required=true, example="1718241682136516608") @ApiParam(value="\u5546\u54c1id", required=true, example="1718241682136516608") Long productId, @ApiParam(value="\u7535\u5546\u5e73\u53f0", required=true, example="1") @ApiParam(value="\u7535\u5546\u5e73\u53f0", required=true, example="1") String platform, @ApiParam(value="\u5546\u54c1\u6570\u91cf,\u5f71\u54cd\u9636\u68af\u4ef7", example="1") @ApiParam(value="\u5546\u54c1\u6570\u91cf,\u5f71\u54cd\u9636\u68af\u4ef7", example="1") BigDecimal qty, @ApiParam(value="\u884c\u653f\u533a\u5212id\uff0c\u5f71\u54cd\u5e93\u5b58", example="1218127639441748993") @ApiParam(value="\u884c\u653f\u533a\u5212id\uff0c\u5f71\u54cd\u5e93\u5b58", example="1218127639441748993") String admindivisionId) {
        MalGoods malGoods = MalGoods.of((MalMatGoodsInitParam)MalMatGoodsInitParam.buildGeneralParam((Long)productId, (String)platform, (BigDecimal)qty, (String)admindivisionId, (Long)RequestContext.get().getOrgId()), (boolean)true, (boolean)true);
        MalGoodsInfo goodsInfo = malGoods.getGoodsInfo();
        goodsInfo.setSpecification(malGoods.getSpecification());
        goodsInfo.setLadderPriceRange(new HashMap());
        return CustomApiResult.success((Object)goodsInfo);
    }

    @ApiGetMapping(value="getDetailByProductNumber")
    public CustomApiResult<MalGoodsInfo> getDetailByProductNumber(@ApiParam(value="\u5546\u54c1\u7f16\u7801", required=true, example="SP-00000017") @ApiParam(value="\u5546\u54c1\u7f16\u7801", required=true, example="SP-00000017") String productNumber, @ApiParam(value="\u7535\u5546\u5e73\u53f0", required=true, example="1") @ApiParam(value="\u7535\u5546\u5e73\u53f0", required=true, example="1") String platform, @ApiParam(value="\u5546\u54c1\u6570\u91cf,\u5f71\u54cd\u9636\u68af\u4ef7", example="1") @ApiParam(value="\u5546\u54c1\u6570\u91cf,\u5f71\u54cd\u9636\u68af\u4ef7", example="1") BigDecimal qty, @ApiParam(value="\u884c\u653f\u533a\u5212id\uff0c\u5f71\u54cd\u5e93\u5b58", example="1218127639441748993") @ApiParam(value="\u884c\u653f\u533a\u5212id\uff0c\u5f71\u54cd\u5e93\u5b58", example="1218127639441748993") String admindivisionId) {
        MalGoods malGoods = MalGoods.of((MalMatGoodsInitParam)MalMatGoodsInitParam.buildGeneralParamWithSku((Long)0L, (String)productNumber, (String)platform, (BigDecimal)qty, (String)admindivisionId, (Long)RequestContext.get().getOrgId()), (boolean)true, (boolean)true);
        MalGoodsInfo goodsInfo = malGoods.getGoodsInfo();
        goodsInfo.setSpecification(malGoods.getSpecification());
        goodsInfo.setLadderPriceRange(new HashMap());
        return CustomApiResult.success((Object)goodsInfo);
    }

    @ApiGetMapping(value="getMalSimilarGoods")
    public CustomApiResult<List<MalSimilarGoods>> getMalSimilarGoods(@ApiParam(value="\u5546\u54c1id", required=true, example="1718241682136516608") @ApiParam(value="\u5546\u54c1id", required=true, example="1718241682136516608") Long productId, @ApiParam(value="\u7535\u5546\u5e73\u53f0", required=true, example="1") @ApiParam(value="\u7535\u5546\u5e73\u53f0", required=true, example="1") String platform) {
        MalGoods malGoods = MalGoods.of((MalMatGoodsInitParam)MalMatGoodsInitParam.buildGeneralParam((Long)productId, (String)platform, (BigDecimal)BigDecimal.ONE, null, (Long)RequestContext.get().getOrgId()), (boolean)false, (boolean)false);
        List malSimilarGoodsList = malGoods.getMalSimilarGoodsList();
        for (MalSimilarGoods malSimilarGoods : malSimilarGoodsList) {
            for (MalSaleAttr malSaleAttr : malSimilarGoods.getMalSaleAttrs()) {
                HashSet<String> skuIds = new HashSet<String>(malSaleAttr.getSkuIds().size());
                for (Object skuId : malSaleAttr.getSkuIds()) {
                    skuIds.add(String.valueOf(skuId));
                }
                malSaleAttr.setSkuIds(skuIds);
            }
        }
        return CustomApiResult.success((Object)malSimilarGoodsList);
    }

    @ApiGetMapping(value="getLadderPrice")
    public CustomApiResult<List<LadderPriceInfo>> getLadderPrice(@ApiParam(value="\u5546\u54c1id", required=true, example="1710991854566177792") @ApiParam(value="\u5546\u54c1id", required=true, example="1710991854566177792") Long productId) {
        Map ladderPriceMap = MalGoods.batchGetLadderPrice(Collections.singletonList(productId), (Long)RequestContext.get().getOrgId());
        return CustomApiResult.success(ladderPriceMap.get(productId));
    }

    @ApiGetMapping(value="getRecommendedGoods")
    public CustomApiResult<MalSearchResult> getRecommendedGoods(@ApiParam(value="\u5546\u54c1id", required=true, example="1718241682136516608") @ApiParam(value="\u5546\u54c1id", required=true, example="1718241682136516608") Long productId, @ApiParam(value="\u7535\u5546\u5e73\u53f0", required=true, example="1") @ApiParam(value="\u7535\u5546\u5e73\u53f0", required=true, example="1") String platform) {
        MalGoods malGoods = MalGoods.of((MalMatGoodsInitParam)MalMatGoodsInitParam.buildGeneralParam((Long)productId, (String)platform, (BigDecimal)BigDecimal.ONE, null, (Long)RequestContext.get().getOrgId()), (boolean)false, (boolean)false);
        RecommendRule recommendRule = new RecommendRule();
        recommendRule.setMalGoods(malGoods);
        ArrayList<RecommendRule> recommendRuleList = new ArrayList<RecommendRule>();
        recommendRuleList.add(recommendRule);
        MalConverRuleService malConverRuleService = (MalConverRuleService)DomainServiceFactory.serviceOf(MalConverRuleService.class);
        SearchParam searchParam = malConverRuleService.converRuleToSearchParam(recommendRuleList);
        MalEsSearchParam malEsSearchParam = new MalEsSearchParam();
        EsSearchParam esSearchParam = new EsSearchParam();
        esSearchParam.setPageNum(0);
        esSearchParam.setPageSize(60);
        EsFilterField sourceEsFilter = new EsFilterField("source", "=", new Object[]{searchParam.getSource()});
        ArrayList<EsFilterField> esFilterFields = new ArrayList<EsFilterField>();
        esFilterFields.add(sourceEsFilter);
        EsFilterField categoryNumberFilter = new EsFilterField("classnumber", "=", new Object[]{searchParam.getCategoryNumber()});
        esFilterFields.add(categoryNumberFilter);
        EsFilterField goodsNameEsFilter = new EsFilterField("name", "like", new Object[]{"%" + searchParam.getProductName() + "%"});
        esFilterFields.add(goodsNameEsFilter);
        EsFilterField notItselfFilter = new EsFilterField("goodsid", "!=", new Object[]{searchParam.getProductId()});
        esFilterFields.add(notItselfFilter);
        esFilterFields.add(this.getMallstatusFilter());
        esSearchParam.setEsFilterFields(esFilterFields);
        malEsSearchParam.setEsSearchParam(esSearchParam);
        MalSearchResult malSearchResult = ((MalEsSearchService)DomainServiceFactory.serviceOf(MalEsSearchService.class)).search(malEsSearchParam);
        malSearchResult.setMalNewSearchDyn(null);
        malSearchResult.setMalFilterBars(null);
        return CustomApiResult.success((Object)malSearchResult);
    }

    private EsFilterField getMallstatusFilter() {
        return new EsFilterField("mallstatus", "=", new Object[]{"B"}).or(new EsFilterField("mallstatus", "=", new Object[]{"1"}));
    }
}

