/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.webapi.controller;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.custom.annotation.ApiResponseBody;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.mal.business.factory.MalBusinessFactory;
import kd.scm.mal.business.placeorder.entity.MalToPlaceOrderItem;
import kd.scm.mal.business.placeorder.entity.MalToPlaceOrderParam;
import kd.scm.mal.business.placeorder.service.MalPlaceOrderService;
import kd.scm.mal.business.placeorder.vo.MalPlaceOrderVo;
import kd.scm.mal.business.shopcart.service.MalShopCartService;
import kd.scm.mal.business.shopcart.vo.MalCartItemVo;
import kd.scm.mal.business.shopcart.vo.MalCartVo;

@ApiController(value="mal", desc="\u5546\u57ce\u8d2d\u7269\u8f66\u670d\u52a1")
@ApiMapping(value="shopcart")
public class MalShopCartController {
    private static final Log log = LogFactory.getLog((String)MalShopCartController.class.getName());

    @ApiPostMapping(value="addToCart")
    public CustomApiResult<Void> addToCart(@ApiParam(value="\u5546\u54c1id", required=true, example="1718241682136516608") @ApiParam(value="\u5546\u54c1id", required=true, example="1718241682136516608") Long goodsId, @ApiParam(value="\u7535\u5546\u5e73\u53f0", required=true, example="1") @ApiParam(value="\u7535\u5546\u5e73\u53f0", required=true, example="1") String platform, @ApiParam(value="\u52a0\u8d2d\u6570\u91cf", required=true, example="10") @ApiParam(value="\u52a0\u8d2d\u6570\u91cf", required=true, example="10") BigDecimal qty) {
        try {
            ((MalShopCartService)MalBusinessFactory.serviceOf(MalShopCartService.class)).addToCart(goodsId, platform, qty);
        }
        catch (KDBizException e) {
            return CustomApiResult.fail((String)ApiErrorCode.Data_Invalid.getStatusCode(), (String)e.getMessage());
        }
        return CustomApiResult.success(null);
    }

    @ApiPostMapping(value="getCart")
    public CustomApiResult<@ApiResponseBody(value="\u5f53\u524d\u7528\u6237\u8d2d\u7269\u8f66\u4fe1\u606f") MalCartVo> getCart(@ApiParam(value="\u6536\u8d27\u5730\u5740id") @ApiParam(value="\u6536\u8d27\u5730\u5740id") Long receiptId) {
        return CustomApiResult.success((Object)((MalShopCartService)MalBusinessFactory.serviceOf(MalShopCartService.class)).getCart(receiptId));
    }

    @ApiPostMapping(value="deleteCartItems")
    public CustomApiResult<Void> deleteCartItems(@ApiParam(value="\u8d2d\u7269\u8f66\u5546\u54c1id\u5217\u8868", required=true, example="[1718241682136516608]") @ApiParam(value="\u8d2d\u7269\u8f66\u5546\u54c1id\u5217\u8868", required=true, example="[1718241682136516608]") List<Long> goodsIds) {
        ((MalShopCartService)MalBusinessFactory.serviceOf(MalShopCartService.class)).deleteCartItems(goodsIds);
        return CustomApiResult.success(null);
    }

    @ApiPostMapping(value="modifyCartItemQty")
    public CustomApiResult<Void> updateCartItemQty(@ApiParam(value="\u5546\u54c1id", required=true, example="1718241682136516608") @ApiParam(value="\u5546\u54c1id", required=true, example="1718241682136516608") Long goodsId, @ApiParam(value="\u7535\u5546\u5e73\u53f0", required=true, example="1") @ApiParam(value="\u7535\u5546\u5e73\u53f0", required=true, example="1") String platform, @ApiParam(value="\u4fee\u6539\u6570\u91cf", required=true, example="10") @ApiParam(value="\u4fee\u6539\u6570\u91cf", required=true, example="10") BigDecimal qty) {
        ((MalShopCartService)MalBusinessFactory.serviceOf(MalShopCartService.class)).modifyCartItemQty(goodsId, platform, qty);
        return CustomApiResult.success(null);
    }

    @ApiPostMapping(value="toPlaceOrder")
    public CustomApiResult<MalPlaceOrderVo> toPlaceOrder(@ApiParam(value="\u9009\u4e2d\u7684\u8d2d\u7269\u8f66\u5546\u54c1", required=true) @ApiParam(value="\u9009\u4e2d\u7684\u8d2d\u7269\u8f66\u5546\u54c1", required=true) List<MalCartItemVo> selectedCartItemVoList, @ApiParam(value="\u6536\u8d27\u5730\u5740id", required=true) @ApiParam(value="\u6536\u8d27\u5730\u5740id", required=true) Long receiptId, @ApiParam(value="\u4e0b\u5355\u7ec4\u7ec7id") @ApiParam(value="\u4e0b\u5355\u7ec4\u7ec7id") Long orgId) {
        if (!ObjectUtils.isEmpty(selectedCartItemVoList)) {
            MalToPlaceOrderParam malToPlaceOrderParam = this.prepareToPlaceOrderParam(selectedCartItemVoList, receiptId, orgId);
            try {
                MalPlaceOrderVo malPlaceOrderVo = ((MalPlaceOrderService)MalBusinessFactory.serviceOf(MalPlaceOrderService.class)).toPlaceOrder(malToPlaceOrderParam);
                return CustomApiResult.success((Object)malPlaceOrderVo);
            }
            catch (Exception e) {
                log.error(ExceptionUtil.getStackTrace((Throwable)e));
                return CustomApiResult.fail((String)ApiErrorCode.Data_Invalid.getStatusCode(), (String)e.getMessage());
            }
        }
        return CustomApiResult.fail((String)ApiErrorCode.Data_NotFound.getStatusCode(), (String)ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u8d2d\u7269\u8f66\u5546\u54c1\u8fdb\u884c\u7ed3\u7b97\u3002", (String)"MalShopCartController_8", (String)"scm-mal-webapi", (Object[])new Object[0]));
    }

    private MalToPlaceOrderParam prepareToPlaceOrderParam(List<MalCartItemVo> selectedCartItemVoList, Long receiptId, Long orgId) {
        MalToPlaceOrderParam malToPlaceOrderParam = new MalToPlaceOrderParam();
        malToPlaceOrderParam.setReceiptId(receiptId);
        if (orgId == null || orgId == 0L) {
            orgId = RequestContext.get().getOrgId();
        }
        malToPlaceOrderParam.setDptOrgId(orgId);
        ArrayList<MalToPlaceOrderItem> malToPlaceOrderItems = new ArrayList<MalToPlaceOrderItem>(selectedCartItemVoList.size());
        for (MalCartItemVo selectedCartItemVo : selectedCartItemVoList) {
            MalToPlaceOrderItem malToPlaceOrderItem = new MalToPlaceOrderItem();
            malToPlaceOrderItem.setQty(selectedCartItemVo.getQty());
            malToPlaceOrderItem.setGoodsId(selectedCartItemVo.getGoodsId());
            malToPlaceOrderItem.setGoodsNumber(selectedCartItemVo.getGoodsNumber());
            malToPlaceOrderItem.setPlatform(selectedCartItemVo.getPlatform());
            malToPlaceOrderItems.add(malToPlaceOrderItem);
        }
        malToPlaceOrderParam.setMalToPlaceOrderItemList(malToPlaceOrderItems);
        return malToPlaceOrderParam;
    }
}

