/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.webapi.plugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.openapi.api.plugin.ApiQueryPlugin;
import kd.bos.openapi.api.plugin.ApiSerializerPlugin;
import kd.bos.openapi.api.plugin.SerializerResult;
import kd.bos.openapi.api.result.ApiQueryResult;
import kd.bos.openapi.common.result.OpenApiResult;
import kd.bos.openapi.common.util.JacksonUtil;
import kd.bos.orm.query.QFilter;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.enums.JDOrderStatusEnum;

public class MalOrderGetDetailPlugin
implements ApiQueryPlugin,
ApiSerializerPlugin {
    public QFilter getFilter(QFilter filter, Map<String, Object> reqData) {
        Map data = (Map)reqData.get("data");
        for (Map.Entry entry : data.entrySet()) {
            if (!StringUtils.equals((CharSequence)"erplogstatus", (CharSequence)((CharSequence)entry.getKey())) || !StringUtils.isNotBlank(entry.getValue())) continue;
            filter.and("entryentity.erplogstatus", "=", entry.getValue());
        }
        return filter;
    }

    public SerializerResult serialize(Object response, String accept, String contentType) {
        OpenApiResult openApiResult;
        HashMap<String, String> platformValToNameMap = new HashMap<String, String>();
        if (response instanceof OpenApiResult && (openApiResult = (OpenApiResult)response).getData() instanceof ApiQueryResult) {
            ApiQueryResult apiQueryResult = (ApiQueryResult)openApiResult.getData();
            for (Map row : apiQueryResult.getRows()) {
                Object orderStatus;
                Object platform = row.get("platform");
                if (platform != null) {
                    String platformName = (String)platformValToNameMap.get(platform.toString());
                    if (StringUtils.isBlank((CharSequence)platformName)) {
                        platformName = EcPlatformEnum.fromVal((String)platform.toString()).getName();
                        platformValToNameMap.put(platform.toString(), platformName);
                    }
                    row.put("platform_name", platformName);
                }
                if ((orderStatus = row.get("orderstatus")) != null) {
                    for (JDOrderStatusEnum orderStatusEnum : JDOrderStatusEnum.values()) {
                        if (!orderStatusEnum.getVal().equals(String.valueOf(orderStatus))) continue;
                        row.put("orderstatus_name", orderStatusEnum.getName());
                    }
                }
                LinkedHashMap supplierIdToRowsMap = new LinkedHashMap();
                List entryentity = (List)row.get("entryentity");
                if (ObjectUtils.isEmpty((Object)entryentity)) continue;
                for (Map entry : entryentity) {
                    Object supplierId = entry.get("supplier_id");
                    if (supplierId == null) continue;
                    supplierId = String.valueOf(supplierId);
                    List rows = supplierIdToRowsMap.getOrDefault(supplierId, new ArrayList());
                    rows.add(entry);
                    supplierIdToRowsMap.put(supplierId, rows);
                }
                row.put("entryentity", supplierIdToRowsMap);
            }
        }
        return new SerializerResult("application/json", JacksonUtil.writeValueAsPrettyString((Object)response));
    }
}

