/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.webapi.service.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.mal.domain.service.DomainServiceFactory;
import kd.scm.mal.domain.service.MalVersionSwitchService;
import kd.scm.mal.webapi.dto.MainPageConfigDtoNew;
import kd.scm.mal.webapi.service.IMainPageConfigService;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public abstract class AbstractMainPageConfigServiceNew
implements IMainPageConfigService {
    protected MainPageConfigDtoNew mainPageConfigDtoNew = new MainPageConfigDtoNew();
    protected static final Log log = LogFactory.getLog(AbstractMainPageConfigServiceNew.class);
    private static final ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"mainPageThreadPool", (int)4);
    private final Map<String, Long> componentNameIdMap = new HashMap<String, Long>(16);

    @Override
    public MainPageConfigDtoNew getMainPageConfig() {
        long start = System.currentTimeMillis();
        try (DataSet ds = this.loadMainPageConfigDs();){
            this.initComponentNameIdMap(ds);
            Future navJoFuture = threadPool.submit(this::confNavJo);
            Future cardBodyJAFuture = threadPool.submit(() -> this.confCardBody(ds));
            JSONObject logoJo = this.confLogoJo(ds);
            JSONObject malSwiperJo = this.confMalSwiper(ds);
            JSONObject storeBodyJo = this.confStoreBody(ds);
            JSONObject catGoodsShowJo = this.confCatGoodsShowJo(ds);
            JSONObject cartJo = this.confCartJo();
            JSONArray topMenuItemJa = this.confTopMenuItem();
            JSONObject constant = this.confConstant();
            JSONObject bottombox = this.confBottombox(ds);
            JSONObject showMainPage = this.confshowMainPage();
            this.mainPageConfigDtoNew.setSearchFormId(((MalVersionSwitchService)DomainServiceFactory.serviceOf(MalVersionSwitchService.class)).getMalNewSearchKey());
            this.mainPageConfigDtoNew.setShowMainPage(showMainPage);
            this.mainPageConfigDtoNew.setBottombox(bottombox);
            this.mainPageConfigDtoNew.setLogo(logoJo);
            this.mainPageConfigDtoNew.setMalSwiper(malSwiperJo);
            this.mainPageConfigDtoNew.setStoreBody(storeBodyJo);
            this.mainPageConfigDtoNew.setCategoryGoodsShow(catGoodsShowJo);
            this.mainPageConfigDtoNew.setCart(cartJo);
            this.mainPageConfigDtoNew.setTopMenuItem(topMenuItemJa);
            this.mainPageConfigDtoNew.setConstant(constant);
            try {
                this.mainPageConfigDtoNew.setCardBody((JSONArray)cardBodyJAFuture.get());
                this.mainPageConfigDtoNew.setNav((JSONObject)navJoFuture.get());
            }
            catch (InterruptedException | ExecutionException e) {
                log.warn(ExceptionUtil.getStackTrace((Throwable)e));
                throw new KDBizException("kd.scm.mal.webapi.service.impl.AbstractMainPageConfigServiceNew.getMainPageConfig:" + e.getMessage());
            }
        }
        log.info("@@showMainPage cost:" + (System.currentTimeMillis() - start));
        return this.mainPageConfigDtoNew;
    }

    protected void initComponentNameIdMap(DataSet ds) {
        DataSet logoDs = ds.copy();
        for (Row row : logoDs) {
            this.componentNameIdMap.put(row.getString("entryentity.component.group.compobject.number"), row.getLong("entryentity.component.id"));
        }
    }

    public Long getComponentId(String name) {
        return this.componentNameIdMap.getOrDefault(name, 0L);
    }

    public abstract JSONObject confConstant();

    public abstract JSONObject confLogoJo(DataSet var1);

    public abstract JSONArray confTopMenuItem();

    public abstract JSONObject confCartJo();

    public abstract JSONObject confNavJo();

    public abstract JSONObject confCatGoodsShowJo(DataSet var1);

    public abstract JSONObject confStoreBody(DataSet var1);

    public abstract JSONObject confMalSwiper(DataSet var1);

    public abstract JSONArray confCardBody(DataSet var1);

    public abstract JSONObject confBottombox(DataSet var1);

    public abstract JSONObject confshowMainPage();

    public DataSet loadMainPageConfigDs() {
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE).and(new QFilter("isnew", "=", (Object)Boolean.TRUE));
        DynamicObjectCollection query = QueryServiceHelper.query((String)"pmm_compconfig", (String)"number,rank", (QFilter[])new QFilter[]{enableFilter}, (String)"rank asc");
        if (query.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5230\u201c\u5546\u57ce\u7ba1\u7406-\u57fa\u7840\u8bbe\u7f6e-\u5546\u57ce\u9996\u9875\u914d\u7f6e\u201d\u4e2d\u542f\u7528\u9996\u9875\u914d\u7f6e\u65b9\u6848\u3002", (String)"AbstractMainPageConfigServiceNew_0", (String)"scm-mal-webapi", (Object[])new Object[0]));
        }
        String selectFields = "id,name,number,goodsclass,entryentity.component.id,entryentity.component.name,entryentity.component.group.id,entryentity.component.group.name,entryentity.component.group.number,entryentity.component.group.compobject.number";
        DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"pmm_compconfig", (String)selectFields, (QFilter[])new QFilter[]{enableFilter.and(new QFilter("number", "=", (Object)((DynamicObject)query.get(0)).getString("number")))}, (String)"entryentity.seq");
        try (DataSet copyDs = ds.copy();){
            Iterator iterator = copyDs.iterator();
            if (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                ds = ds.filter("id = " + row.getString("id"));
            }
            DataSet dataSet = ds;
            return dataSet;
        }
    }
}

