/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.webapi.service.impl;

import java.math.BigDecimal;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.url.UrlService;
import kd.scm.common.ecapi.entity.GoodsInfo;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.ProductSourceEnum;
import kd.scm.mal.common.addcart.MalAddToCartHelper;
import kd.scm.mal.common.util.MainPageUtils;
import kd.scm.mal.common.util.MalProductUtil;
import kd.scm.mal.common.util.MalSearchUtils;
import kd.scm.mal.webapi.service.IMainPageService;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

@Deprecated
public class MainPageServiceImpl
implements IMainPageService {
    private static final Log log = LogFactory.getLog(MainPageServiceImpl.class);

    @Override
    public int addToCart(String pk, String source) {
        MalAddToCartHelper.addCartNew((Long)Long.parseLong(pk), (String)source);
        return MalProductUtil.getCartNumber();
    }

    @Override
    public int getCartNum() {
        return MalProductUtil.getCartNumber();
    }

    @Override
    public JSONArray categorygoodsShowLoadMore(List<String> excepGoodclassIds) {
        JSONArray categoryGoodsJa = new JSONArray();
        String selectFields = "id,number,name,longnumber";
        QFilter sourceFilter = new QFilter("source", "=", (Object)ProductSourceEnum.PRODUCTSOURCE_SELF.getVal());
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter idNotInFilter = new QFilter("id", "not in", excepGoodclassIds);
        QFilter levelFilter = new QFilter("level", "=", (Object)"3");
        QFilter statusFilter = new QFilter("status", "=", (Object)BillStatusEnum.AUDIT.getVal());
        boolean con = true;
        StringBuilder logString = new StringBuilder();
        while (con) {
            DataSet goodclassDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"pbd_goodsclass", (String)selectFields, (QFilter[])new QFilter[]{sourceFilter, enableFilter, idNotInFilter, levelFilter, statusFilter}, null, (int)3);
            if (goodclassDs.copy().count("id", false) < 3) {
                con = false;
            }
            while (goodclassDs.hasNext()) {
                Row goodclass = goodclassDs.next();
                QFilter categoryFilter = new QFilter("category", "=", (Object)goodclass.getString("id"));
                QFilter mallstatusFilter = new QFilter("mallstatus", "=", (Object)"B");
                String goodsSelectFields = "id,number,name,source,shopprice,thumbnail,supplier.name";
                DataSet goodsDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"pbd_goods", (String)goodsSelectFields, (QFilter[])new QFilter[]{enableFilter, categoryFilter, mallstatusFilter, statusFilter, sourceFilter}, null, (int)3);
                Iterator iterator = goodsDs.iterator();
                JSONArray productJa = new JSONArray();
                JSONObject categoryGoodsJo = new JSONObject();
                if (!iterator.hasNext()) {
                    excepGoodclassIds.add(goodclass.getString("id"));
                    logString.append(ResManager.loadKDString((String)"@@\u65e0\u5546\u54c1\u5206\u7c7b\uff1a", (String)"MainPageServiceImpl_0", (String)"scm-mal-webapi", (Object[])new Object[0])).append(goodclass.getString("id")).append("&").append(goodclass.getString("number")).append("\n");
                }
                while (iterator.hasNext()) {
                    Row catProduct = (Row)iterator.next();
                    if (!categoryGoodsJo.containsKey((Object)"category")) {
                        JSONObject categoryJo = new JSONObject();
                        categoryJo.put((Object)"id", (Object)goodclass.getString("id"));
                        categoryJo.put((Object)"name", (Object)goodclass.getString("name"));
                        categoryJo.put((Object)"number", (Object)goodclass.getString("number"));
                        categoryJo.put((Object)"longNumber", (Object)goodclass.getString("longnumber"));
                        categoryGoodsJo.put((Object)"category", (Object)categoryJo);
                    }
                    JSONObject productJo = new JSONObject();
                    productJo.put((Object)"productId", (Object)catProduct.getString("id"));
                    productJo.put((Object)"source", (Object)catProduct.getString("source"));
                    productJo.put((Object)"productName", (Object)catProduct.getString("name"));
                    productJo.put((Object)"shopPrice", (Object)catProduct.getBigDecimal("shopprice").setScale(2, 4));
                    String thumbnail = catProduct.getString("thumbnail");
                    if (!thumbnail.startsWith("http")) {
                        thumbnail = UrlService.getImageFullUrl((String)thumbnail);
                    }
                    productJo.put((Object)"productImgPath", (Object)thumbnail);
                    productJo.put((Object)"supplier", (Object)catProduct.getString("supplier.name"));
                    productJa.add((Object)productJo);
                    categoryGoodsJo.put((Object)"goods", (Object)productJa);
                }
                if (!categoryGoodsJo.containsKey((Object)"goods") || !categoryGoodsJo.containsKey((Object)"category")) continue;
                categoryGoodsJa.add((Object)categoryGoodsJo);
                con = false;
            }
        }
        log.info(logString.toString());
        log.info("@@excepGoodclassIds:" + excepGoodclassIds.size());
        return categoryGoodsJa;
    }

    @Override
    public JSONArray loadJdProducts() {
        DynamicObject[] col = MainPageUtils.getAvailableCategory((String)ProductSourceEnum.PRODUCTSOURCE_JD.getVal());
        LinkedHashMap<String, JSONObject> catProductMap = new LinkedHashMap<String, JSONObject>();
        for (int i = 0; i < col.length; ++i) {
            String catNumber = col[i].getString("number");
            List goodsInfos = MalSearchUtils.searchFromJDByCategory((String)catNumber, (int)1, (int)12);
            String catId = col[i].getString("id");
            if (goodsInfos.size() > 0 && !catProductMap.containsKey(catId)) {
                JSONObject categoryGoodsJo = new JSONObject();
                JSONObject categoryJo = new JSONObject();
                categoryJo.put((Object)"id", (Object)catId);
                categoryJo.put((Object)"name", (Object)col[i].getString("name"));
                categoryJo.put((Object)"number", (Object)catNumber);
                categoryJo.put((Object)"longNumber", (Object)col[i].getString("longnumber"));
                categoryGoodsJo.put((Object)"category", (Object)categoryJo);
                JSONArray productJa = new JSONArray();
                categoryGoodsJo.put((Object)"goods", (Object)productJa);
                catProductMap.put(catId, categoryGoodsJo);
            }
            for (GoodsInfo goodsInfo : goodsInfos) {
                JSONObject productJo = new JSONObject();
                productJo.put((Object)"productId", (Object)goodsInfo.getProductId());
                if (ProductSourceEnum.PRODUCTSOURCE_JD.getName().equals(goodsInfo.getProductSource())) {
                    productJo.put((Object)"source", (Object)ProductSourceEnum.PRODUCTSOURCE_JD.getVal());
                }
                productJo.put((Object)"productName", (Object)goodsInfo.getProductName());
                BigDecimal shopprice = goodsInfo.getShopPrice();
                productJo.put((Object)"shopPrice", (Object)String.valueOf((shopprice == null ? BigDecimal.ZERO : shopprice).setScale(2, 4)));
                String thumbnail = goodsInfo.getProductImgPath();
                if (thumbnail != null && !thumbnail.startsWith("http")) {
                    thumbnail = UrlService.getImageFullUrl((String)thumbnail);
                }
                productJo.put((Object)"productImgPath", (Object)thumbnail);
                productJo.put((Object)"supplier", (Object)goodsInfo.getSupplier());
                JSONObject jsonObject = (JSONObject)catProductMap.get(catId);
                if (jsonObject == null) continue;
                jsonObject.getJSONArray("goods").add((Object)productJo);
            }
        }
        return JSONArray.fromObject(catProductMap.values());
    }

    @Override
    public JSONObject getNavJo(String source) {
        JSONObject navJo = new JSONObject();
        navJo.put((Object)"isShowAlways", (Object)Boolean.FALSE);
        navJo.put((Object)"navItems", (Object)MainPageUtils.getCategory((String)source));
        return navJo;
    }
}

