/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.ecapi.jd.enums.AfterSaleServiceTypeEnum;
import kd.scm.common.ecapi.jd.enums.ComponentExportEnum;
import kd.scm.common.ecapi.util.AddressUtil;
import kd.scm.common.ecapi.util.PayTypeUtil;
import kd.scm.common.enums.ReturnStatusEnum;
import kd.scm.common.util.BOTPUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.MutexUtil;
import kd.scm.common.util.ValidateMatchUtil;
import kd.scm.mal.common.aftersale.AfterSaleFactory;
import kd.scm.mal.common.aftersale.IAfterSaleService;
import kd.scm.mal.common.aftersale.enums.SNBankEnum;
import kd.scm.mal.common.aftersale.enums.SNReturnReasonEnum;
import kd.scm.mal.common.aftersale.enums.XFSReturnReasonEnum;
import kd.scm.mal.common.util.MalAddressUtil;
import kd.scm.mal.common.util.MalPlaceOrderUtils;

public class MalAfterSalePlugin
extends AbstractFormPlugin
implements UploadListener,
CellClickListener,
RowClickEventListener {
    public static final String CACHE_SOURCE = "source";
    public static final String BILLID = "billid";
    private static final String CACHE_CURROW = "currow";
    private static final String CACHE_MALORDERID = "CACHE_MALORDERID";
    private static final String CASH_ON_DELIVERY = "03";
    private static final long CHINA = 1000001L;
    private static final Log log = LogFactory.getLog(MalAfterSalePlugin.class);

    public void afterCreateNewData(EventObject e) {
        String orderEntryToAfterSale = (String)this.getView().getFormShowParameter().getCustomParam("malOrderEntry");
        if (orderEntryToAfterSale != null) {
            List<String> malOrderEntries = Arrays.asList(orderEntryToAfterSale.split(","));
            HashSet<String> mutexIdSet = new HashSet<String>(malOrderEntries);
            HashSet successMutexIdSet = new HashSet(malOrderEntries.size());
            Map batchRequest = MutexUtil.batchRequest(mutexIdSet, (String)this.getView().getEntityId(), (String)"returnreq");
            for (Map.Entry booleanEntry : batchRequest.entrySet()) {
                if (!((Boolean)booleanEntry.getValue()).booleanValue()) {
                    MutexUtil.batchRelease(successMutexIdSet, (String)this.getView().getEntityId(), (String)"returnreq");
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u6709\u5355\u636e\u5728\u9000\u8d27\u7533\u8bf7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u6267\u884c\u3002", (String)"MalAfterSalePlugin_28", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                    return;
                }
                successMutexIdSet.add(booleanEntry.getKey());
            }
            this.getPageCache().put("successMutexIdSet", JSON.toJSONString(successMutexIdSet));
            this.initView(malOrderEntries);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Boolean visibleFlag = Boolean.TRUE;
        String source = this.getPageCache().get(CACHE_SOURCE);
        CardEntry cardEntry = (CardEntry)this.getControl("entryentity");
        if (!EcPlatformEnum.ECPLATFORM_SUNING.getVal().equals(source) && !EcPlatformEnum.ECPLATFORM_XFS.getVal().equals(source)) {
            visibleFlag = Boolean.FALSE;
            cardEntry.setChildVisible(visibleFlag.booleanValue(), -1, new String[]{"reasonflex1", "servicetimeflex1"});
            this.getView().setVisible(visibleFlag, new String[]{"reasonflex", "flexpanelap53", "flexpanelap511", "flexpanelap54", "servicetimeflex"});
        }
        if (EcPlatformEnum.ECPLATFORM_SUNING.getVal().equals(source)) {
            cardEntry.setChildVisible(visibleFlag.booleanValue(), -1, new String[]{"reasonflex1", "servicetimeflex1"});
            this.getView().setVisible(visibleFlag, new String[]{"reasonflex", "flexpanelap53", "flexpanelap511", "flexpanelap54", "servicetimeflex"});
        }
        if (EcPlatformEnum.ECPLATFORM_XFS.getVal().equals(source)) {
            cardEntry.setChildVisible(visibleFlag.booleanValue(), -1, new String[]{"reasonflex1"});
            cardEntry.setChildVisible(false, -1, new String[]{"servicetimeflex1"});
            this.getView().setVisible(visibleFlag, new String[]{"reasonflex"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap53", "flexpanelap511", "flexpanelap54", "servicetimeflex"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        CardEntry cardEntry = (CardEntry)this.getControl("entryentity");
        cardEntry.addCellClickListener((CellClickListener)this);
    }

    private void initView(List<String> malRrderEntries) {
        DynamicObjectCollection malOrderCol = this.getOrderDynColByEntryId(malRrderEntries);
        this.initEcPage(this.getPageCache().get(CACHE_SOURCE));
        this.fillData(malOrderCol);
    }

    private DynamicObjectCollection getOrderDynColByEntryId(List<String> malOrderEntriyIds) {
        String selectFields = "id,entryentity.id,entryentity.goods.id,entryentity.goods.number,entryentity.goods.supplier,entryentity.goods.name,entryentity.goods.model,entryentity.goods.thumbnail,platform,entryentity.goods.packinglist,entryentity.qty,entryentity.sumreceiptqty,entryentity.suminstockqty,entryentity.taxprice,entryentity.taxrate,entryentity.price,entryentity.jdorder.id,entryentity.jdorder.number,receipt.wholeaddress,ecorderid,ecsource,entryentity.order,entryentity.sumreturnreqqty";
        ArrayList malOrderEntriyLongIds = new ArrayList(malOrderEntriyIds.size());
        malOrderEntriyIds.forEach(id -> {
            if (StringUtils.isNotEmpty((CharSequence)id)) {
                malOrderEntriyLongIds.add(Long.valueOf(id));
            }
        });
        QFilter entryIdFilter = new QFilter("entryentity.id", "in", malOrderEntriyLongIds);
        QFilter[] filters = new QFilter[]{entryIdFilter};
        DynamicObjectCollection dynCol = QueryServiceHelper.query((String)"mal_order", (String)selectFields, (QFilter[])filters);
        if (dynCol.size() > 0) {
            this.getPageCache().put(CACHE_SOURCE, ((DynamicObject)dynCol.get(0)).getString("platform"));
        }
        return dynCol;
    }

    private void fillData(DynamicObjectCollection malOrderDynCol) {
        if (malOrderDynCol.size() == 0) {
            return;
        }
        this.fillCommonField(malOrderDynCol);
        this.fillAfterSaleGoodsDeltail(malOrderDynCol);
    }

    private Set<String> getEntryentityIds(DynamicObjectCollection malOrderDynCol) {
        HashSet<String> srcentryids = new HashSet<String>();
        for (DynamicObject item : malOrderDynCol) {
            String srcentryid = item.getString("entryentity.id");
            srcentryids.add(srcentryid);
        }
        return srcentryids;
    }

    public void fillAfterSaleGoodsDeltail(DynamicObjectCollection malOrderDynCol) {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        String ecPorderId = "";
        String source = this.getPageCache().get(CACHE_SOURCE);
        IAfterSaleService afterSaleService = AfterSaleFactory.getAfterSaleServiceBySource((String)source);
        ArrayList<AfterSaleServiceTypeEnum> afterSaleServiceTypeEnums = new ArrayList<AfterSaleServiceTypeEnum>();
        ArrayList<ComponentExportEnum> componentExportEnums = new ArrayList<ComponentExportEnum>();
        if (!malOrderDynCol.isEmpty()) {
            String malOrderId = ((DynamicObject)malOrderDynCol.get(0)).getString("id");
            this.getPageCache().put(CACHE_MALORDERID, malOrderId);
            String ecPOrderPk = ((DynamicObject)malOrderDynCol.get(0)).getString("entryentity.order");
            String ecSource = ((DynamicObject)malOrderDynCol.get(0)).getString("ecsource");
            DynamicObject ecOrderDyn = this.queryEcOrderDyn(ecSource, ecPOrderPk);
            String string = ecPorderId = ecOrderDyn != null ? ecOrderDyn.getString("porderid") : "";
            if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(source)) {
                this.fillSelfDetail();
            } else {
                this.fillEcDetail(malOrderDynCol, afterSaleServiceTypeEnums, componentExportEnums, ecOrderDyn, ecPorderId, afterSaleService, source);
            }
            Map<String, String> skuEcorderIdMap = this.getSkuEcorderIdMap(malOrderDynCol);
            Map<String, String> skuEcorderPkMap = this.getSkuEcOrderPkMap(malOrderDynCol, source);
            Set<String> srcentryids = this.getEntryentityIds(malOrderDynCol);
            Map srcEntryIdRetMap = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IPurOrderService", (String)"getDataForReceiptAndReturn", (Object[])new Object[]{srcentryids});
            log.info("fillAfterSaleGoodsDeltail.srcEntryIdRetMap" + srcEntryIdRetMap);
            HashMap<String, String> pageCacheTempMap = new HashMap<String, String>(malOrderDynCol.size() << 2);
            for (int i = 0; i < malOrderDynCol.size(); ++i) {
                DynamicObject malOrderDyn = (DynamicObject)malOrderDynCol.get(i);
                this.fillEntryData(malOrderDyn, vs, i);
                String sku = malOrderDyn.getString("entryentity.goods.number");
                String ecOrderId = skuEcorderIdMap.get(sku);
                if (this.judgeSource(source) && StringUtils.isEmpty((CharSequence)ecOrderId)) {
                    ecOrderId = malOrderDyn.getString("entryentity.jdorder.number");
                }
                Map itemMap = (Map)srcEntryIdRetMap.get(malOrderDyn.getString("entryentity.id"));
                BigDecimal sumrecretqty = BigDecimal.ZERO;
                BigDecimal suminstockretqty = BigDecimal.ZERO;
                if (itemMap != null) {
                    sumrecretqty = (BigDecimal)itemMap.get("sumrecretqty");
                    suminstockretqty = (BigDecimal)itemMap.get("suminstockretqty");
                }
                BigDecimal canreturnqty = afterSaleService.getCanReturnQty(ecOrderId, malOrderDyn, sumrecretqty, suminstockretqty);
                if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(source)) {
                    vs.set("pickwaretype", (Object)ComponentExportEnum.DOOR_TO_TAKE.getVal(), i);
                    vs.set("customerexpect", (Object)AfterSaleServiceTypeEnum.RETURN.getVal(), i);
                }
                this.processDefaultValue(source, vs, componentExportEnums, afterSaleServiceTypeEnums, i);
                canreturnqty = canreturnqty.compareTo(BigDecimal.ZERO) > 0 ? canreturnqty : BigDecimal.ZERO;
                vs.set("canreturnqty", (Object)canreturnqty, i);
                vs.set("jdchildorderid", (Object)ecOrderId, i);
                vs.set("ecporderid", (Object)ecPorderId, i);
                vs.set("ecorderid", (Object)skuEcorderIdMap.get(sku), i);
                vs.set("ecorderpk", (Object)skuEcorderPkMap.get(sku), i);
                if (null == sku || null == ecOrderId) continue;
                pageCacheTempMap.put(sku, ecOrderId);
            }
            this.getPageCache().put(pageCacheTempMap);
            model.batchCreateNewEntryRow("entryentity", vs);
        }
    }

    protected void fillEcDetail(DynamicObjectCollection malOrderDynCol, List<AfterSaleServiceTypeEnum> afterSaleServiceTypeEnums, List<ComponentExportEnum> componentExportEnums, DynamicObject ecOrderDyn, String ecPorderId, IAfterSaleService afterSaleService, String source) {
        if (ecOrderDyn == null) {
            return;
        }
        String ecSku = ((DynamicObject)malOrderDynCol.get(0)).getString("entryentity.goods.number");
        String ecOrderId = ecOrderDyn.getString("orderid");
        if (this.judgeSource(source) && StringUtils.isEmpty((CharSequence)ecOrderId)) {
            ecOrderId = ((DynamicObject)malOrderDynCol.get(0)).getString("entryentity.jdorder.number");
        }
        afterSaleServiceTypeEnums.addAll(afterSaleService.getCustomerExpectComp(ecOrderId, ecSku));
        componentExportEnums.addAll(afterSaleService.getComponentExport(ecOrderId, ecSku));
        afterSaleServiceTypeEnums = this.querySnAfterSaleServiceTypeEnums(ecOrderId, ecSku, ecPorderId, afterSaleService);
        Map<String, String> serviceTimeMap = this.queryServiceTimeMap(ecOrderId, ecSku, ecPorderId, afterSaleService);
        this.initCustomerExpectComboEdit(afterSaleServiceTypeEnums, source);
        this.initPickwareTypeComboEdit(componentExportEnums, source);
        this.initServiceTimeComboEdit(serviceTimeMap);
    }

    protected void fillSelfDetail() {
        ComboEdit pickwaretypeComboEdit = (ComboEdit)this.getControl("pickwaretype");
        ComboEdit customerExpectComboEdit = (ComboEdit)this.getControl("customerexpect");
        ArrayList<ComboItem> pickwaretypeData = new ArrayList<ComboItem>();
        ArrayList<ComboItem> customerExpectData = new ArrayList<ComboItem>();
        ComboItem pickwaretypeComboItem1 = new ComboItem(new LocaleString(ComponentExportEnum.CUSTOMER_SEND.getName()), String.valueOf(ComponentExportEnum.CUSTOMER_SEND.getVal()));
        ComboItem pickwaretypeComboItem2 = new ComboItem(new LocaleString(ComponentExportEnum.DOOR_TO_TAKE.getName()), String.valueOf(ComponentExportEnum.DOOR_TO_TAKE.getVal()));
        pickwaretypeData.add(pickwaretypeComboItem1);
        pickwaretypeData.add(pickwaretypeComboItem2);
        pickwaretypeComboEdit.setComboItems(pickwaretypeData);
        pickwaretypeComboEdit.selectedStore(pickwaretypeComboItem2);
        ComboItem customerExpectComboItem1 = new ComboItem(new LocaleString(AfterSaleServiceTypeEnum.RETURN.getName()), String.valueOf(AfterSaleServiceTypeEnum.RETURN.getVal()));
        ComboItem customerExpectComboItem2 = new ComboItem(new LocaleString(AfterSaleServiceTypeEnum.EXCHANGE.getName()), String.valueOf(AfterSaleServiceTypeEnum.EXCHANGE.getVal()));
        customerExpectData.add(customerExpectComboItem1);
        customerExpectData.add(customerExpectComboItem2);
        customerExpectComboEdit.setComboItems(customerExpectData);
        customerExpectComboEdit.selectedStore(customerExpectComboItem1);
    }

    protected void initServiceTimeComboEdit(Map<String, String> serviceTimeMap) {
        if (serviceTimeMap == null) {
            return;
        }
        ArrayList data = new ArrayList();
        ComboEdit servicetimeComboEdit = (ComboEdit)this.getControl("servicetime");
        serviceTimeMap.forEach((key, value) -> data.add(new ComboItem(new LocaleString(value), key)));
        servicetimeComboEdit.setComboItems(data);
    }

    protected Map<String, String> queryServiceTimeMap(String ecOrderId, String ecSku, String ecPorderId, IAfterSaleService afterSaleService) {
        String[] ecAdrLongnumberStrs = this.getAddrLongnumberStrs();
        if (ecAdrLongnumberStrs.length > 2) {
            return afterSaleService.queryRepaireServiceTime(ecOrderId, ecSku, ecPorderId, ecAdrLongnumberStrs[1], ecAdrLongnumberStrs[2]);
        }
        return new HashMap<String, String>();
    }

    protected String[] getAddrLongnumberStrs() {
        String ierpAdrId;
        String source = this.getPageCache().get(CACHE_SOURCE);
        String ecAdrLongnumber = "";
        if (StringUtils.isEmpty((CharSequence)ecAdrLongnumber) && StringUtils.isNotEmpty((CharSequence)(ierpAdrId = (String)this.getModel().getValue("admindivisionfield")))) {
            ecAdrLongnumber = AddressUtil.getLongNumber((Long)Long.valueOf(ierpAdrId), (String)source);
        }
        return ecAdrLongnumber.split("\\.");
    }

    protected Map<String, String> getSkuEcOrderPkMap(DynamicObjectCollection malOrderDynCol, String platform) {
        HashMap<String, String> res = new HashMap<String, String>();
        if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(platform)) {
            return res;
        }
        malOrderDynCol.forEach(malOrderDyn -> {
            boolean isEmpty;
            String ecorderPk = malOrderDyn.getString("entryentity.order");
            boolean bl = isEmpty = StringUtils.isEmpty((CharSequence)ecorderPk) || "0".equals(ecorderPk);
            if (isEmpty && this.judgeSource(platform)) {
                ecorderPk = malOrderDyn.getString("entryentity.jdorder.id");
            }
            if (StringUtils.isNotEmpty((CharSequence)ecorderPk) && !"0".equals(ecorderPk)) {
                res.put(malOrderDyn.getString("entryentity.goods.number"), ecorderPk);
            }
        });
        return res;
    }

    protected void processDefaultValue(String source, TableValueSetter vs, List<ComponentExportEnum> componentExportEnums, List<AfterSaleServiceTypeEnum> afterSaleServiceTypeEnums, int i) {
        if (this.judgeSource(source)) {
            this.processJdDefaultValue(vs, componentExportEnums, afterSaleServiceTypeEnums, i);
        }
        if (EcPlatformEnum.ECPLATFORM_SUNING.getVal().equals(source)) {
            this.processSnDefaultValue(vs, afterSaleServiceTypeEnums, i);
        }
    }

    protected void processJdDefaultValue(TableValueSetter vs, List<ComponentExportEnum> componentExportEnums, List<AfterSaleServiceTypeEnum> afterSaleServiceTypeEnums, int i) {
        for (ComponentExportEnum componentExportEnum : componentExportEnums) {
            if (ComponentExportEnum.DOOR_TO_TAKE.getVal() != componentExportEnum.getVal()) continue;
            vs.set("pickwaretype", (Object)ComponentExportEnum.DOOR_TO_TAKE.getVal(), i);
        }
        for (AfterSaleServiceTypeEnum afterSaleServiceTypeEnum : afterSaleServiceTypeEnums) {
            if (AfterSaleServiceTypeEnum.JD_RETURN.getVal() != afterSaleServiceTypeEnum.getVal()) continue;
            vs.set("customerexpect", (Object)AfterSaleServiceTypeEnum.JD_RETURN.getVal(), i);
        }
    }

    protected void processSnDefaultValue(TableValueSetter vs, List<AfterSaleServiceTypeEnum> afterSaleServiceTypeEnums, int i) {
        vs.set("pickwaretype", (Object)ComponentExportEnum.DOOR_TO_TAKE.getVal(), i);
        for (AfterSaleServiceTypeEnum afterSaleServiceTypeEnum : afterSaleServiceTypeEnums) {
            if (AfterSaleServiceTypeEnum.RETURN.getVal() != afterSaleServiceTypeEnum.getVal()) continue;
            vs.set("customerexpect", (Object)AfterSaleServiceTypeEnum.RETURN.getVal(), i);
        }
    }

    @Deprecated
    protected BigDecimal getCanReturnQty(String source, String ecOrderId, DynamicObject malOrderDyn, IAfterSaleService afterSaleService) {
        BigDecimal max = malOrderDyn.getBigDecimal("entryentity.sumreceiptqty").max(malOrderDyn.getBigDecimal("entryentity.suminstockqty"));
        String sku = malOrderDyn.getString("entryentity.goods.number");
        BigDecimal canreturnqty = this.judgeSource(source) ? afterSaleService.getAvailableNumberComp(ecOrderId, sku) : max.subtract(malOrderDyn.getBigDecimal("entryentity.sumreturnreqqty"));
        return canreturnqty;
    }

    protected void fillEntryData(DynamicObject dyn, TableValueSetter vs, int i) {
        vs.set("goodsimg", (Object)dyn.getString("entryentity.goods.thumbnail"), i);
        vs.set("goodsnum", (Object)dyn.getString("entryentity.goods.number"), i);
        vs.set("goodsname", (Object)dyn.getString("entryentity.goods.name"), i);
        vs.set("goodsmodel", (Object)dyn.getString("entryentity.goods.model"), i);
        vs.set("packlist", (Object)dyn.getString("entryentity.goods.packinglist"), i);
    }

    protected DynamicObject queryEcOrderDyn(String ecSource, String ecPOrderPk) {
        if (StringUtils.isEmpty((CharSequence)ecSource)) {
            return null;
        }
        DynamicObject ecOrderDyn = "pbd_jdorder".equals(ecSource) ? QueryServiceHelper.queryOne((String)ecSource, (String)"number orderid,jdorderid porderid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(ecPOrderPk))}) : QueryServiceHelper.queryOne((String)ecSource, (String)"orderid,porderid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(ecPOrderPk))});
        return ecOrderDyn;
    }

    private DynamicObjectCollection queryMalOrderDyn(String srcbillid) {
        if (StringUtils.isEmpty((CharSequence)srcbillid)) {
            return new DynamicObjectCollection();
        }
        return QueryServiceHelper.query((String)"mal_order", (String)"platform,ecsource,entryentity.goods.number,entryentity.jdorder.id,entryentity.jdorder.number,entryentity.order,ecorderid,malpaytype.number,billno", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(srcbillid))});
    }

    protected void initEcPage(String source) {
        boolean visibleFlag = true;
        CardEntry cardEntry = (CardEntry)this.getControl("entryentity");
        if (!EcPlatformEnum.ECPLATFORM_SUNING.getVal().equals(source) && !EcPlatformEnum.ECPLATFORM_XFS.getVal().equals(source)) {
            visibleFlag = false;
            cardEntry.setChildVisible(visibleFlag, -1, new String[]{"reasonflex1", "servicetimeflex1"});
            this.getView().setVisible(Boolean.valueOf(visibleFlag), new String[]{"reasonflex", "flexpanelap53", "flexpanelap511", "flexpanelap54", "servicetimeflex"});
        }
        if (EcPlatformEnum.ECPLATFORM_SUNING.getVal().equals(source)) {
            cardEntry.setChildVisible(visibleFlag, -1, new String[]{"reasonflex1", "servicetimeflex1"});
            this.getView().setVisible(Boolean.valueOf(visibleFlag), new String[]{"reasonflex", "flexpanelap53", "flexpanelap511", "flexpanelap54", "servicetimeflex"});
            this.initSnReasonComboEdit();
            this.initSnBankComboEdit();
        }
        if (EcPlatformEnum.ECPLATFORM_XFS.getVal().equals(source)) {
            cardEntry.setChildVisible(visibleFlag, -1, new String[]{"reasonflex1"});
            cardEntry.setChildVisible(false, -1, new String[]{"servicetimeflex1"});
            this.getView().setVisible(Boolean.valueOf(visibleFlag), new String[]{"reasonflex"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap53", "flexpanelap511", "flexpanelap54", "servicetimeflex"});
            this.initXfsReasonComboEdit();
        }
    }

    private void initXfsReasonComboEdit() {
        ComboEdit reasonComb = (ComboEdit)this.getControl("reason");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(XFSReturnReasonEnum.values().length);
        for (XFSReturnReasonEnum xfsReturnReasonEnum : XFSReturnReasonEnum.values()) {
            ComboItem comboItem = new ComboItem(new LocaleString(xfsReturnReasonEnum.getName()), xfsReturnReasonEnum.getVal());
            items.add(comboItem);
        }
        reasonComb.setComboItems(items);
    }

    protected void initSnBankComboEdit() {
        ComboEdit reasonComb = (ComboEdit)this.getControl("bank");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(SNBankEnum.values().length);
        for (SNBankEnum snBankEnum : SNBankEnum.values()) {
            ComboItem comboItem = new ComboItem(new LocaleString(snBankEnum.getName()), snBankEnum.getVal());
            items.add(comboItem);
        }
        reasonComb.setComboItems(items);
    }

    protected void initSnReasonComboEdit() {
        ComboEdit reasonComb = (ComboEdit)this.getControl("reason");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(SNReturnReasonEnum.values().length);
        for (SNReturnReasonEnum snReturnReasonEnum : SNReturnReasonEnum.values()) {
            ComboItem comboItem = new ComboItem(new LocaleString(snReturnReasonEnum.getName()), snReturnReasonEnum.getVal());
            items.add(comboItem);
        }
        reasonComb.setComboItems(items);
    }

    protected List<AfterSaleServiceTypeEnum> querySnAfterSaleServiceTypeEnums(String ecOrderId, String ecSku, String ecPOrderId, IAfterSaleService afterSaleService) {
        String[] ecAdrLongnumberStrs = this.getAddrLongnumberStrs();
        if (ecAdrLongnumberStrs.length > 2) {
            return afterSaleService.getCustomerExpectComp(ecOrderId, ecSku, ecPOrderId, ecAdrLongnumberStrs[1], ecAdrLongnumberStrs[2]);
        }
        return new ArrayList<AfterSaleServiceTypeEnum>();
    }

    protected Map<String, String> getSkuEcorderIdMap(DynamicObjectCollection malOrderDynCol) {
        if (malOrderDynCol.size() > 0) {
            HashMap<String, String> resMap = new HashMap<String, String>((int)((double)malOrderDynCol.size() / 0.75));
            String ecSource = ((DynamicObject)malOrderDynCol.get(0)).getString("ecsource");
            if (StringUtils.isEmpty((CharSequence)ecSource)) {
                return new HashMap<String, String>();
            }
            ArrayList ecOrderPks = new ArrayList();
            malOrderDynCol.forEach(dynamicObject -> {
                long ecorderPk = dynamicObject.getLong("entryentity.order");
                if (0L != ecorderPk) {
                    ecOrderPks.add(dynamicObject.getLong("entryentity.order"));
                }
            });
            QFilter ecIdFilter = new QFilter("id", "in", ecOrderPks);
            DynamicObjectCollection ecOrderDynCol = "pbd_jdorder".equals(ecSource) ? QueryServiceHelper.query((String)ecSource, (String)"id,entryentity.goods.number,number orderid", (QFilter[])new QFilter[]{ecIdFilter}) : QueryServiceHelper.query((String)ecSource, (String)"id,entryentity.goods.number,orderid", (QFilter[])new QFilter[]{ecIdFilter});
            ecOrderDynCol.forEach(ecOrderDyn -> resMap.put(ecOrderDyn.getString("entryentity.goods.number"), ecOrderDyn.getString("orderid")));
            return resMap;
        }
        return new HashMap<String, String>();
    }

    protected void fillCommonField(DynamicObjectCollection dynCol) {
        String wholeAddress = ((DynamicObject)dynCol.get(0)).getString("receipt.wholeaddress");
        if (StringUtils.isNotEmpty((CharSequence)wholeAddress)) {
            this.fillAddressInfo(wholeAddress);
        }
    }

    protected void fillAddressInfo(String wholeAddress) {
        DynamicObject addressDyn = MalAddressUtil.getAddressByWholeAddress((String)wholeAddress);
        if (addressDyn != null) {
            this.getModel().setValue("admindivisionfield", (Object)addressDyn.getString("address"));
            this.getModel().setValue("detailaddress", (Object)addressDyn.getString("mapaddress"));
            this.getModel().setValue("cutomername", (Object)addressDyn.getString("name"));
            this.getModel().setValue("customerphone", (Object)addressDyn.getString("phone"));
            this.getModel().setValue("admindivisionfield1", (Object)addressDyn.getString("address"));
            this.getModel().setValue("detailaddress1", (Object)addressDyn.getString("mapaddress"));
        }
    }

    protected void initCustomerExpectComboEdit(List<AfterSaleServiceTypeEnum> afterSaleServiceTypeEnums, String source) {
        if (afterSaleServiceTypeEnums == null) {
            return;
        }
        ArrayList<ComboItem> data = new ArrayList<ComboItem>();
        ComboEdit customerxpectcomboEdit = (ComboEdit)this.getControl("customerexpect");
        if (!EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(source)) {
            for (AfterSaleServiceTypeEnum afterSaleServiceTypeEnum : afterSaleServiceTypeEnums) {
                data.add(new ComboItem(new LocaleString(afterSaleServiceTypeEnum.getName()), String.valueOf(afterSaleServiceTypeEnum.getVal())));
            }
            customerxpectcomboEdit.setComboItems(data);
        }
    }

    protected void initPickwareTypeComboEdit(List<ComponentExportEnum> componentExportEnums, String source) {
        if (componentExportEnums == null) {
            return;
        }
        ArrayList<ComboItem> data = new ArrayList<ComboItem>();
        ComboEdit pickwaretypeComboEdit = (ComboEdit)this.getControl("pickwaretype");
        if (!EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(source)) {
            for (ComponentExportEnum componentExportEnum : componentExportEnums) {
                data.add(new ComboItem(new LocaleString(componentExportEnum.getName()), String.valueOf(componentExportEnum.getVal())));
            }
            pickwaretypeComboEdit.setComboItems(data);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        String source = this.getPageCache().get(CACHE_SOURCE);
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"aftersalesubmit")) {
            if (!this.validateData()) {
                args.setCancel(true);
                return;
            }
            if (StringUtils.equals((CharSequence)EcPlatformEnum.ECPLATFORM_SELF.getVal(), (CharSequence)source)) {
                this.submitSelfAfterSale();
            } else if (this.submitEcAfterSale(source)) {
                this.jumpToReturnReqList();
            } else {
                args.setCancel(true);
            }
        }
    }

    protected boolean submitEcAfterSale(String source) {
        HashSet<String> createSet = new HashSet<String>(2);
        int count = this.getEntryCount();
        HashSet<String> skuSet = new HashSet<String>();
        HashSet<String> orderSet = new HashSet<String>();
        Map<String, String> hasSubmitSkuMap = this.queryExistSkuRetreqMap(source);
        for (int i = 0; i < count; ++i) {
            String sku = (String)this.getModel().getValue("goodsnum", i);
            if (null == hasSubmitSkuMap.get(sku)) continue;
            skuSet.add(sku);
            orderSet.add(hasSubmitSkuMap.get(sku));
        }
        if (skuSet.size() > 0) {
            String msg = ResManager.loadKDString((String)"\u5546\u54c1{0}\u5df2\u5b58\u5728\u6709\u6548\u552e\u540e\u7533\u8bf7\u5355{1},\u82e5\u8981\u7ee7\u7eed\u7533\u8bf7\u552e\u540e\uff0c\u8bf7\u5c06\u5df2\u6709\u552e\u540e\u7533\u8bf7\u5355\u53d6\u6d88\u6216\u4f5c\u5e9f\u3002", (String)"MalAfterSalePlugin_0", (String)"scm-mal-formplugin", (Object[])new Object[]{skuSet, orderSet});
            this.getView().showTipNotification(msg);
            return false;
        }
        boolean isSuccess = false;
        for (int i = 0; i < count; ++i) {
            String sku = (String)this.getModel().getValue("goodsnum", i);
            createSet.clear();
            createSet.add(sku);
            if (!this.pushAfterSaleBill(createSet)) continue;
            isSuccess = true;
        }
        return isSuccess;
    }

    protected Map<String, String> queryExistSkuRetreqMap(String source) {
        QFilter ecOrderIdFilter;
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add(ReturnStatusEnum.TO_BE_CONFIRM.getVal());
        statusList.add(ReturnStatusEnum.CONFIRMED.getVal());
        statusList.add(ReturnStatusEnum.CANCEL.getVal());
        QFilter billstatusFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter cfmstatusFilter = new QFilter("cfmstatus", "in", statusList);
        QFilter platformFilter = new QFilter("platform", "=", (Object)source);
        Date dateBeforeMonth = DateUtil.addWeek((Date)TimeServiceHelper.now(), (int)-2);
        QFilter billdateFilter = new QFilter("billdate", ">", (Object)dateBeforeMonth);
        if (this.judgeSource(source)) {
            String jdChildOrderId = (String)this.getModel().getValue("jdchildorderid", 0);
            if (StringUtils.isBlank((CharSequence)jdChildOrderId)) {
                log.error("jdChildOrderId\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u7533\u8bf7\u552e\u540e");
                throw new KDBizException(ResManager.loadKDString((String)"\u4eac\u4e1c\u5b50\u8ba2\u5355\u53f7\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u63d0\u4ea4\u552e\u540e\u3002", (String)"MalAfterSalePlugin_1", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            }
            ecOrderIdFilter = new QFilter("entryentity.jdchildorderid", "=", (Object)jdChildOrderId);
        } else {
            Long ecOrderPk = Long.valueOf((String)this.getModel().getValue("ecorderpk", 0));
            ecOrderIdFilter = new QFilter("entryentity.ecorder", "=", (Object)ecOrderPk);
        }
        String selectFields = "entryentity.goods.number,entryentity.jdchildorderid,billno";
        QFilter[] filters = new QFilter[]{billstatusFilter, cfmstatusFilter, platformFilter, billdateFilter, ecOrderIdFilter};
        HashMap<String, String> hasSubmitSkuMap = new HashMap<String, String>();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mal_returnreq", (String)selectFields, (QFilter[])filters, null);){
            ds.forEach(row -> hasSubmitSkuMap.put(row.getString("entryentity.goods.number"), row.getString("billno")));
        }
        return hasSubmitSkuMap;
    }

    protected void submitSelfAfterSale() {
        HashSet<String> submitSuccessNumberSet = new HashSet<String>((int)((double)this.getEntryCount() / 0.75));
        for (int i = 0; i < this.getEntryCount(); ++i) {
            submitSuccessNumberSet.add(String.valueOf(this.getModel().getValue("goodsnum", i)));
        }
        this.pushAfterSaleBill(submitSuccessNumberSet);
    }

    protected void jumpToReturnReqDetail(Long billId) {
        HashMap<String, Long> returnData = new HashMap<String, Long>();
        returnData.put(BILLID, billId);
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    public void jumpToReturnReqList() {
        ListShowParameter fsp = new ListShowParameter();
        fsp.setBillFormId("mal_returnreq");
        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)fsp);
    }

    public boolean pushAfterSaleBill(Set<String> submitSuccessNumberList) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Map params = fsp.getCustomParams();
        String orderEntriesStr = (String)params.get("malOrderEntry");
        List<Object> malOrderEntryIds = Arrays.asList(orderEntriesStr.split(","));
        Map<String, DynamicObject> malOrderEntryIdPurOrderMap = this.queryPurOrderByMalOrderEntryId(malOrderEntryIds);
        boolean[] isSuccess = new boolean[]{true};
        ArrayList malOrderEntryIdList = new ArrayList(malOrderEntryIds.size());
        malOrderEntryIds.forEach(id -> malOrderEntryIdList.add(Long.valueOf((String)id)));
        StringBuilder logStr = new StringBuilder();
        BOTPUtil.pushBill((String)"mal_order", (String)"mal_returnreq", (Object)Long.valueOf((String)params.get("malOrderId")), malOrderEntryIdList, (String)"entryentity", targetDatas -> {
            for (DynamicObject targetData : targetDatas) {
                this.fillBill(targetData);
                DynamicObjectCollection entryCol = targetData.getDynamicObjectCollection("entryentity");
                String srcbillid = this.getPageCache().get(CACHE_MALORDERID);
                DynamicObjectCollection malOrderDynCol = this.queryMalOrderDyn(srcbillid);
                if (!malOrderDynCol.isEmpty()) {
                    targetData.set("ecsource", (Object)((DynamicObject)malOrderDynCol.get(0)).getString("ecsource"));
                }
                String platform = targetData.getString("platform");
                Map<String, String> skuEcOrderPkMap = this.getSkuEcOrderPkMap(malOrderDynCol, platform);
                this.fillBillEntry(entryCol, platform, skuEcOrderPkMap, malOrderEntryIdPurOrderMap, submitSuccessNumberList);
                OperateOption option = OperateOption.create();
                option.setVariableValue("ishasright", String.valueOf(true));
                option.setVariableValue("isStrict", String.valueOf(false));
                option.setVariableValue("WF", String.valueOf(false));
                OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"mal_returnreq", (DynamicObject[])new DynamicObject[]{targetData}, (OperateOption)option);
                if (!saveResult.getSuccessPkIds().isEmpty()) {
                    Long pk = (Long)saveResult.getSuccessPkIds().get(0);
                    OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"mal_returnreq", (Object[])new Long[]{pk}, (OperateOption)option);
                    if (!submitResult.getSuccessPkIds().isEmpty()) {
                        OperationResult autidtResult = OperationServiceHelper.executeOperate((String)"audit", (String)"mal_returnreq", (Object[])new Long[]{pk}, (OperateOption)option);
                        if (!autidtResult.getSuccessPkIds().isEmpty()) {
                            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\u3002", (String)"MalAfterSalePlugin_2", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                            this.jumpToReturnReqDetail((Long)autidtResult.getSuccessPkIds().get(0));
                            continue;
                        }
                        logStr.append(autidtResult.getMessage()).append(":").append(autidtResult.getAllErrorOrValidateInfo()).append(System.lineSeparator());
                        OperationServiceHelper.executeOperate((String)"unsubmit", (String)"mal_returnreq", (Object[])new Long[]{pk}, (OperateOption)option);
                        OperationServiceHelper.executeOperate((String)"delete", (String)"mal_returnreq", (Object[])new Long[]{pk}, (OperateOption)option);
                        this.getView().showTipNotification(autidtResult.getMessage() + " " + ExceptionUtil.getErrorInfoDetails((List)autidtResult.getAllErrorOrValidateInfo()));
                        isSuccess[0] = false;
                        continue;
                    }
                    logStr.append(submitResult.getMessage()).append(":").append(submitResult.getAllErrorOrValidateInfo()).append(System.lineSeparator());
                    OperationServiceHelper.executeOperate((String)"delete", (String)"mal_returnreq", (Object[])new Long[]{pk}, (OperateOption)option);
                    this.getView().showTipNotification(submitResult.getMessage() + " " + ExceptionUtil.getErrorInfoDetails((List)saveResult.getAllErrorOrValidateInfo()));
                    isSuccess[0] = false;
                    continue;
                }
                logStr.append(saveResult.getMessage()).append(":").append(saveResult.getAllErrorOrValidateInfo()).append(System.lineSeparator());
                this.getView().showTipNotification(saveResult.getMessage() + " " + ExceptionUtil.getErrorInfoDetails((List)saveResult.getAllErrorOrValidateInfo()));
                isSuccess[0] = false;
            }
        });
        if (logStr.length() > 0) {
            log.info(logStr.toString());
        }
        return isSuccess[0];
    }

    @Deprecated
    protected void saveSubmitAndAudit(DynamicObject targetData, boolean[] isSuccess) {
    }

    protected void fillBillEntry(DynamicObjectCollection entryCol, String platform, Map<String, String> skuEcOrderPkMap, Map<String, DynamicObject> malOrderEntryIdPurOrderMap, Set<String> submitSuccessNumberList) {
        Iterator entryItr = entryCol.iterator();
        while (entryItr.hasNext()) {
            DynamicObject entry = (DynamicObject)entryItr.next();
            String goodsNumber = entry.getString("goods.number");
            if (submitSuccessNumberList.contains(goodsNumber)) {
                int rowIndex = this.getRowIndex(goodsNumber);
                BigDecimal returnQty = CommonUtil.getBigDecimalPro((Object)this.getModel().getValue("returnqty", rowIndex)).setScale(2, 4);
                entry.set("qty", (Object)returnQty);
                entry.set("retreasoncode", this.getModel().getValue("reason", rowIndex));
                entry.set("retreason", this.getModel().getValue("quetiondesc", rowIndex));
                entry.set("returntype", this.getModel().getValue("customerexpect", rowIndex));
                entry.set("pickwaretype", this.getModel().getValue("pickwaretype", rowIndex));
                BigDecimal amount = entry.getBigDecimal("price").multiply(returnQty).setScale(2, 4);
                entry.set("amount", (Object)amount);
                BigDecimal tax = amount.multiply(entry.getBigDecimal("taxrate")).divide(new BigDecimal(100), RoundingMode.HALF_UP);
                entry.set("tax", (Object)tax);
                BigDecimal taxamount = entry.getBigDecimal("taxprice").multiply(returnQty).setScale(2, 4);
                entry.set("taxamount", (Object)taxamount);
                String ecOrderPk = skuEcOrderPkMap.get(entry.getString("goods.number"));
                if (!EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(platform)) {
                    entry.set("ecorder_id", (Object)ecOrderPk);
                    entry.set("ecorder", (Object)MalPlaceOrderUtils.getOrderDyn((String)ecOrderPk, (String)platform));
                }
                entry.set("servicetime", this.getModel().getValue("servicetime", rowIndex));
                DynamicObject purOrderDyn = malOrderEntryIdPurOrderMap.get(entry.getString("srcentryid"));
                if (purOrderDyn == null) continue;
                entry.set("pobillid", (Object)purOrderDyn.getString("materialentry.pobillid"));
                entry.set("poentryid", (Object)purOrderDyn.getString("materialentry.poentryid"));
                continue;
            }
            entryItr.remove();
        }
    }

    public void fillBill(DynamicObject targetData) {
        String returnType = String.valueOf(this.getModel().getValue("customerexpect", 0));
        if (StringUtils.equals((CharSequence)String.valueOf(AfterSaleServiceTypeEnum.EXCHANGE.getVal()), (CharSequence)returnType) || StringUtils.equals((CharSequence)String.valueOf(AfterSaleServiceTypeEnum.JD_EXCHANGE.getVal()), (CharSequence)returnType) || StringUtils.equals((CharSequence)String.valueOf(AfterSaleServiceTypeEnum.CG_EXCHANGE.getVal()), (CharSequence)returnType)) {
            targetData.set("replenishtype", (Object)1);
        } else {
            targetData.set("replenishtype", (Object)3);
        }
        targetData.set("phone", this.getModel().getValue("customerphone"));
        targetData.set("email", this.getModel().getValue("email"));
        targetData.set("linkman", this.getModel().getValue("cutomername"));
        targetData.set("admindivision", this.getModel().getValue("admindivisionfield"));
        targetData.set("address", this.getModel().getValue("detailaddress"));
        targetData.set("cardnumber", this.getModel().getValue("cardnumber"));
        targetData.set("cardusername", this.getModel().getValue("cardusername"));
        targetData.set("bank", this.getModel().getValue("bank"));
    }

    public Map<String, DynamicObject> queryPurOrderByMalOrderEntryId(List<Object> malOrderEntryIds) {
        HashMap<String, DynamicObject> res = new HashMap<String, DynamicObject>();
        DynamicObjectCollection purOrderDynCol = QueryServiceHelper.query((String)"pur_order", (String)"id,materialentry.id,materialentry.srcentryid,materialentry.pobillid,materialentry.poentryid", (QFilter[])new QFilter[]{new QFilter("materialentry.srcentryid", "in", malOrderEntryIds)});
        purOrderDynCol.forEach(purOrderDyn -> res.put(purOrderDyn.getString("materialentry.srcentryid"), (DynamicObject)purOrderDyn));
        return res;
    }

    private int getRowIndex(String goodsNumber) {
        for (int i = 0; i < this.getEntryCount(); ++i) {
            if (!StringUtils.equals((CharSequence)String.valueOf(this.getModel().getValue("goodsnum", i)), (CharSequence)goodsNumber)) continue;
            return i;
        }
        return -1;
    }

    protected boolean validateData() {
        if (this.getEntryCount() <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5546\u54c1\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u9009\u62e9\u5546\u54c1\u3002", (String)"MalAfterSalePlugin_3", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            return false;
        }
        String source = this.getPageCache().get(CACHE_SOURCE);
        IAfterSaleService afterSaleService = AfterSaleFactory.getAfterSaleServiceBySource((String)source);
        Map<String, Boolean> judgeFacProductMap = this.getJudgeFacProductMap();
        for (int i = 0; i < this.getEntryCount(); ++i) {
            BigDecimal returnqty = (BigDecimal)this.getModel().getValue("returnqty", i);
            String customerexpect = (String)this.getModel().getValue("customerexpect", i);
            if (customerexpect == null) {
                this.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u5546\u54c1{0}\uff1a\u670d\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MalAfterSalePlugin_4", (String)"scm-mal-formplugin", (Object[])new Object[0]), this.getModel().getValue("goodsnum", i)));
                return false;
            }
            String pickwaretype = (String)this.getModel().getValue("pickwaretype", i);
            if (pickwaretype == null) {
                this.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u5546\u54c1{0}\uff1a\u9000\u56de\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MalAfterSalePlugin_27", (String)"scm-mal-formplugin", (Object[])new Object[0]), this.getModel().getValue("goodsnum", i)));
                return false;
            }
            int aftersaleType = Integer.parseInt(customerexpect);
            if (!this.validateReturnqty(returnqty, i)) {
                return false;
            }
            String quetiondesc = (String)this.getModel().getValue("quetiondesc", i);
            if (quetiondesc.length() < 10 || quetiondesc.length() > 128) {
                this.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u5546\u54c1{0}\uff1a\u8bf7\u8f93\u5165\u95ee\u9898\u63cf\u8ff0 10-128\u5b57\u3002", (String)"MalAfterSalePlugin_5", (String)"scm-mal-formplugin", (Object[])new Object[0]), this.getModel().getValue("goodsnum", i)));
                return false;
            }
            if (this.judgeSource(source) && !this.validateJdSubmitInfo(afterSaleService, i)) {
                return false;
            }
            if (!source.equals(EcPlatformEnum.ECPLATFORM_SUNING.getVal()) || this.validateSnSubmitInfo(judgeFacProductMap, aftersaleType, i)) continue;
            return false;
        }
        if (!this.validateCommonData(source)) {
            return false;
        }
        return this.validateEcCommonData(source);
    }

    protected boolean validateReturnqty(BigDecimal returnqty, int i) {
        if (returnqty.compareTo(new BigDecimal(returnqty.intValue())) != 0) {
            this.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u5546\u54c1{0}\uff1a\u9000\u8d27\u6570\u91cf\u4e0d\u4e3a\u6b63\u6574\u6570\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"MalAfterSalePlugin_6", (String)"scm-mal-formplugin", (Object[])new Object[0]), this.getModel().getValue("goodsnum", i)));
            return false;
        }
        if (returnqty.compareTo(BigDecimal.ZERO) <= 0 || returnqty.compareTo(CommonUtil.getBigDecimalPro((Object)this.getModel().getValue("canreturnqty", i))) > 0) {
            this.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u5546\u54c1{0}\uff1a\u6570\u91cf\u4e3a0\u6216\u9000\u8d27\u6570\u91cf\u8d85\u8fc7\u5546\u54c1\u53ef\u9000\u8d27\u6570\u91cf\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"MalAfterSalePlugin_7", (String)"scm-mal-formplugin", (Object[])new Object[0]), this.getModel().getValue("goodsnum", i)));
            return false;
        }
        return true;
    }

    protected boolean validateEcCommonData(String source) {
        String malPayTypeNumber;
        String ecPayTypeNumber;
        String malOrderId = this.getPageCache().get(CACHE_MALORDERID);
        DynamicObjectCollection malOrderDynCol = this.queryMalOrderDyn(malOrderId);
        if (EcPlatformEnum.ECPLATFORM_SUNING.getVal().equals(source) && StringUtils.isNotEmpty((CharSequence)malOrderId) && !malOrderDynCol.isEmpty() && CASH_ON_DELIVERY.equals(ecPayTypeNumber = PayTypeUtil.getNumber((String)(malPayTypeNumber = ((DynamicObject)malOrderDynCol.get(0)).getString("malpaytype.number")), (String)source))) {
            if (StringUtils.isEmpty((CharSequence)((String)this.getModel().getValue("cardnumber")))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u652f\u4ed8\u65b9\u5f0f\u4e3a\u8d27\u5230\u4ed8\u6b3e\u73b0\u91d1\u65f6\uff0c\u94f6\u884c\u5361\u53f7\u5fc5\u586b\u3002", (String)"MalAfterSalePlugin_8", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (StringUtils.isEmpty((CharSequence)((String)this.getModel().getValue("bank")))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u652f\u4ed8\u65b9\u5f0f\u4e3a\u8d27\u5230\u4ed8\u6b3e\u73b0\u91d1\u65f6\uff0c\u94f6\u884c\u5fc5\u586b\u3002", (String)"MalAfterSalePlugin_9", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (StringUtils.isEmpty((CharSequence)((String)this.getModel().getValue("cardusername")))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u652f\u4ed8\u65b9\u5f0f\u4e3a\u8d27\u5230\u4ed8\u6b3e\u73b0\u91d1\u65f6\uff0c\u6301\u5361\u4eba\u59d3\u540d\u5fc5\u586b\u3002", (String)"MalAfterSalePlugin_10", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    public Map<String, Boolean> getJudgeFacProductMap() {
        String source = this.getPageCache().get(CACHE_SOURCE);
        if (EcPlatformEnum.ECPLATFORM_SUNING.getVal().equals(source)) {
            return MalPlaceOrderUtils.judgeFacProductByOrder((String)((String)this.getModel().getValue("ecporderid", 0)));
        }
        return new HashMap<String, Boolean>();
    }

    public boolean validateCommonData(String source) {
        DynamicObject admindivisionDyn = MalAddressUtil.getAdmindivisionById((String)String.valueOf(this.getModel().getValue("admindivisionfield")));
        if (null == admindivisionDyn) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5730\u5740\u4fe1\u606f\u3002", (String)"MalAfterSalePlugin_11", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(source) && 1000001L != admindivisionDyn.getLong("country")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7535\u5546\u6682\u53ea\u652f\u6301\u4e2d\u56fd\u8303\u56f4\u5730\u5740\u3002", (String)"MalAfterSalePlugin_12", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (2 > admindivisionDyn.getInt("level")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u5728\u5730\u533a\u8bf7\u81f3\u5c11\u5b8c\u5584\u5230\u53bf\u7ea7\u5730\u5740\u3002", (String)"MalAfterSalePlugin_13", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.isBlank((CharSequence)((String)this.getModel().getValue("detailaddress")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be6\u7ec6\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MalAfterSalePlugin_14", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.isBlank((CharSequence)((String)this.getModel().getValue("cutomername")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u987e\u5ba2\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MalAfterSalePlugin_15", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            return false;
        }
        String phone = (String)this.getModel().getValue("customerphone");
        if (!ValidateMatchUtil.isTel((String)phone) && !StringUtils.isPhoneNumberValid((String)phone)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8054\u7cfb\u65b9\u5f0f\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u60a8\u7684\u624b\u673a\u53f7\u7801\u6216\u56fa\u5b9a\u7535\u8bdd\u3002", (String)"MalAfterSalePlugin_16", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            return false;
        }
        String postcode = String.valueOf(this.getModel().getValue("postcode"));
        if (StringUtils.isNotBlank((CharSequence)postcode) && !ValidateMatchUtil.isPostcode((String)postcode)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u90ae\u653f\u7f16\u7801\u3002", (String)"MalAfterSalePlugin_17", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            return false;
        }
        String email = String.valueOf(this.getModel().getValue("email"));
        if (StringUtils.isNotBlank((CharSequence)email) && !ValidateMatchUtil.isEmail((String)email)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u90ae\u7bb1\u3002", (String)"MalAfterSalePlugin_18", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public boolean validateSnSubmitInfo(Map<String, Boolean> judgeFacProductMap, int aftersaleType, int i) {
        String serviceTime;
        String reason;
        String sku = (String)this.getModel().getValue("goodsnum", i);
        Boolean isFacProduct = judgeFacProductMap.get(sku);
        if (AfterSaleServiceTypeEnum.RETURN.getVal() == aftersaleType && isFacProduct != null && isFacProduct.booleanValue() && StringUtils.isEmpty((CharSequence)(reason = (String)this.getModel().getValue("reason", i)))) {
            this.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u5546\u54c1{0}\u4e3a\u5382\u9001\u5546\u54c1\uff0c\u539f\u56e0\u5fc5\u987b\u586b\u5199\u3002", (String)"MalAfterSalePlugin_19", (String)"scm-mal-formplugin", (Object[])new Object[0]), sku));
            return false;
        }
        if (AfterSaleServiceTypeEnum.REPAIR.getVal() == aftersaleType && StringUtils.isEmpty((CharSequence)(serviceTime = (String)this.getModel().getValue("servicetime", i)))) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u7ef4\u4fee\u7684\u670d\u52a1\u65f6\u95f4\u5fc5\u586b\u3002", (String)"MalAfterSalePlugin_20", (String)"scm-mal-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5982\u679c\u670d\u52a1\u65f6\u95f4\u6ca1\u6709\u53ef\u9009\u503c\uff0c\u8bf7\u62e8\u6253\u5ba2\u6237\u670d\u52a1\u70ed\u7ebf\uff1a4008-516-516\uff0c\u8054\u7cfb\u5ba2\u670d\u5904\u7406\u3002", (String)"MalAfterSalePlugin_21", (String)"scm-mal-formplugin", (Object[])new Object[0]), MessageTypes.Default);
            return false;
        }
        return true;
    }

    public boolean validateJdSubmitInfo(IAfterSaleService afterSaleService, int i) {
        BigDecimal canReturnQty;
        String sku = (String)this.getModel().getValue("goodsnum", i);
        String jdChildOrderId = (String)this.getModel().getValue("jdchildorderid", i);
        BigDecimal returnQty = (BigDecimal)this.getModel().getValue("returnqty", i);
        if (returnQty.compareTo(canReturnQty = afterSaleService.getAvailableNumberComp(jdChildOrderId, sku)) > 0) {
            String msg1 = ResManager.loadKDString((String)"\u5546\u54c1", (String)"MalAfterSalePlugin_22", (String)"scm-mal-formplugin", (Object[])new Object[0]);
            String msg2 = ResManager.loadKDString((String)"\u53ef\u552e\u540e\u6570\u91cf\u4e0d\u8db3\u3002", (String)"MalAfterSalePlugin_23", (String)"scm-mal-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg1 + sku + msg2);
        }
        String customerexpect = (String)this.getModel().getValue("customerexpect", i);
        String goodsName = (String)this.getModel().getValue("goodsname", i);
        List serviceTypeEnums = afterSaleService.getCustomerExpectComp(jdChildOrderId, sku);
        boolean isExpectMatch = false;
        for (AfterSaleServiceTypeEnum e : serviceTypeEnums) {
            if (null == customerexpect || Integer.parseInt(customerexpect) != e.getVal()) continue;
            isExpectMatch = true;
        }
        if (!isExpectMatch) {
            this.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"{0}\u4e0d\u652f\u6301{1}\u3002", (String)"MalAfterSalePlugin_24", (String)"scm-mal-formplugin", (Object[])new Object[0]), goodsName, ComponentExportEnum.fromVal((int)Integer.parseInt(customerexpect)).getName()));
            return false;
        }
        String componentExport = (String)this.getModel().getValue("pickwaretype", i);
        boolean isExportMatch = false;
        List componentExportEnums = afterSaleService.getComponentExport(jdChildOrderId, sku);
        for (ComponentExportEnum e : componentExportEnums) {
            if (null == componentExport || Integer.parseInt(componentExport) != e.getVal()) continue;
            isExportMatch = true;
        }
        if (!isExportMatch) {
            this.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"{0}\u4e0d\u652f\u6301{1}\u3002", (String)"MalAfterSalePlugin_24", (String)"scm-mal-formplugin", (Object[])new Object[0]), goodsName, ComponentExportEnum.fromVal((int)Integer.parseInt(customerexpect)).getName()));
            return false;
        }
        return true;
    }

    protected int getEntryCount() {
        return this.getModel().getEntryRowCount("entryentity");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String source = this.getPageCache().get(CACHE_SOURCE);
        String fieldName = e.getProperty().getName();
        if ((StringUtils.equals((CharSequence)"customerexpect", (CharSequence)fieldName) || StringUtils.equals((CharSequence)"pickwaretype", (CharSequence)fieldName)) && !this.judgeSource(source)) {
            for (int i = 0; i < this.getModel().getEntryRowCount("entryentity"); ++i) {
                this.getModel().setValue(fieldName, e.getChangeSet()[0].getNewValue(), i);
            }
        }
        if (StringUtils.equals((CharSequence)"customerexpect", (CharSequence)fieldName) && EcPlatformEnum.ECPLATFORM_SUNING.getVal().equals(source)) {
            int customerexpectVal = Integer.parseInt((String)e.getChangeSet()[0].getNewValue());
            if (AfterSaleServiceTypeEnum.RETURN.getVal() == customerexpectVal) {
                this.unlockField("reason");
            } else {
                this.clearAndLockField("reason");
            }
            if (AfterSaleServiceTypeEnum.REPAIR.getVal() == customerexpectVal) {
                this.unlockField("servicetime");
            } else {
                this.clearAndLockField("servicetime");
            }
        }
    }

    protected void unlockField(String fieldname) {
        int count = this.getEntryCount();
        for (int i = 0; i < count; ++i) {
            this.getView().setEnable(Boolean.TRUE, i, new String[]{fieldname});
        }
    }

    public void clearAndLockField(String fieldName) {
        int count = this.getEntryCount();
        for (int i = 0; i < count; ++i) {
            this.getModel().setValue(fieldName, (Object)"", i);
            this.getView().setEnable(Boolean.FALSE, i, new String[]{fieldName});
        }
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        int rowIndex = cellClickEvent.getRow();
        String curRow = this.getPageCache().get(CACHE_CURROW);
        String jdChildOrderId = (String)this.getModel().getValue("jdchildorderid", rowIndex);
        String sku = (String)this.getModel().getValue("goodsnum", rowIndex);
        String ecOrderId = (String)this.getModel().getValue("ecorderid", rowIndex);
        String ecPOrderId = (String)this.getModel().getValue("ecporderid", rowIndex);
        String source = this.getPageCache().get(CACHE_SOURCE);
        IAfterSaleService afterSaleService = AfterSaleFactory.getAfterSaleServiceBySource((String)source);
        if (!EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(source) && null != afterSaleService && !String.valueOf(rowIndex).equals(curRow)) {
            List componentExportEnums;
            List afterSaleServiceTypeEnums;
            if (this.judgeSource(source)) {
                afterSaleServiceTypeEnums = afterSaleService.getCustomerExpectComp(jdChildOrderId, sku);
                componentExportEnums = afterSaleService.getComponentExport(jdChildOrderId, sku);
            } else if (EcPlatformEnum.ECPLATFORM_ZKH.getVal().equals(source)) {
                afterSaleServiceTypeEnums = afterSaleService.getCustomerExpectComp(ecOrderId, sku, ecPOrderId, null, null);
                componentExportEnums = afterSaleService.getComponentExport(jdChildOrderId, sku);
            } else {
                String[] ecAdrLongnumberStrs = this.getAddrLongnumberStrs();
                if (ecAdrLongnumberStrs.length > 2) {
                    afterSaleServiceTypeEnums = afterSaleService.getCustomerExpectComp(ecOrderId, sku, ecPOrderId, ecAdrLongnumberStrs[1], ecAdrLongnumberStrs[2]);
                    componentExportEnums = afterSaleService.getComponentExport(ecOrderId, sku);
                } else {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6b63\u786e\u7ef4\u62a4\u5730\u5740\u4fe1\u606f\u3002", (String)"MalAfterSalePlugin_25", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                }
            }
            if (afterSaleServiceTypeEnums.size() == 0) {
                throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u5546\u54c1{0}\u6682\u4e0d\u652f\u6301\u7533\u8bf7\u552e\u540e\u3002", (String)"MalAfterSalePlugin_26", (String)"scm-mal-formplugin", (Object[])new Object[0]), sku));
            }
            this.initCustomerExpectComboEdit(afterSaleServiceTypeEnums, source);
            this.initPickwareTypeComboEdit(componentExportEnums, source);
            this.getPageCache().put(CACHE_CURROW, String.valueOf(rowIndex));
            this.getView().updateView();
        }
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    private boolean judgeSource(String source) {
        return EcPlatformEnum.ECPLATFORM_JD.getVal().equals(source) || EcPlatformEnum.ECPLATFORM_JDPRO.getVal().equals(source);
    }

    public void pageRelease(EventObject e) {
        JSONArray successMutexIdSet;
        super.pageRelease(e);
        String successMutexIdSetStr = this.getPageCache().get("successMutexIdSet");
        if (StringUtils.isNotEmpty((CharSequence)successMutexIdSetStr) && (successMutexIdSet = JSONArray.parseArray((String)successMutexIdSetStr)).size() > 0) {
            this.getPageCache().remove(BILLID);
            HashSet mutexIdSet = new HashSet(successMutexIdSet.toJavaList(String.class));
            MutexUtil.batchRelease(mutexIdSet, (String)this.getView().getEntityId(), (String)"returnreq");
        }
    }
}

