/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.formplugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.enums.ProductSourceEnum;
import kd.scm.common.helper.apiconnector.api.util.EcApiUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.common.util.StyleUtil;
import kd.scm.mal.common.util.MainPageUtils;
import kd.scm.mal.formplugin.info.Category2JsonInfo;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class MalCardCategoryTreePlugin
extends AbstractFormPlugin {
    private static Log log = LogFactory.getLog(MalCardCategoryTreePlugin.class);
    private Map<String, TreeNode> allNodeMap = null;
    private List<TreeNode> firstCategoryNode = this.getAndBuildAllNodes(ProductSourceEnum.PRODUCTSOURCE_SELF.getVal());
    private static String BUTTONKEYS = "buttonKeys";
    private static String CURBUTTONKEY = "curbuttonkey";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        String[] buttonKeys = this.getButtonKeysFromCache();
        if (buttonKeys != null) {
            for (String key : buttonKeys) {
                Button button = (Button)this.getView().getControl(key);
                if (button == null) continue;
                button.addClickListener((ClickListener)this);
            }
        }
        Button tabself = (Button)this.getView().getControl("tabself");
        tabself.addClickListener((ClickListener)this);
        Button tabjd = (Button)this.getView().getControl("tabjd");
        tabjd.addClickListener((ClickListener)this);
        for (int i = 0; i < 8; ++i) {
            Button button = (Button)this.getControl("category_labelap" + i);
            button.addClickListener((ClickListener)this);
        }
    }

    public String[] getButtonKeysFromCache() {
        String cacheButtonKeys = this.getPageCache().get(BUTTONKEYS);
        String[] buttonKeys = new String[]{""};
        if (cacheButtonKeys != null) {
            buttonKeys = cacheButtonKeys.split("_");
        }
        return buttonKeys;
    }

    public void afterCreateNewData(EventObject e) {
        String openTpye;
        JSONObject jo;
        long start = System.currentTimeMillis();
        this.firstCategoryNode = this.getAndBuildAllNodes(MainPageUtils.getDefaultMal().getVal());
        Map erpParams = this.getView().getFormShowParameter().getShowParameter().getCustomParams();
        Object customfilter = erpParams.get("customfilter");
        if (customfilter != null && (jo = JSONObject.fromObject((Object)(openTpye = String.valueOf(customfilter)))).containsKey((Object)"opentype")) {
            this.getPageCache().put("opentype", jo.getString("opentype"));
        }
        ProductSourceEnum productSourceEnum = MainPageUtils.getDefaultMal();
        this.customCategoryTreeChange(productSourceEnum.getVal());
        if (ProductSourceEnum.PRODUCTSOURCE_JD == productSourceEnum) {
            StyleUtil.setControlerColor((IFormView)this.getView(), (String)"tabself", (String)"", (String)"");
            StyleUtil.setControlerColor((IFormView)this.getView(), (String)"tabjd", (String)"#FFFFFF", (String)"#FC8555");
        } else {
            StyleUtil.setControlerColor((IFormView)this.getView(), (String)"tabself", (String)"#FFFFFF", (String)"#FC8555");
            StyleUtil.setControlerColor((IFormView)this.getView(), (String)"tabjd", (String)"", (String)"");
        }
        log.info("-->\u6253\u5f00\u9996\u9875\u8017\u65f61\uff1a" + String.valueOf(System.currentTimeMillis() - start) + "ms");
    }

    public JSONArray getCategory(String source) {
        ArrayList<Category2JsonInfo> fistCategoryList = new ArrayList<Category2JsonInfo>();
        String selectFields = "id,number,longnumber,name,parent.id,parent.number,parent.name,level,isleaf,enable,status";
        QFilter filter = new QFilter("standard", "=", (Object)Long.valueOf(EcApiUtil.getStandard((String)source)));
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"mdr_goodsclass", (String)selectFields, (QFilter[])new QFilter[]{filter, enableFilter});
        HashMap<String, Category2JsonInfo> categoryMap = new HashMap<String, Category2JsonInfo>((int)((double)dynamicObjects.length / 0.75));
        for (DynamicObject row : dynamicObjects) {
            Category2JsonInfo node = new Category2JsonInfo();
            String nodeID = row.getString("id");
            node.setLongNumber(row.getString("longnumber"));
            node.setName(row.getString("name"));
            node.setId(nodeID);
            node.setLevel(row.getInt("level"));
            node.setNumber(row.getString("number"));
            String parentid = row.getString("parent.id");
            if (node.getLevel() == 1) {
                fistCategoryList.add(node);
            } else {
                node.setParentid(parentid);
            }
            categoryMap.put(nodeID, node);
        }
        for (Map.Entry entry : categoryMap.entrySet()) {
            Category2JsonInfo node = (Category2JsonInfo)entry.getValue();
            Category2JsonInfo parentNode = (Category2JsonInfo)categoryMap.get(node.getParentid());
            if (parentNode == null) continue;
            List<Category2JsonInfo> children = parentNode.getChildren();
            if (children == null) {
                children = new ArrayList<Category2JsonInfo>();
            }
            children.add(node);
            parentNode.setChildren(children);
        }
        JSONArray jsonStr = JSONArray.fromObject(fistCategoryList);
        JSONArray jSONArray = new JSONArray();
        for (Object jo : jsonStr) {
            jSONArray.add(jo);
        }
        return jSONArray;
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        if ("click".equals(e.getEventName())) {
            String clickData = e.getEventArgs();
            JSONObject jo = JSONObject.fromObject((Object)clickData);
            String longNumber = jo.getString("longnumber");
            String labelText = jo.getString("label");
            String number = jo.getString("number");
            if (ProductSourceEnum.PRODUCTSOURCE_SELF.getVal().equals(this.getPageCache().get("source"))) {
                this.jumpToSelfSearch(longNumber, labelText);
            }
            if (ProductSourceEnum.PRODUCTSOURCE_JD.getVal().equals(this.getPageCache().get("source"))) {
                this.jumpToJdSearch(number, labelText);
            }
        }
    }

    public void jumpToSelfSearch(String longNumber, String labelText) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("mal_search");
        ShowType showType = MainPageUtils.getShowType((IPageCache)this.getPageCache());
        showParameter.getOpenStyle().setShowType(showType);
        showParameter.setCustomParam("opentype", (Object)showType);
        HashMap<String, Object> searchParamMap = new HashMap<String, Object>();
        ArrayList<String> searchFields = new ArrayList<String>();
        searchFields.add("catlongnumber");
        searchParamMap.put("searchText", longNumber);
        searchParamMap.put("searchFields", searchFields);
        searchParamMap.put("searchShowName", labelText);
        searchParamMap.put("source", ProductSourceEnum.PRODUCTSOURCE_SELF.getVal());
        showParameter.setCustomParams(searchParamMap);
        this.getView().showForm(showParameter);
    }

    public void jumpToJdSearch(String number, String labelText) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("mal_search");
        ShowType showType = MainPageUtils.getShowType((IPageCache)this.getPageCache());
        showParameter.getOpenStyle().setShowType(showType);
        showParameter.setCustomParam("opentype", (Object)showType);
        HashMap<String, Object> searchParamMap = new HashMap<String, Object>();
        ArrayList<String> searchFields = new ArrayList<String>();
        searchFields.add("catlongnumber");
        searchParamMap.put("searchText", number);
        searchParamMap.put("searchFields", searchFields);
        searchParamMap.put("source", ProductSourceEnum.PRODUCTSOURCE_JD.getVal());
        searchParamMap.put("searchShowName", labelText);
        searchParamMap.put("isSearchByJDCatNum", "1");
        showParameter.setCustomParams(searchParamMap);
        this.getView().showForm(showParameter);
    }

    protected final List<TreeNode> getAndBuildAllNodes(String source) {
        this.firstCategoryNode = new ArrayList<TreeNode>();
        TreeNode allTagNode = new TreeNode();
        allTagNode.setId("alltag");
        allTagNode.setText(ResManager.loadKDString((String)"\u5168\u90e8\u5206\u7c7b", (String)"MalCardCategoryTreePlugin_0", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        this.firstCategoryNode.add(allTagNode);
        if (!"0".equals(source)) {
            this.allNodeMap = this.getFirstAndSecondCategory(source);
        }
        for (Map.Entry<String, TreeNode> entry : this.allNodeMap.entrySet()) {
            TreeNode node = entry.getValue();
            TreeNode parentNode = this.allNodeMap.get(node.getParentid());
            if (parentNode == null) continue;
            parentNode.addChild(node);
        }
        return Collections.unmodifiableList(this.firstCategoryNode);
    }

    public Map<String, TreeNode> getFirstAndSecondCategory(String source) {
        String selectFields = "id,number,longnumber,name,parent.id,parent.number,parent.name,level,isleaf,enable,status";
        QFilter filter = new QFilter("standard", "=", (Object)Long.valueOf(EcApiUtil.getStandard((String)source)));
        QFilter enableFilter = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        QFilter levelFilter = new QFilter("level", "in", (Object)new int[]{1, 2});
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"mdr_goodsclass", (String)selectFields, (QFilter[])new QFilter[]{filter, enableFilter, levelFilter});
        HashMap<String, TreeNode> firstAndSecondNodeMap = new HashMap<String, TreeNode>((int)((double)dynamicObjects.length / 0.75));
        for (DynamicObject row : dynamicObjects) {
            TreeNode node = new TreeNode();
            String nodeID = row.getString("id");
            node.setLongNumber(row.getString("longnumber"));
            node.setText(row.getString("name"));
            node.setId(nodeID);
            String parentid = row.getString("parent.id");
            if (parentid == null || parentid.equals("0")) {
                node.setExpend(true);
                this.firstCategoryNode.add(node);
            } else {
                node.setParentid(parentid);
            }
            firstAndSecondNodeMap.put(nodeID, node);
        }
        return firstAndSecondNodeMap;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button button = null;
        if (evt.getSource() instanceof Button) {
            button = (Button)evt.getSource();
        } else if (evt.getSource() instanceof Container) {
            // empty if block
        }
        if (button != null && "tabself".equals(button.getKey())) {
            this.customCategoryTreeChange(ProductSourceEnum.PRODUCTSOURCE_SELF.getVal());
            MainPageUtils.showMainPage((String)ProductSourceEnum.PRODUCTSOURCE_SELF.getVal(), (IFormView)this.getView(), (IDataModel)this.getModel(), null);
            StyleUtil.setControlerColor((IFormView)this.getView(), (String)"tabself", (String)"#FFFFFF", (String)"#FC8555");
            StyleUtil.setControlerColor((IFormView)this.getView(), (String)"tabjd", (String)"", (String)"");
        }
        if (button != null && "tabjd".equals(button.getKey())) {
            this.customCategoryTreeChange(ProductSourceEnum.PRODUCTSOURCE_JD.getVal());
            MainPageUtils.showMainPage((String)ProductSourceEnum.PRODUCTSOURCE_JD.getVal(), (IFormView)this.getView(), (IDataModel)this.getModel(), (IPageCache)this.getPageCache());
            StyleUtil.setControlerColor((IFormView)this.getView(), (String)"tabself", (String)"", (String)"");
            StyleUtil.setControlerColor((IFormView)this.getView(), (String)"tabjd", (String)"#FFFFFF", (String)"#FC8555");
        }
        if (button != null && button.getKey().contains("category_labelap")) {
            String index = button.getKey().substring("category_labelap".length());
            String categoryMsg = String.valueOf(this.getModel().getValue("category" + index));
            if (this.getPageCache().get("source").equals(ProductSourceEnum.PRODUCTSOURCE_SELF.getVal())) {
                this.jumpToSelfSearch(categoryMsg.split(";")[1], categoryMsg.split(";")[0]);
            }
            if (this.getPageCache().get("source").equals(ProductSourceEnum.PRODUCTSOURCE_JD.getVal())) {
                this.jumpToJdSearch(categoryMsg.split(";")[1], categoryMsg.split(";")[0]);
            }
        }
    }

    public void customCategoryTreeChange(String source) {
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        if (customcontrol != null) {
            JSONObject customCtrParam = new JSONObject();
            customCtrParam.put((Object)"rootName", (Object)ResManager.loadKDString((String)"\u5168\u90e8\u5546\u54c1\u5206\u7c7b", (String)"MalCardCategoryTreePlugin_1", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            customCtrParam.put((Object)"categoryItem", (Object)this.getCategory(source).toString());
            customCtrParam.put((Object)"isShowSecondInMain", (Object)this.getIsShowSecondInMain());
            customcontrol.setData((Object)customCtrParam.toString());
            this.getPageCache().put("source", source);
        }
    }

    public String getIsShowSecondInMain() {
        String appId = "UUPIH+47DAK";
        String isShow = ParamUtil.getParam((String)appId, (String)"categorystyle");
        return isShow == null ? "0" : isShow;
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
    }

    public void onGetControl(OnGetControlArgs e) {
        String[] buttonKeys;
        for (String key : buttonKeys = this.getButtonKeysFromCache()) {
            if (!StringUtils.equals((CharSequence)key, (CharSequence)e.getKey())) continue;
            Button button = new Button();
            button.setKey(key);
            button.setView(this.getView());
            button.addClickListener((ClickListener)this);
            e.setControl((Control)button);
        }
        String curButtonKey = this.getPageCache().get(CURBUTTONKEY);
        if (StringUtils.equals((CharSequence)curButtonKey, (CharSequence)e.getKey())) {
            Button curButton = new Button();
            curButton.setKey(curButtonKey);
            curButton.addClickListener((ClickListener)this);
            e.setControl((Control)curButton);
        }
    }

    public ShowType getShowType() {
        if (StringUtils.isNotBlank((CharSequence)this.getPageCache().get("opentype"))) {
            return ShowType.forValue((int)Integer.parseInt(this.getPageCache().get("opentype")));
        }
        return ShowType.MainNewTabPage;
    }
}

