/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.cardentry.CardEntryFieldAp;
import kd.bos.metadata.form.cardentry.CardEntryFixRowPanelAp;
import kd.bos.metadata.form.cardentry.CardEntryFlexPanelAp;
import kd.bos.mvc.form.FormView;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.MalOrderParamUtil;
import kd.scm.mal.business.factory.MalBusinessFactory;
import kd.scm.mal.business.shopcart.service.MalShopCartService;
import kd.scm.mal.business.stock.service.MalStockService;
import kd.scm.mal.common.util.MalProductUtil;
import kd.scm.mal.domain.model.compare.ComparePriceInfo;
import kd.scm.mal.domain.model.compare.MalCompareDetail;
import kd.scm.mal.domain.model.goods.MalGoods;
import kd.scm.mal.domain.model.goods.MalMatGoodsInitParam;
import kd.scm.mal.domain.model.productdetail.MalProductDetail;
import kd.scm.mal.domain.service.DomainServiceFactory;
import kd.scm.mal.domain.service.IMalCompareService;
import kd.scm.mal.domain.service.MalPriceMonitorService;
import kd.scm.mal.domain.service.MalVersionSwitchService;
import kd.scm.mal.domain.service.impl.MalCompareService;
import kd.scm.malcore.domain.LadderPriceInfo;

public class MalCompareDetailPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener,
RowClickEventListener {
    private static final Log log = LogFactory.getLog((String)MalCompareDetailPlugin.class.getName());
    public static final String IMAGEAP_CONTAINER_1 = "imageap_container1";
    private static final String IMAGEAP = "imageap";
    private static final String ENTRYENTITY = "entryentity";
    private static final String LASTPIC = "lastpic";
    private static final String NEXTPIC = "nextpic";
    private static final String PIC_INDEX = "pic_index";
    private static final String IMAGEAP_CONTAINER = "imageap_container";
    private static final String MAINIMAGEAP_CONTAINER = "mainimageap_container";
    private static final String GOODS_CONTAINER = "goods_container";
    private static final String ADD_CART = "add_cart";
    private static final String DELETEDETAILENTRY = "deletedetailentry";
    private static final String ADD_GOODS = "add_goods";
    private static final String SCMSEARCH = "scmsearch";
    private static final String HISTORY_PRICE = "history_price";
    private static final String IMAGEAP_CONTAINER_2 = "imageap_container2";
    private static final String IMAGEAP_CONTAINER_3 = "imageap_container3";
    private static final String IMAGEAP_CONTAINER_4 = "imageap_container4";
    private static final String PRICE_TREND_VIEW = "priceTrendView";
    private static final String PRICE_TREND_CONTAINER = "priceTrendContainer";
    private static final String SHOWHISTORYPRICE = "showHistoryPrice";
    private static final String LEFT = "vectorapleft";
    private static final String RIGHT = "vectorapright";
    private static final String LADPRICE = "ladpricevectorap";
    private static final int SHOWNUM = 4;
    private static final String COMPARE_PAGECACHE = "detailpageindex";
    private static final String ADDQTY = "addqty";
    private static final String PRICE = "price";
    private static final String ADDQTY_CACHE = "addqty_cache";
    private static final String PRICE_CACHE = "price_cache";
    private static final String ATTRGSALEROUP = "attrsalegroup";
    private static final String VECTORAPOPEN = "vectorapopen";
    private static final String VECTORAPCLOSE = "vectorapclose";
    private static final String LABELNAME = "labelname";
    private static final String ATTRGSALE = "attrsale";
    private static final String ATTRGSALEVALUE = "attrsalevalue";
    private static final String ATTRText = "textedit";
    private static final String SPLIT = "-";
    private static final String SALEGROUP_CACHE = "salegroupcache";
    private static final String ATTETEXT_CACHE = "attrtextkey";
    private static final String VERTORAP_CACHE = "vertorapkey";
    private static final String VERTORAPOPEN_CACHE = "vertorapopenkey";

    public void afterCreateNewData(EventObject e) {
        this.refresh();
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
    }

    private void refresh() {
        String purchaseOrg = (String)this.getView().getFormShowParameter().getCustomParam("purchase_org");
        long orgId = RequestContext.get().getOrgId();
        if (purchaseOrg != null) {
            orgId = Long.parseLong(purchaseOrg);
        }
        this.refreshByOrg(orgId);
        this.initViewStatus();
        this.initPageStatus();
        this.setCompareDetailStatusByCompare();
    }

    private void refreshByOrg(Long orgId) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (null != customParams.get("compareId")) {
            this.setDefaultByCompareShot();
        } else {
            List malGoodsList = ((IMalCompareService)DomainServiceFactory.serviceOf(IMalCompareService.class)).getDetailCompareGoods(Long.valueOf(RequestContext.get().getCurrUserId()), orgId, BigDecimal.ONE);
            this.setDefaultByCompareRecord(malGoodsList);
        }
    }

    private void setDefaultByCompareShot() {
        int index = 0;
        int pageIndex = 1;
        int maxCompareRows = 0;
        List<String> compareDims = this.getCompareDims();
        String pageIndexCache = this.getPageCache().get(COMPARE_PAGECACHE);
        if (!StringUtils.isEmpty((CharSequence)pageIndexCache)) {
            pageIndex = Integer.parseInt(pageIndexCache);
        }
        TableValueSetter vs = new TableValueSetter(new String[0]);
        List<Map<String, Object>> compareShotInfo = this.getCompareShotInfo();
        if (null == compareShotInfo) {
            List comparePriceInfos = ((IMalCompareService)DomainServiceFactory.serviceOf(IMalCompareService.class)).queryComparePriceRecordShot(Long.valueOf(Long.parseLong(String.valueOf(this.getView().getFormShowParameter().getCustomParams().get("compareId")))));
            ArrayList<MalMatGoodsInitParam> malMatGoodsInitParams = new ArrayList<MalMatGoodsInitParam>(1024);
            for (ComparePriceInfo info : comparePriceInfos) {
                malMatGoodsInitParams.add(MalMatGoodsInitParam.buildGeneralParam((Long)info.getGoodsId(), (String)info.getGoodsSource(), (BigDecimal)BigDecimal.ONE, null, (Long)info.getCompareOrg()));
            }
            Map malGoodsMap = MalGoods.batchInstance(malMatGoodsInitParams, (boolean)false, (boolean)true);
            this.setDefaultByCompareRecord(new ArrayList<MalGoods>(malGoodsMap.values()));
            return;
        }
        maxCompareRows = compareShotInfo.size();
        if (pageIndex * 4 < maxCompareRows) {
            maxCompareRows = pageIndex * 4;
        }
        for (int i = (pageIndex - 1) * 4; i < maxCompareRows; ++i) {
            Map<String, Object> shotMap = compareShotInfo.get(i);
            for (String compareDim : compareDims) {
                if (shotMap.get(compareDim) == null) continue;
                vs.set(compareDim, shotMap.get(compareDim), index);
            }
            ++index;
        }
        this.getModel().beginInit();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData(ENTRYENTITY);
        model.batchCreateNewEntryRow(ENTRYENTITY, vs);
        this.getModel().endInit();
        this.getView().updateView(ENTRYENTITY);
        if (index < 4) {
            int maxIndex = maxCompareRows % 4;
            maxIndex = maxIndex == 0 ? maxCompareRows / 4 : maxCompareRows / 4 + 1;
            if (pageIndex == maxIndex) {
                int size = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRYENTITY).size();
                for (int i = size + (pageIndex - 1) * 4; i < maxCompareRows; ++i) {
                    this.getModel().createNewEntryRow(ENTRYENTITY);
                }
            } else {
                for (int i = index; i < 4; ++i) {
                    this.getModel().createNewEntryRow(ENTRYENTITY);
                }
            }
            ++index;
        }
        this.setLadpriceValueByShot(compareShotInfo);
        this.initGoodsCount(compareShotInfo.size());
    }

    private void initGoodsCount(int size) {
        Label labelap_num = (Label)this.getView().getControl("labelap_num");
        labelap_num.setText(ResManager.loadKDString((String)"\u5171{0}\u4e2a", (String)"MalCompareDetailPlugin_5", (String)"scm-mal-formplugin", (Object[])new Object[]{size}));
    }

    private void setLadpriceValueByShot(List<Map<String, Object>> compareShotInfo) {
        DynamicObjectCollection entrCol = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRYENTITY);
        CardEntry cardEntry = (CardEntry)this.getControl(ENTRYENTITY);
        for (DynamicObject row : entrCol) {
            int seq = row.getInt("seq") - 1;
            if (null != row.getDynamicObject("goods")) {
                Long goodsId = row.getDynamicObject("goods").getLong("id");
                for (Map<String, Object> shotMap : compareShotInfo) {
                    if (Long.parseLong(String.valueOf(shotMap.get("goods"))) != goodsId) continue;
                    List ladderPriceInfos = (List)shotMap.get("ladprice");
                    String ladpriceStr = this.getLadPriceStr(ladderPriceInfos, row);
                    if (ladpriceStr.length() != 0) {
                        this.getView().getModel().setValue("compare_ladprice", (Object)ladpriceStr, seq);
                    } else {
                        this.getView().getModel().setValue("compare_ladprice", (Object)SPLIT, seq);
                    }
                    if (ladderPriceInfos == null || ladderPriceInfos.size() <= 3) {
                        cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), seq, new String[]{"expandladprice"});
                        continue;
                    }
                    cardEntry.setChildVisible(Boolean.TRUE.booleanValue(), seq, new String[]{"expandladprice"});
                }
                continue;
            }
            cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), seq, new String[]{"expandladprice"});
        }
    }

    private void setDefaultByCompareRecord(List<MalGoods> malGoodsList) {
        int index = 0;
        int pageIndex = 1;
        int maxCompareRows = 0;
        MalCompareDetail malCompareDetail = new MalCompareDetail(this.getModel().getDataEntity(true));
        List<String> compareDims = this.getCompareDims();
        String pageIndexCache = this.getPageCache().get(COMPARE_PAGECACHE);
        if (!StringUtils.isEmpty((CharSequence)pageIndexCache)) {
            pageIndex = Integer.parseInt(pageIndexCache);
        }
        TableValueSetter vs = new TableValueSetter(new String[0]);
        maxCompareRows = malGoodsList.size();
        if (pageIndex * 4 < maxCompareRows) {
            maxCompareRows = pageIndex * 4;
        }
        Map qtyPriceMap = new HashMap(1024);
        if (null != this.getPageCache().get(ADDQTY_CACHE)) {
            qtyPriceMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(ADDQTY_CACHE), Map.class);
        }
        this.getPageCache().put(ADDQTY_CACHE, SerializationUtils.toJsonString(qtyPriceMap));
        for (int i = (pageIndex - 1) * 4; i < maxCompareRows; ++i) {
            MalGoods malGoods = malGoodsList.get(i);
            for (String compareDim : compareDims) {
                Object value = malCompareDetail.handleDim(compareDim, malGoods, malGoodsList);
                if (value == null) continue;
                vs.set(compareDim, value, index);
            }
            ++index;
        }
        this.getModel().beginInit();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData(ENTRYENTITY);
        model.batchCreateNewEntryRow(ENTRYENTITY, vs);
        this.getModel().endInit();
        this.getView().updateView(ENTRYENTITY);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (index < 4) {
            int maxIndex;
            maxCompareRows = new MalCompareService().getMaxCompareRows();
            if (null != customParams.get("compareId")) {
                maxCompareRows = malGoodsList.size();
            }
            if (pageIndex == (maxIndex = (maxIndex = maxCompareRows % 4) == 0 ? maxCompareRows / 4 : maxCompareRows / 4 + 1)) {
                int size = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRYENTITY).size();
                for (int i = size + (pageIndex - 1) * 4; i < maxCompareRows; ++i) {
                    this.getModel().createNewEntryRow(ENTRYENTITY);
                }
            } else {
                for (int i = index; i < 4; ++i) {
                    this.getModel().createNewEntryRow(ENTRYENTITY);
                }
            }
            ++index;
        }
        this.setLadpriceValue(malGoodsList);
        DynamicObjectCollection entryCol = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRYENTITY);
        for (DynamicObject row : entryCol) {
            if (row.get("goods") != null & null != qtyPriceMap.get(row.getString("goods.id"))) {
                Map qtyMap = (Map)qtyPriceMap.get(row.getString("goods.id"));
                this.getModel().setValue(ADDQTY, qtyMap.get("qty"), row.getInt("seq") - 1);
            }
            if (null == customParams.get("compareId")) continue;
            for (MalGoods malGoods : malGoodsList) {
                if (!malGoods.getProductId().equals(row.getString("goods.id"))) continue;
                this.getModel().setValue(PRICE, (Object)malGoods.getTaxPrice(), row.getInt("seq") - 1);
            }
        }
        this.initGoodsCount(malGoodsList.size());
        this.initInstockView();
    }

    private void initInstockView() {
        this.getModel().beginInit();
        boolean selfInventoryUnlimited = MalOrderParamUtil.isSelfInventoryUnlimited();
        DynamicObjectCollection entryCol = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRYENTITY);
        for (int index = 0; index < entryCol.size(); ++index) {
            DynamicObject dynamicObject = (DynamicObject)entryCol.get(index);
            String stock_desc = dynamicObject.getString("stock_desc");
            if ("".equals(stock_desc)) {
                dynamicObject.set("isinventorylimited", (Object)"0");
                dynamicObject.set("selfstock", (Object)ResManager.loadKDString((String)"\u5e93\u5b58\u5145\u8db3", (String)"MalCompareDetailPlugin_7", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                continue;
            }
            if (!"0".equals(stock_desc)) continue;
            if (selfInventoryUnlimited) {
                dynamicObject.set("isinventorylimited", (Object)"0");
                dynamicObject.set("selfstock", (Object)ResManager.loadKDString((String)"\u5e93\u5b58\u5145\u8db3", (String)"MalCompareDetailPlugin_7", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                continue;
            }
            dynamicObject.set("selfstock", (Object)ResManager.loadKDString((String)"\u5e93\u5b58\u4e0d\u8db3", (String)"MalCompareDetailPlugin_8", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRYENTITY);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.createAtrrView();
    }

    private void setAttrValue() {
    }

    private List<Map<String, Object>> getCompareShotInfo() {
        List shotStr;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (null != customParams.get("compareId") && !StringUtils.isEmpty((CharSequence)((ComparePriceInfo)(shotStr = ((IMalCompareService)DomainServiceFactory.serviceOf(IMalCompareService.class)).queryComparePriceRecordShot(Long.valueOf(Long.parseLong(String.valueOf(customParams.get("compareId")))))).get(0)).getCompareDetailShot())) {
            List shots = SerializationUtils.fromJsonStringToList((String)((ComparePriceInfo)shotStr.get(0)).getCompareDetailShot(), Map.class);
            return shots;
        }
        return null;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initViewStatus();
        this.initPageStatus();
        this.setCompareDetailStatusByCompare();
    }

    private void setCompareDetailStatusByCompare() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (null != customParams.get("compareId")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"header_flex"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"searchcontainer"});
            CardEntry cardEntry = (CardEntry)this.getControl(ENTRYENTITY);
            DynamicObjectCollection entryCol = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRYENTITY);
            for (DynamicObject row : entryCol) {
                int index = row.getInt("seq") - 1;
                cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), index, new String[]{"vectorap_delete", "price_hight_container1", "cardentryflexpanelap31", "add_goods_container"});
                cardEntry.setChildEnable(Boolean.FALSE.booleanValue(), index, new String[]{ADDQTY, "bt_cart"});
                cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), index, new String[]{"bt_cart"});
            }
        }
    }

    private void createAtrrView() {
    }

    private CardEntryFlexPanelAp createCardEntryFlexPanelAp(int index, String saleGroupName, boolean isGroup) {
        CardEntryFlexPanelAp attrFlex1 = new CardEntryFlexPanelAp();
        return attrFlex1;
    }

    private CardEntryFieldAp createCardEntryFieldAp(int index, String saleGroupName) {
        CardEntryFieldAp cardEntryFieldAp = new CardEntryFieldAp();
        return cardEntryFieldAp;
    }

    private CardEntryFixRowPanelAp createCardEntryFixRowPanelAp(int index, String saleGroupName, boolean isGroup) {
        CardEntryFixRowPanelAp attrFlex = new CardEntryFixRowPanelAp();
        return attrFlex;
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
    }

    public void initialize() {
        super.initialize();
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        super.getEntityType(e);
    }

    private void initViewStatus() {
        boolean flag;
        boolean bl = flag = ((MalVersionSwitchService)DomainServiceFactory.serviceOf(MalVersionSwitchService.class)).getMalPickGoodsKey().equals(this.getView().getFormShowParameter().getParentFormId()) || ((MalVersionSwitchService)DomainServiceFactory.serviceOf(MalVersionSwitchService.class)).getMalPickGoodsKey().equals(this.getView().getFormShowParameter().getCustomParam("origin"));
        if (flag) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"searchcontainer", "vector_org"});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"helpcontianer1", "helpcontianer2", "helpcontianer3", "helpcontianer4"});
        DynamicObjectCollection cols = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRYENTITY);
        CardEntry cardEntry = (CardEntry)this.getControl(ENTRYENTITY);
        for (int i = 0; i < cols.size(); ++i) {
            if (flag) {
                cardEntry.setChildVisible(false, i, new String[]{"bt_cart"});
            } else {
                cardEntry.setChildVisible(false, i, new String[]{"bt_purchase"});
            }
            if (null == ((DynamicObject)cols.get(i)).get("goods")) {
                cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), i, new String[]{"vectorap_delete"});
                continue;
            }
            cardEntry.setChildVisible(Boolean.TRUE.booleanValue(), i, new String[]{"vectorap_delete"});
        }
    }

    private void initPageStatus() {
        int maxCompareRows = new MalCompareService().getMaxCompareRows();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (null != customParams.get("compareId")) {
            List shotStr = ((IMalCompareService)DomainServiceFactory.serviceOf(IMalCompareService.class)).queryComparePriceRecordShot(Long.valueOf(Long.parseLong(String.valueOf(customParams.get("compareId")))));
            maxCompareRows = shotStr.size();
        }
        DynamicObjectCollection cols = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRYENTITY);
        CardEntry cardEntry = (CardEntry)this.getControl(ENTRYENTITY);
        for (int i = 0; i < cols.size(); ++i) {
            if (i == 0) {
                cardEntry.setChildVisible(false, i, new String[]{RIGHT});
                continue;
            }
            if (i == cols.size() - 1) {
                cardEntry.setChildVisible(false, i, new String[]{LEFT});
                continue;
            }
            cardEntry.setChildVisible(false, i, new String[]{LEFT, RIGHT});
        }
        String pageIndex = this.getPageCache().get(COMPARE_PAGECACHE);
        if (StringUtils.isEmpty((CharSequence)pageIndex)) {
            cardEntry.setChildVisible(Boolean.TRUE.booleanValue(), cols.size() - 1, new String[]{RIGHT});
            cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), 0, new String[]{LEFT});
            if (null != customParams.get("compareId") && maxCompareRows <= 4) {
                cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), cols.size() - 1, new String[]{RIGHT});
                cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), 0, new String[]{LEFT});
            }
        } else {
            int maxIndex = maxCompareRows % 4;
            maxIndex = maxIndex == 0 ? maxCompareRows / 4 : maxCompareRows / 4 + 1;
            int index = Integer.parseInt(pageIndex);
            if (index == 1) {
                cardEntry.setChildVisible(Boolean.TRUE.booleanValue(), cols.size() - 1, new String[]{RIGHT});
                cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), 0, new String[]{LEFT});
                if (null != customParams.get("compareId") && maxCompareRows <= 4) {
                    cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), cols.size() - 1, new String[]{RIGHT});
                    cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), 0, new String[]{LEFT});
                }
            }
            if (index == maxIndex) {
                cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), cols.size() - 1, new String[]{RIGHT});
                cardEntry.setChildVisible(Boolean.TRUE.booleanValue(), 0, new String[]{LEFT});
            }
            if (index > 1 && index < maxIndex) {
                cardEntry.setChildVisible(Boolean.TRUE.booleanValue(), cols.size() - 1, new String[]{RIGHT});
                cardEntry.setChildVisible(Boolean.TRUE.booleanValue(), 0, new String[]{LEFT});
            }
        }
    }

    private List<String> getCompareDims() {
        ArrayList<String> res = new ArrayList<String>();
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)this.getView().getEntityId(), (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        List controlAps = formMeta.getItems();
        for (ControlAp controlAp : controlAps) {
            if (!(controlAp instanceof CardEntryFieldAp) || controlAp.isHidden()) continue;
            res.add(controlAp.getKey());
        }
        log.info("getCompareDims.res:" + res);
        return res;
    }

    private Long getOrgId() {
        String purchaseOrg;
        if (null == this.getView()) {
            return RequestContext.get().getOrgId();
        }
        boolean flag = ((MalVersionSwitchService)DomainServiceFactory.serviceOf(MalVersionSwitchService.class)).getMalPickGoodsKey().equals(this.getView().getFormShowParameter().getParentFormId()) || ((MalVersionSwitchService)DomainServiceFactory.serviceOf(MalVersionSwitchService.class)).getMalPickGoodsKey().equals(this.getView().getFormShowParameter().getCustomParam("origin"));
        long orgId = RequestContext.get().getOrgId();
        if (flag && (purchaseOrg = (String)this.getView().getFormShowParameter().getCustomParam("purchase_org")) != null) {
            orgId = Long.parseLong(purchaseOrg);
        }
        return orgId;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        int picIndex;
        int curSelectIndex;
        super.afterDoOperation(afterDoOperationEventArgs);
        if (ADD_CART.equals(afterDoOperationEventArgs.getOperateKey())) {
            this.addCart();
        }
        if (DELETEDETAILENTRY.equals(afterDoOperationEventArgs.getOperateKey())) {
            this.clearCurrentEntryAndRefresh();
        }
        if (ADD_GOODS.equals(afterDoOperationEventArgs.getOperateKey())) {
            this.toAddGoods();
        }
        if (LASTPIC.equals(afterDoOperationEventArgs.getOperateKey())) {
            curSelectIndex = this.getSelectedIndexs()[0];
            picIndex = (Integer)this.getModel().getValue(PIC_INDEX, curSelectIndex);
            this.getModel().setValue(PIC_INDEX, (Object)Math.max(1, --picIndex), curSelectIndex);
        }
        if (NEXTPIC.equals(afterDoOperationEventArgs.getOperateKey())) {
            curSelectIndex = this.getSelectedIndexs()[0];
            picIndex = (Integer)this.getModel().getValue(PIC_INDEX, curSelectIndex);
            this.getModel().setValue(PIC_INDEX, (Object)Math.min(this.getPicSize(curSelectIndex), ++picIndex), curSelectIndex);
        }
    }

    private void addCart() {
        int[] selectedIndexs = this.getSelectedIndexs();
        DynamicObject goodsDyn = (DynamicObject)this.getModel().getValue("goods", selectedIndexs[0]);
        if (goodsDyn != null) {
            long pk = goodsDyn.getLong("id");
            ArrayList<Long> prodIds = new ArrayList<Long>(1);
            prodIds.add(pk);
            Boolean isView = MalProductUtil.setMsgView((IFormView)this.getView(), prodIds, (String)"addcart", (Long)this.getOrgId());
            if (isView.booleanValue()) {
                return;
            }
            this.checkStock();
            Long srcCompareId = 0L;
            if (null != this.getPageCache().get("compareId")) {
                String compareId = this.getPageCache().get("compareId");
                srcCompareId = Long.parseLong(compareId);
            }
            Map qtyPriceMap = new HashMap(1024);
            if (null != this.getPageCache().get(ADDQTY_CACHE)) {
                qtyPriceMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(ADDQTY_CACHE), Map.class);
            }
            List malGoodsList = ((IMalCompareService)DomainServiceFactory.serviceOf(IMalCompareService.class)).getDetailCompareGoods(Long.valueOf(RequestContext.get().getCurrUserId()), this.getOrgId(), BigDecimal.ONE);
            MalCompareDetail malCompareDetail = new MalCompareDetail(this.getModel().getDataEntity(true));
            List<String> compareDims = this.getCompareDims();
            ArrayList compareDeatilShop = new ArrayList(1024);
            ArrayList<Long> goodsIds = new ArrayList<Long>(1024);
            for (int i = 0; i < malGoodsList.size(); ++i) {
                MalGoods malGoods = (MalGoods)malGoodsList.get(i);
                goodsIds.add(Long.parseLong(malGoods.getProductId()));
            }
            Map goodsMap = MalGoods.batchGetLadderPrice(goodsIds, (Long)this.getOrgId());
            for (int i = 0; i < malGoodsList.size(); ++i) {
                MalGoods malGoods = (MalGoods)malGoodsList.get(i);
                HashMap<String, Object> compareDeatilShotMap = new HashMap<String, Object>(1024);
                for (String compareDim : compareDims) {
                    Object value = malCompareDetail.handleDim(compareDim, malGoods, malGoodsList);
                    if (value == null) continue;
                    compareDeatilShotMap.put(compareDim, value);
                }
                if (null != qtyPriceMap.get(malGoods.getProductId())) {
                    Map qtyMap = (Map)qtyPriceMap.get(malGoods.getProductId());
                    compareDeatilShotMap.put(ADDQTY, qtyMap.get("qty"));
                    compareDeatilShotMap.put(PRICE, qtyMap.get(PRICE));
                } else {
                    compareDeatilShotMap.put(ADDQTY, BigDecimal.ONE);
                }
                compareDeatilShop.add(compareDeatilShotMap);
                if (null == goodsMap.get(Long.parseLong(malGoods.getProductId()))) continue;
                compareDeatilShotMap.put("ladprice", goodsMap.get(Long.parseLong(malGoods.getProductId())));
            }
            Long compareId = ((IMalCompareService)DomainServiceFactory.serviceOf(IMalCompareService.class)).addComparePriceRecord(Long.valueOf(pk), Long.valueOf(RequestContext.get().getCurrUserId()), srcCompareId, this.getOrgId(), compareDeatilShop);
            this.getPageCache().put("compareId", String.valueOf(compareId));
        }
    }

    private int getPicSize(int curSelectIndex) {
        int size = 0;
        for (int i = 1; i <= 4; ++i) {
            Object v = this.getModel().getValue(IMAGEAP + i, curSelectIndex);
            if (null == v || !StringUtils.isNotBlank((CharSequence)String.valueOf(v))) continue;
            ++size;
        }
        return size;
    }

    private void addPurchase() {
        int[] selectRows = this.getSelectedIndexs();
        if (selectRows.length > 0) {
            DynamicObject goodsDyn = (DynamicObject)this.getModel().getValue("goods", selectRows[0]);
            this.getView().returnDataToParent((Object)goodsDyn.getLong("id"));
        }
        this.getView().close();
    }

    private void toAddGoods() {
        DynamicObject selectedGoodsDyn = (DynamicObject)this.getModel().getValue("goods", 0);
        String purchaseOrg = (String)this.getView().getFormShowParameter().getCustomParam("purchase_org");
        long orgId = RequestContext.get().getOrgId();
        if (purchaseOrg != null) {
            orgId = Long.parseLong(purchaseOrg);
        }
        List malGoodsList = ((IMalCompareService)DomainServiceFactory.serviceOf(IMalCompareService.class)).getDetailCompareGoods(Long.valueOf(RequestContext.get().getCurrUserId()), Long.valueOf(orgId));
        String searchText = "";
        if (malGoodsList.size() > 0) {
            searchText = ((MalGoods)malGoodsList.get(0)).getProductName();
        }
        this.jumpToAddCompareGoodsPage(searchText);
    }

    private void jumpToAddCompareGoodsPage(String searchText) {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add("goods");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(((MalVersionSwitchService)DomainServiceFactory.serviceOf(MalVersionSwitchService.class)).getMalAddCompareGoodsKey());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, Object> searchParamMap = new HashMap<String, Object>();
        searchParamMap.put("searchText", searchText);
        searchParamMap.put("searchFields", list);
        DynamicObject orgDyn = (DynamicObject)this.getModel().getValue("header_org");
        if (orgDyn != null) {
            searchParamMap.put("purchase_org", orgDyn.getString("id"));
        }
        showParameter.setCustomParams(searchParamMap);
        showParameter.setCustomParam("origin", (Object)this.getView().getFormShowParameter().getParentFormId());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ((MalVersionSwitchService)DomainServiceFactory.serviceOf(MalVersionSwitchService.class)).getMalAddCompareGoodsKey()));
        showParameter.setShowTitle(false);
        this.getView().showForm(showParameter);
        this.getView().setVisible(Boolean.FALSE, new String[]{SCMSEARCH});
        this.getView().updateView();
        this.getPageCache().put("refreshSearch", "0");
    }

    private void clearCurrentEntryAndRefresh() {
        int[] selectedIndexs = this.getSelectedIndexs();
        if (selectedIndexs.length > 0) {
            DynamicObject goodsDyn = (DynamicObject)this.getModel().getValue("goods", selectedIndexs[0]);
            if (goodsDyn != null) {
                ((IMalCompareService)DomainServiceFactory.serviceOf(IMalCompareService.class)).deleteCompareRecords(Stream.of(Long.valueOf(goodsDyn.getLong("id"))).collect(Collectors.toSet()), Long.valueOf(RequestContext.get().getCurrUserId()));
                List<String> compareDims = this.getCompareDims();
                for (String compareDim : compareDims) {
                    this.getModel().setValue(compareDim, null, selectedIndexs[0]);
                }
                if (null != this.getPageCache().get("compareId")) {
                    String compareId = this.getPageCache().get("compareId");
                    ((IMalCompareService)DomainServiceFactory.serviceOf(IMalCompareService.class)).deleteComparePriceRecord(Long.valueOf(goodsDyn.getLong("id")), Long.valueOf(compareId), this.getOrgId());
                }
                Map qtyPriceMap = new HashMap(1024);
                if (null != this.getPageCache().get(ADDQTY_CACHE)) {
                    qtyPriceMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(ADDQTY_CACHE), Map.class);
                }
                qtyPriceMap.remove(goodsDyn.getString("id"));
                this.getPageCache().put(ADDQTY_CACHE, SerializationUtils.toJsonString(qtyPriceMap));
                DynamicObject orgDyn = (DynamicObject)this.getModel().getValue("header_org");
                List malGoodsList = ((IMalCompareService)DomainServiceFactory.serviceOf(IMalCompareService.class)).getDetailCompareGoods(Long.valueOf(RequestContext.get().getCurrUserId()), Long.valueOf(orgDyn.getLong("id")), BigDecimal.ONE);
                this.initGoodsCount(malGoodsList.size());
            }
            this.getView().updateView();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (StringUtils.equals((CharSequence)ADD_CART, (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            if (null != this.getView().getFormShowParameter().getCustomParams().get("purchase_org")) {
                this.addPurchase();
            } else {
                this.addToCart();
            }
        }
    }

    private void checkStock() {
        DynamicObject goodsDyn;
        int[] selectedIndexs = this.getSelectedIndexs();
        if (selectedIndexs.length > 0 && (goodsDyn = (DynamicObject)this.getModel().getValue("goods", selectedIndexs[0])) != null) {
            long pk = goodsDyn.getLong("id");
            MalGoods malGoods = MalGoods.of((Long)pk);
            BigDecimal compareQty = BigDecimal.ONE;
            if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malGoods.getPlatform())) {
                compareQty = (BigDecimal)this.getModel().getValue(ADDQTY, selectedIndexs[0]);
            }
            if (!((MalStockService)MalBusinessFactory.serviceOf(MalStockService.class)).validGoodsStock(malGoods, compareQty)) {
                boolean isPurChase = ((MalVersionSwitchService)DomainServiceFactory.serviceOf(MalVersionSwitchService.class)).getMalPickGoodsKey().equals(this.getView().getFormShowParameter().getParentFormId());
                if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malGoods.getPlatform()) && !MalOrderParamUtil.isSelfInventoryUnlimited()) {
                    if (isPurChase) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3\uff0c\u65e0\u6cd5\u52a0\u5165\u9009\u8d2d\u3002", (String)"MalCompareDetailPlugin_9", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                    } else {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3\uff0c\u65e0\u6cd5\u52a0\u5165\u8d2d\u7269\u8f66\u3002", (String)"MalCompareDetailPlugin_10", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                    }
                    return;
                }
                if (!EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malGoods.getPlatform())) {
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(ADD_CART, (IFormPlugin)this);
                    String confirmTip = isPurChase ? ResManager.loadKDString((String)"\u8be5\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3\uff0c\u786e\u5b9a\u8981\u52a0\u5165\u9009\u8d2d\u5417\uff1f", (String)"MalCompareDetailPlugin_0", (String)"scm-mal-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8be5\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3\uff0c\u786e\u5b9a\u8981\u52a0\u5165\u8d2d\u7269\u8f66\u5417\uff1f", (String)"MalCompareDetailPlugin_1", (String)"scm-mal-formplugin", (Object[])new Object[0]);
                    this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                    return;
                }
            }
            if (null != this.getView().getFormShowParameter().getCustomParams().get("purchase_org")) {
                this.addPurchase();
            } else {
                this.addToCart();
            }
        }
    }

    private void addToCart() {
        DynamicObject goodsDyn;
        int[] selectedIndexs = this.getSelectedIndexs();
        if (selectedIndexs.length > 0 && (goodsDyn = (DynamicObject)this.getModel().getValue("goods", selectedIndexs[0])) != null) {
            long pk = goodsDyn.getLong("id");
            String goodsName = goodsDyn.getString("name");
            String source = goodsDyn.getString("source");
            ((MalShopCartService)MalBusinessFactory.serviceOf(MalShopCartService.class)).addToCart(Long.valueOf(pk), source, BigDecimal.ONE);
            String msg = ResManager.loadKDString((String)"{0}\u6dfb\u52a0\u8d2d\u7269\u8f66\u6210\u529f\u3002", (String)"MalCompareDetailPlugin_2", (String)"scm-mal-formplugin", (Object[])new Object[]{goodsName});
            this.getView().showSuccessNotification(msg);
        }
    }

    public void registerListener(EventObject e) {
        String vectorapKeysStr;
        Button vectorap_delete;
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        this.addClickListeners(new String[]{IMAGEAP_CONTAINER_1, IMAGEAP_CONTAINER_2, IMAGEAP_CONTAINER_3, IMAGEAP_CONTAINER_4, MAINIMAGEAP_CONTAINER, GOODS_CONTAINER});
        Button vectorLeft = (Button)this.getView().getControl(LEFT);
        if (null != vectorLeft) {
            vectorLeft.addClickListener((ClickListener)this);
        }
        Button vectorRight = (Button)this.getView().getControl(RIGHT);
        if (null != vectorLeft) {
            vectorRight.addClickListener((ClickListener)this);
        }
        if (null != (vectorap_delete = (Button)this.getView().getControl("vectorap_delete"))) {
            vectorap_delete.addClickListener((ClickListener)this);
        }
        if (!StringUtils.isEmpty((CharSequence)(vectorapKeysStr = this.getPageCache().get(VERTORAP_CACHE)))) {
            List vectorapKeys = SerializationUtils.fromJsonStringToList((String)vectorapKeysStr, Map.class);
            for (Map vectorapKeyMap : vectorapKeys) {
                for (String key : vectorapKeyMap.keySet()) {
                    Button vectorap = (Button)this.getView().getControl(key);
                    if (null == vectorap) continue;
                    vectorap.addClickListener((ClickListener)this);
                }
            }
        }
    }

    public void click(EventObject evt) {
        String comparepage;
        DynamicObject goodsDyn;
        Object v;
        int[] selectRows;
        super.click(evt);
        Object source = evt.getSource();
        String key = "";
        if (source instanceof Container) {
            key = ((Container)source).getKey();
        }
        if (evt.getSource() instanceof Button) {
            Button bt = (Button)evt.getSource();
            key = bt.getKey();
        }
        if (key.startsWith(IMAGEAP_CONTAINER) && (selectRows = this.getSelectedIndexs()).length > 0 && null != (v = this.getModel().getValue(IMAGEAP + key.substring(key.length() - 1, key.length()), selectRows[0])) && StringUtils.isNotBlank((CharSequence)String.valueOf(v))) {
            this.getModel().setValue(PIC_INDEX, (Object)Integer.parseInt(key.substring(key.length() - 1)), selectRows[0]);
        }
        if (Stream.of(MAINIMAGEAP_CONTAINER, GOODS_CONTAINER).collect(Collectors.toSet()).contains(key) && (selectRows = this.getSelectedIndexs()).length > 0 && (goodsDyn = (DynamicObject)this.getModel().getValue("goods", selectRows[0])) != null) {
            String goodsId = goodsDyn.getString("id");
            String number = goodsDyn.getString("number");
            String platform = goodsDyn.getString("source");
            String goodsName = goodsDyn.getString("name");
            String orgin = (String)this.getView().getFormShowParameter().getCustomParam("origin");
            if (StringUtils.isEmpty((CharSequence)orgin)) {
                orgin = this.getView().getFormShowParameter().getParentFormId();
            }
            CloseCallBack cb = new CloseCallBack((IFormPlugin)this, orgin);
            ShowType showType = ShowType.NewWindow;
            HashMap<String, String> customParamMap = new HashMap<String, String>();
            if (((MalVersionSwitchService)DomainServiceFactory.serviceOf(MalVersionSwitchService.class)).getMalPickGoodsKey().equals(orgin)) {
                showType = ShowType.Modal;
                DynamicObject orgDyn = (DynamicObject)this.getModel().getValue("header_org");
                if (orgDyn != null) {
                    customParamMap.put("purchase_org", orgDyn.getString("id"));
                }
            }
            this.getView().showForm(MalProductDetail.getDetailPageFormShowParam((String)goodsId, (String)number, (String)platform, (String)goodsName, (String)orgin, (ShowType)showType, customParamMap, (CloseCallBack)cb));
        }
        if (LEFT.equals(key)) {
            comparepage = this.getPageCache().get(COMPARE_PAGECACHE);
            int pageIndex = 1;
            if (!StringUtils.isEmpty((CharSequence)comparepage)) {
                pageIndex = Integer.parseInt(comparepage);
            }
            this.getPageCache().put(COMPARE_PAGECACHE, String.valueOf(--pageIndex));
            this.refresh();
        }
        if (RIGHT.equals(key)) {
            comparepage = this.getPageCache().get(COMPARE_PAGECACHE);
            int pageIndex = 1;
            if (!StringUtils.isEmpty((CharSequence)comparepage)) {
                pageIndex = Integer.parseInt(comparepage);
            }
            this.getPageCache().put(COMPARE_PAGECACHE, String.valueOf(++pageIndex));
            this.refresh();
        }
    }

    private void vertorApClick(String key) {
    }

    public void entryRowClick(RowClickEvent evt) {
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)ENTRYENTITY, (CharSequence)source.getKey())) {
            int row = evt.getRow();
            this.getPageCache().put("row", String.valueOf(row));
        }
    }

    private void showLadpriceForm(int rowIndex) {
        DynamicObject goods = (DynamicObject)this.getModel().getValue("goods", rowIndex);
        long goodsId = goods.getLong("id");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object ladpriceStr = null;
        if (null != customParams.get("compareId")) {
            List<Map<String, Object>> compareShotInfo = this.getCompareShotInfo();
            for (Map<String, Object> shotMap : compareShotInfo) {
                if (Long.parseLong(String.valueOf(shotMap.get("goods"))) != goodsId) continue;
                ladpriceStr = shotMap.get("ladprice");
                break;
            }
        } else {
            ArrayList<Long> goodsIds = new ArrayList<Long>(1);
            goodsIds.add(goodsId);
            Map goodsMap = MalGoods.batchGetLadderPrice(goodsIds, (Long)this.getOrgId());
            if (null != goodsMap.get(goodsId)) {
                ladpriceStr = goodsMap.get(goodsId);
            }
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("pbd_ladderprice");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, String> detailParamMap = new HashMap<String, String>();
        detailParamMap.put("status", "1");
        detailParamMap.put("ladderPrices", SerializationUtils.toJsonString((Object)ladpriceStr));
        showParameter.setCustomParams(detailParamMap);
        this.getView().showForm(showParameter);
    }

    private int[] getSelectedIndexs() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        return entryGrid.getEntryState().getSelectedRows();
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        if (HISTORY_PRICE.equals(hyperLinkClickEvent.getFieldName())) {
            this.showPriceTrend(hyperLinkClickEvent.getRowIndex() + 1);
        }
        if ("expandladprice".equals(hyperLinkClickEvent.getFieldName())) {
            this.showLadpriceForm(hyperLinkClickEvent.getRowIndex());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject orgDyn;
        if (PIC_INDEX.equals(e.getProperty().getName())) {
            this.switchPicture((Integer)e.getChangeSet()[0].getNewValue(), e.getChangeSet()[0].getRowIndex());
        }
        if ("header_org".equals(e.getProperty().getName()) && (orgDyn = (DynamicObject)e.getChangeSet()[0].getNewValue()) != null) {
            this.refreshByOrg(orgDyn.getLong("id"));
        }
        if (StringUtils.equals((CharSequence)ADDQTY, (CharSequence)e.getProperty().getName())) {
            ChangeData[] changedData = e.getChangeSet();
            BigDecimal oldVal = CommonUtil.getBigDecimalPro((Object)changedData[0].getOldValue());
            BigDecimal newVal = CommonUtil.getBigDecimalPro((Object)changedData[0].getNewValue());
            if (newVal.compareTo(BigDecimal.ZERO) == 0 || newVal.compareTo(BigDecimal.ZERO) < 0) {
                this.getModel().setValue(ADDQTY, (Object)oldVal, e.getChangeSet()[0].getRowIndex());
            }
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            Object goods = this.getModel().getValue("goods", rowIndex);
            if (null != goods) {
                BigDecimal qty = CommonUtil.getBigDecimalPro((Object)this.getModel().getValue(ADDQTY, rowIndex));
                DynamicObject goodsDyn = (DynamicObject)goods;
                Long goodsId = goodsDyn.getLong("id");
                String source = goodsDyn.getString("source");
                MalGoods malGoods = this.getMalGoods(goodsId, qty, source);
                this.getView().getModel().setValue(PRICE, (Object)malGoods.getTaxPrice(), rowIndex);
                Map<String, HashMap<String, String>> qtyPriceMap = new HashMap(1024);
                if (null != this.getPageCache().get(ADDQTY_CACHE)) {
                    qtyPriceMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(ADDQTY_CACHE), Map.class);
                }
                HashMap<String, String> map = new HashMap<String, String>(1024);
                map.put("qty", String.valueOf(qty));
                map.put(PRICE, String.valueOf(malGoods.getTaxPrice()));
                qtyPriceMap.put(goodsDyn.getString("id"), map);
                this.getPageCache().put(ADDQTY_CACHE, SerializationUtils.toJsonString(qtyPriceMap));
            }
        }
    }

    private void setLadpriceValue(List<MalGoods> malGoodsList) {
        DynamicObjectCollection entrCol = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRYENTITY);
        CardEntry cardEntry = (CardEntry)this.getControl(ENTRYENTITY);
        for (DynamicObject row : entrCol) {
            int seq = row.getInt("seq") - 1;
            if (null != row.getDynamicObject("goods")) {
                Long goodsId = row.getDynamicObject("goods").getLong("id");
                for (MalGoods malGoods : malGoodsList) {
                    if (Long.parseLong(malGoods.getProductId()) != goodsId) continue;
                    List ladderPriceInfos = malGoods.getLadderPriceInfos();
                    String ladpriceStr = this.getLadPriceStr(ladderPriceInfos, row);
                    if (ladpriceStr.length() != 0) {
                        this.getView().getModel().setValue("compare_ladprice", (Object)ladpriceStr, seq);
                    } else {
                        this.getView().getModel().setValue("compare_ladprice", (Object)SPLIT, seq);
                    }
                    if (ladderPriceInfos == null || ladderPriceInfos.size() <= 3) {
                        cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), seq, new String[]{"expandladprice"});
                        continue;
                    }
                    cardEntry.setChildVisible(Boolean.TRUE.booleanValue(), seq, new String[]{"expandladprice"});
                }
                continue;
            }
            cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), seq, new String[]{"expandladprice"});
        }
    }

    private String getLadPriceStr(List<LadderPriceInfo> ladderPriceInfos, DynamicObject row) {
        DynamicObject unit = row.getDynamicObject("unit");
        DynamicObject currency = row.getDynamicObject("currency");
        int amtprecision = 2;
        String sign = "";
        if (null != currency) {
            amtprecision = currency.getInt("amtprecision");
            sign = currency.getString("sign");
        }
        StringBuilder stringBuilder = new StringBuilder();
        int max = 3;
        if (null == ladderPriceInfos || ladderPriceInfos.size() == 0) {
            return stringBuilder.toString();
        }
        if (ladderPriceInfos.size() < 3) {
            max = ladderPriceInfos.size();
        }
        String msg = ResManager.loadKDString((String)"\u4ee5\u4e0a", (String)"MalCompareDetailPlugin_6", (String)"scm-mal-formplugin", (Object[])new Object[0]);
        for (int i = 0; i < max; ++i) {
            Object ladderPriceInfo;
            if (i + 1 == ladderPriceInfos.size()) {
                if (ladderPriceInfos.get(i) instanceof LadderPriceInfo) {
                    ladderPriceInfo = ladderPriceInfos.get(i);
                    stringBuilder.append(ladderPriceInfo.getQtyfrom().setScale(0)).append(unit.getString("name")).append(msg).append(':').append(sign).append(ladderPriceInfo.getLadprice().setScale(amtprecision));
                } else {
                    ladderPriceInfo = (Map)ladderPriceInfos.get(i);
                    stringBuilder.append(((BigDecimal)ladderPriceInfo.get("qtyfrom")).setScale(0)).append(unit.getString("name")).append(msg).append(':').append(sign).append(((BigDecimal)ladderPriceInfo.get("ladprice")).setScale(amtprecision));
                }
            } else if (ladderPriceInfos.get(i) instanceof LadderPriceInfo) {
                ladderPriceInfo = ladderPriceInfos.get(i);
                stringBuilder.append(ladderPriceInfo.getQtyfrom().setScale(0)).append('-').append(ladderPriceInfo.getQtyto().setScale(0)).append(unit.getString("name")).append(':').append(sign).append(ladderPriceInfo.getLadprice().setScale(amtprecision));
            } else {
                ladderPriceInfo = (Map)ladderPriceInfos.get(i);
                stringBuilder.append(((BigDecimal)ladderPriceInfo.get("qtyfrom")).setScale(0)).append('-').append(((BigDecimal)ladderPriceInfo.get("qtyto")).setScale(0)).append(unit.getString("name")).append(':').append(sign).append(((BigDecimal)ladderPriceInfo.get("ladprice")).setScale(amtprecision));
            }
            if (i == 2) continue;
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    private MalGoods getMalGoods(Long goodsId, BigDecimal qty, String source) {
        ArrayList<MalMatGoodsInitParam> malMatGoodsInitParams = new ArrayList<MalMatGoodsInitParam>(1024);
        malMatGoodsInitParams.add(MalMatGoodsInitParam.buildGeneralParam((Long)goodsId, (String)source, (BigDecimal)qty, null, (Long)this.getOrgId()));
        Map malGoodsMap = MalGoods.batchInstance(malMatGoodsInitParams, (boolean)false, (boolean)false);
        return (MalGoods)malGoodsMap.get(goodsId);
    }

    private void switchPicture(int picIndex, int rowIndex) {
        String newPic = (String)this.getModel().getValue(IMAGEAP + picIndex, rowIndex);
        this.getModel().setValue(IMAGEAP, (Object)newPic, rowIndex);
    }

    private void showPriceTrend(int index) {
        String source;
        Long goodsId;
        MalGoods malGoods;
        MalPriceMonitorService service;
        int[] selectRows = this.getSelectedIndexs();
        DynamicObject goodsDyn = (DynamicObject)this.getModel().getValue("goods", selectRows[0]);
        Object pricemonitortab = this.getModel().getValue("pricemonitortab");
        ArrayList<String> invisibletabs = new ArrayList<String>(16);
        if (null != pricemonitortab) {
            String[] tabs;
            for (String tab : tabs = String.valueOf(pricemonitortab).split(",")) {
                if (StringUtils.isEmpty((CharSequence)tab)) continue;
                invisibletabs.add(tab);
            }
        }
        if (!(service = new MalPriceMonitorService()).checkIsShowPriceMonitorForm(malGoods = this.getMalGoods(goodsId = Long.valueOf(goodsDyn.getLong("id")), BigDecimal.ONE, source = goodsDyn.getString("source")), invisibletabs)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6bd4\u4ef7\u8bb0\u5f55\u3001\u540c\u6b3e\u5546\u54c1\u3001\u534a\u5e74\u5185\u7684\u5386\u53f2\u4ef7\u683c\u548c\u672c\u7ec4\u7ec7\u4ea4\u6613\u4ef7\u6570\u636e\u3002", (String)"MalCompareDetailPlugin_11", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("mal_pricemonitordetail");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap detailParamMap = new HashMap();
        detailParamMap.put("purchase_org", this.getView().getFormShowParameter().getCustomParams().get("purchase_org"));
        detailParamMap.put("goodsId", goodsDyn.getLong("id"));
        detailParamMap.put("source", goodsDyn.getLong("source"));
        detailParamMap.put("org", this.getOrgId());
        detailParamMap.put("sourceForm", this.getModel().getDataEntity().getDataEntityType().getName());
        detailParamMap.put("invisibletabs", SerializationUtils.toJsonString(invisibletabs));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "samegoods"));
        showParameter.setCustomParams(detailParamMap);
        this.getView().showForm(showParameter);
    }

    private void removePriceTrend() {
        IPageCache pageCache = this.getPageCache();
        String priceTrendView = pageCache.get(PRICE_TREND_VIEW);
        IFormView iFormView = null;
        if (StringUtils.isNotBlank((CharSequence)priceTrendView)) {
            iFormView = this.getView().getView(priceTrendView);
            FormView formView = (FormView)iFormView;
            if (formView != null) {
                formView.close();
                this.getView().sendFormAction((IFormView)formView);
            }
            pageCache.remove(PRICE_TREND_VIEW);
            pageCache.remove(PRICE_TREND_CONTAINER);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        IPageCache pageCache = this.getPageCache();
        String malAddCompareGoodsKey = ((MalVersionSwitchService)DomainServiceFactory.serviceOf(MalVersionSwitchService.class)).getMalAddCompareGoodsKey();
        if (malAddCompareGoodsKey.equals(closedCallBackEvent.getActionId())) {
            if ("mal_addcomparegoods".equals(malAddCompareGoodsKey)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{SCMSEARCH});
            }
            this.getPageCache().remove("refreshSearch");
            this.refresh();
        } else if (SHOWHISTORYPRICE.equals(closedCallBackEvent.getActionId())) {
            Map returnData;
            String hasData;
            String priceTrendContainer = pageCache.get(PRICE_TREND_CONTAINER);
            if (closedCallBackEvent.getReturnData() != null && "false".equals(hasData = (String)(returnData = (Map)closedCallBackEvent.getReturnData()).get("hasData"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u67e5\u770b\u534a\u5e74\u5185\u5546\u54c1\u7684\u8d2d\u4e70\u8bb0\u5f55\u548c\u4f9b\u5e94\u5546\u8c03\u4ef7\u4fe1\u606f\uff0c\u6682\u65e0\u76f8\u5173\u8bb0\u5f55\u3002", (String)"MalCompareDetailPlugin_4", (String)"scm-mal-formplugin", (Object[])new Object[0]));
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{priceTrendContainer});
            this.getView().updateView(priceTrendContainer);
            pageCache.remove(PRICE_TREND_CONTAINER);
        } else if (((MalVersionSwitchService)DomainServiceFactory.serviceOf(MalVersionSwitchService.class)).getMalPickGoodsKey().equals(closedCallBackEvent.getActionId()) && !ObjectUtils.isEmpty((Object)closedCallBackEvent.getReturnData())) {
            this.getView().returnDataToParent(closedCallBackEvent.getReturnData());
            this.getView().close();
        }
        if (closedCallBackEvent.getActionId().equals("samegoods") && closedCallBackEvent.getReturnData() != null) {
            Long pk = Long.parseLong(String.valueOf(closedCallBackEvent.getReturnData()));
            this.getView().returnDataToParent((Object)pk);
            this.getView().close();
        }
    }
}

