/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.scm.mal.common.util.MalProductUtil;
import kd.scm.mal.domain.model.goods.MalGoods;
import kd.scm.mal.domain.model.productdetail.MalProductDetail;
import kd.scm.mal.domain.service.DomainServiceFactory;
import kd.scm.mal.domain.service.IMalCompareService;
import kd.scm.mal.domain.service.MalVersionSwitchService;
import kd.scm.mal.formplugin.MalNewProductDetailPlugin;
import kd.scm.mal.formplugin.MalPickGoodsPlugin;

public class MalComparePlugin
extends AbstractFormPlugin
implements HyperLinkClickListener,
RowClickEventListener {
    private static final String SCMSEARCH = "scmsearch";
    private static final String COMPARE = "compare";
    private static final String COMPARE_FLEX = "compare_flex";
    private static final String COMPARE_FLOAD_FLEX = "compare_float_flex";
    private static final String CACHE_COMPARE_SHOW = "cache_compare_show";
    private static final String NUM_FLEX = "num_flex";
    private static final String LEFT_LB = "left_lb";
    private static final String RIGHT_LB = "right_lb";
    private static final String COMPARE_LB = "compare_lb";
    private static final String COMPARE_NUM = "compare_num";
    private static final String BT_HIDECOMPARE = "bt_hidecompare";
    private static final String COMPARE_DELETE = "compare_delete";
    private static final String COMPARE_GOODS = "compare_goods";
    private static final String COMPARE_ENTRYENTITY = "compare_entryentity";
    private static final String COMPARE_PRICE = "compare_price";
    private static final String COMPARE_PICTURE = "compare_picture";
    private static final String START_COMPARE = "start_compare";
    private static final String COMPARE_CLEAR = "compare_clear";
    private static final String COMPARE_GOODSFLEXPANELAP = "compare_goodsflexpanelap";
    private static final String BAR_GOODS_CONTAINER = "bar_goods_container";
    private static final String COMAPARE_PANELAP = "comapare_panelap";
    private static final String REFRESH_COMPARE = "refresh_compare";
    private static final String SHOW_COMPARE = "show_compare";
    private static final String UPDATE_COMPARE_CHECKSTATUS = "update_compare_checkstatus";
    private static final String MAL_RECOMMENDED_GOODS = "mal_recommended_goods";
    private static final String MAL_NEWPRODUCTDETAIL = "mal_newproductdetail";
    private static final String COMPARE_LEFT = "compare_left";
    private static final String COMPARE_RIGHT = "compare_right";
    private static final String COMPARE_PAGECACHE = "compare_pagecache";
    private static final int COMPARE_SHOWNUM = 4;
    private static final String CLI_UPDATE_COMPARE_NUM = "updateCompareNum";

    public void afterCreateNewData(EventObject e) {
        this.sendAction(CLI_UPDATE_COMPARE_NUM);
        this.getView().setVisible(Boolean.FALSE, new String[]{COMPARE_FLEX});
    }

    public void clientCallBack(ClientCallBackEvent e) {
        if (Objects.nonNull(e) && CLI_UPDATE_COMPARE_NUM.equals(e.getName())) {
            this.updateCompareNum(((IMalCompareService)DomainServiceFactory.serviceOf(IMalCompareService.class)).queryCurrentUserCompareRecords().size());
            this.getView().setVisible(Boolean.FALSE, new String[]{COMPARE_FLEX});
            this.getView().getPageCache().remove(CACHE_COMPARE_SHOW);
            this.getPageCache().remove(COMPARE_PAGECACHE);
        }
    }

    private void sendAction(String name) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> param = new HashMap<String, Object>(8);
        param.put("name", name);
        param.put("duration", 0);
        param.put("async", Boolean.TRUE);
        proxy.addAction("addClientCallBack", param);
    }

    private List<MalGoods> getSimpleCompareGoods() {
        return ((IMalCompareService)DomainServiceFactory.serviceOf(IMalCompareService.class)).getSimpleCompareGoods(Long.valueOf(RequestContext.get().getCurrUserId()));
    }

    private void updateCompareNum(int compareNum) {
        this.getModel().setValue(COMPARE_NUM, (Object)Math.max(compareNum, 0));
    }

    private void initBar(List<MalGoods> malGoodsList) {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int index = 0;
        String pageIndexCache = this.getPageCache().get(COMPARE_PAGECACHE);
        int pageIndex = 1;
        int maxCompareRows = malGoodsList.size();
        if (!StringUtils.isEmpty((CharSequence)pageIndexCache)) {
            pageIndex = Integer.parseInt(pageIndexCache);
        }
        if (pageIndex * 4 < maxCompareRows) {
            maxCompareRows = pageIndex * 4;
        }
        for (int i = (pageIndex - 1) * 4; i < maxCompareRows; ++i) {
            MalGoods malGoods = malGoodsList.get(i);
            vs.set(COMPARE_GOODS, (Object)malGoods.getId(), index);
            vs.set(COMPARE_PICTURE, (Object)malGoods.getThumbnail(), index);
            vs.set(COMPARE_PRICE, (Object)malGoods.getTaxPrice(), index);
            ++index;
        }
        this.getModel().beginInit();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData(COMPARE_ENTRYENTITY);
        model.batchCreateNewEntryRow(COMPARE_ENTRYENTITY, vs);
        this.getModel().setValue(COMPARE_NUM, (Object)malGoodsList.size());
        this.getModel().endInit();
        this.getView().updateView(COMPARE_ENTRYENTITY);
        this.getView().updateView(COMPARE_FLOAD_FLEX);
        if (Arrays.asList(((MalVersionSwitchService)DomainServiceFactory.serviceOf(MalVersionSwitchService.class)).getMalNewSearchKey(), ((MalVersionSwitchService)DomainServiceFactory.serviceOf(MalVersionSwitchService.class)).getMalPickGoodsKey(), ((MalVersionSwitchService)DomainServiceFactory.serviceOf(MalVersionSwitchService.class)).getMalAddCompareGoodsKey(), ((MalVersionSwitchService)DomainServiceFactory.serviceOf(MalVersionSwitchService.class)).getMalRecommendedGoodsKey()).contains(this.getView().getEntityId())) {
            this.getView().invokeOperation(UPDATE_COMPARE_CHECKSTATUS);
        }
    }

    private void hideCompare() {
        this.getView().setVisible(Boolean.FALSE, new String[]{COMPARE_FLEX});
        this.getView().getPageCache().remove(CACHE_COMPARE_SHOW);
        this.getView().updateView(COMPARE_FLEX);
        this.getPageCache().remove(COMPARE_PAGECACHE);
    }

    private void showCompare(List<MalGoods> malGoodsList) {
        this.getView().setVisible(Boolean.TRUE, new String[]{COMPARE_FLEX});
        this.initBar(malGoodsList);
        this.getView().setEnable(Boolean.valueOf(malGoodsList.size() >= 2), new String[]{START_COMPARE});
        this.getView().getPageCache().put(CACHE_COMPARE_SHOW, "1");
        if (malGoodsList.size() > 4) {
            String pageIndex = this.getPageCache().get(COMPARE_PAGECACHE);
            if (StringUtils.isEmpty((CharSequence)pageIndex)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{COMPARE_RIGHT});
                this.getView().setVisible(Boolean.FALSE, new String[]{COMPARE_LEFT});
            } else {
                int maxCompareRows = malGoodsList.size();
                int maxIndex = maxCompareRows % 4;
                maxIndex = maxIndex == 0 ? maxCompareRows / 4 : maxCompareRows / 4 + 1;
                int index = Integer.parseInt(pageIndex);
                if (index == 1) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{COMPARE_RIGHT});
                    this.getView().setVisible(Boolean.FALSE, new String[]{COMPARE_LEFT});
                }
                if (index == maxIndex) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{COMPARE_RIGHT});
                    this.getView().setVisible(Boolean.TRUE, new String[]{COMPARE_LEFT});
                }
                if (index > 1 && index < maxIndex) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{COMPARE_LEFT, COMPARE_RIGHT});
                }
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{COMPARE_LEFT, COMPARE_RIGHT});
        }
    }

    private void refreshCompare() {
        String purchaseOrg = (String)this.getView().getFormShowParameter().getCustomParam("purchase_org");
        long orgId = RequestContext.get().getOrgId();
        if (purchaseOrg != null) {
            orgId = Long.parseLong(purchaseOrg);
        }
        List malGoodsList = ((IMalCompareService)DomainServiceFactory.serviceOf(IMalCompareService.class)).getSimpleCompareGoods(Long.valueOf(RequestContext.get().getCurrUserId()), Long.valueOf(orgId));
        this.initBar(malGoodsList);
        this.getView().setEnable(Boolean.valueOf(malGoodsList.size() >= 2), new String[]{START_COMPARE});
    }

    public void registerListener(EventObject e) {
        Button vectorLeft;
        Button vectorIcon;
        Container comaparePanelap;
        Container compareGoodsflexpanelap;
        Container barGoodsContainer;
        EntryGrid entryGrid;
        Button bt;
        Container numFlex;
        Label rightLabel;
        Label leftLabel;
        Label compareLabel;
        super.registerListener(e);
        Container compareFlex = (Container)this.getControl(COMPARE_FLOAD_FLEX);
        if (compareFlex != null) {
            compareFlex.addClickListener((ClickListener)this);
        }
        if ((compareLabel = (Label)this.getControl(COMPARE_LB)) != null) {
            compareLabel.addClickListener((ClickListener)this);
        }
        if ((leftLabel = (Label)this.getControl(LEFT_LB)) != null) {
            leftLabel.addClickListener((ClickListener)this);
        }
        if ((rightLabel = (Label)this.getControl(RIGHT_LB)) != null) {
            rightLabel.addClickListener((ClickListener)this);
        }
        if ((numFlex = (Container)this.getControl(NUM_FLEX)) != null) {
            numFlex.addClickListener((ClickListener)this);
        }
        if ((bt = (Button)this.getControl(BT_HIDECOMPARE)) != null) {
            bt.addClickListener((ClickListener)this);
        }
        if ((entryGrid = (EntryGrid)this.getControl(COMPARE_ENTRYENTITY)) != null) {
            entryGrid.addHyperClickListener((HyperLinkClickListener)this);
            entryGrid.addRowClickListener((RowClickEventListener)this);
        }
        if ((barGoodsContainer = (Container)this.getControl(BAR_GOODS_CONTAINER)) != null) {
            barGoodsContainer.addClickListener((ClickListener)this);
        }
        if ((compareGoodsflexpanelap = (Container)this.getControl(COMPARE_GOODSFLEXPANELAP)) != null) {
            compareGoodsflexpanelap.addClickListener((ClickListener)this);
        }
        if ((comaparePanelap = (Container)this.getControl(COMAPARE_PANELAP)) != null) {
            comaparePanelap.addClickListener((ClickListener)this);
        }
        if (null != (vectorIcon = (Button)this.getView().getControl(COMPARE_DELETE))) {
            vectorIcon.addClickListener((ClickListener)this);
        }
        if (null != (vectorLeft = (Button)this.getView().getControl(COMPARE_LEFT))) {
            vectorLeft.addClickListener((ClickListener)this);
        }
        Button vectorRight = (Button)this.getView().getControl(COMPARE_RIGHT);
        if (null != vectorLeft) {
            vectorRight.addClickListener((ClickListener)this);
        }
    }

    public void click(EventObject evt) {
        DynamicObject goodsDyn;
        int[] selectRows;
        super.click(evt);
        String key = "";
        if (evt.getSource() instanceof Container) {
            Container container = (Container)evt.getSource();
            key = container.getKey();
        }
        if (evt.getSource() instanceof Button) {
            Button bt = (Button)evt.getSource();
            key = bt.getKey();
        }
        if (Arrays.asList(COMPARE_FLOAD_FLEX, COMPARE_FLEX, LEFT_LB, RIGHT_LB, NUM_FLEX, COMPARE_LB).contains(key)) {
            String isCompareHasShow = this.getView().getPageCache().get(CACHE_COMPARE_SHOW);
            if (StringUtils.isEmpty((CharSequence)isCompareHasShow)) {
                this.showCompare(this.getSimpleCompareGoods());
            } else {
                this.hideCompare();
            }
        }
        if (BT_HIDECOMPARE.equals(key)) {
            this.hideCompare();
        }
        if (Stream.of(COMPARE_GOODSFLEXPANELAP, BAR_GOODS_CONTAINER, COMAPARE_PANELAP).collect(Collectors.toSet()).contains(key) && (selectRows = this.getSelectedIndexs()).length > 0 && (goodsDyn = (DynamicObject)this.getModel().getValue(COMPARE_GOODS, selectRows[0])) != null) {
            String goodsId = goodsDyn.getString("id");
            String number = goodsDyn.getString("number");
            String platform = goodsDyn.getString("source");
            String goodsName = goodsDyn.getString("name");
            String orgin = (String)this.getView().getFormShowParameter().getCustomParam("origin");
            if (StringUtils.isEmpty((CharSequence)orgin)) {
                orgin = this.getView().getEntityId();
            }
            CloseCallBack cb = new CloseCallBack((IFormPlugin)this, orgin);
            ShowType showType = ShowType.NewWindow;
            HashMap<String, String> customParamMap = new HashMap<String, String>();
            if (((MalVersionSwitchService)DomainServiceFactory.serviceOf(MalVersionSwitchService.class)).getMalPickGoodsKey().equals(orgin)) {
                cb = new CloseCallBack((IFormPlugin)new MalPickGoodsPlugin(), orgin);
                showType = ShowType.Modal;
                goodsName = "";
                DynamicObject orgDyn = (DynamicObject)this.getModel().getValue("header_org");
                if (orgDyn != null) {
                    customParamMap.put("purchase_org", orgDyn.getString("id"));
                }
            }
            this.getView().showForm(MalProductDetail.getDetailPageFormShowParam((String)goodsId, (String)number, (String)platform, (String)goodsName, (String)orgin, (ShowType)showType, customParamMap, (CloseCallBack)cb));
        }
        if (COMPARE_DELETE.equals(key)) {
            int rowIndex = 0;
            if (null != this.getPageCache().get("row")) {
                rowIndex = Integer.parseInt(this.getPageCache().get("row"));
            }
            if ((goodsDyn = (DynamicObject)this.getModel().getValue(COMPARE_GOODS, rowIndex)) != null) {
                ((IMalCompareService)DomainServiceFactory.serviceOf(IMalCompareService.class)).deleteCompareRecords(Stream.of(Long.valueOf(goodsDyn.getLong("id"))).collect(Collectors.toSet()), Long.valueOf(RequestContext.get().getCurrUserId()));
            }
            this.getModel().deleteEntryRow(COMPARE_ENTRYENTITY, rowIndex);
            this.updateCompareNum(((IMalCompareService)DomainServiceFactory.serviceOf(IMalCompareService.class)).queryCurrentUserCompareRecords().size());
            List<MalGoods> malGoodsList = this.getSimpleCompareGoods();
            DynamicObjectCollection entryCol = this.getModel().getDataEntity(true).getDynamicObjectCollection(COMPARE_ENTRYENTITY);
            if (entryCol.size() == 0) {
                int pageIndex = 0;
                String pageIndexCache = this.getPageCache().get(COMPARE_PAGECACHE);
                if (!StringUtils.isEmpty((CharSequence)pageIndexCache)) {
                    pageIndex = Integer.parseInt(pageIndexCache);
                }
                if (pageIndex != 0) {
                    this.getPageCache().put(COMPARE_PAGECACHE, String.valueOf(--pageIndex));
                    this.showCompare(malGoodsList);
                }
            }
        }
        if (COMPARE_LEFT.equals(key)) {
            String comparepage = this.getPageCache().get(COMPARE_PAGECACHE);
            int pageIndex = 1;
            if (!StringUtils.isEmpty((CharSequence)comparepage)) {
                pageIndex = Integer.parseInt(comparepage);
            }
            this.getPageCache().put(COMPARE_PAGECACHE, String.valueOf(--pageIndex));
            this.showCompare(this.getSimpleCompareGoods());
        }
        if (COMPARE_RIGHT.equals(key)) {
            String comparepage = this.getPageCache().get(COMPARE_PAGECACHE);
            int pageIndex = 1;
            if (!StringUtils.isEmpty((CharSequence)comparepage)) {
                pageIndex = Integer.parseInt(comparepage);
            }
            this.getPageCache().put(COMPARE_PAGECACHE, String.valueOf(++pageIndex));
            this.showCompare(this.getSimpleCompareGoods());
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)COMPARE_ENTRYENTITY, (CharSequence)source.getKey())) {
            int row = evt.getRow();
            this.getPageCache().put("row", String.valueOf(row));
        }
    }

    private int[] getSelectedIndexs() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(COMPARE_ENTRYENTITY);
        return entryGrid.getEntryState().getSelectedRows();
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        if (COMPARE_DELETE.equals(hyperLinkClickEvent.getFieldName())) {
            DynamicObject goodsDyn = (DynamicObject)this.getModel().getValue(COMPARE_GOODS, hyperLinkClickEvent.getRowIndex());
            if (goodsDyn != null) {
                ((IMalCompareService)DomainServiceFactory.serviceOf(IMalCompareService.class)).deleteCompareRecords(Stream.of(Long.valueOf(goodsDyn.getLong("id"))).collect(Collectors.toSet()), Long.valueOf(RequestContext.get().getCurrUserId()));
            }
            this.getModel().deleteEntryRow(COMPARE_ENTRYENTITY, hyperLinkClickEvent.getRowIndex());
            this.updateCompareNum(((IMalCompareService)DomainServiceFactory.serviceOf(IMalCompareService.class)).queryCurrentUserCompareRecords().size());
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (COMPARE.equals(closedCallBackEvent.getActionId())) {
            this.hideCompare();
        }
        if (this.getView().getEntityId().equals(closedCallBackEvent.getActionId())) {
            if (((MalVersionSwitchService)DomainServiceFactory.serviceOf(MalVersionSwitchService.class)).getMalNewSearchKey().equals(closedCallBackEvent.getActionId())) {
                this.getView().invokeOperation(UPDATE_COMPARE_CHECKSTATUS);
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{SCMSEARCH});
            this.showCompare(this.getSimpleCompareGoods());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (COMPARE_NUM.contains(e.getProperty().getName())) {
            List<MalGoods> malGoodsList = this.getSimpleCompareGoods();
            this.showCompare(this.getSimpleCompareGoods());
            this.getView().setEnable(Boolean.valueOf(malGoodsList.size() >= 2), new String[]{START_COMPARE});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (START_COMPARE.equals(afterDoOperationEventArgs.getOperateKey())) {
            this.startCompare();
        }
        if (COMPARE_CLEAR.equals(afterDoOperationEventArgs.getOperateKey())) {
            this.clearCompare();
        }
        if (REFRESH_COMPARE.equals(afterDoOperationEventArgs.getOperateKey())) {
            this.refreshCompare();
        }
        if (SHOW_COMPARE.equals(afterDoOperationEventArgs.getOperateKey())) {
            this.showCompare(this.getSimpleCompareGoods());
        }
    }

    private void clearCompare() {
        ((IMalCompareService)DomainServiceFactory.serviceOf(IMalCompareService.class)).deleteCompareRecords(null, Long.valueOf(RequestContext.get().getCurrUserId()));
        this.showCompare(this.getSimpleCompareGoods());
    }

    private void startCompare() {
        Boolean isView;
        List detailCompareGoods = ((IMalCompareService)DomainServiceFactory.serviceOf(IMalCompareService.class)).getDetailCompareGoods(Long.valueOf(RequestContext.get().getCurrUserId()));
        ArrayList<Long> prodIds = new ArrayList<Long>(1024);
        for (MalGoods malGoods : detailCompareGoods) {
            prodIds.add(Long.parseLong(malGoods.getProductId()));
        }
        String purchaseOrg = (String)this.getView().getFormShowParameter().getCustomParam("purchase_org");
        long orgId = RequestContext.get().getOrgId();
        if (purchaseOrg != null) {
            orgId = Long.parseLong(purchaseOrg);
        }
        if ((isView = MalProductUtil.setMsgView((IFormView)this.getView(), prodIds, (String)COMPARE, (Long)orgId)).booleanValue()) {
            this.refreshCompare();
            List prodIdsByOrg = MalProductUtil.getProdIdsByOrg(prodIds, (Long)orgId);
            HashSet<Long> deleteSet = new HashSet<Long>(1024);
            for (Long id : prodIds) {
                if (prodIdsByOrg.contains(id)) continue;
                deleteSet.add(id);
            }
            if (deleteSet.size() > 0) {
                ((IMalCompareService)DomainServiceFactory.serviceOf(IMalCompareService.class)).deleteCompareRecords(deleteSet, Long.valueOf(RequestContext.get().getCurrUserId()));
            }
            return;
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("mal_compare_detail");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, this.getView().getEntityId()));
        fsp.setCustomParam("origin", this.getView().getFormShowParameter().getCustomParam("origin"));
        if (((MalVersionSwitchService)DomainServiceFactory.serviceOf(MalVersionSwitchService.class)).getMalPickGoodsKey().equals(this.getView().getEntityId())) {
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)new MalPickGoodsPlugin(), this.getView().getEntityId()));
            DynamicObject orgDyn = (DynamicObject)this.getModel().getValue("header_org");
            if (orgDyn != null) {
                fsp.setCustomParam("purchase_org", (Object)orgDyn.getString("id"));
            }
        }
        if (null != this.getView().getFormShowParameter().getCustomParam("purchase_org")) {
            fsp.setCustomParam("purchase_org", this.getView().getFormShowParameter().getCustomParam("purchase_org"));
        }
        if (MAL_NEWPRODUCTDETAIL.equals(this.getView().getEntityId())) {
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)new MalNewProductDetailPlugin(), this.getView().getEntityId()));
        }
        this.getView().showForm(fsp);
        this.getView().setVisible(Boolean.FALSE, new String[]{SCMSEARCH});
        this.getView().updateView(SCMSEARCH);
    }
}

