/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.formplugin;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scm.common.es.storage.EsFilterField;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.mal.domain.model.goods.MalGoods;

public class MalEcSearchV1Plugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog((String)MalEcSearchV1Plugin.class.getName());
    private static final String VECTOR_SELECT = "vector_select";
    private static final String VECTOR_UNSELECT = "vector_unselect";
    private static final String SEARCH_ENTRYENTITY = "search_entryentity";
    private static final String SEARCHGOODS_SKU = "searchgoods_sku";
    private static final String SEARCHGOODS_PK = "searchgoods_pk";
    private static final String OP_ASYNC_EC_SYNC = "async_ec_sync";
    private static final String OP_EC_UPLOAD = "ec_upload";
    private static final String OP_ADDCART = "addcart";
    private static final String OP_ADD_COMPARE = "add_compare";
    private static final String OP_EC_SYNC = "ec_sync";
    private static final String FILTER_NON_SYNC = "filter_non_sync";
    public static final String PERM_SYNC_EC_GOODS = "3Y+43SO6OSKB";

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.valueOf(true), new String[]{VECTOR_UNSELECT});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{VECTOR_SELECT});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{VECTOR_UNSELECT});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{VECTOR_SELECT});
        this.getView().invokeOperation("switch_list");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Vector vectorSelect = (Vector)this.getControl(VECTOR_SELECT);
        vectorSelect.addClickListener((ClickListener)this);
        Vector vectorUnSelect = (Vector)this.getControl(VECTOR_UNSELECT);
        vectorUnSelect.addClickListener((ClickListener)this);
        Button btnAddCartList = (Button)this.getControl("add_cart_btn_list");
        btnAddCartList.addClickListener((ClickListener)this);
        Button btnAddCompareList = (Button)this.getControl("add_compare_list");
        btnAddCompareList.addClickListener((ClickListener)this);
    }

    public void beforeClick(BeforeClickEvent evt) {
        String sku;
        Button btn;
        super.beforeClick(evt);
        if (evt.getSource() instanceof Button && (OP_ADDCART.equals((btn = (Button)evt.getSource()).getOperationKey()) || OP_ADD_COMPARE.equals(btn.getOperationKey())) && StringUtils.isNotBlank((CharSequence)(sku = this.getFocusNonSyncSku()))) {
            String appId = AppMetadataCache.getAppInfo((String)"mal").getId();
            boolean hasPerm = PermissionServiceHelper.checkPermission((Long)UserServiceHelper.getCurrentUserId(), (String)appId, (String)this.getView().getEntityId(), (String)PERM_SYNC_EC_GOODS);
            if (hasPerm) {
                Map sku2GoodsIdMap = MalGoods.ecSync(Collections.singletonList(sku), (String)this.getPlatform());
                this.fillGoodsId(sku2GoodsIdMap);
            } else {
                if (OP_ADDCART.equals(btn.getOperationKey())) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5916\u90e8\u5546\u54c1\u9700\u540c\u6b65\u540e\u518d\u52a0\u5165\u8d2d\u7269\u8f66\uff0c\u60a8\u6ca1\u6709\u540c\u6b65\u6743\u9650\uff0c\u65e0\u6cd5\u76f4\u63a5\u52a0\u8d2d\u3002", (String)"MalEcSearchV1Plugin_0", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                }
                if (OP_ADD_COMPARE.equals(btn.getOperationKey())) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5916\u90e8\u5546\u54c1\u9700\u540c\u6b65\u540e\u518d\u5bf9\u6bd4\uff0c\u60a8\u6ca1\u6709\u540c\u6b65\u6743\u9650\uff0c\u65e0\u6cd5\u5bf9\u6bd4\u3002", (String)"MalEcSearchV1Plugin_1", (String)"scm-mal-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    private String getFocusNonSyncSku() {
        String res = "";
        CardEntry cardEntry = (CardEntry)this.getControl(SEARCH_ENTRYENTITY);
        int focusRow = cardEntry.getEntryState().getFocusRow();
        cardEntry.selectRows(focusRow);
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(SEARCH_ENTRYENTITY, focusRow);
        Object goodsId = entryRowEntity.get(SEARCHGOODS_PK);
        if (ObjectUtils.isEmpty((Object)goodsId)) {
            res = entryRowEntity.getString(SEARCHGOODS_SKU);
        }
        return res;
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof Vector) {
            Vector vector = (Vector)evt.getSource();
            CardEntry entryentity = (CardEntry)this.getControl(SEARCH_ENTRYENTITY);
            if (VECTOR_SELECT.equals(vector.getKey())) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{VECTOR_SELECT});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{VECTOR_UNSELECT});
                entryentity.selectRows(new int[0], 0);
            }
            if (VECTOR_UNSELECT.equals(vector.getKey())) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{VECTOR_UNSELECT});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{VECTOR_SELECT});
                int count = this.getModel().getEntryRowCount(SEARCH_ENTRYENTITY);
                int[] selectRows = new int[count];
                for (int i = 0; i < count; ++i) {
                    selectRows[i] = i;
                }
                entryentity.selectRows(selectRows, 0);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String sku;
        super.afterDoOperation(afterDoOperationEventArgs);
        if (OP_ASYNC_EC_SYNC.equals(afterDoOperationEventArgs.getOperateKey())) {
            try {
                MalGoods.asyncEcSync((List)((List)this.getSelectedGoodsThreeTuple().item1), (String)this.getPlatform());
            }
            catch (KDBizException e) {
                afterDoOperationEventArgs.getOperationResult().setShowMessage(false);
                this.getView().showTipNotification(e.getMessage());
            }
        }
        if (OP_EC_UPLOAD.equals(afterDoOperationEventArgs.getOperateKey())) {
            try {
                this.ecUpload();
            }
            catch (KDBizException e) {
                afterDoOperationEventArgs.getOperationResult().setShowMessage(false);
                this.getView().showTipNotification(e.getMessage());
            }
        }
        if (OP_EC_SYNC.equals(afterDoOperationEventArgs.getOperateKey()) && StringUtils.isNotBlank((CharSequence)(sku = this.getFocusNonSyncSku()))) {
            Map sku2GoodsIdMap = MalGoods.ecSync(Collections.singletonList(sku), (String)this.getPlatform());
            this.fillGoodsId(sku2GoodsIdMap);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (FILTER_NON_SYNC.equals(e.getProperty().getName())) {
            Boolean newValue = (Boolean)e.getChangeSet()[0].getNewValue();
            EsFilterField esFilterField = new EsFilterField("filterNonSync", "=", new Object[]{newValue});
            this.getPageCache().put("custom_es_filter_field", JSON.toJSONString((Object)esFilterField));
            this.getView().invokeOperation("research");
        }
    }

    private String getPlatform() {
        return String.valueOf(this.getModel().getValue("ec_search_source"));
    }

    private ThreeTuple<List<String>, List<Long>, List<String>> getSelectedGoodsThreeTuple() {
        EntryGrid searchEntry = (EntryGrid)this.getControl(SEARCH_ENTRYENTITY);
        int[] selectRows = searchEntry.getSelectRows();
        ArrayList<String> selectedSkus = new ArrayList<String>(selectRows.length);
        ArrayList<Long> selectedGoodsIds = new ArrayList<Long>(selectRows.length);
        ArrayList<String> unSyncSkus = new ArrayList<String>(selectRows.length);
        for (int rowIndex : selectRows) {
            String goodsId;
            String sku = this.getModel().getEntryRowEntity(SEARCH_ENTRYENTITY, rowIndex).getString(SEARCHGOODS_SKU);
            if (StringUtils.isNotBlank((CharSequence)sku)) {
                selectedSkus.add(sku);
            }
            if (ObjectUtils.isEmpty((Object)(goodsId = this.getModel().getEntryRowEntity(SEARCH_ENTRYENTITY, rowIndex).getString(SEARCHGOODS_PK)))) {
                unSyncSkus.add(sku);
                continue;
            }
            selectedGoodsIds.add(Long.valueOf(goodsId));
        }
        return new ThreeTuple(selectedSkus, selectedGoodsIds, unSyncSkus);
    }

    private void ecUpload() {
        ThreeTuple<List<String>, List<Long>, List<String>> selectedGoods = this.getSelectedGoodsThreeTuple();
        List goodsNumbers = (List)selectedGoods.item1;
        if (goodsNumbers.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u884c\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"MalEcSearchV1Plugin_2", (String)"scm-mal-formplugin", (Object[])new Object[0]));
        }
        if (!((List)selectedGoods.item3).isEmpty()) {
            Map goodsNumber2IdMap = MalGoods.ecSync((List)((List)selectedGoods.item3), (String)this.getPlatform());
            this.fillGoodsId(goodsNumber2IdMap);
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        paramMap.put("biztype", "1");
        paramMap.put("goodsids", this.getSelectedGoodsThreeTuple().item2);
        OpenFormUtil.openBillPage((IFormView)this.getView(), (String)"pmm_ecprodaudit", null, (BillOperationStatus)BillOperationStatus.ADDNEW, (ShowType)ShowType.NewWindow, paramMap, null);
    }

    private void fillGoodsId(Map<String, Long> goodsNumber2IdMap) {
        int[] selectRows;
        EntryGrid searchEntry = (EntryGrid)this.getControl(SEARCH_ENTRYENTITY);
        for (int rowIndex : selectRows = searchEntry.getSelectRows()) {
            String sku = this.getModel().getEntryRowEntity(SEARCH_ENTRYENTITY, rowIndex).getString(SEARCHGOODS_SKU);
            if (!StringUtils.isNotBlank((CharSequence)sku)) continue;
            this.getModel().setValue(SEARCHGOODS_PK, (Object)goodsNumber2IdMap.get(sku));
        }
    }
}

