/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.formplugin;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.ImageAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.url.UrlService;
import kd.scm.common.es.storage.EsFilterField;
import kd.scm.common.es.storage.EsSearchParam;
import kd.scm.common.es.storage.EsSortField;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.mal.business.model.comment.MalCommentAggResult;
import kd.scm.mal.business.model.comment.MalCommentAggValue;
import kd.scm.mal.business.model.comment.MalCommentEsSearchParam;
import kd.scm.mal.business.model.comment.MalCommentEsSearchResult;
import kd.scm.mal.business.service.MalCommentEsSearchService;
import kd.scm.malcore.domain.ProdComment;
import kd.scm.malcore.domain.ProdCommentContent;
import kd.scm.malcore.domain.ProdCommentContentDetail;
import kd.scm.malcore.domain.ProdCommentLabel;
import kd.scm.malcore.enums.ProdCommentTypeEnum;

public class MalGoodsAllCommentPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(MalGoodsAllCommentPlugin.class);
    private static final String TAB_COMMENT = "tabcomment";
    private static final String POSITIVE_RATE = "positive_rate";
    private static final String BTN_ALL = "btn_all";
    private static final String BTN_PICTURE = "btn_picture";
    private static final String BTN_FOLLOW = "btn_follow";
    private static final String BTN_POSITIVE = "btn_positive";
    private static final String BTN_MODERATE = "btn_moderate";
    private static final String BTN_NEGATIVE = "btn_negative";
    private static final String COMMENT_TOTAL_PAGE = "comment_total_page";
    private static final String COMMENT_CURRENT_PAGE = "comment_current_page";
    private static final String COMMENT_FIRST_PAGE = "comment_first_page";
    private static final String COMMENT_PRE_PAGE = "comment_pre_page";
    private static final String COMMENT_NEXT_PAGE = "comment_next_page";
    private static final String COMMENT_END_PAGE = "comment_end_page";
    private static final String COMMENT_PAGE_SIZE = "comment_page_size";
    private static final String PROD_COMMENT_LABELS = "prodCommentLabels";
    private static final String COMMENT_BTN_SELECT = "comment_btn_select";
    private static final String COMMENT_LABEL_SELECT = "comment_label_select";
    private static final String COMMENT_LABEL_TYPE_SELECT = "comment_label_type_select";
    private static final String CONTAINER = "container";

    public void afterCreateNewData(EventObject e) {
        this.commentView();
    }

    private void setCommentNum(MalCommentEsSearchResult result) {
        Object commentPageSource = this.getView().getFormShowParameter().getCustomParam("commentPageSource");
        if ("mal_newproductdetail".equals(commentPageSource)) {
            int num = (int)result.getTotals();
            String numString = this.getQtyText(num);
            HashMap map = new HashMap();
            HashMap<String, String> map1 = new HashMap<String, String>();
            String title = ResManager.loadKDString((String)"\u5546\u54c1\u8bc4\u4ef7\uff08{0}\uff09", (String)"MalGoodsAllCommentPlugin_0", (String)"scm-mal-formplugin", (Object[])new Object[]{numString});
            map.put("text", map1);
            map1.put(RequestContext.get().getLang().name(), title);
            this.getView().getParentView().updateControlMetadata(TAB_COMMENT, map);
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    private String getQtyText(int qty) {
        String numString = String.valueOf(qty);
        if (qty > 1000) {
            numString = "1000+";
        }
        return numString;
    }

    private void commentView() {
        this.getModel().beginInit();
        this.getModel().setValue(COMMENT_CURRENT_PAGE, (Object)1);
        this.getModel().endInit();
        this.getView().updateView(COMMENT_CURRENT_PAGE);
        this.getPageCache().put(COMMENT_BTN_SELECT, BTN_ALL);
        this.tabViewDeal();
        MalCommentEsSearchResult partResult = this.doCommentSearch(0, this.getCommentPageSize(), this.getFullEsFilterFields());
        this.commentContentView(partResult);
    }

    private MalCommentEsSearchResult doCommentSearch(Integer pageNum, Integer pageSize, List<EsFilterField> esFilterFields) {
        MalCommentEsSearchParam malCommentEsSearchParam = new MalCommentEsSearchParam();
        EsSearchParam esSearchParam = new EsSearchParam();
        if (pageNum != null) {
            esSearchParam.setPageNum(pageNum.intValue());
        }
        if (pageSize != null) {
            esSearchParam.setPageSize(pageSize.intValue());
        }
        esSearchParam.setEsFilterFields(esFilterFields);
        EsSortField esSortField = new EsSortField("createtime", false);
        esSearchParam.setEsSortFields(new EsSortField[]{esSortField});
        malCommentEsSearchParam.setEsSearchParam(esSearchParam);
        MalCommentEsSearchService malCommentEsSearchService = new MalCommentEsSearchService();
        return malCommentEsSearchService.search(malCommentEsSearchParam);
    }

    private List<EsFilterField> getFullEsFilterFields() {
        String label_select;
        List<EsFilterField> esFilterFields = this.getDefaultCommentEsFilterFields();
        String btn_select = this.getPageCache().get(COMMENT_BTN_SELECT);
        if (StringUtils.isNotBlank((CharSequence)btn_select)) {
            switch (btn_select) {
                case "btn_picture": {
                    EsFilterField esFilterField = new EsFilterField("pictureurl", "!=", new Object[]{""});
                    esFilterFields.add(esFilterField);
                    break;
                }
                case "btn_follow": {
                    EsFilterField esFilterField = new EsFilterField("commenttype", "=", new Object[]{"1"});
                    esFilterFields.add(esFilterField);
                    break;
                }
                case "btn_positive": {
                    EsFilterField esFilterField = new EsFilterField("entryentity", "entryentity.entrymoduletypenumber", "=", new Object[]{ProdCommentTypeEnum.LEVEL.getVal()});
                    esFilterField.and(new EsFilterField("entryentity", "entryentity.entrycontent", "=", new Object[]{"A"}));
                    esFilterFields.add(esFilterField);
                    break;
                }
                case "btn_moderate": {
                    EsFilterField esFilterField = new EsFilterField("entryentity", "entryentity.entrymoduletypenumber", "=", new Object[]{ProdCommentTypeEnum.LEVEL.getVal()});
                    esFilterField.and(new EsFilterField("entryentity", "entryentity.entrycontent", "=", new Object[]{"B"}));
                    esFilterFields.add(esFilterField);
                    break;
                }
                case "btn_negative": {
                    EsFilterField esFilterField = new EsFilterField("entryentity", "entryentity.entrymoduletypenumber", "=", new Object[]{ProdCommentTypeEnum.LEVEL.getVal()});
                    esFilterField.and(new EsFilterField("entryentity", "entryentity.entrycontent", "=", new Object[]{"C"}));
                    esFilterFields.add(esFilterField);
                    break;
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(label_select = this.getPageCache().get(COMMENT_LABEL_SELECT)))) {
            EsFilterField esFilterField = new EsFilterField("entryentity", "entryentity.entrycontent", "=", new Object[]{label_select});
            esFilterFields.add(esFilterField);
        }
        return esFilterFields;
    }

    private List<EsFilterField> getDefaultCommentEsFilterFields() {
        ArrayList<EsFilterField> esFilterFields = new ArrayList<EsFilterField>(8);
        EsFilterField esFilterField = new EsFilterField("goodsid", "=", new Object[]{this.getGoodsId()});
        esFilterField.and(new EsFilterField("billstatus", "=", new Object[]{"C"}));
        esFilterFields.add(esFilterField);
        return esFilterFields;
    }

    private ProdComment getProdComment(MalCommentEsSearchResult result) {
        this.setCommentNum(result);
        ProdComment prodComment = new ProdComment();
        prodComment.setCommentQty((int)result.getTotals());
        Map<Long, Integer> labelsQty = new LinkedHashMap();
        List malCommentAggResultList = result.getMalCommentAggResultList();
        for (MalCommentAggResult malCommentAggResult : malCommentAggResultList) {
            if (malCommentAggResult == null) continue;
            String type = malCommentAggResult.getType();
            List malCommentAggValueList = malCommentAggResult.getMalCommentAggValueList();
            if (ProdCommentTypeEnum.PICTURE.getVal().equals(type)) {
                prodComment.setPictureQty(((MalCommentAggValue)malCommentAggValueList.get(0)).getQty().intValue());
                continue;
            }
            if (ProdCommentTypeEnum.LEVEL.getVal().equals(type)) {
                for (MalCommentAggValue malCommentAggValue : malCommentAggValueList) {
                    if ("A".equals(malCommentAggValue.getKey())) {
                        prodComment.setPositiveQty(malCommentAggValue.getQty().intValue());
                        continue;
                    }
                    if ("B".equals(malCommentAggValue.getKey())) {
                        prodComment.setModerateQty(malCommentAggValue.getQty().intValue());
                        continue;
                    }
                    if (!"C".equals(malCommentAggValue.getKey())) continue;
                    prodComment.setNegativeQty(malCommentAggValue.getQty().intValue());
                }
                continue;
            }
            if (ProdCommentTypeEnum.LABEL.getVal().equals(type)) {
                for (MalCommentAggValue malCommentAggValue : malCommentAggValueList) {
                    labelsQty.put(Long.valueOf(malCommentAggValue.getKey()), malCommentAggValue.getQty());
                }
                continue;
            }
            if (!"commenttype".equals(type)) continue;
            for (MalCommentAggValue malCommentAggValue : malCommentAggValueList) {
                if (!"1".equals(malCommentAggValue.getKey())) continue;
                prodComment.setFollowQty(malCommentAggValue.getQty().intValue());
            }
        }
        labelsQty = labelsQty.entrySet().stream().sorted(Collections.reverseOrder(Map.Entry.comparingByValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e2, LinkedHashMap::new));
        prodComment.setLabelsQty(labelsQty);
        return prodComment;
    }

    private List<ProdCommentContent> getProdCommentContentList(MalCommentEsSearchResult result) {
        List commentSearchResultList = result.getCommentSearchResultList();
        ArrayList<ProdCommentContent> prodCommentContentList = new ArrayList<ProdCommentContent>(commentSearchResultList.size());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:MM");
        StringBuilder logStr = new StringBuilder();
        for (Map resultMap : commentSearchResultList) {
            ProdCommentContent prodCommentContent = new ProdCommentContent();
            prodCommentContent.setId((Long)resultMap.get("id"));
            try {
                prodCommentContent.setCommentTime(simpleDateFormat.parse((String)resultMap.get("createtime")));
            }
            catch (ParseException e) {
                logStr.append(ExceptionUtil.getStackTrace((Throwable)e)).append(System.lineSeparator());
            }
            prodCommentContent.setCommentator(Long.valueOf(String.valueOf(resultMap.get("creatorid"))));
            prodCommentContent.setPrivacyProtectWay((String)resultMap.get("privacyprotectway"));
            List entryentity = (List)resultMap.get("entryentity");
            ArrayList<ProdCommentContentDetail> prodCommentContentDetails = new ArrayList<ProdCommentContentDetail>(entryentity.size());
            for (Map entry : entryentity) {
                ProdCommentContentDetail prodCommentContentDetail = new ProdCommentContentDetail();
                prodCommentContentDetail.setModuleType((String)entry.get("entrymoduletypenumber"));
                prodCommentContentDetail.setCommentTitle((String)entry.get("entrycommenttitle"));
                prodCommentContentDetail.setValue((String)entry.get("entrycontent"));
                prodCommentContentDetails.add(prodCommentContentDetail);
            }
            if (StringUtils.isNotBlank(resultMap.get("pictureurl"))) {
                ProdCommentContentDetail prodCommentContentDetail = new ProdCommentContentDetail();
                prodCommentContentDetail.setModuleType(ProdCommentTypeEnum.PICTURE.getVal());
                prodCommentContentDetail.setCommentTitle("");
                prodCommentContentDetail.setValue((String)resultMap.get("pictureurl"));
                prodCommentContentDetails.add(prodCommentContentDetail);
            }
            prodCommentContent.setProdCommentContentDetailList(prodCommentContentDetails);
            prodCommentContentList.add(prodCommentContent);
        }
        if (logStr.length() > 0) {
            log.error(logStr.toString());
        }
        return prodCommentContentList;
    }

    private void commentContentView(MalCommentEsSearchResult result) {
        List<ProdCommentContent> prodCommentContentList = this.getProdCommentContentList(result);
        int totals = (int)result.getTotals();
        int totalPage = totals / this.getCommentPageSize();
        if (totals % this.getCommentPageSize() != 0) {
            ++totalPage;
        }
        if (totalPage == 0) {
            totalPage = 1;
        }
        this.getModel().beginInit();
        this.getModel().setValue(COMMENT_TOTAL_PAGE, (Object)totalPage);
        this.getModel().endInit();
        this.getView().updateView(COMMENT_TOTAL_PAGE);
        this.setPageButtonEnable();
        if (prodCommentContentList.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"commentcontainer"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"commentemptycontainer"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"commentcontainer"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"commentemptycontainer"});
            Container commentContainer = (Container)this.getControl("commentcontainer");
            FlexPanelAp commentContainerAp = new FlexPanelAp();
            commentContainerAp.setId("commentContainerAp");
            commentContainerAp.setKey("commentContainerAp");
            commentContainerAp.setWidth(new LocaleString("100%"));
            commentContainerAp.setGrow(1);
            commentContainerAp.setShrink(0);
            commentContainerAp.setDirection("column");
            commentContainerAp.setAlignContent("stretch");
            commentContainerAp.setWrap(false);
            ArrayList<Map> commentControl = new ArrayList<Map>();
            ArrayList<Long> userIds = new ArrayList<Long>(100);
            HashMap<Long, String> userNameMap = new HashMap<Long, String>(100);
            for (ProdCommentContent prodCommentContent : prodCommentContentList) {
                userIds.add(prodCommentContent.getCommentator());
            }
            Map userAvatarPath = UserServiceHelper.getUserAvatarPath(userIds, (boolean)true);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getPluginName(), (String)"bos_user", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", userIds)}, (String)"id");){
                dataSet.forEach(row -> userNameMap.put(row.getLong("id"), row.getString("name")));
            }
            for (ProdCommentContent prodCommentContent : prodCommentContentList) {
                FlexPanelAp commentFlex = this.createCommentFlex(prodCommentContent, userNameMap, userAvatarPath);
                commentContainerAp.getItems().add(commentFlex);
            }
            commentControl.add(commentContainerAp.createControl());
            commentContainer.deleteControls(new String[]{commentContainerAp.getKey()});
            commentContainer.addControls(commentControl);
        }
    }

    private FlexPanelAp createCommentFlex(ProdCommentContent prodCommentContent, Map<Long, String> userNameMap, Map<Long, String> userAvatarPath) {
        FlexPanelAp res = new FlexPanelAp();
        res.setId(prodCommentContent.getId() + CONTAINER);
        res.setKey(prodCommentContent.getId() + CONTAINER);
        res.setWidth(new LocaleString("100%"));
        res.setDirection("row");
        res.setWrap(false);
        Style style = new Style();
        Border border = new Border();
        border.setBottom("1px_solid_#cccccc");
        Margin margin = new Margin();
        margin.setBottom("10px");
        style.setBorder(border);
        style.setMargin(margin);
        res.setStyle(style);
        FlexPanelAp commentUserFlex = this.createCommentUserFlex(prodCommentContent, userNameMap, userAvatarPath);
        FlexPanelAp commentContentFlex = this.createCommentContentFlex(prodCommentContent);
        res.getItems().add(commentUserFlex);
        res.getItems().add(commentContentFlex);
        return res;
    }

    private FlexPanelAp createCommentUserFlex(ProdCommentContent prodCommentContent, Map<Long, String> userNameMap, Map<Long, String> userAvatarPath) {
        FlexPanelAp res = new FlexPanelAp();
        res.setId(prodCommentContent.getCommentator() + "user" + CONTAINER);
        res.setKey(prodCommentContent.getCommentator() + "user" + CONTAINER);
        res.setWidth(new LocaleString("13%"));
        res.setAlignItems("center");
        LabelAp userNameLabel = this.createUserNameLabel(prodCommentContent, userNameMap);
        ImageAp userAvatar = this.createUserAvatar(prodCommentContent, userAvatarPath);
        res.getItems().add(userAvatar);
        res.getItems().add(userNameLabel);
        return res;
    }

    private LabelAp createUserNameLabel(ProdCommentContent prodCommentContent, Map<Long, String> userNameMap) {
        LabelAp res = new LabelAp();
        Long commentator = prodCommentContent.getCommentator();
        res.setKey(commentator + "UserName");
        res.setId(commentator + "UserName");
        res.setAutoTextWrap(true);
        res.setFontSize(14);
        res.setWidth(new LocaleString("60px"));
        StringBuilder name = new StringBuilder(userNameMap.get(commentator));
        String privacyProtectWay = prodCommentContent.getPrivacyProtectWay();
        if ("C".equals(privacyProtectWay)) {
            name = new StringBuilder("***");
        } else if ("B".equals(privacyProtectWay)) {
            if (name.length() < 2) {
                name.replace(0, 1, "*");
            } else {
                for (int i = 1; i < name.length(); ++i) {
                    name.replace(i, i + 1, "*");
                }
            }
        }
        res.setName(new LocaleString(name.toString()));
        Margin margin = new Margin();
        margin.setLeft("10px");
        Style style = new Style();
        style.setMargin(margin);
        res.setStyle(style);
        return res;
    }

    private ImageAp createUserAvatar(ProdCommentContent prodCommentContent, Map<Long, String> userAvatarPath) {
        ImageAp imageAp = new ImageAp();
        Long commentator = prodCommentContent.getCommentator();
        String avatarPathUrl = userAvatarPath.get(commentator);
        if (!avatarPathUrl.contains("http") && !avatarPathUrl.contains("https")) {
            avatarPathUrl = UrlService.getImageFullUrl((String)avatarPathUrl);
        }
        imageAp.setId(commentator + "Avatar");
        imageAp.setKey(commentator + "Avatar");
        imageAp.setHeight(new LocaleString("40px"));
        imageAp.setWidth(new LocaleString("40px"));
        imageAp.setRadius("100px");
        imageAp.setImageKey(avatarPathUrl);
        Margin margin = new Margin();
        margin.setLeft("20px");
        Style style = new Style();
        style.setMargin(margin);
        imageAp.setStyle(style);
        return imageAp;
    }

    private FlexPanelAp createCommentContentFlex(ProdCommentContent prodCommentContent) {
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setId(prodCommentContent.getId() + "commentContent");
        flexPanelAp.setKey(prodCommentContent.getId() + "commentContent");
        flexPanelAp.setWidth(new LocaleString("87%"));
        flexPanelAp.setGrow(1);
        this.showCommentInfo(prodCommentContent.getId() + "commentContent", prodCommentContent.getProdCommentContentDetailList());
        return flexPanelAp;
    }

    private void showCommentInfo(String key, List<ProdCommentContentDetail> prodCommentContentDetailList) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("pbd_prodcomment");
        fsp.setCustomParam("openStyle", (Object)"view");
        fsp.setCustomParam("commentDetails", (Object)SerializationUtils.toJsonString(prodCommentContentDetailList));
        fsp.setCustomParam(PROD_COMMENT_LABELS, (Object)this.getPageCache().get(PROD_COMMENT_LABELS));
        fsp.getOpenStyle().setShowType(ShowType.InContainer);
        fsp.getOpenStyle().setTargetKey(key);
        this.getView().showForm(fsp);
    }

    private void tabViewDeal() {
        MalCommentEsSearchResult allResult = this.doCommentSearch(null, null, this.getDefaultCommentEsFilterFields());
        ProdComment prodComment = this.getProdComment(allResult);
        this.setButtonView(BTN_ALL, ResManager.loadKDString((String)"\u5168\u90e8\u8bc4\u4ef7", (String)"MalGoodsAllCommentPlugin_1", (String)"scm-mal-formplugin", (Object[])new Object[0]), prodComment.getCommentQty());
        this.setButtonView(BTN_FOLLOW, ResManager.loadKDString((String)"\u8ffd\u8bc4", (String)"MalGoodsAllCommentPlugin_2", (String)"scm-mal-formplugin", (Object[])new Object[0]), prodComment.getFollowQty());
        this.setButtonView(BTN_PICTURE, ResManager.loadKDString((String)"\u6652\u56fe", (String)"MalGoodsAllCommentPlugin_3", (String)"scm-mal-formplugin", (Object[])new Object[0]), prodComment.getPictureQty());
        this.setButtonView(BTN_POSITIVE, ResManager.loadKDString((String)"\u597d\u8bc4", (String)"MalGoodsAllCommentPlugin_4", (String)"scm-mal-formplugin", (Object[])new Object[0]), prodComment.getPositiveQty());
        this.setButtonView(BTN_MODERATE, ResManager.loadKDString((String)"\u4e2d\u8bc4", (String)"MalGoodsAllCommentPlugin_5", (String)"scm-mal-formplugin", (Object[])new Object[0]), prodComment.getModerateQty());
        this.setButtonView(BTN_NEGATIVE, ResManager.loadKDString((String)"\u5dee\u8bc4", (String)"MalGoodsAllCommentPlugin_6", (String)"scm-mal-formplugin", (Object[])new Object[0]), prodComment.getNegativeQty());
        int totalPage = prodComment.getCommentQty() / this.getCommentPageSize();
        if (prodComment.getCommentQty() % this.getCommentPageSize() != 0) {
            ++totalPage;
        }
        this.getModel().setValue(COMMENT_TOTAL_PAGE, (Object)totalPage);
        this.fillLabelView(prodComment);
        this.setPageButtonEnable();
    }

    private void setButtonView(String btnName, String name, int qty) {
        name = name + " (" + this.getQtyText(qty) + ") ";
        HashMap map = new HashMap();
        HashMap<String, String> map1 = new HashMap<String, String>();
        map.put("text", map1);
        map1.put(RequestContext.get().getLang().name(), name);
        this.getView().updateControlMetadata(btnName, map);
    }

    private void setPageButtonEnable() {
        int total_page = (Integer)this.getModel().getValue(COMMENT_TOTAL_PAGE);
        if (total_page == 0) {
            this.getModel().beginInit();
            this.getModel().setValue(COMMENT_CURRENT_PAGE, (Object)0);
            this.getModel().endInit();
            this.getView().setEnable(Boolean.FALSE, new String[]{"header_page_flex"});
            return;
        }
        int current_page = (Integer)this.getModel().getValue(COMMENT_CURRENT_PAGE);
        if (total_page == current_page) {
            this.getView().setEnable(Boolean.FALSE, new String[]{COMMENT_NEXT_PAGE, COMMENT_END_PAGE});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{COMMENT_NEXT_PAGE, COMMENT_END_PAGE});
        }
        if (current_page == 1) {
            this.getView().setEnable(Boolean.FALSE, new String[]{COMMENT_PRE_PAGE, COMMENT_FIRST_PAGE});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{COMMENT_PRE_PAGE, COMMENT_FIRST_PAGE});
        }
    }

    private void fillLabelView(ProdComment prodComment) {
        int commentQty = prodComment.getCommentQty();
        Container labelShowContainer = (Container)this.getControl("labelcontainer");
        FlexPanelAp labelContainerAp = new FlexPanelAp();
        labelContainerAp.setId("labelContainerAp");
        labelContainerAp.setKey("labelContainerAp");
        if (commentQty == 0) {
            labelShowContainer.deleteControls(new String[]{labelContainerAp.getKey()});
            this.getModel().setValue(POSITIVE_RATE, (Object)100);
            return;
        }
        int positiveRate = (int)(BigDecimal.valueOf((float)prodComment.getPositiveQty() / (float)commentQty).setScale(2, 4).doubleValue() * 100.0);
        this.getModel().setValue(POSITIVE_RATE, (Object)positiveRate);
        Map labelsQty = prodComment.getLabelsQty();
        if (labelsQty == null || labelsQty.isEmpty()) {
            labelShowContainer.deleteControls(new String[]{labelContainerAp.getKey()});
            return;
        }
        ArrayList prodCommentLabels = new ArrayList();
        ArrayList<Map> labelControl = new ArrayList<Map>();
        labelContainerAp.setHeight(new LocaleString("100%"));
        labelContainerAp.setWidth(new LocaleString("100%"));
        labelContainerAp.setGrow(0);
        labelContainerAp.setShrink(0);
        labelContainerAp.setDirection("row");
        labelContainerAp.setWrap(true);
        labelContainerAp.setAlignContent("center");
        HashMap labels = new HashMap(labelsQty.size());
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getPluginName(), (String)"pmm_commentlabel", (String)"id,name,labeltype", (QFilter[])new QFilter[]{new QFilter("id", "in", labelsQty.keySet())}, (String)"id");
        Object object = null;
        try {
            dataSet.forEach(row -> {
                ProdCommentLabel prodCommentLabel = new ProdCommentLabel();
                prodCommentLabel.setId(row.getLong("id"));
                prodCommentLabel.setName(row.getString("name"));
                prodCommentLabel.setLabelType(row.getString("labeltype"));
                prodCommentLabels.add(prodCommentLabel);
                labels.put(row.getLong("id"), prodCommentLabel);
            });
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        int qty = 0;
        for (Map.Entry entry : labelsQty.entrySet()) {
            if (qty >= 16) break;
            Long labelId = (Long)entry.getKey();
            ProdCommentLabel prodCommentLabel = (ProdCommentLabel)labels.get(labelId);
            FlexPanelAp flexPanelAp = this.createFlexPanelAp(prodCommentLabel, (Integer)entry.getValue());
            labelContainerAp.getItems().add(flexPanelAp);
            ++qty;
        }
        labelControl.add(labelContainerAp.createControl());
        labelShowContainer.deleteControls(new String[]{labelContainerAp.getKey()});
        labelShowContainer.addControls(labelControl);
        this.getPageCache().put(PROD_COMMENT_LABELS, SerializationUtils.toJsonString(prodCommentLabels));
    }

    private FlexPanelAp createFlexPanelAp(ProdCommentLabel prodCommentLabel, int qty) {
        String color = this.getColor(prodCommentLabel);
        FlexPanelAp res = new FlexPanelAp();
        res.setId(prodCommentLabel.getId() + CONTAINER);
        res.setKey(prodCommentLabel.getId() + CONTAINER);
        res.setRadius("5px");
        res.setHeight(new LocaleString("25px"));
        res.setGrow(0);
        res.setAlignItems("center");
        res.setShrink(0);
        res.setIndex(1);
        res.setJustifyContent("center");
        res.setWrap(false);
        res.setWidth(new LocaleString("120px"));
        res.setName(new LocaleString(prodCommentLabel.getId() + CONTAINER));
        Border border = new Border();
        border.setTop("1px_solid_" + color);
        border.setLeft("1px_solid_" + color);
        border.setBottom("1px_solid_" + color);
        border.setRight("1px_solid_" + color);
        Margin margin = new Margin();
        margin.setRight("10px");
        margin.setBottom("10px");
        Style style = new Style();
        style.setBorder(border);
        style.setMargin(margin);
        res.setStyle(style);
        LabelAp labelAp = this.createLabelText(prodCommentLabel, qty);
        res.getItems().add(labelAp);
        return res;
    }

    private LabelAp createLabelText(ProdCommentLabel prodCommentLabel, int qty) {
        String color = this.getColor(prodCommentLabel);
        LabelAp labelAp = new LabelAp();
        labelAp.setId(String.valueOf(prodCommentLabel.getId()));
        labelAp.setKey(String.valueOf(prodCommentLabel.getId()));
        labelAp.setLabelStyle("1");
        labelAp.setShrink(0);
        labelAp.setForeColor(color);
        labelAp.setFontSize(12);
        labelAp.setClickable(true);
        String name = prodCommentLabel.getName() + "(" + qty + ")";
        if (qty > 1000) {
            name = prodCommentLabel.getName() + "(1000+)";
        }
        labelAp.setName(new LocaleString(name));
        return labelAp;
    }

    private String getColor(ProdCommentLabel prodCommentLabel) {
        String labelType = prodCommentLabel.getLabelType();
        String color = "";
        color = "1".equals(labelType) ? "#666666" : "#999999";
        return color;
    }

    private void clickStyleChange(String key, boolean isClicking) {
        ArrayList<Object> list = new ArrayList<Object>();
        HashMap<String, String> dataMap = new HashMap<String, String>();
        list.add(key);
        if (isClicking) {
            dataMap.put("fc", "themeColor");
        } else {
            dataMap.put("fc", "#666666");
        }
        list.add(dataMap);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.addAction("updateControlMetadata", list);
    }

    private Integer getCommentPageSize() {
        return Integer.valueOf((String)this.getModel().getValue(COMMENT_PAGE_SIZE));
    }

    private Long getGoodsId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("goodsId");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button btn_all = (Button)this.getView().getControl(BTN_ALL);
        Button btn_picture = (Button)this.getView().getControl(BTN_PICTURE);
        Button btn_follow = (Button)this.getView().getControl(BTN_FOLLOW);
        Button btn_positive = (Button)this.getView().getControl(BTN_POSITIVE);
        Button btn_moderate = (Button)this.getView().getControl(BTN_MODERATE);
        Button btn_negative = (Button)this.getView().getControl(BTN_NEGATIVE);
        Button comment_first_page = (Button)this.getView().getControl(COMMENT_FIRST_PAGE);
        Button comment_pre_page = (Button)this.getView().getControl(COMMENT_PRE_PAGE);
        Button comment_next_page = (Button)this.getView().getControl(COMMENT_NEXT_PAGE);
        Button comment_end_page = (Button)this.getView().getControl(COMMENT_END_PAGE);
        btn_all.addClickListener((ClickListener)this);
        btn_picture.addClickListener((ClickListener)this);
        btn_follow.addClickListener((ClickListener)this);
        btn_positive.addClickListener((ClickListener)this);
        btn_moderate.addClickListener((ClickListener)this);
        btn_negative.addClickListener((ClickListener)this);
        comment_first_page.addClickListener((ClickListener)this);
        comment_pre_page.addClickListener((ClickListener)this);
        comment_next_page.addClickListener((ClickListener)this);
        comment_end_page.addClickListener((ClickListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (COMMENT_CURRENT_PAGE.equals(e.getProperty().getName())) {
            this.commentCurrentPageChange(e);
        }
        if (COMMENT_PAGE_SIZE.equals(e.getProperty().getName())) {
            this.commentPageSizeChange();
        }
    }

    private void commentCurrentPageChange(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        Integer newValue = (Integer)changeData.getNewValue();
        Integer oldValue = (Integer)changeData.getOldValue();
        Integer totalPage = (Integer)this.getModel().getValue(COMMENT_TOTAL_PAGE);
        if (totalPage.compareTo(oldValue) < 0) {
            return;
        }
        if (totalPage.compareTo(newValue) < 0) {
            this.getModel().beginInit();
            this.getModel().getDataEntity().set(COMMENT_CURRENT_PAGE, (Object)totalPage);
            this.getModel().endInit();
            this.getView().updateView(COMMENT_CURRENT_PAGE);
        }
        if (oldValue.compareTo((Integer)this.getModel().getValue(COMMENT_CURRENT_PAGE)) != 0) {
            MalCommentEsSearchResult result = this.doCommentSearch((Integer)this.getModel().getValue(COMMENT_CURRENT_PAGE) - 1, this.getCommentPageSize(), this.getFullEsFilterFields());
            this.commentContentView(result);
        }
    }

    private void commentPageSizeChange() {
        this.getModel().beginInit();
        this.getModel().setValue(COMMENT_CURRENT_PAGE, (Object)1);
        this.getModel().endInit();
        this.getView().updateView(COMMENT_CURRENT_PAGE);
        MalCommentEsSearchResult result = this.doCommentSearch(0, this.getCommentPageSize(), this.getFullEsFilterFields());
        this.commentContentView(result);
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String labelsJson = this.getPageCache().get(PROD_COMMENT_LABELS);
        if (StringUtils.isNotBlank((CharSequence)labelsJson)) {
            List prodCommentLabels = SerializationUtils.fromJsonStringToList((String)labelsJson, ProdCommentLabel.class);
            for (ProdCommentLabel prodCommentLabel : prodCommentLabels) {
                if (!StringUtils.equals((CharSequence)String.valueOf(prodCommentLabel.getId()), (CharSequence)e.getKey())) continue;
                Label label = new Label();
                label.setView(this.getView());
                label.setKey(e.getKey());
                label.addClickListener((ClickListener)this);
                e.setControl((Control)label);
                return;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button button = null;
        if (evt.getSource() instanceof Button) {
            button = (Button)evt.getSource();
        }
        List<String> commentButtons = Arrays.asList(BTN_ALL, BTN_FOLLOW, BTN_MODERATE, BTN_PICTURE, BTN_POSITIVE, BTN_NEGATIVE);
        if (button != null && commentButtons.contains(button.getKey())) {
            this.commentButtonClick(button.getKey());
            return;
        }
        String prodCommentLabelsJson = this.getPageCache().get(PROD_COMMENT_LABELS);
        if (button != null && StringUtils.isNotBlank((CharSequence)prodCommentLabelsJson)) {
            List prodCommentLabels = SerializationUtils.fromJsonStringToList((String)prodCommentLabelsJson, ProdCommentLabel.class);
            ProdCommentLabel clickProdCommentLabel = null;
            for (ProdCommentLabel prodCommentLabel : prodCommentLabels) {
                if (!button.getKey().equals(String.valueOf(prodCommentLabel.getId()))) continue;
                clickProdCommentLabel = prodCommentLabel;
            }
            if (clickProdCommentLabel != null) {
                this.commentLabelClick(clickProdCommentLabel);
            }
        }
        if (button != null && COMMENT_PRE_PAGE.equals(button.getKey())) {
            this.getModel().setValue(COMMENT_CURRENT_PAGE, (Object)((Integer)this.getModel().getValue(COMMENT_CURRENT_PAGE) - 1));
        } else if (button != null && COMMENT_FIRST_PAGE.equals(button.getKey())) {
            this.getModel().setValue(COMMENT_CURRENT_PAGE, (Object)1);
        } else if (button != null && COMMENT_NEXT_PAGE.equals(button.getKey())) {
            this.getModel().setValue(COMMENT_CURRENT_PAGE, (Object)((Integer)this.getModel().getValue(COMMENT_CURRENT_PAGE) + 1));
        } else if (button != null && COMMENT_END_PAGE.equals(button.getKey())) {
            this.getModel().setValue(COMMENT_CURRENT_PAGE, this.getModel().getValue(COMMENT_TOTAL_PAGE));
        }
    }

    private void commentButtonClick(String key) {
        String oldSelect = this.getPageCache().get(COMMENT_BTN_SELECT);
        if (key.equals(oldSelect)) {
            return;
        }
        this.getModel().beginInit();
        this.getModel().setValue(COMMENT_CURRENT_PAGE, (Object)1);
        this.getModel().endInit();
        this.getView().updateView(COMMENT_CURRENT_PAGE);
        this.clickStyleChange(key, true);
        this.clickStyleChange(oldSelect, false);
        this.getPageCache().put(COMMENT_BTN_SELECT, key);
        String labelSelect = this.getPageCache().get(COMMENT_LABEL_SELECT);
        if (StringUtils.isNotBlank((CharSequence)labelSelect)) {
            String labelSelectType = this.getPageCache().get(COMMENT_LABEL_TYPE_SELECT);
            this.labelStyleClick(labelSelect, labelSelectType, false);
            this.labelContainerStyleClick(labelSelect + CONTAINER, labelSelectType, false);
            this.getPageCache().remove(COMMENT_LABEL_SELECT);
            this.getPageCache().remove(COMMENT_LABEL_TYPE_SELECT);
        }
        MalCommentEsSearchResult result = this.doCommentSearch(0, this.getCommentPageSize(), this.getFullEsFilterFields());
        this.commentContentView(result);
    }

    private void labelStyleClick(String key, String labelType, boolean isClick) {
        ArrayList<Object> list = new ArrayList<Object>();
        HashMap<String, String> dataMap = new HashMap<String, String>();
        list.add(key);
        if (isClick) {
            dataMap.put("fc", "themeColor");
        } else if ("1".equals(labelType)) {
            dataMap.put("fc", "#666666");
        } else if ("0".equals(labelType)) {
            dataMap.put("fc", "#999999");
        }
        list.add(dataMap);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.addAction("updateControlMetadata", list);
    }

    private void labelContainerStyleClick(String key, String labelType, boolean isClick) {
        ArrayList<Object> list = new ArrayList<Object>();
        HashMap dataMap = new HashMap();
        list.add(key);
        String color = "";
        if (isClick) {
            color = "themeColor";
        } else if ("1".equals(labelType)) {
            color = "#666666";
        } else if ("0".equals(labelType)) {
            color = "#999999";
        }
        HashMap style = new HashMap();
        HashMap<String, String> border = new HashMap<String, String>();
        border.put("r", "1px_solid_" + color);
        border.put("l", "1px_solid_" + color);
        border.put("t", "1px_solid_" + color);
        border.put("b", "1px_solid_" + color);
        style.put("b", border);
        dataMap.put("s", style);
        list.add(dataMap);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.addAction("updateControlMetadata", list);
    }

    private void commentLabelClick(ProdCommentLabel prodCommentLabel) {
        String oldSelect = this.getPageCache().get(COMMENT_LABEL_SELECT);
        String oldSelectType = this.getPageCache().get(COMMENT_LABEL_TYPE_SELECT);
        if (StringUtils.isNotBlank((CharSequence)oldSelect) && oldSelect.equals(String.valueOf(prodCommentLabel.getId()))) {
            this.labelStyleClick(oldSelect, oldSelectType, false);
            this.labelContainerStyleClick(oldSelect + CONTAINER, oldSelectType, false);
            this.getPageCache().remove(COMMENT_LABEL_SELECT);
            this.getPageCache().remove(COMMENT_LABEL_TYPE_SELECT);
        } else if (StringUtils.isNotBlank((CharSequence)oldSelect) && !oldSelect.equals(String.valueOf(prodCommentLabel.getId()))) {
            this.labelStyleClick(oldSelect, oldSelectType, false);
            this.labelContainerStyleClick(oldSelect + CONTAINER, oldSelectType, false);
            this.labelStyleClick(String.valueOf(prodCommentLabel.getId()), prodCommentLabel.getLabelType(), true);
            this.labelContainerStyleClick(prodCommentLabel.getId() + CONTAINER, prodCommentLabel.getLabelType(), true);
            this.getPageCache().put(COMMENT_LABEL_SELECT, String.valueOf(prodCommentLabel.getId()));
            this.getPageCache().put(COMMENT_LABEL_TYPE_SELECT, prodCommentLabel.getLabelType());
        } else {
            this.labelStyleClick(String.valueOf(prodCommentLabel.getId()), prodCommentLabel.getLabelType(), true);
            this.labelContainerStyleClick(prodCommentLabel.getId() + CONTAINER, prodCommentLabel.getLabelType(), true);
            this.getPageCache().put(COMMENT_LABEL_SELECT, String.valueOf(prodCommentLabel.getId()));
            this.getPageCache().put(COMMENT_LABEL_TYPE_SELECT, prodCommentLabel.getLabelType());
        }
        this.getModel().setValue(COMMENT_CURRENT_PAGE, (Object)1);
        String btnSelect = this.getPageCache().get(COMMENT_BTN_SELECT);
        if (StringUtils.isNotBlank((CharSequence)btnSelect) && !BTN_ALL.equals(btnSelect)) {
            this.clickStyleChange(btnSelect, false);
            this.clickStyleChange(BTN_ALL, true);
            this.getPageCache().put(COMMENT_BTN_SELECT, BTN_ALL);
        }
        MalCommentEsSearchResult result = this.doCommentSearch(0, this.getCommentPageSize(), this.getFullEsFilterFields());
        this.commentContentView(result);
    }
}

